<?php 


//~ $local = "1";
//~ $servico = "1";
//~ $data = "2008-04-11";
//~ $balcao = "";
//~ $hist = false;

//~ $teste = new EstatisticaAtendimentos;
//~ echo "Datas: \t\t" . print_r($teste->GetDatas($local, $servico, ""), true) ."\n\n";
//~ echo "Emitidas: \t\t" . $teste->GetNumeroSenhasEmitidas($local, $servico, $data, $balcao, $hist) . "\n";
//~ echo "Atendidas: \t\t" . $teste->GetNumeroSenhasAtendidas($local, $servico, $data, $balcao, $hist) . "\n";
//~ echo "Em atendimento: \t" . $teste->GetNumeroSenhasEmAtendimento($local, $servico, $data, $balcao, $hist) . "\n";
//~ echo "Tempo medio de espera: \t" . $teste->GetTempoMedioEspera($local, $servico, $data, $balcao, $hist) . "\n";
//~ echo "Tempo medio de atendimento: \t" .$teste->GetTempoMedioAtendimento($local, $servico, $data, $balcao, $hist) . "\n";

class EstatisticaAtendimentos
{
	var $_db;
	
	function __construct()
	{
		global $NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD;
		$this->_db = new DBAccess($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
	}
	
	function __destruct()
	{
		unset($this->_db);
	}
	
	function GetDatas($local="", $servico="", $balcao="", $hist=false)
	{
		$sql = "select distinct date(data_hora) as data
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		if ($servico) $sql .= " WHERE id_servico='" . $servico . "'";
		if ($balcao) $sql .= " and id_balcao='" . $balcao . "'";
		if ($local) $sql .= " and id_loja='" . $local . "'";
		
		$res = $this->_db->Execute($sql);
		$datas = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($datas, $row["data"]);
			
		return $datas;
	}
	
    function notIn($item)
    {
        return !in_array($item, $this->_auxArr);
    }
    
	/**
	 * retorna o numero de senhas emitidas
	 * se $hist, consulta a tabela de historico
	 */
	function GetNumeroSenhasEmitidas($local="", $servico, $data, $balcao="", $hist=false)
	{
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico='" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and
				(tipo='Emissao'
				or tipo='Redireccao')
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
        
        $res = $this->_db->Execute($sql);
		$senhas = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($senhas, $row["senha"]);
        
        $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
				from log_atendimentos";
			if ($hist) $sql .= "_hist";
			$sql .= " WHERE id_servico='" . $servico . "'";
			if (strlen($balcao)) $sql .= " and id_balcao= '" . $balcao . "'";
			if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			$sql .= " and tipo='Anulada'
				AND numero_senha != 0
				AND date(data_hora)='" . $data . "'";
        
        $res = $this->_db->Execute($sql);
        unset($this->_auxArr);
		$this->_auxArr = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($this->_auxArr, $row["senha"]);
        
        $newArray = array_filter($senhas, array($this,"notIn")); 
        
		return count($newArray);
	}
	
	function GetNumeroSenhasAtendidas($local="", $servico, $data, $balcao="", $hist=false)
	{
		$sql = "SELECT count(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico='" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and
			tipo='Terminado'
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
        
		$res = $this->_db->Execute($sql);
		return $this->_db->Fields($res, "n");
	
        //~ $res = $this->_db->Execute($sql);
		//~ $senhas = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($senhas, $row["senha"]);
        
        //~ $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
				//~ from log_atendimentos";
			//~ if ($hist) $sql .= "_hist";
			//~ $sql .= " WHERE id_servico = '" . $servico . "'";
			//~ if (strlen($balcao)) $sql .= " and id_balcao= '" . $balcao . "'";
			//~ if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			//~ $sql .= " and tipo='Anulada'
				//~ AND numero_senha != 0
				//~ AND date(data_hora)='" . $data . "'";
                
        //~ $res = $this->_db->Execute($sql);
        //~ unset($this->_auxArr);
		//~ $this->_auxArr = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($this->_auxArr, $row["senha"]);
        
        //~ $newArray = array_filter($senhas, array($this,"notIn")); 
        
		//~ return count($newArray);
	}
	
	function GetNumeroSenhasAtendidasFromResumo($data, $local="", $servico="", $balcao="")
	{
		$sql = "select senhas_chamadas
			from resumodiario
			where data_resumo='" . $data . "'";
		if (strlen($local))
			$sql .= " and id_loja='" . $local . "'";
		if (strlen($servico))
			$sql .= " and id_servico='" . $servico . "'";
		if (strlen($balcao))
			$sql .= " and id_balcao='" . $balcao . "'";
		
		$res = $this->_db->Query($sql);
		$senhasChamadas = 0;
		for ($i=0; $i<count($res); $i++)
		{
			$senhasChamadas += $res[$i]["senhas_chamadas"];
		}
		
		return $senhasChamadas;
	}
	
	function GetNumeroSenhasEmAtendimento($local="", $servico, $data, $balcao="", $hist=false)
	{
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico = '" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and tipo='Chamada'
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
        
        $res = $this->_db->Execute($sql);
		$senhas = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($senhas, $row["senha"]);
        
        $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
				from log_atendimentos";
			if ($hist) $sql .= "_hist";
			$sql .= " WHERE id_servico = '" . $servico . "'";
			if (strlen($balcao)) $sql .= " and id_balcao= '" . $balcao . "'";
			if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			$sql .= " and (tipo='Terminado'
				or tipo='Desistencia'
                or tipo='Anulada')
				AND numero_senha != 0
				AND date(data_hora)='" . $data . "'";
				
		$res = $this->_db->Execute($sql);
		unset($this->_auxArr);
		$this->_auxArr = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($this->_auxArr, $row["senha"]);
        
        $newArray = array_filter($senhas, array($this,"notIn")); 
        
		return count($newArray);
	}
	
	function GetNumeroSenhasEmEspera($local="", $servico, $data, $balcao="", $hist=false)
	{
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico = '" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and
				(tipo='Emissao'
				or tipo='Redireccao')
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
        
        $res = $this->_db->Execute($sql);
		$senhas = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($senhas, $row["senha"]);
        
        $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
				from log_atendimentos";
			if ($hist) $sql .= "_hist";
			$sql .= " WHERE id_servico = '" . $servico . "'";
			if (strlen($balcao)) $sql .= " and id_balcao= '" . $balcao . "'";
			if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			$sql .= " and (tipo='Anulada'
				or tipo='Chamada')
				AND numero_senha != 0
				AND date(data_hora)='" . $data . "'";
				
		$res = $this->_db->Execute($sql);
		unset($this->_auxArr);
		$this->_auxArr = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($this->_auxArr, $row["senha"]);
        
        $newArray = array_filter($senhas, array($this,"notIn")); 
        
		return count($newArray);
	}
	
	function GetNumeroSenhasDesistidas($local="", $servico, $data, $balcao="", $hist=false)
	{
		global $ERROS;
		
		$sql = "SELECT count(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico = '" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and tipo='Desistencia'
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
			
		$res = $this->_db->Execute($sql);
                return $this->_db->Fields($res, "n");
        
		//~ $res = $this->_db->Execute($sql);
		//~ $senhas = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($senhas, $row["senha"]);
		
		//~ $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
			//~ from log_atendimentos";
		//~ if ($hist) $sql .= "_hist";
		//~ $sql .= " WHERE id_servico = '" . $servico . "'";
		//~ if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		//~ if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		//~ $sql .= " and tipo='Anulada'
			//~ AND numero_senha != 0
			//~ AND date(data_hora)='" . $data . "'";
			
		//~ $res = $this->_db->Execute($sql);
		//~ unset($this->_auxArr);
		//~ $this->_auxArr = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($this->_auxArr, $row["senha"]);
        
		//~ $newArray = array_filter($senhas, array($this,"notIn")); 
        
		//~ return count($newArray);
	}
	
	function GetNumeroSenhasDesistidasFromResumo($data, $local="", $servico="", $balcao="")
	{
		$sql = "select senhas_desistidas
			from resumodiario
			where data_resumo='" . $data . "'";
		if (strlen($local))
			$sql .= " and id_loja='" . $local . "'";
		if (strlen($servico))
			$sql .= " and id_servico='" . $servico . "'";
		if (strlen($balcao))
			$sql .= " and id_balcao='" . $balcao . "'";
		
		$res = $this->_db->Query($sql);
		$senhasDesistidas = 0;
		for ($i=0; $i<count($res); $i++)
		{
			$senhasDesistidas += $res[$i]["senhas_desistidas"];
		}
		
		return $senhasDesistidas;
	}
	
	function GetTempoProximaSenha($local, $servico)
	{
		$sql = "select timediff(now(),data_hora) as espera
			from log_atendimentos
			where id_log_atendimentos=
				(SELECT min(id_log_atendimentos) as id
				FROM log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and
					(tipo='Emissao'
					or tipo='Redireccao')
				AND numero_senha != 0
				AND data_hora >= CURDATE()
				and concat_ws('_', numero_senha, servico_emissao) not in
					(select distinct concat_ws('_', numero_senha, servico_emissao)
					from log_atendimentos
					WHERE id_servico = '" . $servico . "'
					and id_loja= '" . $local . "'
					and
						(tipo='Anulada'
						or tipo='Chamada')
					AND numero_senha != 0
					AND data_hora >= CURDATE()))";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoProxSenha". $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "espera");
	}
	
	function GetTempoEspera($local="", $servico="", $data, $senha, $hist=false)
	{
        /*$write = false;
        $new = false;
        
        if ($local)
        {
            $arrSenha = explode("_", $senha);
            
            $sql = "select max(id_senha) as id_senha
                from senhas
                where id_loja='" . $local . "'
                and numero_senha='" . $arrSenha[0] . "'
                and servico_emissao='" . $arrSenha[1] . "'
                and data='" . $data . "'";
            
            $res = $this->_db->Execute($sql);
		    $id_senha = $this->_db->Fields($res, "id_senha");
            
            if ($id_senha)
            {
                $sql= "select tempo_espera
                    from senhas
                    where id_senha='" . $id_senha . "'";
                
                $res = $this->_db->Execute($sql);
                $tempo_espera = $this->_db->Fields($res, "tempo_espera");
                
                if (strlen($tempo_espera)) return GetSecondsFromTimeString($tempo_espera);
                else $write = true;
            }
            else $new = true;
        }*/
        
		/*$sql = "SELECT time_to_sec(time(data_hora)) as sec
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where (tipo='Emissao'
				or tipo='Redireccao')";
		if (strlen($servico)) $sql .= " and id_servico = '" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'";*/
			
		$sql = "SELECT time_to_sec(time(data_hora)) as sec
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where (tipo='Emissao' or tipo='Redireccao')";
		if (strlen($servico)) $sql .= " and id_servico = '" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'";
			
		$res = $this->_db->Execute($sql);
		$emissao = $this->_db->Fields($res, "sec");
		
		$sql = "select time_to_sec(time(data_hora)) as sec
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where tipo='Chamada'";
		if (strlen($servico)) $sql .= " and id_servico='" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'
			order by id_log_atendimentos";
			
		$chamadas = $this->_db->Query($sql);
		
		$sql = "select time_to_sec(time(data_hora)) as sec
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where tipo='Suspensa'";
		if (strlen($servico)) $sql .= " and id_servico='" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'
			order by id_log_atendimentos";
			
		$suspensas = $this->_db->Query($sql);
		
		if ($chamadas[0]["sec"])
			$tempoEspera = $chamadas[0]["sec"] - $emissao;
		for ($i = 0; $i < count($suspensas); $i++)
		{
			if (count($chamadas)>1)
				$tempoEspera += ($chamadas[$i + 1]["sec"] - $suspensas[$i]["sec"]);
		}
		
        /*if ($new)
        {
            $sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, tempo_espera) values (
                '" . $data . "',
                '" . $arrSenha[0] . "',
                '" . $local . "',
                '" . $arrSenha[1] . "',
                '" . date("H:i:s", $tempoEspera - 3600) . "')";
                
            $res = $this->_db->Execute($sql);
        }
        else if ($write)
        {
            $sql = "update senhas
                set tempo_espera='" . date("H:i:s", $tempoEspera - 3600) . "'
                where id_senha='" . $id_senha . "'";
                
            $res = $this->_db->Execute($sql);
        }*/
        
		return $tempoEspera;
	}
	
	function GetTempoAtendimento($local="", $servico="", $data, $senha, $hist=false)
	{
        /*$write = false;
        $new = false;
        
        if ($local)
        {
            $arrSenha = explode("_", $senha);
            
            $sql = "select max(id_senha) as id_senha
                from senhas
                where id_loja='" . $local . "'
                and numero_senha='" . $arrSenha[0] . "'
                and servico_emissao='" . $arrSenha[1] . "'
                and data='" . $data . "'";
            
            $res = $this->_db->Execute($sql);
		    $id_senha = $this->_db->Fields($res, "id_senha");
            
            if ($id_senha)
            {
                $sql= "select tempo_atendimento
                    from senhas
                    where id_senha='" . $id_senha . "'";
                
                //debug("id_senha: " . $sql);
                
                $res = $this->_db->Execute($sql);
                $tempo_atendimento = $this->_db->Fields($res, "tempo_atendimento");
                
                //debug("tempo atendimento: " . $tempo_atendimento);
                
                if (strlen($tempo_atendimento)) return GetSecondsFromTimeString($tempo_atendimento);
                else $write = true;
                //~ debug("write");
            }
            else $new = true;
        }*/
        
        $sql = "select max(time(data_hora)) as time
				FROM log_atendimentos";
			if ($hist) $sql .= "_hist";
			$sql .= " where (tipo='Terminado' or tipo='Desistencia')";
			if (strlen($servico)) $sql .= " and id_servico='" . $servico . "'";
			if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
				AND date(data_hora)='" . $data . "'";
		
        $res = $this->_db->Execute($sql);
		$terminado = $this->_db->Fields($res, "time");
        
		$sql = "select time_to_sec(time(data_hora)) as sec
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where tipo='Chamada'";
		if (strlen($servico)) $sql .= " and id_servico='" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'";
		if (strlen($terminado)) $sql .= " and time(data_hora)<='" . $terminado . "'";
		$sql .= " order by id_log_atendimentos";
		
		//debug("chamadas: " . $sql);
		
		$chamadas = $this->_db->Query($sql);

		$sql = "select time_to_sec(time(data_hora)) as sec
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where tipo='Suspensa'";
		if (strlen($servico)) $sql .= " and id_servico='" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'";
		if (strlen($terminado)) $sql .= " and time(data_hora)<='" . $terminado . "'";
		$sql .= " order by id_log_atendimentos";
		
		//debug("suspensas: " . $sql);
		
		$suspensas = $this->_db->Query($sql);
		
		//debug(print_r($chamadas, true)."\n".print_r($suspensas, true));
		
		$tempoAtendimento = 0;
		for ($i = 0; $i < count($suspensas); $i++)
		{
			if ($chamadas[$i]["sec"])
				$tempoAtendimento += ($suspensas[$i]["sec"] - $chamadas[$i]["sec"]);
		}

		$sql = "SELECT time_to_sec(time(data_hora)) as sec
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where (tipo='Terminado' or tipo='Desistencia')";
		if (strlen($servico)) $sql .= " and id_servico='" . $servico . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			AND date(data_hora)='" . $data . "'";
		
		$res = $this->_db->Execute($sql);
		$terminado = $this->_db->Fields($res, "sec");
		if (count($chamadas) && $terminado)
			$tempoAtendimento += ($terminado - $chamadas[count($chamadas) - 1]["sec"]);
        
        /*if ($new)
        {
            $sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, tempo_atendimento) values (
                '" . $data . "',
                '" . $arrSenha[0] . "',
                '" . $local . "',
                '" . $arrSenha[1] . "',
                '" . date("H:i:s", $tempoAtendimento - 3600) . "')";
                
            $res = $this->_db->Execute($sql);
        }
        else if ($write)
        {
            $sql = "update senhas
                set tempo_atendimento='" . date("H:i:s", $tempoAtendimento - 3600 ) . "'
                where id_senha='" . $id_senha . "'";
            //if ($data=='2008-08-18' && $senha=='15_2') debug("senhas: " . $sql);
            $res = $this->_db->Execute($sql);
        }*/
        
		return $tempoAtendimento;
	}
    
	function GetTempoMedioEspera($local="", $servico, $data, $balcao="", $hist=false, $iTime='', $fTime='')
	{
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico = '" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and tipo='Chamada'
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
        if ($iTime && $fTime)
		$sql .= " and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'";
        
        //~ debug($sql);
        
        $res = $this->_db->Execute($sql);
		$senhas = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($senhas, $row["senha"]);
			
			//~ print_r($senhas);
        
        //~ $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
				//~ from log_atendimentos";
			//~ if ($hist) $sql .= "_hist";
			//~ $sql .= " WHERE id_servico = '" . $servico . "'";
			//~ if (strlen($balcao)) $sql .= " and id_balcao= '" . $balcao . "'";
			//~ if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			//~ $sql .= " and tipo='Anulada'
				//~ AND numero_senha != 0
				//~ AND date(data_hora)='" . $data . "'";
                //~ if ($iTime && $fTime)
            //~ $sql .= " and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'";
        
        //~ $res = $this->_db->Execute($sql);
        //~ unset($this->_auxArr);
		//~ $this->_auxArr = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($this->_auxArr, $row["senha"]);
        
		//~ $senhas = array_filter($senhas, array($this,"notIn")); 
		$tempoEspera = 0;
		for ($i=0; $i<count($senhas); $i++)
		{
			$tempoEspera += $this->GetTempoEspera($local, $servico, $data, $senhas[$i], $hist);
		}
		
		if (!count($senhas)) return "00:00:00";
		else return date("H:i:s", ($tempoEspera / count($senhas)) - 3600);
	}
	
	function GetTempoMedioEsperaFromResumo($data, $local="", $servico="", $balcao="")
	{
		$sql = "select tempo_medio_espera, senhas_chamadas, id_servico
			from resumodiario
			where data_resumo='" . $data . "'";
		if (strlen($local))
			$sql .= " and id_loja='" . $local . "'";
		if (strlen($servico))
			$sql .= " and id_servico='" . $servico . "'";
		if (strlen($balcao))
			$sql .= " and id_balcao='" . $balcao . "'";
		
		$res = $this->_db->Query($sql);
		$tempoEspera = 0;
		$senhasChamadas = 0;
		for ($i=0; $i<count($res); $i++)
		{
			$senhasChamadas += $res[$i]["senhas_chamadas"];
			$tempoEspera += (GetSecondsFromTimeString($res[$i]["tempo_medio_espera"]) * $res[$i]["senhas_chamadas"]);
		}
		
		if (!$senhasChamadas) return "00:00:00";
		else return date("H:i:s", ($tempoEspera/$senhasChamadas) - 3600);
	}
	
	function GetTempoMedioAtendimento($local="", $servico, $data, $balcao="", $hist=false, $iTime='', $fTime='')
	{
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " WHERE id_servico = '" . $servico . "'";
		if (strlen($balcao)) $sql .= " and id_balcao='" . $balcao . "'";
		if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
		$sql .= " and tipo='Terminado'
			AND numero_senha != 0
			AND date(data_hora)='" . $data . "'";
        if ($iTime && $fTime)
            $sql .= " and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'";
            
        $res = $this->_db->Execute($sql);
		$senhas = array();
		while ($row = $this->_db->FetchRow($res))
			array_push($senhas, $row["senha"]);
        
	//debug($sql . "\n\nsenhas tempo medio atendimento: " . print_r($senhas, true));
	//~ debug($sql);
	
        //~ $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
				//~ from log_atendimentos";
			//~ if ($hist) $sql .= "_hist";
			//~ $sql .= " WHERE id_servico = '" . $servico . "'";
			//~ if (strlen($balcao)) $sql .= " and id_balcao= '" . $balcao . "'";
			//~ if (strlen($local)) $sql .= " and id_loja='" . $local . "'";
			//~ $sql .= " and tipo='Anulada'
				//~ AND numero_senha != 0
				//~ AND date(data_hora)='" . $data . "'";
        //~ if ($iTime && $fTime)
            //~ $sql .= " and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'";
        
        //~ $res = $this->_db->Execute($sql);
        //~ unset($this->_auxArr);
		//~ $this->_auxArr = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($this->_auxArr, $row["senha"]);
				
		//~ $senhas = array_filter($senhas, array($this,"notIn"));
		$tempoAtendimento = 0;
		for ($i=0; $i<count($senhas); $i++)
		{
			$tempoAtendimento += $this->GetTempoAtendimento($local, $servico, $data, $senhas[$i], $hist);
		}
		
		if (!count($senhas)) return "00:00:00";
		else return date("H:i:s", ($tempoAtendimento / count($senhas)) - 3600);
	}
	
	function GetTempoMedioAtendimentoFromResumo($data, $local="", $servico="", $balcao="")
	{
		$sql = "select tempo_medio_atendimento, senhas_chamadas
			from resumodiario
			where data_resumo='" . $data . "'";
		if (strlen($local))
			$sql .= " and id_loja='" . $local . "'";
		if (strlen($servico))
			$sql .= " and id_servico='" . $servico . "'";
		if (strlen($balcao))
			$sql .= " and id_balcao='" . $balcao . "'";
		
		$res = $this->_db->Query($sql);
		$tempoAtendimento = 0;
		$senhasChamadas = 0;
		for ($i=0; $i<count($res); $i++)
		{
			$senhasChamadas += $res[$i]["senhas_chamadas"];
			$tempoAtendimento += (GetSecondsFromTimeString($res[$i]["tempo_medio_atendimento"]) * $res[$i]["senhas_chamadas"]);
		}
				
		if (!$senhasChamadas) return "00:00:00";
		else return date("H:i:s", ($tempoAtendimento/$senhasChamadas) - 3600);
	}
	
	function GetNumeroSenhasChamadas($local="", $servico, $data, $balcao="", $hist=false, $iTime='', $fTime='')
	{
		$sql = "select count(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where date(data_hora)='" . $data . "'";
		if (strlen($local))
			$sql .= " and id_loja='" . $local . "'";
		if (strlen($servico))
			$sql .= " and id_servico='" . $servico . "'";
		if (strlen($balcao))
			$sql .= " and id_balcao='" . $balcao . "'";
		$sql .= " and tipo='Chamada'";
		if ($iTime && $fTime)
			$sql .= " and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'";
		$sql .= " and numero_senha!='0'";
		
		$res = $this->_db->Execute($sql);
		return $this->_db->Fields($res, "n");
	}
	
	function GetNumeroSenhasChamadasBetweenTime($data, $iTime, $fTime, $hist=false, $local="", $servico="", $balcao="")
	{
		$sql = "select count(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			from log_atendimentos";
		if ($hist) $sql .= "_hist";
		$sql .= " where date(data_hora)='" . $data . "'";
		if (strlen($local))
			$sql .= " and id_loja='" . $local . "'";
		if (strlen($servico))
			$sql .= " and id_servico='" . $servico . "'";
		if (strlen($balcao))
			$sql .= " and id_balcao='" . $balcao . "'";
		$sql .= " and tipo='Chamada'
			and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'
			and numero_senha!='0'";
		
		$res = $this->_db->Execute($sql);
		return $this->_db->Fields($res, "n");
		
        //~ $res = $this->_db->Execute($sql);
		//~ $senhas = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($senhas, $row["senha"]);
            
		//~ $sql = "select distinct concat_ws('_', numero_senha, servico_emissao) as senha
			//~ from log_atendimentos";
		//~ if ($hist) $sql .= "_hist";
		//~ $sql .= " where date(data_hora)='" . $data . "'";
		//~ if (strlen($local))
			//~ $sql .= " and id_loja='" . $local . "'";
		//~ if (strlen($servico))
			//~ $sql .= " and id_servico='" . $servico . "'";
		//~ if (strlen($balcao))
			//~ $sql .= " and id_balcao='" . $balcao . "'";
		//~ $sql .= " and tipo='Desistencia'
			//~ and time(data_hora) between '" . $iTime . "' and '" . $fTime . "'
			//~ and numero_senha!='0'";
            
        //~ $res = $this->_db->Execute($sql);
        //~ unset($this->_auxArr);
		//~ $this->_auxArr = array();
		//~ while ($row = $this->_db->FetchRow($res))
			//~ array_push($this->_auxArr, $row["senha"]);
        
        //~ $newArray = array_filter($senhas, array($this,"notIn")); 
        
		//~ return count($newArray);
	}
	
    function GetHoraEmissaoFromSenha($data, $numero_senha, $id_loja, $servico_emissao)
    {
        $sql = "select hora_emissao from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
    }
    
    function GetBalcaoFromSenha($data, $numero_senha, $id_loja, $servico_emissao)
    {
        $sql = "select id_balcao from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
    }
    
    function GetColaboradorFromSenha($data, $numero_senha, $id_loja, $servico_emissao)
    {
        $sql = "select id_colaborador from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
    }
    
    function IsSenhaDesistida($data, $numero_senha, $id_loja, $servico_emissao)
    {
        $sql = "select desistencia from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
            
        $res = $this->_db->Execute($sql);
		$desistida = $this->_db->Fields($res, "desistencia");
        
        if ($desistida == null)
        {
            $sql = "select count(id_log_atendimentos)";
        }
        else return $desistida;
    }
}
?>
