-- MySQL dump 10.11
--
-- Host: localhost    Database: mobline
-- ------------------------------------------------------
-- Server version	5.0.51a

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `balcoes`
--

DROP TABLE IF EXISTS `balcoes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `balcoes` (
  `id_balcao` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(20) collate latin1_general_ci NOT NULL,
  `id_loja` int(10) unsigned NOT NULL default '0',
  `estado` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_balcao`,`id_loja`),
  KEY `id_loja3` (`id_loja`),
  KEY `FK_balcoes_2` (`estado`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Balcoes de um dada loja';
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `dispensador`
--

DROP TABLE IF EXISTS `dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `dispensador` (
  `id_dispensador` int(10) unsigned NOT NULL auto_increment,
  `estado` int(10) unsigned NOT NULL default '1' COMMENT 'Estado,30,52,16,nenhuma,1,0,9',
  `nome` varchar(45) NOT NULL COMMENT 'Identificador,30,52,1,nenhuma,1,0',
  `id_loja` int(10) unsigned NOT NULL default '0' COMMENT 'Loja,30,52,16,nenhuma,1,0,6',
  `tipo_dispensador` int(10) unsigned NOT NULL default '0',
  `ordem` int(11) default NULL,
  PRIMARY KEY  (`id_dispensador`,`id_loja`),
  KEY `FK_dispensador_1` (`id_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COMMENT='Tabela geral dos dispensadores';
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `dispensador_base`
--

DROP TABLE IF EXISTS `dispensador_base`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `dispensador_base` (
  `id_dispensador_base` int(10) unsigned NOT NULL auto_increment,
  `id_dispensador` int(10) unsigned NOT NULL,
  `identificador` varchar(255) collate latin1_general_ci default NULL,
  `msg_boasvindas` varchar(255) collate latin1_general_ci default NULL,
  `msg_impressaosenha` varchar(255) collate latin1_general_ci default NULL,
  `tipo_processador` int(10) unsigned NOT NULL,
  `tipo_impressora` int(10) unsigned NOT NULL,
  `tipo_ecra` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_dispensador_base`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Dispensadores com ecra tactil';
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `dispensador_manual`
--

DROP TABLE IF EXISTS `dispensador_manual`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `dispensador_manual` (
  `id_dispensador_manual` int(10) unsigned NOT NULL auto_increment,
  `id_servico` int(10) unsigned default NULL COMMENT 'Serviço Associado,30,52,16,nenhuma,1,0,8',
  `id_dispensador` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_dispensador_manual`),
  KEY `FK_dispensador_manual_1` (`id_servico`),
  KEY `FK_dispensador_manual_3` (`id_dispensador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Dispensadores bico de pato';
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `ecra`
--

DROP TABLE IF EXISTS `ecra`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ecra` (
  `id_ecra` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) default NULL COMMENT 'Nome,30,52,1,nenhuma,0,0',
  `identificador` varchar(45) NOT NULL default '' COMMENT 'Identificador,30,52,1,nenhuma,1,0',
  `estado` int(10) unsigned NOT NULL default '1' COMMENT 'Estado,30,52,16,nenhuma,1,0,11',
  `id_loja` int(10) unsigned NOT NULL default '0' COMMENT 'Loja,30,52,16,nenhuma,1,0,6',
  PRIMARY KEY  (`id_ecra`,`id_loja`),
  KEY `FK_ecra_1` (`id_loja`),
  KEY `FK_ecra_2` (`estado`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='Ecras';
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `ecra_dispensador`
--

DROP TABLE IF EXISTS `ecra_dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ecra_dispensador` (
  `id_ecra` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_ecra`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='Ecras associados a um Dispensador';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ecra_dispensador`
--

LOCK TABLES `ecra_dispensador` WRITE;
/*!40000 ALTER TABLE `ecra_dispensador` DISABLE KEYS */;
INSERT INTO `ecra_dispensador` VALUES (1,'abc','abc','abcd'),(2,'elotouch 12\"','elotouch','?'),(3,'Elotouch 15','Elotouch','MacroSevice');
/*!40000 ALTER TABLE `ecra_dispensador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empregados`
--

DROP TABLE IF EXISTS `empregados`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `empregados` (
  `id_empregado` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(50) NOT NULL default '',
  `nome_utilizador` varchar(20) default NULL,
  `password` varchar(20) default NULL,
  `num_tentativas` tinyint(3) unsigned NOT NULL default '0',
  `estado` tinyint(3) unsigned NOT NULL default '1',
  `contacto` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_empregado`),
  UNIQUE KEY `nome_utilizador_2` (`nome_utilizador`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `estados_balcao`
--

DROP TABLE IF EXISTS `estados_balcao`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `estados_balcao` (
  `id_estados_balcao` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estados_balcao`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='Estados associados a um balcao';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `estados_balcao`
--

LOCK TABLES `estados_balcao` WRITE;
/*!40000 ALTER TABLE `estados_balcao` DISABLE KEYS */;
INSERT INTO `estados_balcao` VALUES (1,'Em Funcionamento'),(2,'Funcionamento Suspenso'),(3,'Obsoleto/Inexistente');
/*!40000 ALTER TABLE `estados_balcao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estados_dispensador`
--

DROP TABLE IF EXISTS `estados_dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `estados_dispensador` (
  `id_estado_dispensador` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estado_dispensador`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='Estados associados a um balcao';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `estados_dispensador`
--

LOCK TABLES `estados_dispensador` WRITE;
/*!40000 ALTER TABLE `estados_dispensador` DISABLE KEYS */;
INSERT INTO `estados_dispensador` VALUES (1,'Operacional'),(2,'Inoperacional'),(3,'Sem Papel');
/*!40000 ALTER TABLE `estados_dispensador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estados_ecra`
--

DROP TABLE IF EXISTS `estados_ecra`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `estados_ecra` (
  `id_estados_ecra` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estados_ecra`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='Estados associados a um ecra';
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `estados_ecra`
--

LOCK TABLES `estados_ecra` WRITE;
/*!40000 ALTER TABLE `estados_ecra` DISABLE KEYS */;
INSERT INTO `estados_ecra` VALUES (1,'Activo'),(2,'Avariado'),(3,'Inactivo');
/*!40000 ALTER TABLE `estados_ecra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estados_impressora`
--

DROP TABLE IF EXISTS `estados_impressora`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `estados_impressora` (
  `id_estado_impressora` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estado_impressora`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `estados_impressora`
--

LOCK TABLES `estados_impressora` WRITE;
/*!40000 ALTER TABLE `estados_impressora` DISABLE KEYS */;
INSERT INTO `estados_impressora` VALUES (1,'Operacional'),(2,'Inoperacional'),(3,'Sem Papel');
/*!40000 ALTER TABLE `estados_impressora` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `horario_loja`
--

DROP TABLE IF EXISTS `horario_loja`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `horario_loja` (
  `id_horario_loja` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(60) NOT NULL default '',
  `abertura_0` time default NULL,
  `fecho_0` time default NULL,
  `abertura_1` time default NULL,
  `fecho_1` time default NULL,
  `abertura_2` time default NULL,
  `fecho_2` time default NULL,
  `abertura_3` time default NULL,
  `fecho_3` time default NULL,
  `abertura_4` time default NULL,
  `fecho_4` time default NULL,
  `abertura_5` time default NULL,
  `fecho_5` time default NULL,
  `abertura_6` time default NULL,
  `fecho_6` time default NULL,
  PRIMARY KEY  (`id_horario_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `impressora_dispensador`
--

DROP TABLE IF EXISTS `impressora_dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `impressora_dispensador` (
  `id_impressora` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_impressora`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `impressora_dispensador`
--

LOCK TABLES `impressora_dispensador` WRITE;
/*!40000 ALTER TABLE `impressora_dispensador` DISABLE KEYS */;
INSERT INTO `impressora_dispensador` VALUES (4,'abcv','abc','abc'),(5,'TUP900','STAR','STAR'),(6,'Epson tm-t70','Epson','CPC');
/*!40000 ALTER TABLE `impressora_dispensador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_colaborador`
--

DROP TABLE IF EXISTS `local_colaborador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `local_colaborador` (
  `id_local` int(10) unsigned NOT NULL,
  `id_colaborador` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_local`,`id_colaborador`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `log_accoes`
--

DROP TABLE IF EXISTS `log_accoes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_accoes` (
  `id_log_accoes` int(10) unsigned NOT NULL auto_increment,
  `id_utilizador` int(10) unsigned default NULL,
  `id_loja` int(10) unsigned default NULL,
  `objecto` varchar(45) collate latin1_general_ci NOT NULL,
  `nome_objecto` varchar(45) collate latin1_general_ci NOT NULL,
  `accao` varchar(45) collate latin1_general_ci NOT NULL,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_log_accoes`),
  KEY `id_loja8` (`id_loja`),
  KEY `id_utilizador` (`id_utilizador`)
) ENGINE=MyISAM AUTO_INCREMENT=715 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='InnoDB free: 3072 kB; (`id_loja`) REFER `q_local/lojas`(`id';
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `log_acessos`
--

DROP TABLE IF EXISTS `log_acessos`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_acessos` (
  `id_acessos` int(11) NOT NULL auto_increment,
  `utilizador` varchar(100) character set latin1 collate latin1_general_ci NOT NULL default '',
  `tipo` varchar(100) character set latin1 collate latin1_general_ci NOT NULL default '',
  `acesso` varchar(20) character set latin1 collate latin1_general_ci NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `endereco` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`id_acessos`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `log_acessos_empregados`
--

DROP TABLE IF EXISTS `log_acessos_empregados`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_acessos_empregados` (
  `id_acessos` int(11) NOT NULL auto_increment,
  `id_empregado` int(10) unsigned default NULL,
  `acesso` varchar(20) character set latin1 collate latin1_general_ci NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_balcao` int(10) unsigned default NULL,
  `id_loja` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_acessos`,`id_loja`),
  KEY `id_loja6` (`id_loja`),
  KEY `FK_log_acessos_empregados_2` (`id_empregado`),
  KEY `FK_log_acessos_empregados_3` (`id_balcao`,`id_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=1849 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 3072 kB; (`id_empregado`) REFER `q_local/empre';
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `log_acessos_utilizadores`
--

DROP TABLE IF EXISTS `log_acessos_utilizadores`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_acessos_utilizadores` (
  `id_acessos` int(11) NOT NULL auto_increment,
  `id_utilizador` int(10) unsigned default NULL,
  `acesso` varchar(20) collate latin1_general_ci NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_acessos`),
  KEY `FK_log_acessos_utilizadores_1` (`id_utilizador`)
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `log_actividade_servicos`
--

DROP TABLE IF EXISTS `log_actividade_servicos`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_actividade_servicos` (
  `id_log_actividade_servicos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_servico` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(45) NOT NULL default '',
  `id_loja` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_log_actividade_servicos`),
  KEY `FK_log_actividade_servicos_1` (`id_loja`),
  KEY `FK_log_actividade_servicos_2` (`id_servico`),
  KEY `FK_log_actividade_servicos_3` (`id_empregado`),
  KEY `FK_log_actividade_servicos_4` (`id_balcao`,`id_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=92639 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `log_atendimentos`
--

DROP TABLE IF EXISTS `log_atendimentos`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_atendimentos` (
  `id_log_atendimentos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_servico` int(10) unsigned default NULL,
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(20) NOT NULL default '',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_dispensador` int(10) unsigned default NULL,
  `nome_cliente` varchar(60) default NULL,
  `servico_emissao` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_log_atendimentos`,`id_loja`),
  KEY `id_servico` (`id_servico`),
  KEY `id_loja5` (`id_loja`),
  KEY `FK_log_atendimentos_4` (`id_empregado`),
  KEY `FK_log_atendimentos_5` (`id_balcao`,`id_loja`),
  KEY `FK_log_atendimentos_6` (`id_dispensador`,`id_loja`),
  KEY `FK_log_atendimentos_7` (`servico_emissao`),
  KEY `idx_servico_loja` (`id_servico`,`id_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=57711 DEFAULT CHARSET=latin1 COMMENT='InnoDB free: 10240 kB; (`id_loja`) REFER `q_local/lojas`(`i';
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `log_atendimentos_hist`
--

DROP TABLE IF EXISTS `log_atendimentos_hist`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `log_atendimentos_hist` (
  `id_log_atendimentos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_servico` int(10) unsigned default NULL,
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(20) collate utf8_unicode_ci NOT NULL default '',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_dispensador` int(10) unsigned default NULL,
  `nome_cliente` varchar(60) collate utf8_unicode_ci default NULL,
  `servico_emissao` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_log_atendimentos`,`id_loja`),
  KEY `id_servico` (`id_servico`),
  KEY `id_loja5` (`id_loja`),
  KEY `FK_log_atendimentos_hist_4` (`id_empregado`),
  KEY `FK_log_atendimentos_hist_5` (`id_balcao`,`id_loja`),
  KEY `FK_log_atendimentos_hist_6` (`id_dispensador`,`id_loja`),
  KEY `FK_log_atendimentos_hist_7` (`servico_emissao`),
  KEY `idx_servico_hst_loja` (`id_servico`,`id_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=57182 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `lojas`
--

DROP TABLE IF EXISTS `lojas`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lojas` (
  `id_loja` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(20) NOT NULL default '',
  `morada` varchar(255) default NULL,
  `horario` int(10) unsigned NOT NULL default '0',
  `previsao_atendimento` tinyint(1) NOT NULL default '0',
  `telefone` int(10) unsigned default NULL,
  `email` varchar(45) default NULL,
  `imprimir_nome` tinyint(1) NOT NULL default '0',
  `imprimir_morada` tinyint(1) NOT NULL default '0',
  `imprimir_telefone` tinyint(1) NOT NULL default '0',
  `imprimir_email` tinyint(1) NOT NULL default '0',
  `endereco` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_loja`),
  KEY `FK_lojas_1` (`horario`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `processador_dispensador`
--

DROP TABLE IF EXISTS `processador_dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `processador_dispensador` (
  `id_processador` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_processador`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `processador_dispensador`
--

LOCK TABLES `processador_dispensador` WRITE;
/*!40000 ALTER TABLE `processador_dispensador` DISABLE KEYS */;
INSERT INTO `processador_dispensador` VALUES (1,'abc','abc','abc'),(2,'VIA 800','VIA','CG'),(3,'VIA 800','VIA','CG'),(4,'Dell','Dell','TMN');
/*!40000 ALTER TABLE `processador_dispensador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `promocao`
--

DROP TABLE IF EXISTS `promocao`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `promocao` (
  `id_promocao` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  `texto` varchar(255) NOT NULL default '',
  `imagem` varchar(180) default NULL,
  PRIMARY KEY  (`id_promocao`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `resumodiario`
--

DROP TABLE IF EXISTS `resumodiario`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `resumodiario` (
  `id_resumo` int(10) unsigned NOT NULL auto_increment,
  `data_resumo` date default NULL,
  `id_servico` int(11) default NULL,
  `id_loja` int(11) default NULL,
  `id_balcao` int(11) default NULL,
  `id_empregado` int(11) default NULL,
  `senhas_emitidas` int(11) default NULL,
  `senhas_chamadas` int(11) default NULL,
  `senhas_desistidas` int(11) default NULL,
  `tempo_medio_espera` time default NULL,
  `tempo_medio_atendimento` time default NULL,
  PRIMARY KEY  (`id_resumo`)
) ENGINE=MyISAM AUTO_INCREMENT=1927 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `resumodiario_temp`
--

DROP TABLE IF EXISTS `resumodiario_temp`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `resumodiario_temp` (
  `id_log_atendimentos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_servico` int(10) unsigned default NULL,
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(20) collate utf8_unicode_ci NOT NULL default '',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_dispensador` int(10) unsigned default NULL,
  `nome_cliente` varchar(60) collate utf8_unicode_ci default NULL,
  `servico_emissao` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_log_atendimentos`,`id_loja`),
  KEY `id_servico` (`id_servico`),
  KEY `id_loja5` (`id_loja`),
  KEY `FK_log_atendimentos_hist_4` (`id_empregado`),
  KEY `FK_log_atendimentos_hist_5` (`id_balcao`,`id_loja`),
  KEY `FK_log_atendimentos_hist_6` (`id_dispensador`,`id_loja`),
  KEY `FK_log_atendimentos_hist_7` (`servico_emissao`),
  KEY `idx_servico_hst_loja` (`id_servico`,`id_loja`)
) ENGINE=MyISAM AUTO_INCREMENT=307 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `senhas`
--

DROP TABLE IF EXISTS `senhas`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `senhas` (
  `id_senha` int(10) unsigned NOT NULL auto_increment,
  `data` date NOT NULL default '0000-00-00',
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `servico_emissao` int(10) unsigned NOT NULL default '0',
  `tempo_espera` time default NULL,
  `tempo_atendimento` time default NULL,
  PRIMARY KEY  (`id_senha`),
  KEY `id_loja5` (`id_loja`),
  KEY `id_senha` (`numero_senha`,`servico_emissao`)
) ENGINE=MyISAM AUTO_INCREMENT=1491 DEFAULT CHARSET=latin1 COMMENT='InnoDB free: 10240 kB; (`id_loja`) REFER `q_local/lojas`(`i';
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `servicos`
--

DROP TABLE IF EXISTS `servicos`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `servicos` (
  `id_servico` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  `identificador` varchar(15) default NULL,
  `limite_clientes` int(10) unsigned default NULL,
  `ordem` int(11) default NULL,
  `horario` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_servico`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `servicos_balcao`
--

DROP TABLE IF EXISTS `servicos_balcao`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `servicos_balcao` (
  `id_balcao` int(10) unsigned NOT NULL,
  `id_servico` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_balcao`,`id_servico`),
  KEY `id_servico` (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Serviços associados a um balcão';
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `servicos_dispensador`
--

DROP TABLE IF EXISTS `servicos_dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `servicos_dispensador` (
  `id_dispensador` int(10) unsigned NOT NULL,
  `id_servico` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_dispensador`,`id_servico`),
  KEY `id_servico` (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Serviços associados a um dispensador';
SET character_set_client = @saved_cs_client;



--
-- Table structure for table `servicos_ecra`
--

DROP TABLE IF EXISTS `servicos_ecra`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `servicos_ecra` (
  `id_ecra` int(10) unsigned NOT NULL,
  `id_servico` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_ecra`,`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `servicos_prestados`
--

DROP TABLE IF EXISTS `servicos_prestados`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `servicos_prestados` (
  `id_servico_prestado` int(10) unsigned NOT NULL auto_increment,
  `id_servico` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `promocao_0` int(10) unsigned default NULL,
  `promocao_1` int(10) unsigned default NULL,
  `promocao_2` int(10) unsigned default NULL,
  `promocao_3` int(10) unsigned default NULL,
  `promocao_4` int(10) unsigned default NULL,
  `promocao_5` int(10) unsigned default NULL,
  `promocao_6` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_servico_prestado`),
  KEY `FK_teclado_web_1` (`id_loja`),
  KEY `FK_teclado_web_2` (`id_servico`),
  KEY `FK_servicos_prestados_3` (`promocao_0`),
  KEY `FK_servicos_prestados_4` (`promocao_1`),
  KEY `FK_servicos_prestados_5` (`promocao_2`),
  KEY `FK_servicos_prestados_6` (`promocao_3`),
  KEY `FK_servicos_prestados_7` (`promocao_4`),
  KEY `FK_servicos_prestados_8` (`promocao_5`),
  KEY `FK_servicos_prestados_9` (`promocao_6`),
  KEY `Index_11` (`id_loja`,`id_servico_prestado`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `sistema_central`
--

DROP TABLE IF EXISTS `sistema_central`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `sistema_central` (
  `id_sistema_central` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(60) default NULL,
  `endereco` varchar(45) NOT NULL default '',
  `ultima_actualizacao` datetime default NULL,
  PRIMARY KEY  (`id_sistema_central`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `status_impressora`
--

DROP TABLE IF EXISTS `status_impressora`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `status_impressora` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `text` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `status_impressora`
--

LOCK TABLES `status_impressora` WRITE;
/*!40000 ALTER TABLE `status_impressora` DISABLE KEYS */;
INSERT INTO `status_impressora` VALUES (1,'Normal'),(2,'Sem Papel'),(3,'Desligada/Offline'),(4,'Papel Prox do Fim'),(5,'Erro Desconhecido');
/*!40000 ALTER TABLE `status_impressora` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `status_terminal`
--

DROP TABLE IF EXISTS `status_terminal`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `status_terminal` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `text` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `status_terminal`
--

LOCK TABLES `status_terminal` WRITE;
/*!40000 ALTER TABLE `status_terminal` DISABLE KEYS */;
INSERT INTO `status_terminal` VALUES (1,'Bateria Normal'),(2,'Pouca Bateria');
/*!40000 ALTER TABLE `status_terminal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_dispositivo`
--

DROP TABLE IF EXISTS `tipo_dispositivo`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tipo_dispositivo` (
  `id_tipo_dispositivo` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_tipo_dispositivo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Informação geral relativa a um dado dispositivo';
SET character_set_client = @saved_cs_client;


--
-- Table structure for table `tipos_dispensador`
--

DROP TABLE IF EXISTS `tipos_dispensador`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tipos_dispensador` (
  `id_tipos_dispensador` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '' COMMENT 'Nome do Tipo,30,52,1,nenhuma,1,0',
  `nome_tabela` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_tipos_dispensador`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tipos_dispensador`
--

LOCK TABLES `tipos_dispensador` WRITE;
/*!40000 ALTER TABLE `tipos_dispensador` DISABLE KEYS */;
INSERT INTO `tipos_dispensador` VALUES (1,'Base','dispensador_base'),(2,'Bico De Pato','dispensador_manual');
/*!40000 ALTER TABLE `tipos_dispensador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipos_utilizadores`
--

DROP TABLE IF EXISTS `tipos_utilizadores`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tipos_utilizadores` (
  `id_tipos_utilizadores` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(100) collate latin1_general_ci NOT NULL default '',
  `perm_utilizadores` tinyint(4) NOT NULL default '0',
  `perm_tipos_utilizadores` tinyint(4) NOT NULL default '0',
  `perm_log_acessos_empregados` tinyint(4) NOT NULL default '0',
  `perm_log_acessos_utilizadores` tinyint(3) unsigned NOT NULL default '0',
  `perm_empregados` tinyint(3) unsigned NOT NULL default '0',
  `perm_log_accoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_config_teclado` tinyint(3) unsigned NOT NULL default '0',
  `perm_tipos_terminal` tinyint(3) unsigned NOT NULL default '0',
  `perm_tipos_impressora` tinyint(3) unsigned NOT NULL default '0',
  `perm_tipos_dispensador` tinyint(3) unsigned NOT NULL default '0',
  `perm_terminal` tinyint(3) unsigned NOT NULL default '0',
  `perm_impressora` tinyint(3) unsigned NOT NULL default '0',
  `perm_dispensador` tinyint(3) unsigned NOT NULL default '0',
  `perm_lojas` tinyint(3) unsigned NOT NULL default '0',
  `perm_servicos` tinyint(3) unsigned NOT NULL default '0',
  `perm_balcoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_promocoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_estatisticas` tinyint(3) unsigned NOT NULL default '0',
  `perm_previsoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_ecra` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_tipos_utilizadores`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tipos_utilizadores`
--

LOCK TABLES `tipos_utilizadores` WRITE;
/*!40000 ALTER TABLE `tipos_utilizadores` DISABLE KEYS */;
INSERT INTO `tipos_utilizadores` VALUES (1,'Gestor',2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2);
/*!40000 ALTER TABLE `tipos_utilizadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `utilizadores`
--

DROP TABLE IF EXISTS `utilizadores`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `utilizadores` (
  `id_utilizadores` int(10) unsigned NOT NULL auto_increment,
  `id_tipos_utilizadores` int(10) unsigned NOT NULL default '0',
  `nome` varchar(50) collate latin1_general_ci NOT NULL default '',
  `nome_utilizador` varchar(20) collate latin1_general_ci NOT NULL default '',
  `palavra_chave` varchar(20) collate latin1_general_ci NOT NULL default '',
  `estado` tinyint(4) NOT NULL default '0',
  `num_tentativas` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id_utilizadores`),
  UNIQUE KEY `nome_utilizador` (`nome_utilizador`),
  KEY `id_tipos_utilizadores` (`id_tipos_utilizadores`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `utilizadores`
--

LOCK TABLES `utilizadores` WRITE;
/*!40000 ALTER TABLE `utilizadores` DISABLE KEYS */;
INSERT INTO `utilizadores` VALUES (1,1,'Gestor Mobbit','dolce','vita',0,0);
/*!40000 ALTER TABLE `utilizadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `variaveis`
--

DROP TABLE IF EXISTS `variaveis`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `variaveis` (
  `id_variavel` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(60) NOT NULL default '',
  `valor` varchar(60) NOT NULL default '',
  PRIMARY KEY  (`id_variavel`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `variaveis`
--

LOCK TABLES `variaveis` WRITE;
/*!40000 ALTER TABLE `variaveis` DISABLE KEYS */;
INSERT INTO `variaveis` VALUES (1,'tempo_minimo_atendimento','30'),(2,'tempo_maximo_atendimento','3600'),(3,'uri_actualizacao_ecras','/senhas/qmobbit.php');
/*!40000 ALTER TABLE `variaveis` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2008-08-07 12:42:57
