<?php 

/* Classe de Gestão de Balcões */

class Balcao extends AcessoBD{
	var $bd;

	/*
	   Construtor da classe

	   0 = Erro da BD
	 */
	function Balcao() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	function GetBalcaoFromButtonId($buttonid)
	{
		$sql = "select id_balcao from balcoes where buttonid='".$buttonid."'";
		if (!$rs = $this->bd->executarSQL($sql)) 
			return 0;
		else 
			return $this->bd->obterValor($rs, "id_balcao");
	}

	/*
	 * Devolve os balcoes existentes numa dada loja.
	 */
	function obtemLista($loja , $entidade) {
                /*
                 *  A porra do erro aparece aqui
                 *  Por vezes nao se consegue efectuar ligacao à base de dados
                 * 
                 */

		$userid = $_SESSION['sessao_empregado'];
		$sql = "SELECT b.id_balcao, b.nome FROM `balcoes` b join empregados e on b.id_balcao=e.id_balcao AND e.id_empregado=".$userid;

		$lista = array("id","nome");

		$rs = $this->bd->executarSQL($sql);

		global $ERROS;
		if(!$rs) {
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return $lista;
		}

		if($this->bd->obterNumRegistos($rs)==0)
		{
			/*
				retorna a lista de balcoes que não estão assignados a um empregado
			*/
			$sql = "SELECT b.id_balcao, b.nome FROM `balcoes` b	where b.id_balcao NOT IN (select emp.id_balcao from empregados emp where emp.id_balcao IS NOT NULL) ORDER BY b.nome";
			$rs = $this->bd->executarSQL($sql);
		}

		for($i = 0 ;  $i < $this->bd->obterNumRegistos($rs) ; $i++){
			$this->bd->moverRegisto($rs, $i);
			$tuplo = $this->bd->obterRegisto($rs);
			$lista["id"][$i] = $tuplo["id_balcao"];
			$lista["nome"][$i] = $tuplo["nome"];
		}

		return $lista;
	}


	/*
	 * Função que devolve os serviços associados a um
	 * balcão.
	 */
	function DevolveServicosAssociados($id_balcao)
	{
		$diaSemana = date("N") + 1; // 2 (Segunda) a 8 (Domingo)
		if ($diaSemana==7) $diaSemana = 0; // sabado
		if ($diaSemana==8) $diaSemana = 1; // domingo	
		$diaAnterior = ($diaSemana==0)?6:($diaSemana - 1);

		$sql = "select sb.id_servico id, s.nome nome, s.prioridade prioridade, e.nome entidade, sb.servico_prioritario, s.horario as id_horario ";
		$sql.= "from servicos_balcao sb
					inner join servicos s on sb.id_servico=s.id_servico
					inner join entidades e on e.id_entidade = s.id_entidade
					where sb.id_balcao='".$id_balcao."'";
					
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}

		$servicos = array();
		$num_servicos = $this->bd->obterNumRegistos($rs);

		for ($i=0 ; $i < $num_servicos ; $i++) {

			$servico = $this->bd->obterRegisto($rs);
			$horario = new Horario();
			$horario->get($servico["id_horario"]);
			$servico["24h"] = $horario->isContinuouslyOpenToday();

			array_push($servicos, $servico);
		}

		return $servicos;
	}

	function GetLoja($id_balcao)
	{
		$sql = "select id_loja
			from balcoes
			where id_balcao='" . $id_balcao . "'";
		if (!$rs = $this->bd->executarSQL($sql)) return 0;
		else return $this->bd->obterValor($rs, "id_loja");
	}

	function GetServicos24h($id_balcao) {

		if (empty($id_balcao))
			return;

		$servico = new Servico();
		$servicos = $this->DevolveServicosAssociados($id_balcao);
		$num_svcs = count($servicos);

		$servicos24h = array();
		for ($i = 0; $i < $num_svcs; $i++) {
			if (!isset($servicos24h[$servicos[$i]["id"]])) {
				$servicos24h[$servicos[$i]["id"]] = $servico->Is24HourService($servicos[$i]["id"]);
			}
		}

		return $servicos24h;
	}

	function GetServicosPrioritarios($id_balcao) {

		if (empty($id_balcao))
			return;


		$servico = new Servico();
		$servicos = array();
        
		$sql = "select sb.id_servico id, s.nome nome, s.prioridade prioridade, e.nome entidade 
		  from servicos_balcao sb
		  inner join servicos s on s.id_servico=sb.id_servico
		  inner join entidades e on e.id_entidade=s.id_entidade
		  WHERE sb.id_balcao='" . $id_balcao . "'
		  AND sb.servico_prioritario=1";

		if (!$rs = $this->bd->executarSQL($sql)) {
			return $servicos;
		}


		$num_svcs = $this->bd->obterNumRegistos($rs);
		for ($i = 0; $i < $num_svcs; $i++) {
			$servicos[] = $this->bd->obterRegisto($rs);
		}
		$servicosPrioritarios = array();
		for ($i = 0; $i < $num_svcs; $i++) {
			if (!isset($servicosPrioritarios[$servicos_prioritarios[$i]["id"]])) {
				$servicosPrioritarios[$servicos[$i]["id"]] = true;
			}
		}
		
		return $servicosPrioritarios;
	}

	/*function GetServicoPrioritario($id_balcao)
	  {
	  $sql = "select id_servico_prioritario
	  from balcoes
	  where id_balcao='" . $id_balcao . "'";
	  if (!$rs = $this->bd->executarSQL($sql)) return 0;
	  else return $this->bd->obterValor($rs, "id_servico_prioritario");
	  }*/

	/*function GetServicosPrioritarios($id_balcao)
	  {
	  $sql = "select spb.id_servico id, s.nome nome, s.prioridade prioridade, e.nome entidade 
	  from servicos_prioritarios_balcao spb
	  inner join servicos s on s.id_servico=spb.id_servico
	  inner join entidades e on e.id_entidade=s.id_entidade
	  where spb.id_balcao='".$id_balcao."'";

	  if(!$rs = $this->bd->executarSQL($sql)){
	  return 0;
	  }

	  $servicos = array();
	  $num_servicos = $this->bd->obterNumRegistos($rs);

	  for ($i=0 ; $i < $num_servicos ; $i++) {
	  array_push($servicos, $this->bd->obterRegisto($rs));
	  }

	  return $servicos;
	  }*/

        
	function updateTimers($current_state, $future_state){
         $time_log=new timeManager();
         $id_empregado=$_SESSION["sessao_empregado"];
			
         //se a data em que terminou o atendimento difere da data em que o começou
         if(date("Y-m-d")!=date("Y-m-d", $current_state['time']) && ( $current_state['id']=='1' || $current_state['id']=='2' || $current_state['id']=='4'|| $current_state['id']=='5') && $current_state['id']!=''){
			
           $startTimeStamp = mktime(0, 0, 0, date("m", $current_state['time']), date("d", $current_state['time']), date("Y", $current_state['time']));
			$actualTimeStamp =  $startTimeStamp;
            $endDateTimeStamp = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
             
            //enche o q falta p o resto do 1o dia
            $interval=0;
            while($actualTimeStamp < $endDateTimeStamp && $startTimeStamp > 0 ) { //GE ADDED && $startTimeStamp > 0 
                if($actualTimeStamp == $startTimeStamp){
                     $interval=86400-$current_state['seconds'];
                }else{
                      $interval=86400;
                } 
            
                switch($current_state['id']){
                    //se esta ha mais de um dia em atendimento
                    case 1: 
                        $time_log->updateTempoAtendimento($id_empregado, $interval, $actualTimeStamp);
                        break;
                    //se esta ha mais de um dia suspenso
                    case 2:
                        $time_log->updateTempoSuspenso($id_empregado, $interval, $actualTimeStamp);
                        break;
                }
                $time_log->updateTempoSessao($id_empregado, $interval, $actualTimeStamp);
                
                $actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp)+1, date("Y", $actualTimeStamp));
            }
			
         }       
     
         
        ////terminou um atendimento
        if($current_state['id']=='1' && ($future_state=='4' || $future_state=='3' || $future_state=='5')){
            $interval=time()-$current_state['time'];
            $time_log->updateTempoAtendimento($id_empregado, $interval, time());     
        }
              
        ////terminou suspensao
        if($current_state['id']=='2' && ($future_state=='4' || $future_state=='3' || $future_state=='5')){
            $interval=time()-$current_state['time'];
            $time_log->updateTempoSuspenso($id_empregado, $interval, time());    
        }
              
        if($current_state['id']=='5' && ($future_state=='4' || $future_state=='3' || $future_state=='2')){
            $interval=time()-$current_state['time'];
            $time_log->updateTempoSuspenso($id_empregado, $interval, time());    
        } 
        if($current_state['id']!='3'){
        $interval=time()-$current_state['time'];
        $time_log->updateTempoSessao($id_empregado, $interval, time());
        }
		
    }  
        
        
	function GetEstado($id)
	{
		$sql = "select estado from balcoes where id_balcao='".$id."'";

		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}
		else return $this->bd->obterValor($rs, "estado");
	}

        function GetEstadoTime($id)
	{
		$sql = "select estado, UNIX_TIMESTAMP(data_hora) as data_hora, TIME_TO_SEC(TIME(data_hora)) as seconds from balcoes where id_balcao='".$id."'";

		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}                
        $estado=array();			
		$estado['id']=$this->bd->obterValor($rs, "estado");	
        $estado['time']=$this->bd->obterValor($rs, "data_hora");				
        $estado['seconds']=$this->bd->obterValor($rs, "seconds");
        return $estado;
	}
      
        
	function SetEstado($id, $s)
	{       
		$current_s=$this->GetEstadoTime($id);
        if($current_s['id']!=$s){
               
			$sql = "update balcoes set estado='".$s."', data_hora=now() where id_balcao='".$id."'";
			
			if(!$rs = $this->bd->executarSQL($sql)) {
				return 0;
			}else{
                $this->updateTimers($current_s, $s);
                $e=new Empregado();
                $e->updateEstado($_SESSION["sessao_empregado"], $s, $id, $_SESSION['sessao_loja']);
            }
			
        }         
	}
             
    function isSameStatus($id, $id_status){
        $sql="SELECT estado FROM balcoes WHERE id_balcao=$id";
        $res=$this->bd->executarSQL($sql);
        $estado=$this->bd->obterValor($res, 'estado');
        
        if($estado==$id_status){
           return 1; 
        }else{
            return 0;
        }
    }
        
	/*
	   Destrutor da classe

	   0 = Erro da BD
	 */		
	function Fechar()
	{
		$this->bd->fecharBD();
	}

	function SetMachine($id, $machname)
	{
		$sql = "update balcoes set machine='".$machname."' where id_balcao='".$id."'";
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}
	}

	function ClearMachine($machname)
	{
		$sql = "update balcoes set machine=null where machine='".$machname."'";
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}
	}

	function GetBalcaoByMachine($machname)
	{
		$sql = "select id_balcao from balcoes where machine='".$machname."'";
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}
		else return $this->bd->obterValor($rs, "id_balcao");
	}

	function GetNome($id)
	{
		$sql = "select nome from balcoes where id_balcao=".$id;
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}
		else return $this->bd->obterValor($rs, "nome");
	}

	function GetPiso($id)
	{
		$sql = "select piso from balcoes where id_balcao='".$id."'";

		if(!$rs = $this->bd->executarSQL($sql)){
			return;
		}
		else return $this->bd->obterValor($rs, "piso");
	}

	function GetBalcoes($estado, $piso, $servico, $ocupados=true, $min_rank="")
	{
		//		$sql = "select distinct b.id_balcao id
		//				from balcoes b
		//				inner join estados_balcao eb on eb.id_estados_balcao=b.estado
		//				inner join servicos_balcao sb on sb.id_balcao=b.id_balcao
		//				where b.estado=".$estado."
		//				and b.piso=".$piso."
		//				and sb.id_servico=".$servico;

		//		$sql = "select distinct b.id_balcao id
		//				from balcoes b
		//				inner join servicos_balcao sb on sb.id_balcao=b.id_balcao
		//				where b.estado=".$estado."
		//				and b.piso=".$piso."
		//				and sb.id_servico=".$servico;

		$sql = "select aux.id, aux.id_balcao, b.piso, b.estado, sb.id_servico, lae.id_empregado, e.ranking, lae.acesso, aux4.status
			from log_acessos_empregados lae
			inner join (
					select max(id_acessos) id, id_balcao
					from log_acessos_empregados
					group by id_balcao) aux on aux.id=lae.id_acessos
			inner join balcoes b on b.id_balcao=aux.id_balcao
			inner join servicos_balcao sb on sb.id_balcao=aux.id_balcao
			inner join empregados e on e.id_empregado=lae.id_empregado
			left join (
					select aux3.id, aux3.id_colaborador, s.status, s.servico_destino
					from senhas s
					inner join (
						select max(id_senha) id, id_colaborador
						from senhas
						group by id_colaborador) aux3 on aux3.id=s.id_senha) aux4 on (aux4.id_colaborador=lae.id_empregado and aux4.servico_destino=sb.id_servico)
			where b.estado=".$estado."
			and b.piso=".$piso."
			and sb.id_servico=".$servico;
		if ($ocupados) $sql .= " and (aux4.status='Chamada' or aux4.status='Rechamada')";
		else $sql .= " and (aux4.status!='Chamada' and aux4.status!='Rechamada')";
		if (strlen($min_rank)) $sql .= " and e.ranking>".$min_rank;

		//		debug(print_r($sql, true), $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");

		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}

		$balcoes = array();
		$num = $this->bd->obterNumRegistos($rs);

		for ($i=0 ; $i < $num ; $i++) {
			array_push($balcoes, $this->bd->obterRegisto($rs));
		}

		return $balcoes;
	}

	function IsBusy($id)
	{
		$sql = "select count(*) as n
			from senhas
			where (status='Chamada' or status='Rechamada')
			and (data = curdate() OR data = date_add(curdate(), INTERVAL -1 DAY))
			and id_balcao=".$id;

		if(!$rs = $this->bd->executarSQL($sql)){
			return;
		}
		else return $this->bd->obterValor($rs, "n");
	}

	function GetBalcoesOcupados($local)
	{
		//	    $sql = "select lae.acesso, lae.data_hora, lae.id_balcao, b.nome, eb.nome estado,
		//		from log_acessos_empregados lae
		//		inner join (select id_balcao, max(id_acessos) id from log_acessos_empregados group by id_balcao) la on la.id=lae.id_acessos
		//		inner join balcoes b on b.id_balcao=lae.id_balcao
		//		inner join estados_balcao eb on eb.id_estados_balcao=b.estado
		//		where (lae.acesso='Entrada' or lae.acesso='Saida')
		//		and lae.id_loja=".$local;

		$sql = "select lae.id_balcao id_balcao, e.nome as empregado, e.id_empregado as id_empregado, timestampdiff(second, b.data_hora, now()) idletime, lae.acesso acesso
			from log_acessos_empregados lae
			inner join (select id_balcao, max(id_acessos) id from log_acessos_empregados group by id_balcao) la on la.id=lae.id_acessos
			left join empregados e on lae.id_empregado=e.id_empregado
			inner join balcoes b on b.id_balcao=lae.id_balcao
			where (lae.acesso='Entrada' or lae.acesso='Suspenso')
			and lae.id_loja=".$local;

		$ret["id_balcao"] = array();
		$ret["empregado"] = array();

		$rs = $this->bd->executarSQL($sql);

		while ($row = $this->bd->obterRegisto($rs))
		{
			global $MAX_IDLE_TIME;

			if ($MAX_IDLE_TIME>0 && $row["idletime"] && $row["idletime"] > $MAX_IDLE_TIME && $row["acesso"] == "Entrada")
			{
				$log_actividade = new LogActividadeServico();
				$log_actividade->fechaServico($row["id_empregado"], $row["id_balcao"], $local);
				$log_actividade->Fechar();

				$objecto = new LogAcesso();
				$lastAccess = $objecto->GetUltimoRegistoAcesso($row["id_empregado"]);
				if ($row["id_balcao"] && $lastAccess["endereco"]==IpToTwelveChar($_SERVER["REMOTE_ADDR"]) && $lastAccess["acesso"]=="Entrada") $rs = $objecto->Inserir("Saida", $row["id_empregado"], $row["id_balcao"], $local);
				$objecto->UserLogout($row["id_empregado"], $_SERVER["REMOTE_ADDR"]);
				$objecto->fechar();

				$balcao = new Balcao();
				$balcao->SetEstado($row["id_balcao"], 3);
			}
			else
			{
				array_push($ret["id_balcao"], $row["id_balcao"]);
				array_push($ret["empregado"], $row["empregado"]);
			}
		}

		return $ret;
	}

	function IsIdle($id)
	{
		global $MAX_IDLE_TIME;
		if ($MAX_IDLE_TIME<0) return;
		$sql = "select if(timestampdiff(second, data_hora, now())>".$MAX_IDLE_TIME.",1,'') c from balcoes where estado=1 and id_balcao=".$id;

		if(!$rs = $this->bd->executarSQL($sql)) return;
		else return $this->bd->obterValor($rs, "c");
	}
}
?>
