<?php

/*
* Zqueue - Terminal
*
* version v3.4.0.1
* date: 14-set-2021
* updates: fixed problem with countdown, automatically calculates time dfierence between server and client timezone, main clock in header auto updates
* sources: cabecalho.php, utils.php, qTerminal/redireccionamento.php

* version v3.0.0.0
* date: 15-Jun-2020
*
*/

$MAX_IDLE_TIME = 3600;

define("PATH", __DIR__ . DIRECTORY_SEPARATOR);
$PATH = PATH;

$LANG_PATH = PATH . 'lang/';
$LANG = "pt";

define("DEBUG", "false");
define("DIR_DEBUG", PATH . "logs");

date_default_timezone_set('europe/lisbon');
ini_set('default_charset', 'UTF-8');
//require_once("AcessoBD.class.php");
require_once("AcessoBDMySQLi.class.php");

require_once("utils.php");

require_once "phpUtils/DBAccess.class.php";
require_once "senhas/Senhas.class.php";
require_once "EstatisticaAtendimentos/EstatisticaAtendimentos.class.php";

require_once("empregados/Empregado.class.php");
require_once("balcoes/Balcao.class.php");
require_once("servicos/Servico.class.php");
require_once("dispensador/Dispensador.class.php");
require_once("configuracao_teclado/ConfiguracaoTeclado.class.php");
require_once("log_acessos/LogAcesso.class.php");
require_once("log_atendimentos/LogAtendimento.class.php");
require_once("log_actividade_servicos/LogActividadeServico.class.php");
require_once("loja/Loja.class.php");
require_once("entidades/Entidade.class.php");
require_once("local_colaborador/LocalColaborador.class.php");
require_once("entidade_colaborador/EntidadeColaborador.class.php");
require_once("log_accoes/LogAccao.class.php");
require_once("forms/Form.class.php");
require_once("form_submissions/FormSubmission.class.php");

require_once("qterminal/ChildrenSessionControl.class.php");
require_once("timeManager/timeManager.class.php");

require_once("horarios/Horario.class.php");
require_once("horarios/HorarioSemana.class.php");
require_once("horarios/Periodo.class.php");
require_once("horarios/WeekDay.class.php");

require_once("lib/adodb/adodb.inc.php");

require_once("include.inc.php");

// AUTO LOGIN
$AUTO_LOGIN = 0;
if ($AUTO_LOGIN) mb_internal_encoding("UTF-8");



//$NOME_BD = "zqueue_db";
$NOME_BD = "zqueue_db";
$NOME_SERVIDOR = "localhost";
$NOME_SERVIDOR_CENTRAL = "localhost";
$PORTO_SERVIDOR_CENTRAL = 4444;
$USERNAME = "zquser";
$PASSWORD = "zq0livais";

$TRINCO = "embrulhado";
$DIR = '/' . getApplicationRoot() . '/';
//$DIR_XML_SENHAS = "/home/niexpo/playdir/contents/";
$DIR_XML_SENHAS = DIR_DEBUG;
$LATENCIA_ATENDIMENTO = 0; //Intervalo minimo entre a chamada de duas senhas (em segundos)
$FREQUENCIA_ACTUALIZACAO= 30000; //Frequencia com que o chamador web e actualizado (em milisegundos)
$FREQUENCIA_RELOGIO= 30000; //Frequencia com que o chamador web e actualizado (em milisegundos)
$LARGURA_BOTAO = 130; //Largura em pixeis reservada para cada coluna respectiva a um servico
$ALTURA_JANELA = 275; //Altura em pixeis da janela do chamador

define("CONTINUOUS_CALLING", TRUE);
define("WRONG_PASS_BLOCK_TIME", 60); // in seconds

// Mensagens
$ERROS = array(
		"Erro do sistema! Por favor, tente de novo ou contacte a administra&ccedil;&atilde;o do sistema.", // 0 - Erro da BD
		"Dados incorrectos! Por favor, verifique o seu nome de utilizador e a sua palavra-chave.", // 1 - Erro Utilizador
		"Palavra-Chave incorrecta! Por favor, verifique a sua palavra-chave.", // 2 - Erro Chave
		"Atingiu o n&uacute;mero m&aacute;ximo de tentativas! Por favor, aguarde uns segundos antes de voltar a tentar.", // 3 - Erro Tentativas
		"Voc&ecirc; encontra-se inactivo no sistema! Por favor, contacte a administra&ccedil;&atilde;o do sistema.", // 4 - Erro Inactivo
		"Nome de utilizador j&aacute; existente! Por favor, escolha outro nome de utilizador.", // 5 - Erro Existente
		"Erro de Datas Existentes", // 6 - Erro para Data Existente
		"Palavra-Chave alterada com sucesso. &Eacute; necess&aacute;ria re-autentica&ccedil;&atilde;o." // 7
	      );

// If multiple slashes are provided, remove them and redirect (in utils.php)
checkEmptyFolders();

?>
