<?php 

/**
 *  Classe de Gestão de Horários
 *  Corresponde à tabela 'horario' da base de dados.
 */
class FormSubmission extends AcessoBD {

	var $bd;
	var $id;
	var $id_form;   // FK to corresponding Form
    var $id_senha;  // FK to corresponding Senha (Ticket)
	var $data;	    // The Data that was submitted with the form
	var $created;   // Date created
	var $modified;  // Date modified

	/*
	  Construtor da classe

	  0 = Erro da BD
	 */

	function FormSubmission() {
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	/*
	  Função de inserção

	  0 = Erro da BD
	  5 = Erro Existente
	  true = Sucesso
	 */

	function Inserir($dados) {

		// Get the form template in order to know which fields
		// are valid so as to not allow anyone to inject invalid
		// fields and values into this form
		$form = new Form();
		$form->get($dados["id_form"]);


		if (!$form->getId()) {
			debug("ERROR Form Data Insert: Form template with the provided Id (" . $dados["id_form"] . ") does not exist.");
			return "nok";
		}

		$templateFields = json_decode($form->data, true);
		if (!is_array($templateFields)) {
			debug("ERROR Form Data Insert: Form template has no specified fields.");
			debug($templateFields);
			return "nok";
		}

		$formData = array();
		foreach ($templateFields as $name => $field) { // the name is also available at $field['name']
			if (isset($dados[$name])) {
				// array('Label Text' => 'Field Value');
				$formData[$field['label']] = $dados[$name];
			}
		}

		$formSubmission = new FormSubmission();


		$formSubmission->id_form = $dados["id_form"];
        $formSubmission->id_senha = $dados["id_senha"];
		$formSubmission->data = addslashes(json_encode($formData));
		$formSubmission->created = date("Y-m-d H:i:s", time());
		$formSubmission->modified = $formSubmission->created;

		$formSubmission->save();

        return "ok";
	}

	/**
	 * Função de Edição
	 *
	 * @param array   $dados   Um array com todos os dados de um Formulário
	 * @param integer $id      O id do Formulário a editar
	 * @return mixed           0 = Erro da BD
	 *                         5 = Erro Existente
	 *                         true = Sucesso
	 */
	function Editar($dados, $id) {
		return "ok";
	}

	function GetFormSubmission($id="") {
		$this->get($id);
		return $this;
	}

	/*
	  Fun��o de leitura de dados

	  0 = Erro da BD
	  true = Sucesso
	 */

	function LerDados($id) {
		$this->get($id);
		$_SESSION["sessao_campos"]['form_submission'] = $this;
		return "ok";
	}

	/**
	 * Função de Remoção.
	 *
	 * @param  mixed $id    Um único id ou um array de ids
	 * @return mixed
	 */
	function Remover($id) {
		// Nothing here for now
		return "nok";
	}

	function Exportar($dados) {

		$form_id = $dados['form'];
		if (!isset($form_id) || !is_numeric($form_id)) {
			return "nok";
		}

		$sql = "SELECT f.id, f.id_form, f.id_senha, f.data, f.created, f.modified, ";
		$sql.= "s.id_senha, s.numero_senha, ";
		$sql.= "svc_emi.id_servico as id_servico_emissao, svc_emi.nome as nome_servico_emissao, svc_emi.identificador as identificador_servico_emissao, ";
		$sql.= "svc_dest.id_servico as id_servico_destino, svc_dest.nome as nome_servico_destino, svc_dest.identificador as identificador_servico_destino ";
		$sql.= "FROM form_submission f ";
		$sql.= "LEFT JOIN senhas s ON s.id_senha = f.id_senha ";
		$sql.= "LEFT JOIN servicos svc_emi ON svc_emi.id_servico = s.servico_emissao ";
		$sql.= "LEFT JOIN servicos svc_dest ON svc_dest.id_servico = s.servico_destino ";
		$sql.= "WHERE f.id_form = " . addslashes($form_id). " ";

		// Expected date format: YYYY-MM-DD
		if (isset($dados['datestart']) && !empty($dados['datestart'])) {
			list($y, $m, $d) = explode('-', $dados['datestart']);
			$time = @mktime(0, 0, 0, $m, $d, $y);
			if ($time != -1 && $time != FALSE) {
				$sql.= "AND created >= '" . date("Y-m-d H:i:s", $time) . "' ";
			}
		}
		if (isset($dados['dateend']) && !empty($dados['dateend'])) {
			list($y, $m, $d) = explode('-', $dados['dateend']);
			$time = @mktime(23, 59, 59, $m, $d, $y);
			if ($time != -1 && $time != FALSE) {
				$sql.= "AND created <= '" . date("Y-m-d H:i:s", $time) . "' ";
			}
		}
		$sql.= "ORDER BY f.created ASC";
		
		global $ERROS, $N_REGISTOS;
		if (!$rs = $this->bd->executarSQL($sql)) {
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			exit();
		}

		// Get all the different fields that exist and store the values of
		// the submission with their associated field labels, different versions
		// of the Form template can have added different fields
		$numResults = $this->bd->obterNumRegistos($rs);
		$fieldValues = array();
		$fieldValues['id_senha'] = array();
		for ($i = 0; $i < $numResults; $i++) {
			$this->bd->moverRegisto($rs, $i);
			$submission = $this->bd->obterRegisto($rs);
			
			$fieldValues['submissao'][$i] = $submission['created'];
			$fieldValues['id_senha'][$i] = $submission['id_senha']; // Set the id_senha "manually" since it doesn't belong to the data JSON object
			$fieldValues['numero_senha'][$i] = $submission['numero_senha'];
			$fieldValues['id_servico_emissao'][$i] = $submission['id_servico_emissao'];
			$fieldValues['nome_servico_emissao'][$i] = $submission['nome_servico_emissao'];
			$fieldValues['identificador_servico_emissao'][$i] = $submission['identificador_servico_emissao'];
			$fieldValues['id_servico_destino'][$i] = $submission['id_servico_destino'];
			$fieldValues['nome_servico_destino'][$i] = $submission['nome_servico_destino'];
			$fieldValues['identificador_servico_destino'][$i] = $submission['identificador_servico_destino'];
			
			$data = json_decode($submission['data'], true);
			if (!is_array($data)) continue;
			foreach ($data as $name => $value) {
				if (!isset($fieldValues[$name])) {
					$fieldValues[$name] = array();
                }
				$fieldValues[$name][$i] = $value;
			}
		}

		header('Content-type: text/csv');
		header('Content-disposition: attachment;filename=FormSubmissionsExport_Form' . $form_id . "_" . date('Ymd_His') . '.csv');

		$out = fopen('php://output', 'w');
		$headings = array_keys($fieldValues);
//        array_unshift($headings, 'id_senha');
		if (isset($_REQUEST['sort']) && $_REQUEST['sort'] == "true")
			sort($headings);
		fputcsv($out, $headings); // Write the CSV Header Row
		for ($i = 0; $i < $numResults; $i++) {
            $line = array();
//            $this->bd->moverRegisto($rs, $i);
//            $submission = $this->bd->obterRegisto($rs);
//            $line[] = $submission['id_senha'];
			foreach ($headings as $name) {
				if (!isset($fieldValues[$name][$i]))
					$line[] = '';
				else if (is_array($fieldValues[$name][$i]))
					$line[] = join("||", $fieldValues[$name][$i]);
				else
					$line[] = $fieldValues[$name][$i];
			}
			fputcsv($out, $line);
		}
		fclose($out);
		exit();
	}

	/*
	 * Função de listagem de Forms
	 *
	 * 0 = Erro da BD
	 * true = Sucesso
	 */

	//!!!! ATTENTION: This method lists the forms and not the form submissions themselves
	function ListarForms() {

		$sql = "SELECT f.id, f.descr, f.path FROM form f ";

		if ($_REQUEST["campo"] != "")
			$sql .= "ORDER BY f." . $_REQUEST["campo"] . " ";
		else
			$sql .= "ORDER BY f.descr ";

		if ($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else
			$sql .= "ASC";

		global $ERROS, $N_REGISTOS;
		if (!$rs = $this->bd->executarSQL($sql)) {
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // número de registos por página
		$numPaginas = 1; // número de páginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // número total registos
		// caso haja eliminação de registos que diminua o número de páginas
		if (($numTuplos / $numRegPag) <= ( $_REQUEST["pagina"] - 1))
			$_REQUEST["pagina"] -= 1;

		// caso não existam registos
		if ($numTuplos == 0) {
			echo "<div class='empty_msg'>" . translate('word_nao_existem') . " " . translate("word_forms") . " " . translate('word_registados_sistema') . "</div>";
			return;
		}

		// calculo do número de páginas de registos
		if ($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoDiversa.php?accao=exportar_form_submissions' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>
							<tr>
								<td class='button_page' colspan='6'><strong>" . translate('word_pages', true) . " </strong>";


		if ($_REQUEST["pagina"] > 1) {
			$pagAnterior = $_REQUEST["pagina"] - 1;
			echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
		} else {
			$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
			echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
		}

		while ($n <= $numPaginas) {
			if ($n == $_REQUEST["pagina"])
				echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='current_page'>$n</div></a>";
			else
				echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
			$n++;
		}

		$n = ($_REQUEST["pagina"] - 1) * $numRegPag;
		$incremento = $n;

		if ($_REQUEST["pagina"] < $numPaginas) {
			$pagPosterior = $_REQUEST["pagina"] + 1;
			echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
		} else {
			if ($numTuplos % $numRegPag != 0)
				$numRegPag = $numTuplos % $numRegPag;
			echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
		}

		echo "		</td>
				</tr>";

		// Filters row
		echo '<tr>';
		echo '<td>&nbsp;</td>';
		echo '<td>';
		echo '<table class="form_table" cellspacing="0" cellpadding="0" style="width: 100%">
                <tr>
                    <td class="question_space" colspan="5">'.
                        translate('word_filters', false).'
                    </td>
                </tr>
                <tr>
                    <td class="input_space right top">'.
                        translate('word_data_start') .':
                    </td>
                    <td class="input_space left top">
                        <input id="datestart" type="text" name="datestart" maxlength="10" size="11" value="'.getRequestValue('data').'">
                        <a href="javascript:var cal1 = new calendar1(document.getElementById(\'datestart\'));
                                        cal1.year_scroll = true;
                                        cal1.time_comp = false;
                                        cal1.popup();">
                        <img src="../img/calendario/cal.gif" width="16" height="16" border="0" alt="'.translate('word_click_to_calendar', true).'"></a>
                                <font class="info_msg">(aaaa-mm-dd)</font>
                        <span id="msg_datestart" class="error_msg">&nbsp;</span>
                    </td>
                    <td class="input_space right top">'.
                        translate('word_data_end') .':
                    </td>
                    <td class="input_space left top">
                        <input id="dateend" type="text" name="dateend" maxlength="10" size="11" value="'.getRequestValue('data').'">
                        <a href="javascript:var cal1 = new calendar1(document.getElementById(\'dateend\'));
                                        cal1.year_scroll = true;
                                        cal1.time_comp = false;
                                        cal1.popup();">
                        <img src="../img/calendario/cal.gif" width="16" height="16" border="0" alt="'.translate('word_click_to_calendar', true).'"></a>
                                <font class="info_msg">(aaaa-mm-dd)</font>
                        <span id="msg_dateend" class="error_msg">&nbsp;</span>
                    </td>
                    <td class="right">
						&nbsp;
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&nbsp;</td>
                </tr>
            </table>';
		echo '</td>';
		echo '</tr>';



		echo "<tr class='column_row'>";

		if ($_SESSION["sessao_perms"]["perm_forms"] > 0) {
			echo "<td width='8'>&nbsp;</td>";
		}

		if (strcmp($_REQUEST["campo"], "descr") == 0)
			if ($_REQUEST["ordem"] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=1'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div>" . translate('word_name', true) . "</div></a></td>";

		echo "</tr>";

		while ($n < ($numRegPag + $incremento)) {
			$this->bd->moverRegisto($rs, $n);
			$legacy = $this->bd->obterValor($rs, "path") != "";

			echo"<tr>";
			if ($_SESSION["sessao_perms"]["perm_forms"] > 0 && !$legacy) {
				// Only show the edit checkbox if we have permission to edit it and it is not one of the legacy file-based forms
				echo "<td><input name='form' type='radio' value='" . $this->bd->obterValor($rs, "id") . "'/> </td>";
			}
			else if ($legacy) {
				echo "<td>&nbsp;</td>";
			}

			if (!$legacy) {
				echo "<td>" . $this->bd->obterValor($rs, "descr") . "</td>";
			}
			else {
				echo "<td>" . $this->bd->obterValor($rs, "descr") . " (" . translate('word_form_not_exportable', true) . ")</td>";
			}

			echo "</tr>";

			$n++;
		}
		echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div><span id='msg_form' class='error_msg'>&nbsp;</span></div>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
		echo "<tr>
					<td>
					<table>
						<tr>
							<td class='button_large'>
								<div onClick='validaFormFormSubmission()'>" . translate('word_exportar_csv', true) . "</div>
							</td>
						</tr>
					</table>
					</td>
				</tr>";
		echo "</table>";



		echo "</form>";
	}

	/*
	  Destrutor da classe

	  0 = Erro da BD
	 */

	function Fechar() {
		$this->bd->fecharBD();
	}

	//----------------------------//
	//   Forms Model Methods   //
	//----------------------------//

	function getId() {
		return $this->id;
	}

	function get($id) {


		// TODO write this method


		$sql = "SELECT form_submission.id submission_id, ";
		$sql.= "form_submission.id_form form_id, ";
        $sql.= "form_submission.id_senha senha_id, ";
		$sql.= "form_submission.data submission_data, ";
		$sql.= "form_submission.created submission_created, ";
		$sql.= "form_submission.modified submission_modified ";
		$sql.= "FROM form_submission ";
		$sql.= "WHERE form_submission.id = "; // Add the id of the form here
		$rows = $this->bd->getRows($sql . $id);
		// Map the SQL result to the actual Form Class
		$this->mapDatabaseToObject($rows);
	}

	/**
	 * Lists forms according to a $where clause and returns only Form's $fields fields.
	 *
	 * @param string $where   Optional. Where clause in the form of "id = 5 AND descr = 'some name'"
	 * @param array  $fields  Optional. An array of which Form fields to return.
	 */
	function listFormSubmissions($where = "", $fields = array('id')) {
		if (is_array($fields) == false)
			return null;

		$sql = "SELECT " . implode(", ", $fields);
		$sql.= " FROM form_submission ";
		if (empty($where) == false) {
			$sql.= "WHERE $where ";
		}
		return $this->bd->getRows($sql);
	}

	function save($validate = true) {
		$success = true;

		if ($this->id > 0) {
			// We're editing an existing Form Data Submission
			$sql = "UPDATE form_submission SET ";
			$sql.= "data = '" . $this->data . "', ";
			$sql.= "modified = NOW() ";
			$sql.= "WHERE id = " . $this->id . ";";
			if ($this->bd->executarSQL($sql) == false) {
				$success = false;
			}
		} else {
			$sql = "INSERT INTO form_submission(id, id_form, id_senha, data, created, modified) VALUES(0, ";
			$sql.= "'" . $this->id_form . "', ";
            $sql.= "'" . $this->id_senha . "', ";
			$sql.= "'" . $this->data . "',";
			$sql.= "NOW(), NOW());";
			if ($this->bd->executarSQL($sql) == false) {
				$success = false;
			} else {
				$autoIncrementId = $this->bd->obterUltimoInsertId();
				$this->id = $autoIncrementId;
			}
		}

		if ($success) {
			return "ok";
		} else {
			return false;
		}
	}

	/**
	 * This function maps the database query result rows into
	 * the Domain Model represented by this class and its associations.
	 *
	 * Each row is expected to be something like the following
	 *     [0] => Array
	 *         (
	 *             [submission_id] => 22
	 *             [form_id] => 1
     *             [senha_id] => 5678
	 *             [submission_data] => "<JSON Encoded Form Submission Data>"
	 *             [submission_created] => "<some date time>"
	 *             [submission_modified] => "<some date time>"
	 *         )
	 *
	 */
	private function mapDatabaseToObject($rows, $submissionTarget = null) {

		if ($submissionTarget == null) {
			$submissionTarget = $this;
		}

		if (empty($rows)) {
			return false;
		}

		foreach ($rows as $row) {
			$submissionTarget->id = $row['submission_id'];
			$submissionTarget->id_form = $row['form_id'];
            $submissionTarget->id_senha = $row['senha_id'];
			$submissionTarget->data = $row['submission_data'];
			$submissionTarget->created = $row['submission_created'];
			$submissionTarget->modified = $row['submission_modified'];
		}
	}
}
?>