<?php 

/**
 *  Classe de Gestão de Horários
 *  Corresponde à tabela 'horario' da base de dados.
 */
class Form extends AcessoBD {

    var $bd;

    var $id;
	var $descr;
    var $path;
	var $data;

    /*
      Construtor da classe

      0 = Erro da BD
     */
    function Form() {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        //$this->bd = new AcessoBD();
        //return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
      Função de inserção

      0 = Erro da BD
      5 = Erro Existente
      true = Sucesso
     */

    function Inserir($dados) {
        $form = new Form();

		$form->descr = $dados["descr"];
        $form->path = null;
		$form->data = addslashes($dados["form_data"]);

        $form->save();
        return "ok";
    }

    /**
     * Função de Edição
     *
     * @param array   $dados   Um array com todos os dados de um Formulário
     * @param integer $id      O id do Formulário a editar
     * @return mixed           0 = Erro da BD
     *                         5 = Erro Existente
     *                         true = Sucesso
     */
    function Editar($dados, $id) {

        $form = new Form();
        $form->get($id);

		if (!$form->id) {
			echo "form nok<br />";
			return "nok";
		}

		$form->descr = $dados["descr"];
        $form->path = null;
		$form->data = addslashes($dados["form_data"]);

		$form->save();

		return "ok";
    }

    function GetForms($id="") {
        $this->get($id);
        return $this;
    }

    /*
      Fun��o de leitura de dados

      0 = Erro da BD
      true = Sucesso
     */

    function LerDados($id) {
        $this->get($id);
        $_SESSION["sessao_campos"]['form'] = $this;
        return "ok";
    }

    /**
     * Função de Remoção.
     *
     * @param  mixed $id    Um único id ou um array de ids
     * @return mixed
     */
    function Remover($id) {

		$success = true;
        if ($this->bd->executarSQL("START TRANSACTION;") == false) {
            return false;
        }

        // get the form names that will be deleted so we can log them at the end
        $numEntradas = count($id);
        $descrs = array();
        $sql = "SELECT descr FROM form WHERE ";
        for ($i = $numEntradas - 1; $i > 0; $i--)
            $sql .= "id = " . $id[$i] . " OR ";
        $sql .= "id = " . $id[0] . ";";

        if ($rs = $this->bd->executarSQL($sql)) {
            for ($i = 0; $i < $numEntradas; $i++) {
                $this->bd->moverRegisto($rs, $i);
                array_push($descrs, $this->bd->obterValor($rs, "descr"));
            }
        } else {
            $this->bd->executarSQL("ROLLBACK;");
            return 0;
        }

        $sql = "DELETE FROM form ";
        $sql.= "WHERE ";
        for ($i = $numEntradas - 1; $i > 0; $i--)
            $sql .= "id = " . $id[$i] . " OR ";
        $sql .= "id = " . $id[0] . ";";

        if ($this->bd->executarSQL($sql) == false) {
            $success = false;
        }

        if (!$success) {
            // Failure
            $this->bd->executarSQL("ROLLBACK;");
            return false;
        }

        if ($this->bd->executarSQL("COMMIT;") == false) {
            return false;
        }
        $objecto = new LogAccao();
        for ($i = count($descrs) - 1; $i >= 0; $i--) {
            $rs = $objecto->Inserir("Remoção", "Forms", $descrs[$i]);
        }
        $objecto->fechar();
        return "ok";

    }

    /*
     * Função de listagem
     *
     * 0 = Erro da BD
     * true = Sucesso
     */

    function Listar() {

        $sql = "SELECT f.id, f.descr, f.path FROM form f ";

        if ($_REQUEST["campo"] != "")
            $sql .= "ORDER BY f." . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY f.descr ";

        if ($_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";


        global $ERROS, $N_REGISTOS;
        if (!$rs = $this->bd->executarSQL($sql)) {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $n = 1;
        $numRegPag = $N_REGISTOS; // número de registos por página
        $numPaginas = 1; // número de páginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // número total registos
        // caso haja eliminação de registos que diminua o número de páginas
        if (($numTuplos / $numRegPag) <= ( $_REQUEST["pagina"] - 1))
            $_REQUEST["pagina"] -= 1;

        // caso não existam registos
        if ($numTuplos == 0) {
            echo "<div class='empty_msg'>" . translate('word_nao_existem') . " " . translate("word_forms") . " " . translate('word_registados_sistema') . "</div>";
            return;
        }

        // calculo do número de páginas de registos
        if ($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=forms&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"] . "&ordem=" . $_REQUEST["ordem"] . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>
							<tr>
								<td class='button_page' colspan='6'><strong>" . translate('word_pages', true) . " </strong>";


        if ($_REQUEST["pagina"] > 1) {
            $pagAnterior = $_REQUEST["pagina"] - 1;
            echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
        } else {
            $_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
            echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
        }

        while ($n <= $numPaginas) {
            if ($n == $_REQUEST["pagina"])
                echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='current_page'>$n</div></a>";
            else
                echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
            $n++;
        }

        $n = ($_REQUEST["pagina"] - 1) * $numRegPag;
        $incremento = $n;

        if ($_REQUEST["pagina"] < $numPaginas) {
            $pagPosterior = $_REQUEST["pagina"] + 1;
            echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
        } else {
            if ($numTuplos % $numRegPag != 0)
                $numRegPag = $numTuplos % $numRegPag;
            echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
        }

        echo "		</td>
				</tr>";

        echo "<tr class='column_row'>";

        if ($_SESSION["sessao_perms"]["perm_forms"] == 2) {
            echo "<td width='8'>&nbsp;</td>";
        }

        if (strcmp($_REQUEST["campo"], "descr") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=1'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div>" . translate('word_name', true) . "</div></a></td>";

        echo "<td width='135'>" . translate('word_operations', true) . "</td>
				</tr>";

        while ($n < ($numRegPag + $incremento)) {
            $this->bd->moverRegisto($rs, $n);
			$legacy = $this->bd->obterValor($rs, "path") != "";

            echo"<tr>";
            if ($_SESSION["sessao_perms"]["perm_forms"] == 2 && !$legacy ) {
				// Only show the edit checkbox if we have permission to edit it and it is not one of the legacy file-based forms
                echo "<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs, "id") . "'/> </td>";
            }
			else if ($_SESSION["sessao_perms"]["perm_forms"] == 2 && $legacy) {
				echo "<td>&nbsp;</td>";
			}

			if ($legacy) {
				echo "<td>" . $this->bd->obterValor($rs, "descr") . " (" . translate('word_form_not_editable', true) .")</td>";
			}
			else {
				echo "<td>" . $this->bd->obterValor($rs, "descr") . "</td>";
			}

			echo "<td>";
            if ($_SESSION["sessao_perms"]["perm_forms"] == 2 && !$legacy) {
                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=forms&id=" . $this->bd->obterValor($rs, "id") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_edit', true) . "</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=forms&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"] . "&ordem=" . $_REQUEST['ordem'] . "&id=" . $this->bd->obterValor($rs, "id") . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>" . translate('word_remove', true) . "</div></a>";
            } else {
                echo "&nbsp;";
            }
            echo "</td>";
			echo "</tr>";

            $n++;
        }
        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        if ($_SESSION["sessao_perms"]["perm_forms"] == 2) {
            echo "<tr>
					<td>
					<table>
						<tr>
							<td class='button_large'>
								<div onClick='seleccionaCaixa(true)'>" . translate('word_mark_all', true) . "</div>
								<div onClick='seleccionaCaixa(false)'>" . translate('word_unmark_all', true) . "</div>
								<div onClick='removerMarcados(this);'>" . translate('word_remove', true) . "</div>
							</td>
						</tr>
					</table>
					</td>
				</tr>";
        }

        echo "</table>
		</form>";
    }

    /*
      Destrutor da classe

      0 = Erro da BD
     */

    function Fechar() {
        $this->bd->fecharBD();
    }

    //----------------------------//
    //   Forms Model Methods   //
    //----------------------------//

    function getId() {
        return $this->id;
    }

    function get($id) {

        $sql = "SELECT form.id form_id, ";
		$sql.= "form.descr form_descr, ";
        $sql.= "form.path form_path, ";
		$sql.= "form.data form_data ";
        $sql.= "FROM form ";
        $sql.= "WHERE form.id = "; // Add the id of the form here
        $rows = $this->bd->getRows($sql . $id);
        // Map the SQL result to the actual Form Class
        $this->mapDatabaseToObject($rows);
    }

    /**
     * Lists forms according to a $where clause and returns only Form's $fields fields.
     *
     * @param string $where   Optional. Where clause in the form of "id = 5 AND descr = 'some name'"
     * @param array  $fields  Optional. An array of which Form fields to return.
     */
    function listForms($where = "", $fields = array('id')) {
        if (is_array($fields) == false)
            return null;

        $sql = "SELECT " . implode(", ", $fields);
        $sql.= " FROM form ";
        if (empty($where) == false) {
            $sql.= "WHERE $where ";
        }
        return $this->bd->getRows($sql);
    }

    function save($validate = true) {
        $success = true;

        if ($this->id > 0) {
            // We're editing an existing Form
            $sql = "UPDATE form SET ";
			$sql.= "descr = '" . $this->descr. "', ";
			$sql.= "data = '" . $this->data. "' ";
            $sql.= "WHERE id = " . $this->id . ";";
            if ($this->bd->executarSQL($sql) == false) {
                $success = false;
            }
        } else {
            $sql = "INSERT INTO form(id, descr, data) VALUES(0, ";
			$sql.= "'" . $this->descr . "',";
			$sql.= "'" . $this->data . "');";
            if ($this->bd->executarSQL($sql) == false) {
                $success = false;
            } else {
                $autoIncrementId = $this->bd->obterUltimoInsertId();
                $this->id = $autoIncrementId;
            }
        }

        if ($success) {
            $objecto = new LogAccao();
            $rs = $objecto->Inserir("Inserção", "Form", $this->descr);
            $objecto->fechar();
            return "ok";
        } else {
            return false;
        }
    }


    /**
     * This function maps the database query result rows into
     * the Domain Model represented by this class and its associations.
	 * Currently, this is only used for
     *
     * Each row is expected to be something like the following
     *     [0] => Array
     *         (
     *             [form_id] => 1
     *             [form_descr] => "<some description of the form fields>"
     *             [form_path] => "<the file path of the form (for legacy forms)>"
	 *             [form_data] => "<the JSON encoded form data object>"
     *         )
     *
     */
    private function mapDatabaseToObject($rows, $formTarget = null) {

        if ($formTarget == null) {
            $formTarget = $this;
        }

        if (empty($rows)) {
            return false;
        }

		foreach ($rows as $row) {

			$formTarget->id = $row['form_id'];
			$formTarget->descr = $row['form_descr'];
            $formTarget->path = $row['form_path'];
			$formTarget->data = $row['form_data'];
		}

    }

}

?>
