<?php 
	
/* Classe de Gestao de Registos de Accoes */

class LogAccao extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function LogAccao() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	/*
		Funcao de insercao
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($accao, $objecto, $nome_objecto)
	{
		$sql = "INSERT INTO log_accoes (id_utilizador, accao, objecto, nome_objecto, data_hora) VALUES ('"
									. $_SESSION["sessao_id_utilizador"] . "', '" 
									. $accao . "', '" 
									. $objecto . "', '" 
									. $nome_objecto . "', '" 
									. date("Y-m-d") . " " . date("H:i:s") . "');";	

		if($rs = $this->bd->executarSQL($sql))
			return 1;
		else
			return 0;	
	}

	/*
		Funcao de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Listar()
	{
		$sql = "SELECT data_hora, accao, objecto, nome_objecto, ut.nome , ut.tipo tipo_utilizador
				FROM log_accoes a LEFT JOIN (
                    SELECT u.id_utilizadores, u.nome, t.nome tipo
					FROM utilizadores u , tipos_utilizadores t
					WHERE u.id_tipos_utilizadores = t.id_tipos_utilizadores) ut ON a.id_utilizador = ut.id_utilizadores ";

		if($_REQUEST["campo"] != "")	 
			$sql .= "ORDER BY " . $_REQUEST["campo"] . " ";
		else			
			$sql .= "ORDER BY data_hora ";

		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";
		
		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // numero de registos por pagina
		$numPaginas = 1; // numero de paginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // numero total registos
		
		// caso haja eliminacao de registos que diminua o numero de paginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso nao existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>". translate('word_nao_existem_accoes_sistema', true)  ."!</div>";
			return;
		}
		
		// calculo do numero de paginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'>";
								$pagina = 1;
								if($_REQUEST['pagina'] != '')
										$pagina = $_REQUEST['pagina'];
						
								$url2spread = "";
								echo drawPaginas($url2spread . "?campo=$_REQUEST[campo]&ordem=$_REQUEST[ordem]", $numPaginas, $pagina);
								
								$n = ($pagina - 1) * $numRegPag;
								$incremento = $n;
								if($pagina == $numPaginas && ($numTuplos % $numRegPag != 0))
										$numRegPag = $numTuplos % $numRegPag;												
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>";

		if (strcmp($_REQUEST["campo"],"data_hora") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=data_hora&ordem=0'><div>". translate('word_data_hora', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=data_hora&ordem=1'><div>". translate('word_data_hora', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=data_hora&ordem=0'><div>". translate('word_data_hora', true)  ."</div></a></td>";

		if (strcmp($_REQUEST["campo"],"accao") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=accao&ordem=0'><div>". translate('word_accao', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=accao&ordem=1'><div>". translate('word_accao', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=accao&ordem=0'><div>". translate('word_accao', true)  ."</div></a></td>";
		
		if (strcmp($_REQUEST["campo"],"objecto") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=objecto&ordem=0'><div>". translate('word_objecto', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=objecto&ordem=1'><div>". translate('word_objecto', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=objecto&ordem=0'><div>". translate('word_objecto', true)  ."</div></a></td>";

		if (strcmp($_REQUEST["campo"],"nome_objecto") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_objecto&ordem=0'><div>". translate('word_nome_do', true)  ." ". translate('word_objecto', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_objecto&ordem=1'><div>". translate('word_nome_do', true)  ." ". translate('word_objecto', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_objecto&ordem=0'><div>". translate('word_nome_do', true)  ." ". translate('word_objecto', true)  ."</div></a></td>";

		if (strcmp($_REQUEST["campo"],"nome") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_nome_do', true)  ." ". translate('word_utilizador', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>". translate('word_nome_do', true)  ." ". translate('word_utilizador', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_nome_do', true)  ." ". translate('word_utilizador', true)  ."</div></a></td>";
		
		/*if (strcmp($_REQUEST["campo"],"tipo_utilizador") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=tipo_utilizador&ordem=0'><div>Tipo Utilizador<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=tipo_utilizador&ordem=1'><div>Tipo Utilizador<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=tipo_utilizador&ordem=0'><div>Tipo Utilizador</div></a></td>";*/

		echo "</tr>";	
		
		

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);
			
			if($this->bd->obterValor($rs,"nome") != null )
				$nome = $this->bd->obterValor($rs,"nome");
			else
				$nome = "&lt;utilizador apagado&gt;";
				
			if($this->bd->obterValor($rs,"tipo_utilizador") != null )
				$tipo = $this->bd->obterValor($rs,"tipo_utilizador");
			else
				$tipo = "&lt;utilizador apagado&gt;";

			echo"<tr>
					<td>" . $this->bd->obterValor($rs,"data_hora") . "</td>
					<td>" . $this->bd->obterValor($rs,"accao") . "</td>
					<td>" . $this->bd->obterValor($rs,"objecto") . "</td>
					<td>" . $this->bd->obterValor($rs,"nome_objecto") . "</td>
					<td>" . $nome . /*"</td>
					<td>" . $tipo . */"</td>
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						  						
			</table>";		
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>