<?php 
	
/* Classe de Gestao de Acessos */

class LogAcesso extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function LogAcesso() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	function GetUltimoRegisto($id_loja, $id_balcao)
	{
		$sql = "select * from log_acessos_empregados
			where id_balcao='".$id_balcao."'
			and id_loja='".$id_loja."'
			order by id_acessos desc limit 1";
		
		if ($rs = $this->bd->executarSQL($sql))
			return $this->bd->obterRegisto($rs);
	}
	
	function GetUltimoRegistoAcesso($utilizador)
	{
		$sql = "select * from log_acessos
			where utilizador='".$utilizador."'
			order by id_acessos desc limit 1";
		
		if ($rs = $this->bd->executarSQL($sql))
			return $this->bd->obterRegisto($rs);
	}


	/*
		Funcao de insercao
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($acesso, $empregado="", $balcao="", $local="")
	{
		$sql = "select acesso
			from log_acessos_empregados
			where id_balcao='".($balcao?$balcao:$_SESSION["sessao_balcao"])."'
			and id_loja='".($local?$local:$_SESSION["sessao_loja"])."'
			and id_empregado='".($empregado?$empregado:$_SESSION["sessao_empregado"])."'
			order by id_acessos desc limit 1";
        //debug($sql, $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");
		$rs = $this->bd->executarSQL($sql);
		
		if ($this->bd->obterValor($rs, "acesso") != $acesso)
		{
			$sql = "INSERT INTO log_acessos_empregados (id_empregado, acesso, data_hora, id_balcao, id_loja)
				VALUES('".($empregado?$empregado:$_SESSION["sessao_empregado"])."',
					'".$acesso."',
					now(),
					'".($balcao?$balcao:$_SESSION["sessao_balcao"])."',
					'".($local?$local:$_SESSION["sessao_loja"])."')";

//		debug(print_r($sql, true), $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");

			if($rs = $this->bd->executarSQL($sql))
				return 1;
			else
				return 0;
		}	
	}
	
	function LogAccess($id_loja, $id_balcao, $id_empregado, $acesso)
	{
		$sql = "INSERT INTO log_acessos_empregados (id_empregado, acesso, data_hora, id_balcao, id_loja)
			VALUES('".$id_empregado."',
				'".$acesso."',
				now(),
				'".$id_balcao."',
				'".$id_loja."')";
		
		if($rs = $this->bd->executarSQL($sql))
			return 1;
		else
			return 0;
	}
	
	function UserLogin($username, $ip_addr)
	{
        $sql = "select id_empregado from empregados where nome_utilizador='".$username."'";
//        debug($sql, $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");
        $rs = $this->bd->executarSQL($sql);
        $id_empregado = $this->bd->obterValor($rs, "id_empregado");
		
        //// verificar se o mesmo user esta como 'Entrada' e, caso esteja, inserir a sua saida
        $sql = "select endereco, acesso
            from log_acessos
            where utilizador='".$id_empregado."'
            order by id_acessos desc limit 1";
        $rs = $this->bd->executarSQL($sql);
        $endereco = $this->bd->obterValor($rs, "endereco");
        $acesso = $this->bd->obterValor($rs, "acesso");
        if ($acesso == "Entrada")
        {
            $sql = "insert into log_acessos (utilizador, tipo, acesso, data_hora, endereco)
                values ('".$id_empregado."','','Saida',now(),'".$endereco."')";
            $rs = $this->bd->executarSQL($sql);
        }
		
		// fazer o mesmo com os balcoes
        $sql = "select acesso, id_balcao, id_loja
            from log_acessos_empregados
            where id_empregado='".$id_empregado."'
            order by id_acessos desc limit 1";
        $rs = $this->bd->executarSQL($sql);
        $id_loja = $this->bd->obterValor($rs, "id_loja");
        $id_balcao = $this->bd->obterValor($rs, "id_balcao");
        $acesso = $this->bd->obterValor($rs, "acesso");
        if ($acesso == "Entrada")
        {
            $sql = "insert into log_acessos_empregados (id_empregado, acesso, data_hora, id_balcao, id_loja)
                values ('".$id_empregado."','Saida',now(),'".$id_balcao."','".$id_loja."')";
            $rs = $this->bd->executarSQL($sql);
        }
		
        if ($this->GetLastAccess($id_empregado, $ip_addr) != "Entrada")
        {
             //o ip tem q ter 12 carateres, por isso...
            $ip_addr_str = IpToTwelveChar($ip_addr);

            // entrar
            $sql = "insert into log_acessos (utilizador, tipo, acesso, data_hora, endereco)
                values ('".$id_empregado."','','Entrada',now(),'".$ip_addr_str."')";

            $rs = $this->bd->executarSQL($sql);
       }          
		
                
        //// fechar as senhas penduradas
        $senhas = new Senhas();
        $senhas->AnulaSenhasPenduradasPorColaborador($id_empregado);
        unset($senhas);
	}
	
	function UserLogout($utilizador, $endereco)
	{
		if ($this->GetLastAccess($utilizador, $endereco) == "Entrada")
		{                              
			$sql = "insert into log_acessos (utilizador, tipo, acesso, data_hora, endereco)
				values ('".$utilizador."','','Saida',now(),'".IpToTwelveChar($endereco)."')";
			$rs = $this->bd->executarSQL($sql);
		}
	}
	
	function GetLastAccess($utilizador, $endereco)
	{
		$sql = "select acesso
			from log_acessos
            where utilizador='".$utilizador."'
			and endereco='".IpToTwelveChar($endereco)."'
			order by id_acessos desc limit 1";

		$rs = $this->bd->executarSQL($sql);
		return $this->bd->obterValor($rs, "acesso");
	}
	
	function GetLastAccessEmpregado($l, $b, $c)
	{
		$sql = "select max(id_acessos) id
				from log_acessos_empregados
				where id_loja='".$l."' and id_balcao='".$b."' and id_empregado='".$c."'";
		if(!$rs = $this->bd->executarSQL($sql)) return 0;
		$id = $this->bd->obterValor($rs, "id");
		if (!strlen($id)) return 0;
		
		$sql = "select acesso from log_acessos_empregados where id_acessos='".$id."'";
		$rs = $this->bd->executarSQL($sql);
		return $this->bd->obterValor($rs, "acesso");
	}
	
	function SetEstado($s, $l, $b, $c)
	{
          
            $ultimo_estado=$this->GetLastAccessEmpregado($l, $b, $c);
		if ($ultimo_estado != $s)
		{
           
                    
			$sql = "insert into log_acessos_empregados (id_empregado, acesso, data_hora, id_balcao, id_loja)
					values ('".$c."','".$s."',now(),'".$b."','".$l."')";

//			debug(print_r($sql, true), $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");
			
			$this->bd->executarSQL($sql);
		}
	}
	
	/*
		Funcao de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Listar()
	{
		$sql = "SELECT * FROM log_acessos ";
		/*	
		if($_REQUEST["id_cliente"] == "")	 // cliente
			$sql .= "WHERE c.id_cliente = u.id_cliente ";            
		else 
			$sql .= "WHERE c.id_cliente = " . $_REQUEST["id_cliente"] . " AND u.id_cliente = " . $_REQUEST["id_cliente"] . " ";
		
		if($_REQUEST["id_tipo_utilizador"] == "")	 // tipo de utilizador	
			$sql .= "AND t.id_tipo_utilizador = u.id_tipo_utilizador ";
		else
			$sql .= "AND t.id_tipo_utilizador = " . $_REQUEST["id_tipo_utilizador"] . " AND u.id_tipo_utilizador = " . $_REQUEST["id_tipo_utilizador"] . " ";

		if($_REQUEST["estado"] != "")	 // estado
			$sql .= "AND u.estado = " . $_REQUEST["estado"] . " ";*/			
		
		if($_REQUEST["campo"] != "")	 
			$sql .= "ORDER BY " . $_REQUEST["campo"] . " ";		
		else			
			$sql .= "ORDER BY data_hora ";

		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";
		
		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // numero de registos por pagina
		$numPaginas = 1; // numero de paginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // numero total registos
		
		// caso haja eliminacao de registos que diminua o numero de paginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso nao existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>Nao existem acessos no sistema com os filtros seleccionados!</div>";
			return;
		}
		
		// calculo do numero de paginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='4'><strong>". translate('word_paginas', true)  .": </strong>";
					

					if($_REQUEST["pagina"] > 1)
					{
						$pagAnterior = $_REQUEST["pagina"] - 1;
						echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
					}
					else
					{
						$_REQUEST["pagina"] = 1; // na primeira vez nao ha request
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}
										
					while($n <= $numPaginas)
					{
						if($n == $_REQUEST["pagina"])
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='current_page'>$n</div></a>";
						else 
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
						$n++;
					}

					$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
					$incremento = $n;
										
					if($_REQUEST["pagina"] < $numPaginas)
					{
						$pagPosterior = $_REQUEST["pagina"] + 1;
						echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
					}
					else
					{
						if($numTuplos % $numRegPag != 0)
							$numRegPag = $numTuplos % $numRegPag;
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}						
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>";

		if (strcmp($_REQUEST["campo"],"data_hora") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=data_hora&ordem=0'><div>". translate('word_data_hora', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=data_hora&ordem=1'><div>". translate('word_data_hora', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=data_hora&ordem=0'><div>". translate('word_data_hora', true)  ."</div></a></td>";

		if (strcmp($_REQUEST["campo"],"acesso") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=acesso&ordem=0'><div>". translate('word_acesso', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=acesso&ordem=1'><div>". translate('word_acesso', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=acesso&ordem=0'><div>". translate('word_acesso', true)  ."</div></a></td>";
	
		if (strcmp($_REQUEST["campo"],"utilizador") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=utilizador&ordem=0'><div>". translate('word_nome_do', true)  ." Utilizador<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=utilizador&ordem=1'><div>". translate('word_nome_do', true)  ." Utilizador<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=utilizador&ordem=0'><div>". translate('word_nome_do', true)  ." Utilizador</div></a></td>";
			
		if (strcmp($_REQUEST["campo"],"endereco") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=endereco&ordem=0'><div>". translate('word_endereco_ip', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=endereco&ordem=1'><div>". translate('word_endereco_ip', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=endereco&ordem=0'><div>". translate('word_endereco_ip', true)  ."</div></a></td>";

		echo "</tr>";	
		
		

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);

			echo"<tr>
					<td>" . $this->bd->obterValor($rs,"data_hora") . "</td>	
					<td>" . $this->bd->obterValor($rs,"acesso") . "</td>			
					<td>" . $this->bd->obterValor($rs,"utilizador") . "</td>
					<td>" . $this->bd->obterValor($rs,"endereco") . "</td>				
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						  						
			</table>";		
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>