<?php 
	
/* Classe de Gestao de Atendimentos */

class LogAtendimento extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function LogAtendimento() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	
	/*
		Funcao de insercao de uma entrada no log
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function InserirChamada($num_senha, $servico, $tipo, $data_hora, $servico_emissao, $nome_cliente=null)
	{		
		$sql = "INSERT INTO log_atendimentos "
		."(id_empregado, id_balcao, id_servico, data_hora, numero_senha, id_loja, tipo,servico_emissao, nome_cliente) VALUES("
									. $_SESSION["sessao_empregado"] . ", "
									. $_SESSION["sessao_balcao"] . ", "
									. $servico . ", '" 
									. $data_hora . "', "
									. $num_senha . ","
									. $_SESSION["sessao_loja"] .","
									."'".$tipo."',"
									.$servico_emissao;
		
		/*if(is_null($nome_cliente) || $nome_cliente == "")
			$sql .= ",null);";
		else*/
			$sql .= ",'".$nome_cliente."');";
		
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		}
		
		$sql = "SELECT MAX(id_log_atendimentos) FROM log_atendimentos;";
		
		if(!$rs = $this->bd->executarSQL($sql)){
			return 0;
		} else {
			return $this->bd->obterValor($rs, 0);
		}
		
	}
	
	
	/*
		Devolve o numero da ultima senha
		chamada num dado servico
		
		0 = Erro da BD ou nao existem senhas emitidas para aquele servico
	*/
	function UltimaSenhaChamada($servico)
	{
		$sql = "SELECT id_log_atendimentos FROM log_atendimentos
				WHERE id_empregado IS NULL
				AND id_balcao IS NULL
				AND id_dispensador IS NULL
				AND nome_cliente='Reset Contagem'
				AND id_servico = ".$servico."
				AND tipo='Emissao'
				ORDER BY id_log_atendimentos DESC LIMIT 1;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		if($this->bd->obterNumRegistos($rs) == 0)
			$id_reset = 0;
		else 
			$id_reset = $this->bd->obterValor($rs, "id_log_atendimentos");
		
		/*$sql = "SELECT c.maxid, numero_senha, nome_cliente, servico_emissao
				FROM	(SELECT MAX(id_log_atendimentos) maxid, numero_senha, nome_cliente, servico_emissao
						FROM log_atendimentos
						WHERE tipo='Chamada' AND id_servico = ".$servico."
						AND id_log_atendimentos > ".$id_reset."
						GROUP BY numero_senha) c 
					LEFT JOIN
						(SELECT MAX(id_log_atendimentos) maxid, numero_senha
						FROM log_atendimentos
						WHERE tipo='Chamada Anterior'
						AND id_servico = ".$servico."
						AND id_log_atendimentos > ".$id_reset."
						GROUP BY numero_senha) a
					USING (numero_senha)
				WHERE c.maxid > a.maxid OR a.maxid IS NULL
				ORDER BY c.maxid DESC LIMIT 1;";*/
		/* todo: maxid? */	
		$sql = "SELECT id_log_atendimentos as maxid, data_hora, numero_senha, nome_cliente, servico_emissao
			FROM log_atendimentos 
			WHERE id_servico=$servico 
			AND data_hora >= ALL (SELECT data_hora 
						FROM log_atendimentos
					       	WHERE id_servico=$servico);";
				
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
				
		if( $this->bd->obterNumRegistos($rs) != 0){
			$tuplo = $this->bd->obterRegisto($rs);
			$ultima_senha = array();
			$ultima_senha["id"] = $tuplo["maxid"];
			$ultima_senha["numero"] = $tuplo["numero_senha"];
			$ultima_senha["cliente"] = $tuplo["nome_cliente"];
			$ultima_senha["servico_emissao"] = $tuplo["servico_emissao"];
			return $ultima_senha;
		}
		else {
			$ultima_senha = array();
			$ultima_senha["id"] = 0;
			$ultima_senha["numero"] = 0;
			return $ultima_senha;
		}
	}
	
	
	/*
		Devolve o numero da ultima senha
		emitida num dado servico
		
		0 = Erro da BD ou nao existem senhas emitidas para aquele servico
	*/
	function UltimaSenhaEmitida($servico)
	{
		$sql = "SELECT id_log_atendimentos FROM log_atendimentos
				WHERE id_empregado IS NULL
				AND id_balcao IS NULL
				AND id_dispensador IS NULL
				AND nome_cliente='Reset Contagem'
				AND id_servico = ".$servico."
				AND tipo='Emissao'
				ORDER BY id_log_atendimentos DESC LIMIT 1;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		if($this->bd->obterNumRegistos($rs) == 0)
			$id_reset = 0;
		else 
			$id_reset = $this->bd->obterValor($rs, "id_log_atendimentos");
		
		$sql = "SELECT id_log_atendimentos, numero_senha, nome_cliente, servico_emissao ".
				"FROM log_atendimentos at ".
				"WHERE tipo='Emissao' ".
				"AND at.servico_emissao = ". $servico ." ".
				"AND id_log_atendimentos > ".$id_reset." ".
				"ORDER BY id_log_atendimentos DESC LIMIT 1;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
				
		if( $this->bd->obterNumRegistos($rs) != 0){
			$tuplo = $this->bd->obterRegisto($rs);
			$ultima_senha = array();
			$ultima_senha["id"] = $tuplo["id_log_atendimentos"];
			$ultima_senha["numero"] = $tuplo["numero_senha"];
			$ultima_senha["cliente"] = $tuplo["nome_cliente"];
			$ultima_senha["servico_emissao"] = $tuplo["servico_emissao"];
			return $ultima_senha;
		}
		else {
			$ultima_senha = array();
			$ultima_senha["id"] = 0;
			$ultima_senha["numero"] = 0;
			return $ultima_senha;
		}
	}
	
	function atendeTerminada($numero_senha, $servico_emissao){
		
		$sql = "SELECT id_log_atendimentos, nome_cliente, id_servico FROM log_atendimentos
				WHERE servico_emissao = ".$servico_emissao."
				AND numero_senha = ".$numero_senha."
				AND (tipo='Terminado' OR tipo='Desistencia')
				ORDER BY id_log_atendimentos DESC LIMIT 1;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		if($this->bd->obterNumRegistos($rs) == 0)
			return 0;
			
		$tuplo = $this->bd->obterRegisto($rs);
		$senha = array();
		$senha["id"] = $tuplo["id_log_atendimentos"];
		$senha["numero"] = $numero_senha;
		$senha["cliente"] = $tuplo["nome_cliente"];
		$senha["servico_emissao"] = $servico_emissao;
		$senha["servico"] = $tuplo["id_servico"];
		
		$sql = "SELECT id_log_atendimentos FROM log_atendimentos
				WHERE id_empregado IS NULL
				AND id_balcao IS NULL
				AND id_dispensador IS NULL
				AND nome_cliente='Reset Contagem'
				AND id_servico = ".$tuplo["id_servico"]."
				AND tipo='Emissao'
				ORDER BY id_log_atendimentos DESC LIMIT 1;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		if($this->bd->obterNumRegistos($rs) == 0)
			$id_reset = 0;
		else 
			$id_reset = $this->bd->obterValor($rs, "id_log_atendimentos");
			
		if($id_reset > $senha["id"])
			return 0;
		
		$sql = "UPDATE log_atendimentos SET tipo='Suspensa'
				WHERE id_log_atendimentos = ".$senha["id"].";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		else 
			return $senha;
		
	}
	
	function ListaDeEspera($servico){
		
		$sql = "SELECT id_log_atendimentos FROM log_atendimentos
				WHERE id_empregado IS NULL
				AND id_balcao IS NULL
				AND id_dispensador IS NULL
				AND nome_cliente='Reset Contagem'
				AND id_servico = ".$servico."
				AND tipo='Emissao'
				ORDER BY id_log_atendimentos DESC LIMIT 1;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		if($this->bd->obterNumRegistos($rs) == 0)
			$id_reset = 0;
		else 
			$id_reset = $this->bd->obterValor($rs, "id_log_atendimentos");
		
			$sql = "SELECT max(id_log_atendimentos) id, numero_senha, servico_emissao, TIME(data_hora) as hora,
						SUBSTRING_INDEX(group_concat(tipo order by id_log_atendimentos DESC),',',1) ultimo_tipo, 
						SUBSTRING_INDEX(group_concat(nome_cliente order by id_log_atendimentos DESC),',',1) cliente
					FROM log_atendimentos
					WHERE id_servico = ".$servico."
					AND id_log_atendimentos > ".$id_reset."
					GROUP BY numero_senha, servico_emissao
					HAVING ultimo_tipo = 'Emissao' OR ultimo_tipo = 'Redireccao' OR ultimo_tipo = 'Suspensa'
					ORDER BY id ASC;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$lista = array();
		$lista_suspensas = array();
		
		$tamanho_lista = $this->bd->obterNumRegistos($rs);
		
		for($i=0 ; $i < $tamanho_lista ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$tuplo = $this->bd->obterRegisto($rs);
			$senha = array();
			$senha["id"] = $tuplo["id"];
			$senha["numero"] = $tuplo["numero_senha"];
			$senha["cliente"] = $tuplo["cliente"];
			$senha["servico_emissao"] = $tuplo["servico_emissao"];
			$senha["tipo"] = $tuplo["ultimo_tipo"];
			$senha["tempo_registo"] = $tuplo["hora"];
			
			if($senha["tipo"] == "Suspensa")
				array_push($lista_suspensas, $senha);
			else
				array_push($lista, $senha);
		}
		
		$lista = array_merge($lista, $lista_suspensas);
		
		return $lista;
		
	}
	
	/* 
		Verifica se existe alguma chamada feita
		pelo "loggado" no sistema no periodo
		de latencia. Devolve true se o periodo de
		latencia foi cumprido.
	*/

	function verificaLatencia()
	{
		global $LATENCIA_ATENDIMENTO;
		
		$sql = "SELECT numero_senha FROM log_atendimentos
				WHERE UNIX_TIMESTAMP(data_hora) 
				BETWEEN UNIX_TIMESTAMP() - ". $LATENCIA_ATENDIMENTO ." AND UNIX_TIMESTAMP();";

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		if($this->bd->obterNumRegistos($rs) == 0)
			return true;
		else 
			return false;
			
	}
	
	/*
	 * Calcula o tempo que um dado cliente esteve 'a
	 * espera ate' ser chamado.
	 */
	function obterTempoEspera($id_senha) {
		$sql = "SELECT UNIX_TIMESTAMP(data_hora) AS data_hora, tipo
						FROM log_atendimentos WHERE id_log_atendimentos >= $id_senha
						ORDER BY id_log_atendimentos ASC";
						
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$total = $this->bd->obterNumRegistos($rs);
		$i = 0;
		$this->bd->moverRegisto($rs, $i);
		$tuplo_inicial = $this->bd->obterRegisto($rs);
		
		$tempo_inicial = $tuplo_inicial["data_hora"];
		
		return time() - $tempo_inicial;
		/*for($i=1 ; $i < $total ; $i++) {
			
		}*/
	}		
	
	function actualizaEcra($id_servico, $id_loja){
		
		$sucesso_actualizacao="ok";
		
		$sql = "SELECT valor FROM variaveis WHERE nome='uri_actualizacao_ecras';";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		if($this->bd->obterNumRegistos($rs) == 0)
			return 0;
			
		/*$uri_actualizacao = $this->bd->obterValor($rs,"valor");*/
		
		$documento = $this->constroiXML($id_servico, $id_loja);
		if($documento == 0)
			return 0;
		/* envia a informacao para o servidor central */
		$this->notificarServidorCentral($id_servico, $id_loja);
		$xml_string = $documento->saveXML();
		/*	
		$pedido = new HTTP_Request();
		$pedido->setMethod(HTTP_REQUEST_METHOD_POST);
		$pedido->addHeader("Content-Type", "text/xml; charset=UTF-8");
		$pedido->addRawPostData($xml_string);	
		$sql = "SELECT e.identificador
				FROM ecra e
				WHERE e.id_loja = ".$id_loja.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		for($i = 0 ; $i < $this->bd->obterNumRegistos($rs) ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$nome_servico = obterNomeGeral($info_chamada["id_servico"],"id_servico","nome","servicos");
			
			$url_ecra = "http://". $this->bd->obterValor($rs, "identificador").$uri_actualizacao;
			
			$pedido->setURL($url_ecra);
			$response = $pedido->sendRequest();
			
			// erro ao efectuar o pedido
			if (PEAR::isError($response)) {
				return 0;
			}
			
			if($pedido->getResponseCode() != 200)
				$sucesso_actualizacao = 0;
		}*/
		
		return $sucesso_actualizacao;
	}

	function notificarServidorCentral($id_servico, $id_loja) {
		global $NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL;
		// inicia a ligacao ao servidor central, com um timeout de 30 segundos
		$socketfp = fsockopen($NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL, $errno, $errstr, 30);
		if (!socketfp) {
			// TODO: retornar erro para o bof, e possivelmente colocar a info do servidor central
			// no campo identificador de um local.
			echo translate('word_erro_com_servidor_central', true)  .": $errno - $errstr<br />\n";
			return;
		}
		fputs($socketfp, "CHMDSENH $id_servico $id_loja\n");
		fclose($socketfp);
	}
	
	function constroiXML($id_servico, $id_loja) {
		global $DIR_XML_SENHAS;	
		$config_teclado = new ConfiguracaoTeclado();
		$servicos_prestados = $config_teclado->DevolveTeclas($id_loja);
		$num_servicos = count($servicos_prestados);
		
		$documento = new DOMDocument("1.0", "UTF-8");
		$documento->formatOutput = true;
		
		$root = $documento->createElement("servicos");
		$documento->appendChild($root);
			
		for($i = 0 ; $i < $num_servicos ; $i++)	{
			$ultima_senha = $this->UltimaSenhaChamada($servicos_prestados[$i]["id"]);
			print_r($ultima_senha);
			$sql = "SELECT la.data_hora, la.tipo, la.nome_cliente,
							s.nome servico, s.id_servico,
							b.nome balcao, b.id_balcao,
							l.nome loja, l.endereco, l.id_loja
					FROM log_atendimentos la LEFT JOIN servicos s USING(id_servico)
							LEFT JOIN empregados e USING(id_empregado)
							LEFT JOIN balcoes b USING(id_balcao, id_loja)
							LEFT JOIN lojas l USING(id_loja)
					WHERE id_log_atendimentos=".$ultima_senha["id"].";";
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
			$tuplo = $this->bd->obterRegisto($rs);
			$no_chamada = $documento->createElement("servico");
			$no_chamada->setAttribute("id", $tuplo["id_servico"]);			
			// o servico que chamou a ultima senha deve ter o foco
			if($servicos_prestados[$i]["id"] == $id_servico) {
				$no_chamada->setAttribute("focus", "true");
			} else { 
				$no_chamada->setAttribute("focus", "false");
			}
			$root->appendChild($no_chamada);
			
			// info servico
			$no_nome_servico = $documento->createElement("nome_servico", $tuplo["servico"]);
			$no_chamada->appendChild($no_nome_servico);
			
			// info balcao
			$no_balcao = $documento->createElement("balcao");
			$no_balcao->setAttribute("id", $tuplo["id_balcao"]);
			$no_chamada->appendChild($no_balcao);
			
				$no_nome_balcao = $documento->createElement("nome", $tuplo["balcao"]);
				$no_balcao->appendChild($no_nome_balcao);
			
			// info da ultima senha chamada
			$no_senha = $documento->createElement("ultima_chamada");
			$no_senha->setAttribute("id", $ultima_senha["id"]);
			$no_chamada->appendChild($no_senha);
					
						$no_data_hora = $documento->createElement("data_hora", $tuplo["data_hora"]);
						$no_senha->appendChild($no_data_hora);
						
						$no_num_senha = $documento->createElement("numero_senha", sprintf("%02d",$ultima_senha["numero"]));
						$no_senha->appendChild($no_num_senha);
						
						$no_nome_cliente = $documento->createElement("nome", $tuplo["nome_cliente"]);
						$no_senha->appendChild($no_nome_cliente);
			
			// info senhas em espera
			$lista_espera = $this->ListaDeEspera($servicos_prestados[$i]["id"]);	
			$no_lista = $documento->createElement("lista_espera");
			$no_chamada->appendChild($no_lista);
			
				$tamanho_lista = count($lista_espera);
				for($j=0 ; $j < $tamanho_lista ; $j++) {
					$no_senha = $documento->createElement("senha");
					$no_senha->setAttribute("id", $lista_espera[$j]["id"]);
					$no_lista->appendChild($no_senha);
					
						$no_num_senha = $documento->createElement("numero_senha", $lista_espera[$j]["numero"]);
						$no_senha->appendChild($no_num_senha);
						
						$no_nome_cliente = $documento->createElement("nome", $lista_espera[$j]["cliente"]);
						$no_senha->appendChild($no_nome_cliente);
				}
		}	
		//$documento->save("/home/niexpo/playdir/contents/display.xml");
		$documento->save($DIR_XML_SENHAS . "display$id_loja.xml");
		return $documento;
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>
