<?php 
	
/* Classe de Gest�o de Servi�os */

class Servico extends AcessoBD
{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Servico() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	/*
		Indica o número máximo de clientes
		que é aceitável estarem em espera
		
		0 = Erro da BD
	*/		
	function LimiteClientes($servico)
	{
		$sql = "SELECT limite_clientes FROM servicos
				WHERE id_servico = ".$servico.";";
		
		
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$limite = $this->bd->obterValor($rs, "limite_clientes");
		
		if(!isset($limite))
		{
			$limite = 0;
		}
		
		return $limite;
		
	}
	
	function GetFactorPrioridade($servico)
	{
		$sql = "select prioridade
			from servicos
			where id_servico='" . $servico . "'";
		if (!$rs = $this->bd->executarSQL($sql)) return 0;
		else return $this->bd->obterValor($rs, "prioridade");
	}
	
	function IsSuspensivel($servico)
	{
		$sql = "select suspensivel from servicos where id_servico='" . $servico . "'";
		if (!$rs = $this->bd->executarSQL($sql)) return 0;
		else return $this->bd->obterValor($rs, "suspensivel");
	}
	
	function IsReencaminhavel($servico)
	{
		$sql = "select reencaminhavel from servicos where id_servico='" . $servico . "'";
		if (!$rs = $this->bd->executarSQL($sql)) return 0;
		else return $this->bd->obterValor($rs, "reencaminhavel");
	}
	
	function IsReencaminhaSempre($servico)
	{
		$sql = "select reencaminha_sempre from servicos where id_servico='" . $servico . "'";
		if (!$rs = $this->bd->executarSQL($sql)) return 0;
		else return $this->bd->obterValor($rs, "reencaminha_sempre");
	}

	function GetForm($servico)
	{
		$sql = "select f.path from form f inner join servicos s on s.id_form=f.id where s.id_servico=".$servico;
		$res = $this->bd->executarSQL($sql);
		return $this->bd->obterValor($res, "path");
	}

    function Is24HourService($servico)
    {

        $sql = "SELECT s.horario As id_horario " .
                "FROM servicos AS s " .
                "WHERE s.id_servico = " . $servico;

        $res = $this->bd->executarSQL($sql);
        $idHorario = $this->bd->obterValor($res, "id_horario");
        $horario = new Horario();
        $horario->get($idHorario);

        if ($horario->isContinuouslyOpenToday()) {
            return 1;
        }
        return 0;
    }
    
    function GetService($id)
    {
        $sql = "select s.nome nome_servico, e.nome nome_entidade from servicos s inner join entidades e on e.id_entidade=s.id_entidade where id_servico=".$id;
        $res = $this->bd->executarSQL($sql);
        return $this->bd->obterRegisto($res);
    }
    
    function GetFormId($servico)
    {
        $sql = "select f.id from form f inner join servicos s on s.id_form=f.id where s.id_servico=".$servico;
        $res = $this->bd->executarSQL($sql);
        if ($this->bd->obterNumRegistos($res) == 0) {
            return false;
        }
        return $this->bd->obterValor($res, "id");
    }

    /**
     * Get the list of services for what a given service is allowed to redirect
     *
     * @param $id service id
     */
    function GetRedirectionServiceList($id)
    {
        $sql = "select destination_id from servicos_redireccao where source_id=".$id;
        $res = $this->bd->executarSQL($sql);
        $servicos = array();
        while ($res && $row = $this->bd->obterRegisto($res))
        {
            array_push($servicos, $row["destination_id"]);
        }
        return $servicos;
    }

    /*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>