<?php 
	
/* Classe de Gest�o de Empregados */

class Empregado extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Empregado() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;

		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
  /*
	 * Devolve o identificador da loja associada ao empregado,
	 * ou 0 em caso de erro da BD.
	 */		
	function ObtemLocalTrabalho($empregado) {
		$sql = "SELECT local_trabalho 
						FROM empregados 
						WHERE nome_utiilizador='$empregado';";
						
		if (!$rs = $this->bd->executarSQL($sql)) {
			return 0;
		}
		$tuplo = $this->bd->obterRegisto($rs);
		$id_loja = $tuplo["local_trabalho"];
		return $id_loja;
	}

    function Inserir($dados) {
		global $TRINCO;

		$auto = 0;
		$time_to_call = 0;

		switch ($dados["call_method"])
		{
			case "manual":
				break;
			case "semiauto":
				$auto = 1;
				$time_to_call = 0;
				break;
			case "auto":
				$auto = 1;
				$time_to_call = $dados["time_to_call"];
				break;
			default:
				break;
		}

		if($dados["nome"] == "")
			$dados["nome"] = "null";

		if($dados["contacto"] == "")
			$dados["contacto"] = "null";
		else $dados["contacto"] = "'".$dados["contacto"]."'";

		if($dados["nome_utilizador"] == "")
			$dados["nome_utilizador"] = "null";
		else $dados["nome_utilizador"] = "'".$dados["nome_utilizador"]."'";

		if($dados["password"] == "")
			$dados["password"] = "null";
		else $dados["password"] = "'".$dados["password"]."'";

		/*if($dados["chamada"] == "")
			$dados["chamada"] = 0;
		else $dados["chamada"] = 1;*/

		if ($dados["desistir"] == "")
			$dados["time_to_disable"] = "null";
		else $dados["time_to_disable"] = "'".$dados["time_to_disable"]."'";

		$sql = "INSERT INTO empregados (nome, nome_utilizador, password, estado, contacto, auto, refresh_time, disable_desistir_after)
									VALUES (
									".$dados["nome"].",
									".$dados["nome_utilizador"].",
									".$dados["password"].",
									".$dados["estado"].",
									".$dados["contacto"].",
									".$auto.",
									".$time_to_call.",
									".$dados["time_to_disable"].")";

		if($rs = $this->bd->executarSQL($sql)) {
			$sql = "SELECT MAX(id_empregado) FROM empregados;";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;

			$id = $this->bd->obterValor($rs,0);

			// insere os locais de trabalho do empregado
			$locais_trabalho = new LocalColaborador();

			$res = $locais_trabalho->Inserir($dados["locais_trabalho"], $id, NULL);
			if (!$res) {
				return 0;
			}
//			// regista a inserção
//			$this->EscreveXMLSync($id, "inserir");
//
			// insere as entidades associadas ao empregado
			$entidades_trabalho = new EntidadeColaborador();

			$res = $entidades_trabalho->Inserir($dados["entidades_trabalho"], $id, NULL);
			if (!$res) {
				return 0;
			}

			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Empregado", $dados["nome"]);
			$objecto->fechar();

			return "ok";
		} else {
			return 0;
		}
	}

	function GetUserId($username)
	{
        $sql = "select id_empregado from empregados where nome_utilizador='".$username."'";
		$rs = $this->bd->executarSQL($sql);
		return $this->bd->obterValor($rs, "id_empregado");
	}

	/*
		Fun��o que verifica a autentica��o do utilizador
		
		0 = Erro da BD
		1 = Erro Utilizador
		2 = Erro Chave
		3 = Erro Tentativas
		4 = Erro Inactivo
		true = Sucesso	
	*/
	function VerificarEmpregado($empregado, $chave)
	{
        $sql = "SELECT * FROM empregados WHERE nome_utilizador='".$empregado."'";

		if($rs = $this->bd->executarSQL($sql, true))
		{
			$tuplo = $this->bd->obterRegisto($rs);
			
			$id_empregado = $tuplo["id_empregado"];
			$nome = $tuplo["nome"];
			//$id_loja = $tuplo["local_trabalho"];
			
			if($tuplo) {
				$num_tentativas = $tuplo["num_tentativas"];
				$blocked = false;
				if ($num_tentativas > 1000) {
					// $num_tentativas is a timestamp that indicates when the user was blocked
					if (time() < $num_tentativas + WRONG_PASS_BLOCK_TIME) {
						$blocked = true;
					}					
				}
				
				if(!$blocked) { // verifica se o utilizador n�o est� bloqueado por tentativas
					global $TRINCO;

					$sql = "SELECT * FROM empregados WHERE password = '".$tuplo["password"] . "';"; 	

					if(!$rs = $this->bd->executarSQL($sql))
							return 0;

					$rs = $this->bd->obterRegisto($rs);

					$num_tentativas++;
					
					//$temp = $tuplo["palavra_chave"] . " e " . $rs[0] . " e " . $chave;
					//debug($temp);
                    //echo $tuplo["password"]." - ".$chave."<br/>";
					//if(strcasecmp($tuplo["password"],$chave) == 0) // 0 caso sejam iguais
					if (password_verify($chave, $tuplo["password"]))
					{
						if($tuplo["estado"] == 3) // verifica se o utilizador est� inactivo
							return 4;
					
						$_SESSION["sessao_nome"] = $nome;
	
						if($num_tentativas != 1) // verifica se � necess�rio actualizar o n�mero de tentativas para 0
						{
							$sql = "UPDATE empregados SET num_tentativas=0, estado=1 WHERE id_empregado=" . $id_empregado . ";";			
									
							if(!$rs = $this->bd->executarSQL($sql))
								return 0;					
						}
						
//						debug($tuplo["nome_utilizador"], $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");
                        $_SESSION["sessao_login"] = $tuplo["nome_utilizador"];
						$_SESSION["sessao_passwd"] = $chave;
						$_SESSION["sessao_empregado"] = $id_empregado;
//						$_SESSION["sessao_loja"] = 0;//$id_loja;
						$_SESSION["sessao_tipo"] = "Empregado";																							
						$_SESSION["sessao_autenticado"] = 1;
						$_SESSION["sessao_auto"] = $tuplo["auto"];
						
						$_SESSION["sessao_refresh"] = $tuplo["refresh_time"];
						$_SESSION["sessao_disable_desistir_after"] = $tuplo["disable_desistir_after"];

						$_SESSION["sessao_ranking"] = $tuplo["ranking"];

						global $LANG;
						$_SESSION["sessao_lang_correcta"]=$LANG;
						$_SESSION["langArray"] = array();
						
						return "ok";
					}
					else					
					{					
						$sql = "UPDATE empregados SET num_tentativas=" . $num_tentativas ." WHERE id_empregado = " . $id_empregado . " ;";				
						if(!$rs = $this->bd->executarSQL($sql))
							return 0;	
							
						if($num_tentativas < 3) // verifica se n�o atingiu o n�mero m�ximo de tentativas
							return 2;
						else
						{		
							$sql = "UPDATE empregados SET num_tentativas=".time().", estado='2' WHERE id_empregado=" .  $id_empregado . ";";
							if($rs = $this->bd->executarSQL($sql))
								return 3;
							else
								return 0;		
						}						
					}
				}
				else 
					return 3;
			}
			else 
				return 1;
		}
		else
			return 0;
	}

        
        function createRecordIfDoesntExist($id_colaborador){
            
            $sql = "SELECT * from empregados_estados WHERE id_empregado=$id_colaborador";
            $rs = $this->bd->executarSQL($sql);
            if($this->bd->obterNumRegistos($rs)==0){
                $sql = "insert into empregados_estados (id_empregado) values ($id_colaborador)";
                $this->bd->executarSQL($sql);
            }
            
        }
        
        
        function updateEstado($id_colaborador, $estado, $balcao, $loja){
            $this->createRecordIfDoesntExist($id_colaborador);
            $sql = "UPDATE empregados_estados SET id_loja=$loja, id_balcao=$balcao, estado=$estado WHERE id_empregado=$id_colaborador";
            $this->bd->executarSQL($sql);
        }
        
        
        
        
	function MudaPalavraChave($user, $new)
	{
		$new = password_hash($new, PASSWORD_BCRYPT);
		$sql = "update empregados set password='".$new."' where nome_utilizador='".$user."'";
		if($rs = $this->bd->executarSQL($sql))
			return 7;
		else
			return 0;
	}
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>
