<?php 
	
/* Classe de Gest�o de Empregados */

class EmpregadoDGRHE extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function EmpregadoDGRHE() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;

		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
  /*
	 * Devolve o identificador da loja associada ao empregado,
	 * ou 0 em caso de erro da BD.
	 */		
	function ObtemLocalTrabalho($empregado) {
		$sql = "SELECT local_trabalho 
						FROM empregados 
						WHERE nome_utiilizador='$empregado';";
						
		if (!$rs = $this->bd->executarSQL($sql)) {
			return 0;
		}
		$tuplo = $this->bd->obterRegisto($rs);
		$id_loja = $tuplo["local_trabalho"];
		return $id_loja;
	}

    function Inserir($dados) {
		global $TRINCO;

		$auto = 0;
		$time_to_call = 0;

		switch ($dados["call_method"])
		{
			case "manual":
				break;
			case "semiauto":
				$auto = 1;
				$time_to_call = 0;
				break;
			case "auto":
				$auto = 1;
				$time_to_call = $dados["time_to_call"];
				break;
			default:
				break;
		}

		if($dados["nome"] == "")
			$dados["nome"] = "null";

		if($dados["contacto"] == "")
			$dados["contacto"] = "null";
		else $dados["contacto"] = "'".$dados["contacto"]."'";

		if($dados["id_externo"] == "")
            $dados["id_externo"] = "NULL";
        else $dados["id_externo"] = "'".trim($dados["id_externo"])."'";

		if($dados["nome_utilizador"] == "")
			$dados["nome_utilizador"] = "null";
		else $dados["nome_utilizador"] = "'".$dados["nome_utilizador"]."'";

		if($dados["password"] == "")
			$dados["password"] = "null";
		else $dados["password"] = "'".password_hash($dados["password"], PASSWORD_BCRYPT)."'";
       
		/*if($dados["chamada"] == "")
			$dados["chamada"] = 0;
		else $dados["chamada"] = 1;*/

		if ($dados["desistir"] == "")
			$dados["time_to_disable"] = "null";
		else $dados["time_to_disable"] = "'".$dados["time_to_disable"]."'";

		$sql = "INSERT INTO empregados (nome, nome_utilizador, password, estado, ranking, contacto, id_externo, auto, refresh_time, disable_desistir_after, id_balcao)
									VALUES (
									".(strlen($dados["nome"])?("'".($dados["nome"])."'"):"null").",
									".$dados["nome_utilizador"].",
									".$dados["password"].",
									".$dados["estado"].",
									".$dados["ranking"].",
									".$dados["contacto"].",
									".$dados["id_externo"].",
									".$auto.",
									".$time_to_call.",
									".$dados["time_to_disable"].",
									".$dados["id_balcao"].")";

		if($rs = $this->bd->executarSQL($sql)) {
			$sql = "SELECT MAX(id_empregado) as novo FROM empregados;";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;

			$id = $this->bd->obterValor($rs,'novo');

			// insere os locais de trabalho do empregado
			$locais_trabalho = new LocalColaborador();

			$res = $locais_trabalho->Inserir($dados["locais_trabalho"], $id, NULL);
			if (!$res) {
				return 0;
			}
//			// regista a inserção
//			$this->EscreveXMLSync($id, "inserir");
//
			// insere as entidades associadas ao empregado
			$entidades_trabalho = new EntidadeColaborador();

			$res = $entidades_trabalho->Inserir($dados["entidades_trabalho"], $id, NULL);
			if (!$res) {
				return 0;
			}

			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Empregado", $dados["nome"]);
			$objecto->fechar();

			return "ok";
		} else {
			return 0;
		}
	}

	function GetUserId($username)
	{
        $sql = "select id_empregado from empregados where nome_utilizador='".$username."'";
		$rs = $this->bd->executarSQL($sql);
		return $this->bd->obterValor($rs, "id_empregado");
	}

	function VerificarEmpregadoAD($empregado, $chave, &$nome)
	{	$builtWithLdap = extension_loaded('ldap');
		//var_dump($builtWithLdap);

		$ldaprdn  = "dgrhe.min-edu.pt\\" . $empregado;
		$ldappass = $chave;
		//echo "connected in...";
		$ldapconn = ldap_connect("10.20.0.111") or return 100;

		// We have to set this option for the version of Active Directory we are using.
		ldap_set_option($ldapconn, LDAP_OPT_PROTOCOL_VERSION, 3) or return 100;//die('Unable to set LDAP protocol version');
		ldap_set_option($ldapconn, LDAP_OPT_REFERRALS, 0); // We need this for doing an LDAP search.

		$ldapbind = ldap_bind($ldapconn);

		if (!$ldapbind) {		    
		    return 100;//echo "LDAP bind anonymous failed...";
		}


		if (ldap_bind($ldapconn, $ldaprdn, $ldappass)) {
		    $attributes = ['cn'];
		    $filter = "(&(objectClass=user)(objectCategory=person)(userPrincipalName=".ldap_escape($ldaprdn . "@dgrhe.min-edu.pt", null, LDAP_ESCAPE_FILTER)."))";
		    $baseDn = "DC=dgrhe.min-edu.pt,DC=pt";
		    $results = @ldap_search($ldapconn, $baseDn, $filter, $attributes);
		    $info = @ldap_get_entries($ldapconn, $results);

		    $ldap_success = ($info && $info['count'] === 1);
		    for ($i=0; $i<$info["count"]; $i++) {
	             $nome = $info[$i]["cn"][0];
	        }
		    if($ldap_success)
		     	return 'ok';
		} 
		else return 1;
	}
	/*
		Fun��o que verifica a autentica��o do utilizador
		
		0 = Erro da BD
		1 = Erro Utilizador
		2 = Erro Chave
		3 = Erro Tentativas
		4 = Erro Inactivo
		true = Sucesso	
	*/
	function VerificarEmpregado($empregado, $chave)
	{
		global $LOJA_DEFAULT;
		global $ENTIDADE_DEFAULT;
		//1. Validar credenciais na AD
		$nome = '';
		$ret = $this->VerificarEmpregadoAD($empregado, $chave, $nome)
		if($ret != 'ok')
			return $ret;

		//2. Verificar existe na BD
		if($this->VerificarEmpregadoLocal($empregado, $chave) == 1)
		{
	
			//3. Criar registo na BD
			$dados = array();
			$dados["call_method"] = "manual";
			$dados["nome"] = $nome; //obter da ad
			$dados["contacto"] = '';
			$dados["nome_utilizador"] = $empregado;
			$dados["password"] = 'vazio';
			$dados["desistir"] = "";
			$dados["estado"] = 1;
			$dados["ranking"] = 0;
			$dados["id_balcao"] = "NULL";
			$dados["locais_trabalho"] = array($LOJA_DEFAULT); 
			$dados["entidades_trabalho"] = array($ENTIDADE_DEFAULT); 

			if(!$this->Inserir($dados))
				return 0;

			if($this->VerificarEmpregadoLocal($empregado, $chave) == 'ok')
			{
				return 'ok';
			}

		} else
			return 'ok';

	}

	function VerificarEmpregadoLocal($empregado, $chave)
	{
        $sql = "SELECT * FROM empregados WHERE nome_utilizador='".$empregado."'";

		if($rs = $this->bd->executarSQL($sql, true))
		{
			$tuplo = $this->bd->obterRegisto($rs);
			
			$id_empregado = $tuplo["id_empregado"];
			$nome = $tuplo["nome"];
			//$id_loja = $tuplo["local_trabalho"];
			
			if($tuplo) {
				$num_tentativas = $tuplo["num_tentativas"];
				$blocked = false;
				if ($num_tentativas > 1000) {
					// $num_tentativas is a timestamp that indicates when the user was blocked
					if (time() < $num_tentativas + WRONG_PASS_BLOCK_TIME) {
						$blocked = true;
					}					
				}
				
				if(!$blocked) { // verifica se o utilizador n�o est� bloqueado por tentativas
					global $TRINCO;

					$sql = "SELECT * FROM empregados WHERE password = '".$tuplo["password"] . "';"; 	

					if(!$rs = $this->bd->executarSQL($sql))
							return 0;

					$rs = $this->bd->obterRegisto($rs);

					$num_tentativas++;
					
					//não valida password, já foi validada na AD
					if (true)//password_verify($chave, $tuplo["password"]))
					{
						if($tuplo["estado"] == 3) // verifica se o utilizador est� inactivo
							return 4;
					
						$_SESSION["sessao_nome"] = $nome;
	
						if($num_tentativas != 1) // verifica se � necess�rio actualizar o n�mero de tentativas para 0
						{
							$sql = "UPDATE empregados SET num_tentativas=0, estado=1 WHERE id_empregado=" . $id_empregado . ";";			
									
							if(!$rs = $this->bd->executarSQL($sql))
								return 0;					
						}
						
//						debug($tuplo["nome_utilizador"], $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");
                        $_SESSION["sessao_login"] = $tuplo["nome_utilizador"];
						$_SESSION["sessao_passwd"] = $chave;
						$_SESSION["sessao_empregado"] = $id_empregado;
//						$_SESSION["sessao_loja"] = 0;//$id_loja;
						$_SESSION["sessao_tipo"] = "Empregado";																							
						$_SESSION["sessao_autenticado"] = 1;
						$_SESSION["sessao_auto"] = $tuplo["auto"];
						
						$_SESSION["sessao_refresh"] = $tuplo["refresh_time"];
						$_SESSION["sessao_disable_desistir_after"] = $tuplo["disable_desistir_after"];

						$_SESSION["sessao_ranking"] = $tuplo["ranking"];

						global $LANG;
						$_SESSION["sessao_lang_correcta"]=$LANG;
						$_SESSION["langArray"] = array();
						
						return "ok";
					}
					else					
					{					
						$sql = "UPDATE empregados SET num_tentativas=" . $num_tentativas ." WHERE id_empregado = " . $id_empregado . " ;";				
						if(!$rs = $this->bd->executarSQL($sql))
							return 0;	
							
						if($num_tentativas < 3) // verifica se n�o atingiu o n�mero m�ximo de tentativas
							return 2;
						else
						{		
							$sql = "UPDATE empregados SET num_tentativas=".time().", estado='2' WHERE id_empregado=" .  $id_empregado . ";";
							if($rs = $this->bd->executarSQL($sql))
								return 3;
							else
								return 0;		
						}						
					}
				}
				else 
					return 3;
			}
			else 
				return 1;
		}
		else
			return 0;
	}

        
        function createRecordIfDoesntExist($id_colaborador){
            
            $sql = "SELECT * from empregados_estados WHERE id_empregado=$id_colaborador";
            $rs = $this->bd->executarSQL($sql);
            if($this->bd->obterNumRegistos($rs)==0){
                $sql = "insert into empregados_estados (id_empregado) values ($id_colaborador)";
                $this->bd->executarSQL($sql);
            }
            
        }
        
        
        function updateEstado($id_colaborador, $estado, $balcao, $loja){
            $this->createRecordIfDoesntExist($id_colaborador);
            $sql = "UPDATE empregados_estados SET id_loja=$loja, id_balcao=$balcao, estado=$estado WHERE id_empregado=$id_colaborador";
            $this->bd->executarSQL($sql);
        }
        
        
        
        
	function MudaPalavraChave($user, $new)
	{
		$new = password_hash($new, PASSWORD_BCRYPT);
		$sql = "update empregados set password='".$new."' where nome_utilizador='".$user."'";
		if($rs = $this->bd->executarSQL($sql))
			return 7;
		else
			return 0;
	}
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>
