<?php 

	session_start();

	
	require_once("../config.inc.php");
	require_once("../include.inc.php");

	if($_SESSION["sessao_autenticado"] == 0)
		header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);

	if($_SESSION["sessao_balcao"] == 0) {
		header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR . "balcoes/");
	}

	// Communicate with the Mobline Server to confirm an appointment that was
	// just created. If successfull, the mobline server will issue a number of 
	// new tickets equivalent to the number of appointments that were scheduled 
	// for this very day. The issued tickets will basically be copies of the 
	// customer's original ticket but will point to the services that match
	// the health care department of the scheduled appointment. Note that the
	// tickets will just be issued in the database and will *not* be printed
	// on paper. The customer will have to use his original ticket for all
	// of today's scheduled appointments.
	function confirmTicket($service_id, $ticket_id, $nsns, &$error) {
	
		global $NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL;
	

		$transaction_id = UUID::v4();
		
		$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
		if ($socket < 0) {
			$error = translate('word_appointment_server_error', false);
			return false;
		}

		$result = socket_connect($socket, $NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL);
		if ($result < 0) {
			$error = translate('word_appointment_server_error', false);
			return false;
		}

		// Send a CONFTICKET request to the mobline server
		$buffer = "CONFTICKET $nsns $ticket_id $transaction_id\0";
		socket_write($socket, $buffer, strlen($buffer) + 1);
		
		// read the server response
		$buffer = socket_read($socket, 2048, PHP_BINARY_READ);

		if ($buffer === FALSE) {
			$error = translate('word_appointment_server_error', false);
			return false;
		}
		else {
			socket_close($socket);
		}
		
		// Handle the return string
		if (strpos(trim($buffer), "TRUE") !== 0) {
			// Failure
			// $buffer should be somethinig like FALSE|<ErrorNumber>|<ErrorMessage>[|<ErrorNumber>|<ErrorMessage>[...]]
			$error = translate('word_appointment_confirmation_error', false);
			
			return false;
		}
		
		// If we arrived here, everything went presumably fine
		return true;
		
	}
	

	if (isset($_POST['submit'])) {
	
		// The form was submitted, handle it
		
		$id_servico = $_POST['id_servico'];
		$id_senha = $_POST['id_senha'];
		$nsns = $_POST['nsns'];             // national healtcare number
		$error = null;
		
		$return_url = "http://" . $_SERVER['HTTP_HOST'] . $DIR . "qterminal/?servico=" . $id_servico; //$_SESSION["servico_activo"];
		
		$result = confirmTicket($id_servico, $id_senha, $nsns, $error);
		
		$submitted = true;
	
	}
	else {
	
		// The form was *not* submitted yet

		// national healtcare number
		$nsns = null;             
		$id_senha = $_REQUEST["id_senha"];
		
		// TODO debug code, remove
		// $id_senha = 245;

		// Get the Servico Destino from the Senha that we're handling
		$senhas_obj = new Senhas();
		$senha = $senhas_obj->GetSenha($id_senha);
		
		$id_servico = $senha['servico_destino'];
		
		$submitted = false;
	}
		

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Zqueue - <?php  echo  translate('word_atendimento', true)  ?></title>
<link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">
<style type="text/css">
<!--
	#customer_health_info {
		display: <?php  echo  ($error != null) ? "block":"none"; ?>;
	}
	#no_appointments_scheduled {
		display: <?php  echo  ($error != null || ($submitted == true && $error == null)) ? "block":"none"; ?>;
	}
	#loading_message {
		display: none;
	}
-->
</style>
<script type="text/javascript" src="<?php  echo getPathScriptJS("jquery.js"); ?>"></script>
<script type="text/javascript" src="<?php  echo getPathScriptJS("funcoes.js"); ?>"></script>
<script type="text/javascript">
	
	function submitThisForm(form)
	{
		var ok = false;
		for (var i=0; i<form.consulta.length; i++)
		{
			// If a radio button has been selected it will return true
			// (If not it will return false)
			if (form.consulta[i].checked)
			ok = true;
		}
		
		if (ok) form.submit();
	}

	$(document).ready(function() {

		$("input:radio[name='has_new_daily_appointment']").change(
			function()
			{
				if ($("input:radio[name='has_new_daily_appointment']:checked").val() == 1) {
					$("#customer_health_info").show();
					$("#no_appointments_scheduled").hide();
				}
				else {
					$("#customer_health_info").hide();
					$("#no_appointments_scheduled").show();
				}
				$(this).blur();
			}
		);
		
		
		$("#terminate_after_error").click(
			function()
			{
				return confirm("<?php  echo  translate('word_appointment_giveup', false); ?>");
			}
		);
		
		jQuery.fn.preventDoubleSubmit = function() {
			jQuery(this).submit(function() {
				if (this.beenSubmitted) {
					return false;
				}
				else {
					$("#nsns").val($.trim($("#nsns").val()));
					if ($("#nsns").val().match(/^[0-9]{1,9}$/) == null) {
						alert("<?php  echo  translate('word_appointment_nsns_validation_error', false); ?>");
						return false;
					}
					
					$("#msg_erro").hide();
					$("#loading_message").show();
					this.beenSubmitted = true;
					return true;
				}
				
			});
		};
		
		jQuery('#customer_health_info').preventDoubleSubmit();

	}); // document ready
	
</script>
</head>
<body>

<table class="full_area" cellpadding="0" cellspacing="0" >
  <tr>
  <td>&nbsp;</td>
    <td class="atendimento">
		<table width="100%">
			<tr>
    				<td class="current_user">
					<div class="current_user_name">
					<?php 
						if($_SESSION["sessao_autenticado"] == 0)
							echo "".translate('word_bem_vindo', true) ."";
						else
							echo "<a href=\"../sair.php\"><img alt=\"Sair\" class=\"middle\" onClick =\"javascript:flag=true; submitAction('terminar');\" src=\"../img/buttons/button_log_out.gif\"></a>&nbsp;" .
							"<img class=\"middle\" src=\"../img/buttons/button_user.gif\"></a>"
								. " <strong>" . $_SESSION["sessao_nome"] . " @ " . $_SESSION["sessao_nome_balcao"] . "</strong>";
					?>
					</div>
					<div class="current_user_date_time"><?php  echo devolveDataHora(); ?></div>
				</td>
			</tr>
		</table>
		<table class="bg_title_center" cellspacing="0" cellpadding="0">
			<tr>
				<td class="bg_title_left">
				</td>
				<td class="module_space">
						<?php  echo  translate('word_atendimento', true)  ?>
				</td>
				<td class="function_space">
				</td>
				<td class="bg_title_right">
				</td>
			</tr>
		</table>
		<table cellspacing="0" cellpadding="0" style="width: 100%">
			<tr>
				<td class="bg_form_left"></td>
                <td>

				
				<?php  /*if ($show_submit_form):*/ ?>
				
				<?php  if ($submitted == false): /* only show the following options if the form wasn't submitted yet */ ?>
				<span class="input_title"><?php  echo  translate('word_appointment_scheduled_today', false)  ?> </span>
				<label for="has_new_daily_appointment_yes">
					<input type="radio" id="has_new_daily_appointment_yes" name="has_new_daily_appointment" title="Tem consultas novas marcadas para hoje" value="1" <?php  echo  ($error != null) ? "checked":""; ?> />
					<?php  print translate('word_sim'); ?>
				</label>
				<label for="has_new_daily_appointment_no">
					<input type="radio" id= "has_new_daily_appointment_no" name="has_new_daily_appointment" title="Não tem consultas novas marcadas para hoje" value="0" />
					<?php  print translate('word_nao'); ?>
				</label>
				<?php  endif; ?>
				
				<?php  if ($submitted == false || $error != null): ?>
				<form id="customer_health_info" action="marcar_consultas.php" method="POST">
				
					<input type="hidden" name="id_senha" id="id_senha" value="<?php  echo  $id_senha; ?>" />
					<input type="hidden" name="id_servico" id="id_servico" value="<?php  echo  $id_servico; ?>" />
				
					<?php  /* Only Shown if one or more appointments were scheduled for the current day. */ ?>
					<div>
						<div id='msg_erro' class='error_space'><?php  echo  $error ?></div>
						<p>
							<span class="input_title"><?php  echo  translate('word_appointment_nsns', false)  ?>: </span>
							<input id="nsns" type="text" name="nsns" value="<?php  echo  $nsns; ?>" />
						</p>
						<input type="submit" name="submit" value="<?php  echo  translate('word_appointment_issue_tickets', false)  ?>" /> <span id="loading_message"><img src="../img/loading.gif" /> <?php  echo  translate('word_appointment_confirming_wait', false)  ?></span>
					</div>
				
				</form>
				<?php  endif; ?>
				
				<?php  /* The terminate appointment form. */ ?>
				<form id="no_appointments_scheduled" action="../accoes_intermedias/accaoTratarForm.php" method="POST">
					<div>
						<p>
							<?php  if($submitted == true && $error == null): ?>
							<span class="input_title"><?php  echo  translate('word_appointment_confirmed_success', false)  ?></span>
							<?php  endif; ?>
						</p>
						<p>
							<input type="hidden" name="id_senha" id="id_senha" value="<?php  echo  $id_senha; ?>" />
							<input type="hidden" name="id_servico" id="id_servico" value="<?php  echo  $id_servico; ?>" />
							
							<?php  if ($error != null): ?>
							<input type="hidden" name="error" id="error" value="<?php  echo  $error; ?>" />
							<input id="terminate_after_error" type="submit" name="submit" value="<?php  echo  translate('word_appointment_terminate_attendance', false)  ?>" />

							<?php  else: ?>
							
							<input type="submit" name="submit_terminate" value="<?php  echo  translate('word_appointment_terminate_attendance', false)  ?>" />
							<?php  endif; ?>
						</p>
					</div>
				</form>

				</td>
				<td class="bg_form_right"></td>
			</tr>

			<tr>
				<td class="bg_form_bottom_left">
				</td>
				<td class="bg_form_bottom_center">
				</td>
				<td class="bg_form_bottom_right">
				</td>
			</tr>
		</table>
	</td>
	<td>&nbsp;</td>
  </tr>
</table>
</body>
</html>
