<?php 
class DBAccess {

	var $_db;

	function __construct($server, $user, $passwd, $dbname)
	{
		$this->_db = NewADOConnection("mysqli");
		if(!$this->_db)
			return 0;
		if(!$this->_db->Connect($server, $user, $passwd, $dbname))
			return 0;
	}

	function __destruct()
	{
		$this->_db->Close();
	}
	
	function Query($sql)
	{
		$res = $this->_db->Execute($sql);
		$ret = array();
		if ($res->RecordCount())
			while ($row = $res->FetchRow()) array_push($ret, $row);
		return $ret;
	}
	
	function Execute($sql, $debug = false)
	{
        //debug ("execute " . $sql);
		$res = $this->_db->Execute($sql);
		if ($res === false)
            debug("ERROSQL : " . str_replace("\t", " ", $sql));
        if ($debug)
            debug("DEBUGSQL : " . str_replace("\t", " ", $sql));

		return $res;
	}

	function FetchRow($res)
	{
		return $res->FetchRow();
	}

	function Move($res, $pos)
	{
		$res->Move($pos);
	}

	function Fields($res, $name)
	{
                //debug("Fields from " . $name . " are " . $res->Fields($name));
		return $res->Fields($name);
	}

	function RecordCount($res)
	{
		return $res->RecordCount();
	}
	
	function AffectedRows()
	{
		return $this->_db->Affected_Rows();
	}
}
?>