<?php  

	require_once("config.inc.php");	

/* Classe de Gestão de Acesso à BD */

class AcessoBD {

	var $conexao;

	function ligarBD($servidor, $username, $password, $nomebd) {
		$this->conexao = NewADOConnection("mysql"); //só mudar para outra base de dados
		if(!$this->conexao)
			return 0; //echo "Falha de Conexão" . $this->conexao;

                $this->conexao->hasInsertID = true; // Guardar os últimos IDs das tabelas com auto increment

		if(!$this->conexao->Connect($servidor, $username, $password, $nomebd))
			return 0; //echo "Falha de Selecção da BD: " . $this->conexao;

	}
	
	function executarSQL($comandoSQL, $debug = false) {
		$resultado = $this->conexao->Execute($comandoSQL);
		if ($resultado === false) {

			debug("ERROSQL : " . str_replace("\t", " ", $comandoSQL)."\n\n".$this->conexao->ErrorMsg());
                }
        	if ($debug)
			debug("DEBUGSQL : " . str_replace("\t", " ", $comandoSQL));
		
		return $resultado;
	}

	function obterRegisto($resultado) {
		return $resultado->FetchRow();
	}

	function moverRegisto($resultado, $posicao) {
		$resultado->Move($posicao);
	}

	function obterValor($resultado, $nome) {
		return $resultado->Fields($nome);
	}

	function obterNumRegistos($resultado) {
		return $resultado->RecordCount();
	}

	function obterNumRegistosFiltrados($tabela, $instrucao) {
		return $rs->PO_RecordCount($tabela, $instrucao);
	}

	function getRows($sql) {
		$res = $this->executarSQL($sql);

		$l = array();
		while ($res && $row = $this->obterRegisto($res)) {
			array_push($l, $row);
		}
		return $l;
	}

	/*
	 * Begin Transaction
	 */
	function startTransaction() {
		$this->conexao->StartTrans();
	}

	/*
	 * Commit Transaction
	 */
	function completeTransaction() {
		$this->conexao->CompleteTrans();
	}

	/*
	 * Rollback the current Transaction
	 */
	function failTransaction() {
		$this->conexao->FailTrans();
	}

	function obterUltimoInsertId() {
		return $this->conexao->Insert_ID();
	}

	function fecharBD() {
		$this->conexao->Close();
	}

}

?>
