<?php  

//date_default_timezone_set("Europe/Lisbon");

define("BEGINNING_DATE", "2011-01-01");

require_once("../config.inc.php");

//quantidade máxima de linhas de base de dados que envia por post
//esta a ser usado nas senhas, logs de acesso e empregados pois são tabelas muito grandes
$rows_per_post=2000;

//Definido pelo uuid e ip
$url="http://".IP_CENTRAL."/DataCentralizer/childRequestHandler.php?auth=DAEMON_CENTRALIZACAO&uuid=".UUID."&ip=".$_SERVER['SERVER_ADDR'];

//echo $url;


// obter a ultima data e actualizar uuids caso seja necessário
//obter a data a partir da qual vai buscar os dados
$date=do_post_request($url."&request=get_last_update_date");
    //se a loja ainda não está registada no sistema central ou se não existem registos de senhas no sistema

        if($date==FALSE || $date==''){
            $date=BEGINNING_DATE;
        }
        
       

echo " A actualizar a partir de: $date ";


//inicio do dump de dados




global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
$bd = new AcessoBD();
$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0




    
    
    
  

// ------------------ processing  Entidades -------------------------
$entities = array();
$res = $bd->executarSQL("SELECT id_entidade, nome FROM entidades");

while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $entities[] = array('id_entidade' => $row['id_entidade'], 'nome' => $row['nome']);
    unset($row);
}
do_post_request($url."&request=store_entidades", serialize($entities));
unset($entities);unset($res);
echo "<p>Entidades --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Entidades processment finishes ---------------------






// ------------------ processing  Lojas -------------------------
$stores=array();

$res = $bd->executarSQL("SELECT id_loja, nome FROM lojas");

$i=0;
while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $stores[] = array('id_loja' => $row['id_loja'], 'nome' => $row['nome']);

    // to each loja get all entities
    $res2 = $bd->executarSQL("SELECT id_entidade FROM lojas_entidades WHERE id_loja = ".$row['id_loja']);

    $entitiesLoja = array();
    while($row2=$bd->obterRegisto($res2)){
        $entitiesLoja[] = array('id_entidade' => $row2['id_entidade']);
    }
    $stores[$i]['entidades']=$entitiesLoja;
    $i++;
    //echo "<p>max_mem: ".(memory_get_peak_usage()/1048576)."</p>";
}
do_post_request($url."&request=store_lojas", serialize($stores));
echo "<p>Lojas --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Lojas processment finishes ---------------------


    
    

 

// ------------------ processing  Empregados -------------------------

$employes = array();
$res = $bd->executarSQL("SELECT	id_empregado, nome, nome_utilizador FROM empregados");

$i=0;
while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $employes[] = array('id_empregado' => $row['id_empregado'], 'nome' => $row['nome'], 'nome_utilizador' => $row['nome_utilizador']);
    
    $storesEmploye = array();
    $res2 = $bd->executarSQL("SELECT id_local FROM local_colaborador WHERE id_colaborador = ".$row['id_empregado']);
    while($row2=$bd->obterRegisto($res2)){
        $storesEmploye[] = $row2['id_local'];
        unset($row2);
    }
    $employes[$i]['lojas'] = implode(',', $storesEmploye);
    
    $entitiesEmploye = array();
    $res2 = $bd->executarSQL("SELECT id_entidade FROM entidade_colaborador WHERE id_colaborador = ".$row['id_empregado']);
    while($row2=$bd->obterRegisto($res2)){
        $entitiesEmploye[] = $row2['id_entidade'];
        unset($row2);
    }
    $employes[$i]['entidades'] = implode(',', $entitiesEmploye);
    
   
    $i++;
}
do_post_request($url."&request=store_empregados", serialize($employes));
echo "<p>Empregados --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Empregados processment finishes ---------------------







// ------------------ processing  Gestores -------------------------
$managers = array();
$res = $bd->executarSQL("SELECT id_utilizadores, nome, nome_utilizador, palavra_chave FROM utilizadores");
$i=0;
while($row=$bd->obterRegisto($res)){
    set_time_limit(500);
    $managers[] = array('id_utilizadores' => $row['id_utilizadores'], 'nome' => $row['nome'], 'nome_utilizador' => $row['nome_utilizador'], 'palavra_chave' => $row['palavra_chave']);
   
    // to each employe get all stores
    $managers[$i]['lojas'] = array();
    $res2 = $bd->executarSQL("SELECT id_loja FROM utilizadores_lojas WHERE id_utilizadores=".$row['id_utilizadores']);
    while($row2=$bd->obterRegisto($res2)){
         $managers[$i]['lojas'][] = $row2['id_loja'];
         unset($row2);
    }
    
    // to each employe get all entities
    $managers[$i]['entidades'] = array();
    $res2 = $bd->executarSQL("SELECT id_entidade FROM utilizadores_entidades WHERE id_utilizadores = ".$row['id_utilizadores']);
    while($row2=$bd->obterRegisto($res2)){
        $managers[$i]['entidades'][] = $row2['id_entidade'];
        unset($row2);
    }

    unset($res2);unset($row);
    $i++;
    //echo "<p>mem_ciclo $i: ".(memory_get_usage()/1048576)."</p>";
}
do_post_request($url."&request=store_gestores", serialize($managers));
unset($managers);unset($res);
echo "<p>Gestores --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Gestores processment finishes ---------------------











// ------------------ processing  Servicos -------------------------
$services = array();
$res = $bd->executarSQL("SELECT id_servico, nome, id_entidade FROM servicos ");

while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $services[] = array('id_servico' => $row['id_servico'], 'nome' => $row['nome'], 'id_entidade' => $row['id_entidade']);
    unset($row);
}
do_post_request($url."&request=store_servicos", serialize($services));
unset($services);
echo "<p>Serviços --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Servicos processment finishes ---------------------






// ------------------ processing  Balcoes -------------------------
$counters = array();
$res = $bd->executarSQL("SELECT id_balcao, nome, id_loja, id_entidade, estado, data_hora FROM balcoes");

while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $counters[] = array('id_balcao' => $row['id_balcao'], 'nome' => $row['nome'], 'id_loja' => $row['id_loja'], 'id_entidade' => $row['id_entidade'], 'estado' => $row['estado'], 'data_hora' => $row['data_hora']);
    unset($row);
}
do_post_request($url."&request=store_balcoes", serialize($counters));
unset($counters);
echo "<p>Balcoes --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Balcoes processment finishes ---------------------







// ------------------ processing  Formularios -------------------------
$forms = array();
$res = $bd->executarSQL("SELECT id, descr, path, data, unix_timestamp(last_update) as last_update FROM form");

while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $forms[] = array('id' => $row['id'], 'descr' => $row['descr'], 'path' => $row['path'], 'data' => $row['data'], 'last_update' => $row['last_update']);
    unset($row);
}
do_post_request($url."&request=store_formularios", serialize($forms));
unset($forms);
echo "<p>Forms --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Formularios processment finishes ---------------------






// ------------------ processing  Dispensadores -------------------------
$dispensadores = array();
$res = $bd->executarSQL("SELECT id_dispensador, estado, data_hora, nome, id_loja, tipo_dispensador, status_impressora FROM dispensador");

while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $dispensadores[] = array('id_dispensador' => $row['id_dispensador'], 'estado' => $row['estado'], 'data_hora' => $row['data_hora'], 'nome' => $row['nome'], 'id_loja' => $row['id_loja'], 'tipo_dispensador' => $row['tipo_dispensador'], 'status_impressora' => $row['status_impressora']);
    unset($row);
}
do_post_request($url."&request=store_dispensadores", serialize($dispensadores));
unset($dispensadores);
echo "<p>Dispensadores --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Dispensadores processment finishes ---------------------






// ------------------ processing  Screens -------------------------
$ecras = array();
$res = $bd->executarSQL("SELECT id_ecra, nome, identificador, estado, data_hora, id_loja FROM ecra");

while($row=$bd->obterRegisto($res)){
    set_time_limit(60);
    $ecras[] = array('id_ecra' => $row['id_ecra'], 'nome' => $row['nome'], 'identificador' => $row['identificador'], 'estado' => $row['estado'], 'data_hora' => $row['data_hora'], 'id_loja' => $row['id_loja']);
    unset($row);
}
do_post_request($url."&request=store_ecras", serialize($ecras));
unset($ecras);
echo "<p>Ecras --- mem_na_saida: ".(memory_get_usage()/1048576)." ---</p>";
// -------------- Screens processment finishes ---------------------











/// ------------------ processa dados das senhas e tempos por dia -------------------------
$actualTimeStamp = mktime(0, 0, 0, date("m", strtotime($date)), date("d", strtotime($date)), date("Y", strtotime($date)));
$endDateTimeStamp = mktime(0, 0, 0, date("m"), date("d"), date("Y"));


while($actualTimeStamp < $endDateTimeStamp){

$date=date('Y-m-d', $actualTimeStamp);

$yesterday_date=date('Y-m-d', $endDateTimeStamp);
if($date==$yesterday_date){
    echo " cleaning yesterday tickets to store final ones ";
  //Apaga todas as senhas do dia anterior antes de inserir as senhas finais do dia
  do_post_request($url."&request=empty_today_tickets", '');
}
// get all tickets, only from one day (default = today)

$num_res = $bd->executarSQL("SELECT COUNT(*) as tickets_total FROM senhas WHERE data = '$date'")->getRows();

$max_post = ceil($num_res[0]['tickets_total']/$rows_per_post);
$offset=0;
$counter=0;

while($counter<$max_post){
$tickets = array();
$res = $bd->executarSQL("SELECT * FROM senhas WHERE data = '$date' LIMIT $offset, $rows_per_post");

$i=0;

while($row=$bd->obterRegisto($res)){
    
    set_time_limit(500);
    $tickets[] = array('id_senha' => $row['id_senha'], 
                        'data' => $row['data'], 
                        'satisfacao' => $row['satisfacao'], 
                        'numero_senha' => $row['numero_senha'], 
                        'id_loja' => $row['id_loja'],
                        'servico_emissao' => $row['servico_emissao'],
                        'servico_destino' => $row['servico_destino'],
                        'emissao' => $row['emissao'],
                        'previsao_atendimento' => $row['previsao_atendimento'],
                        'tempo_espera' => $row['tempo_espera'],
                        'tempo_atendimento' => $row['tempo_atendimento'],
                        'id_balcao' => $row['id_balcao'],
                        'id_colaborador' => $row['id_colaborador'],
                        'status' => $row['status']
                        );
   
        // to each senha get all form data
	$res2 = $bd->executarSQL("SELECT chave, valor FROM form_data WHERE id_senha = ".$row['id_senha']);
        $tickets[$i]['form_data'] = array();
	while($row2=$bd->obterRegisto($res2)){
           // set_time_limit(100);
            $tickets[$i]['form_data'][$row2['chave']] = $row2['valor'];
            unset($row2);
	}
        
       //  processing  RespostasFormularios 
        $res2 = $bd->executarSQL("SELECT id_form, id_senha, data, created, modified FROM form_submission where id_senha=".$row['id_senha']);
        while($row2=$bd->obterRegisto($res2)){
            //set_time_limit(100);
            $tickets[$i]['form_submission'][] = array(
                   'id_form' => $row2['id_form'], 
                   'data' => $row2['data'],
                   'created' => $row2['created'],
                   'modified' => $row2['modified'],
                );
        }
        unset($row);
        $i++;
}
set_time_limit(500);
do_post_request($url."&request=store_senhas", serialize($tickets));
$counter++;
$offset=$offset+$rows_per_post;
unset($tickets);
}



// -------------- Senhas processment finishes ---------------------





// get all employes access, only from one day (default = today)

$num_res = $bd->executarSQL("SELECT COUNT(*) as tickets_total FROM log_acessos_empregados WHERE DATE(data_hora) = '$date'")->getRows();

$max_post = ceil($num_res[0]['tickets_total']/$rows_per_post);
$offset=0;
$counter=0;
while($counter<$max_post){
$res = $bd->executarSQL("SELECT id_empregado, acesso, data_hora, id_balcao, id_loja FROM log_acessos_empregados WHERE DATE(data_hora) = '$date' LIMIT $offset, $rows_per_post");
$employes_access = array();
while($row=$bd->obterRegisto($res)){
   set_time_limit(100);
    $employes_access[] = array('id_empregado' => $row['id_empregado'], 
                        'acesso' => $row['acesso'], 
                        'data_hora' => $row['data_hora'], 
                        'id_balcao' => $row['id_balcao'],
                        'id_loja' => $row['id_loja']
                        );
    unset($row);
}
set_time_limit(200);
do_post_request($url."&request=store_logs_empregados", serialize($employes_access));
$counter++;
$offset=$offset+$rows_per_post;
unset($employes_access);
}
// -------------- LogsEmpregados processment finishes ---------------------







//logs de duração dos tempos com as novas contagens
$employes_times = array();
$res = $bd->executarSQL("SELECT id, id_empregado, id_loja, tempo_suspenso, tempo_atendimento, tempo_logado, dia, mes, ano, ano_mes, ultima_actualizacao FROM empregados_tempos WHERE DATE(ultima_actualizacao) = '$date'");

while($row=$bd->obterRegisto($res)){
    set_time_limit(100);
    $employes_times[] = array('id' => $row['id'], 
                        'id_empregado' => $row['id_empregado'], 
                        'id_loja' => $row['id_loja'], 
                        'tempo_suspenso' => $row['tempo_suspenso'],
                        'tempo_atendimento' => $row['tempo_atendimento'],
                        'tempo_logado' => $row['tempo_logado'],
                        'dia' => $row['dia'],
                        'mes' => $row['mes'],
                        'ano' => $row['ano'],
                        'ano_mes' => $row['ano_mes'],
                        'ultima_actualizacao' => $row['ultima_actualizacao']
                        );
    unset($row);
}
do_post_request($url."&request=store_empregados_tempos", serialize($employes_times));
unset($employes_times);
// -------------- tempos empregados processment finishes ---------------------


echo "<p>".$date." -- Processado</p>";
$actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp)+1, date("Y", $actualTimeStamp));
}
 
//fim do while

//fim do dump de dados
echo "Central database update process finished";











function do_post_request($url, $data, $optional_headers = 'Content-type: application/x-www-form-urlencoded'){ 
    $params = array('http'=>array('method'=>'POST','content'=>$data)); 
    if($optional_headers !== null){ 
        $params['http']['header'] = $optional_headers; 
    } 
    $ctx = @stream_context_create($params); 
    $fp = fopen($url, 'rb', false, $ctx); 
    if(!$fp){ 
        throw new Exception("Problem with $url, $php_error_msg"); 
    } 
    $response = @stream_get_contents($fp); 
    if($response === false){ 
        throw new Exception("Problem reading data from $url, $php_errormsg"); 
    } 
    return $response; 
}  





?>
