<?php  

require_once("../config.inc.php");

$time_loger=new TimeManager();
$log_acesso=new LogAcessoEmpregado();

//get first records date
$sql = "Select MIN(DATE(data_hora)) as min_date from log_acessos_empregados";
$res = $time_loger->bd->executarSQL($sql)->GetRows();

$start_date=$res[0]['min_date'];

//echo "<p>".memory_get_peak_usage()."</p>";

$actualTimeStamp = mktime(0, 0, 0, date("m", strtotime($start_date)), date("d", strtotime($start_date)), date("Y", strtotime($start_date)));
$endDateTimeStamp = mktime(0, 0, 0, date("m"), date("d")+1, date("Y"));

//cycle all days since the first entry until now
while($actualTimeStamp <= $endDateTimeStamp){
//set_time_limit(356432232);
//echo "<p> Current date: ".date('Y-m-d h:j:s', $actualTimeStamp)."</p>";

//get distinct accesses from empregado and loja for the cycle day
$sql = "Select distinct id_empregado, id_loja, DATE(data_hora) as date from log_acessos_empregados WHERE DATE(data_hora)=DATE(FROM_UNIXTIME($actualTimeStamp))";
$res = $time_loger->bd->executarSQL($sql)->GetRows();

if(count($res)>0){
	$employes_stores = array();
	$count = 0;
		foreach($res AS $row){
			$employes_stores[$count] = array();
			foreach($row AS $field => $value){
				if(!is_numeric($field)){
					$employes_stores[$count][$field] = $value;
				}
		}	
	$count++;
}

	foreach($employes_stores as $employee_store){
			$data = date("Y-m-d", strtotime($employee_store['date']));
			$year_month=date("Ym", strtotime($employee_store['date']));
			//echo "<p> -> id_empregado=".$employee_store['id_empregado'].", id_loja=".$employee_store['id_loja'].", data=".$data;
			$tempos=getTempos($actualTimeStamp, $employee_store['id_loja'], $employee_store['id_empregado']);
			$data1 = $tempos['atendimento'];
			$data2 = $tempos['suspenso'];
			$data3 = $tempos['total'];
			//echo " (atendimento:".$data1."s suspenso:".$data2."s total:".$data3."s )";
			//echo '</p>';
			$sql = "insert into empregados_tempos (id_empregado, id_loja, tempo_suspenso, tempo_atendimento, tempo_logado, dia, mes, ano, ano_mes, ultima_actualizacao) values (".$employee_store['id_empregado'].", ".$employee_store['id_loja'].", SEC_TO_TIME($data2),  SEC_TO_TIME($data1),  SEC_TO_TIME($data3), DAYOFMONTH(FROM_UNIXTIME($actualTimeStamp)), MONTH(FROM_UNIXTIME($actualTimeStamp)), YEAR(FROM_UNIXTIME($actualTimeStamp)), $year_month, FROM_UNIXTIME($actualTimeStamp))";
			$time_loger->bd->executarSQL($sql);
			
	}
}
set_time_limit(300);
$actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp)+1, date("Y", $actualTimeStamp));
//echo memory_get_usage() . "\n";
}





//get tempo for a specific empregado, loja and day
	function getTempos($actualTimeStamp, $id_loja, $id_empregado){
		$time_loger=new TimeManager();
		$tempos=array();
		
		$tempos['atendimento']=0;
		$tempos['suspenso']=0;
		$tempos['total']=0;
		
		$sql = "Select acesso, TIME_TO_SEC(data_hora) as data_hora, UNIX_TIMESTAMP(DATE(data_hora)) as t_stamp from log_acessos_empregados WHERE DATE(data_hora)=DATE(FROM_UNIXTIME($actualTimeStamp)) and id_empregado=$id_empregado and id_loja=$id_loja order by data_hora asc";
		$time_loger->bd->executarSQL($sql);
		
		$res = $time_loger->bd->executarSQL($sql)->GetRows();

		
if(count($res)>0){
	$estados = array();
	$count = 0;
		foreach($res AS $row){
			$estados[$count] = array();
			foreach($row AS $field => $value){
				if(!is_numeric($field)){
					$estados[$count][$field] = $value;
				}
		}	
	$count++;
}

$estado_anterior='';	
$t_inicio_estado=0;	

//obter ultimo estado
        $sql = "Select acesso, TIME_TO_SEC(data_hora) as data_hora, UNIX_TIMESTAMP(DATE(data_hora)) as t_stamp from log_acessos_empregados WHERE DATE(data_hora)<DATE(FROM_UNIXTIME($actualTimeStamp)) and id_empregado=$id_empregado and id_loja=$id_loja order by t_stamp desc limit 1";
		$time_loger->bd->executarSQL($sql);
		$res_estado = $time_loger->bd->executarSQL($sql)->GetRows();
		
		//se o ultimo estado da entrada nao foi uma saida contabiliza os dias de intervalo
                //echo"\n [estado anterior: ".$res_estado[0]['acesso']."] ";
			if($res_estado[0]['acesso']!='Saida' && $res_estado[0]['acesso']!=''){	
                            
					$estado_anterior=$res_estado[0]['acesso'];
                                        
                                        
					
					$segundos_desde_ultimo_estado=$estados[0]['t_stamp']-$res_estado[0]['t_stamp'];
               
					$dias_passados=($segundos_desde_ultimo_estado/86400);
                                        
					$segundos_do_dia_actual=$dias_passados-intval($dias_passados);
					$segundos_do_dia_actual=round($segundos_do_dia_actual*86400);
					
                                        $t_suspenso='00:00:00';
					$t_atendimento='00:00:00';
					
					if($res_estado[0]['acesso']=='Suspenso'){
						$t_suspenso='24:00:00';
					}
					if($res_estado[0]['acesso']=='Entrada'){
						$t_atendimento='24:00:00';
					}
					$year_month=date("Ym", $actualTimeStamp);
					
					//preenche os dias de intervalo
					for ($i = intval($dias_passados)-1; $i>=1; $i--){
						$sql = "insert into empregados_tempos (id_empregado, id_loja, tempo_suspenso, tempo_atendimento, tempo_logado, dia, mes, ano, ano_mes, ultima_actualizacao) values ($id_empregado, $id_loja, '$t_suspenso', '$t_atendimento', '24:00:00', DAYOFMONTH(DATE_SUB(DATE(FROM_UNIXTIME($actualTimeStamp)), Interval $i day)), MONTH(DATE_SUB(DATE(FROM_UNIXTIME($actualTimeStamp)), Interval $i day)), YEAR(DATE_SUB(DATE(FROM_UNIXTIME($actualTimeStamp)), Interval $i day)), $year_month, TIMESTAMP(DATE_SUB(DATE(FROM_UNIXTIME($actualTimeStamp)), Interval $i day)))";
						$time_loger->bd->executarSQL($sql);
                                               // echo " meteu 24h!! $i ";
					}
			}
		

	
	//estados do dia
	$i=0;
	$numItems = count($estados);
	$t_inicio_estado=0;
        
        
	foreach($estados as $estado){
		
			switch($estado['acesso']){
			
				case 'Entrada':
                                    //se for o ultimo estado do dia
					if($i+1 == $numItems){
						$time_till_end_of_day=86400-$estado['data_hora'];
						$tempos['atendimento']=$tempos['atendimento']+$time_till_end_of_day;
					}
                           
					if($estado_anterior=='Suspenso'){
						$tempos['suspenso']=$tempos['suspenso']+($estado['data_hora']-$t_inicio_estado);
					}
					if($estado_anterior=='Entrada'){
						$tempos['atendimento']=$tempos['atendimento']+($estado['data_hora']-$t_inicio_estado);
					}
					
					$t_inicio_estado=$estado['data_hora'];
					$estado_anterior='Entrada';
					
					//echo ' entrada ';
				break;
				
				case 'Saida':
					if($estado_anterior=='Suspenso'){
						$tempos['suspenso']=$tempos['suspenso']+($estado['data_hora']-$t_inicio_estado);
					}
					if($estado_anterior=='Entrada'){
						$tempos['atendimento']=$tempos['atendimento']+($estado['data_hora']-$t_inicio_estado);
					}	
					$estado_anterior='Saida';
					$t_inicio_estado=0;
					//echo ' saida ';
				break;
				
				case 'Suspenso':
                                     //se for o ultimo estado do dia
                                    if($i+1 == $numItems){
						$time_till_end_of_day=86400-$estado['data_hora'];
						$tempos['suspenso']=$tempos['suspenso']+$time_till_end_of_day;
					}
                                        
					if($estado_anterior=='Entrada'){
						$tempos['atendimento']=$tempos['atendimento']+($estado['data_hora']-$t_inicio_estado);
					}
                                        if($estado_anterior=='Suspenso'){
						$tempos['suspenso']=$tempos['suspenso']+($estado['data_hora']-$t_inicio_estado);
					}
					$t_inicio_estado=$estado['data_hora'];
					$estado_anterior='Suspenso';
					//echo ' suspenso ';
				break;
			}
		 $i++;
	}
	$tempos['total']=$tempos['suspenso']+$tempos['atendimento'];
	}
		
		
		return $tempos;
	}

	

?>