-- MySQL dump 10.10
--
-- Host: localhost    Database: mobline
-- ------------------------------------------------------
-- Server version	5.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `balcoes`
--

create database mobline;
use mobline;


DROP TABLE IF EXISTS `balcoes`;
CREATE TABLE `balcoes` (
  `id_balcao` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(20) collate latin1_general_ci NOT NULL,
  `id_loja` int(10) unsigned NOT NULL default '0',
  `estado` int(10) unsigned NOT NULL default '0',
  `id_entidade` int(10) unsigned NOT NULL default '0',
  `nome_ecra` varchar(20) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`id_balcao`,`id_loja`),
  KEY `id_loja3` (`id_loja`),
  KEY `FK_balcoes_2` (`estado`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Balcoes de um dada loja';

--
-- Dumping data for table `balcoes`
--


--
-- Table structure for table `dispensador`
--

DROP TABLE IF EXISTS `dispensador`;
CREATE TABLE `dispensador` (
  `id_dispensador` int(10) unsigned NOT NULL auto_increment,
  `estado` int(10) unsigned NOT NULL default '1' COMMENT 'Estado,30,52,16,nenhuma,1,0,9',
  `nome` varchar(45) NOT NULL COMMENT 'Identificador,30,52,1,nenhuma,1,0',
  `id_loja` int(10) unsigned NOT NULL default '0' COMMENT 'Loja,30,52,16,nenhuma,1,0,6',
  `tipo_dispensador` int(10) unsigned NOT NULL default '0',
  `status_impressora` int(11) default NULL,
  PRIMARY KEY  (`id_dispensador`,`id_loja`),
  KEY `FK_dispensador_1` (`id_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Tabela geral dos dispensadores';

--
-- Dumping data for table `dispensador`
--


/*!40000 ALTER TABLE `dispensador` DISABLE KEYS */;
LOCK TABLES `dispensador` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dispensador` ENABLE KEYS */;

--
-- Table structure for table `dispensador_base`
--

DROP TABLE IF EXISTS `dispensador_base`;
CREATE TABLE `dispensador_base` (
  `id_dispensador_base` int(10) unsigned NOT NULL auto_increment,
  `id_dispensador` int(10) unsigned NOT NULL,
  `identificador` varchar(255) collate latin1_general_ci default NULL,
  `msg_boasvindas` varchar(255) collate latin1_general_ci default NULL,
  `msg_impressaosenha` varchar(255) collate latin1_general_ci default NULL,
  `tipo_processador` int(10) unsigned NOT NULL,
  `tipo_impressora` int(10) unsigned NOT NULL,
  `tipo_ecra` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_dispensador_base`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Dispensadores com ecra tactil';

--
-- Dumping data for table `dispensador_base`
--


/*!40000 ALTER TABLE `dispensador_base` DISABLE KEYS */;
LOCK TABLES `dispensador_base` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dispensador_base` ENABLE KEYS */;

--
-- Table structure for table `dispensador_manual`
--

DROP TABLE IF EXISTS `dispensador_manual`;
CREATE TABLE `dispensador_manual` (
  `id_dispensador_manual` int(10) unsigned NOT NULL auto_increment,
  `id_servico` int(10) unsigned default NULL COMMENT 'Serviço Associado,30,52,16,nenhuma,1,0,8',
  `id_dispensador` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_dispensador_manual`),
  KEY `FK_dispensador_manual_1` (`id_servico`),
  KEY `FK_dispensador_manual_3` (`id_dispensador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Dispensadores bico de pato';

--
-- Dumping data for table `dispensador_manual`
--


/*!40000 ALTER TABLE `dispensador_manual` DISABLE KEYS */;
LOCK TABLES `dispensador_manual` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dispensador_manual` ENABLE KEYS */;

--
-- Table structure for table `ecra`
--

DROP TABLE IF EXISTS `ecra`;
CREATE TABLE `ecra` (
  `id_ecra` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) default NULL COMMENT 'Nome,30,52,1,nenhuma,0,0',
  `identificador` varchar(45) NOT NULL default '' COMMENT 'Identificador,30,52,1,nenhuma,1,0',
  `estado` int(10) unsigned NOT NULL default '1' COMMENT 'Estado,30,52,16,nenhuma,1,0,11',
  `id_loja` int(10) unsigned NOT NULL default '0' COMMENT 'Loja,30,52,16,nenhuma,1,0,6',
  PRIMARY KEY  (`id_ecra`,`id_loja`),
  KEY `FK_ecra_1` (`id_loja`),
  KEY `FK_ecra_2` (`estado`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Ecras';

--
-- Dumping data for table `ecra`
--


/*!40000 ALTER TABLE `ecra` DISABLE KEYS */;
LOCK TABLES `ecra` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `ecra` ENABLE KEYS */;

--
-- Table structure for table `ecra_dispensador`
--

DROP TABLE IF EXISTS `ecra_dispensador`;
CREATE TABLE `ecra_dispensador` (
  `id_ecra` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_ecra`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Ecras associados a um Dispensador';

--
-- Dumping data for table `ecra_dispensador`
--


/*!40000 ALTER TABLE `ecra_dispensador` DISABLE KEYS */;
LOCK TABLES `ecra_dispensador` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `ecra_dispensador` ENABLE KEYS */;

--
-- Table structure for table `empregados`
--

DROP TABLE IF EXISTS `empregados`;
CREATE TABLE `empregados` (
  `id_empregado` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(50) NOT NULL default '',
  `nome_utilizador` varchar(20) default NULL,
  `password` varchar(20) default NULL,
  `num_tentativas` tinyint(3) unsigned NOT NULL default '0',
  `estado` tinyint(3) unsigned NOT NULL default '1',
  `contacto` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_empregado`),
  UNIQUE KEY `nome_utilizador_2` (`nome_utilizador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empregados`
--


/*!40000 ALTER TABLE `empregados` DISABLE KEYS */;
LOCK TABLES `empregados` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `empregados` ENABLE KEYS */;

--
-- Table structure for table `entidade_colaborador`
--

DROP TABLE IF EXISTS `entidade_colaborador`;
CREATE TABLE `entidade_colaborador` (
  `id_entidade` int(10) unsigned NOT NULL,
  `id_colaborador` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_entidade`,`id_colaborador`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `entidade_colaborador`
--


/*!40000 ALTER TABLE `entidade_colaborador` DISABLE KEYS */;
LOCK TABLES `entidade_colaborador` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `entidade_colaborador` ENABLE KEYS */;

--
-- Table structure for table `entidades`
--

DROP TABLE IF EXISTS `entidades`;
CREATE TABLE `entidades` (
  `id_entidade` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(20) NOT NULL default '',
  `morada` varchar(255) default NULL,
  `telefone` int(10) unsigned default NULL,
  `email` varchar(45) default NULL,
  `imagem` varchar(180) default NULL,
  `imprimir_nome` tinyint(1) NOT NULL default '0',
  `imprimir_morada` tinyint(1) NOT NULL default '0',
  `imprimir_telefone` tinyint(1) NOT NULL default '0',
  `imprimir_email` tinyint(1) NOT NULL default '0',
  `previsao_atendimento` tinyint(1) NOT NULL default '0',
  `zona` varchar(255) default NULL,
  PRIMARY KEY  (`id_entidade`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `entidades`
--


/*!40000 ALTER TABLE `entidades` DISABLE KEYS */;
LOCK TABLES `entidades` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `entidades` ENABLE KEYS */;

--
-- Table structure for table `estados_balcao`
--

DROP TABLE IF EXISTS `estados_balcao`;
CREATE TABLE `estados_balcao` (
  `id_estados_balcao` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estados_balcao`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Estados associados a um balcao';

--
-- Dumping data for table `estados_balcao`
--


/*!40000 ALTER TABLE `estados_balcao` DISABLE KEYS */;
LOCK TABLES `estados_balcao` WRITE;
INSERT INTO `estados_balcao` VALUES (1,'Em Funcionamento'),(2,'Funcionamento Suspenso'),(3,'Obsoleto/Inexistente');
UNLOCK TABLES;
/*!40000 ALTER TABLE `estados_balcao` ENABLE KEYS */;

--
-- Table structure for table `estados_dispensador`
--

DROP TABLE IF EXISTS `estados_dispensador`;
CREATE TABLE `estados_dispensador` (
  `id_estado_dispensador` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estado_dispensador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Estados associados a um balcao';

--
-- Dumping data for table `estados_dispensador`
--


/*!40000 ALTER TABLE `estados_dispensador` DISABLE KEYS */;
LOCK TABLES `estados_dispensador` WRITE;
INSERT INTO `estados_dispensador` VALUES (1,'Operacional'),(2,'Inoperacional'),(3,'Sem Papel');
UNLOCK TABLES;
/*!40000 ALTER TABLE `estados_dispensador` ENABLE KEYS */;

--
-- Table structure for table `estados_ecra`
--

DROP TABLE IF EXISTS `estados_ecra`;
CREATE TABLE `estados_ecra` (
  `id_estados_ecra` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estados_ecra`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Estados associados a um ecra';

--
-- Dumping data for table `estados_ecra`
--


/*!40000 ALTER TABLE `estados_ecra` DISABLE KEYS */;
LOCK TABLES `estados_ecra` WRITE;
INSERT INTO `estados_ecra` VALUES (1,'Activo'),(2,'Avariado'),(3,'Inactivo');
UNLOCK TABLES;
/*!40000 ALTER TABLE `estados_ecra` ENABLE KEYS */;

--
-- Table structure for table `estados_impressora`
--

DROP TABLE IF EXISTS `estados_impressora`;
CREATE TABLE `estados_impressora` (
  `id_estado_impressora` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_estado_impressora`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `estados_impressora`
--


/*!40000 ALTER TABLE `estados_impressora` DISABLE KEYS */;
LOCK TABLES `estados_impressora` WRITE;
INSERT INTO `estados_impressora` VALUES (1,'Operacional'),(2,'Inoperacional'),(3,'Sem Papel');
UNLOCK TABLES;
/*!40000 ALTER TABLE `estados_impressora` ENABLE KEYS */;

--
-- Table structure for table `horario_loja`
--

DROP TABLE IF EXISTS `horario_loja`;
CREATE TABLE `horario_loja` (
  `id_horario_loja` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(60) NOT NULL default '',
  `abertura_0` time default NULL,
  `fecho_0` time default NULL,
  `abertura_1` time default NULL,
  `fecho_1` time default NULL,
  `abertura_2` time default NULL,
  `fecho_2` time default NULL,
  `abertura_3` time default NULL,
  `fecho_3` time default NULL,
  `abertura_4` time default NULL,
  `fecho_4` time default NULL,
  `abertura_5` time default NULL,
  `fecho_5` time default NULL,
  `abertura_6` time default NULL,
  `fecho_6` time default NULL,
  PRIMARY KEY  (`id_horario_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `horario_loja`
--


/*!40000 ALTER TABLE `horario_loja` DISABLE KEYS */;
LOCK TABLES `horario_loja` WRITE;
INSERT INTO `horario_loja` VALUES (1,'Horario Loja','00:05:00','23:59:00','00:05:00','23:59:00','00:05:00','23:59:00','00:05:00','23:59:00','00:05:00','23:59:00','00:05:00','23:59:00','00:05:00','23:59:00'),(2,'TEstes_horÃ¡rio',NULL,NULL,NULL,NULL,'13:00:00','23:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Horario Servico','08:00:00','18:00:00','08:00:00','18:00:00','08:00:00','18:00:00','08:00:00','18:00:00','08:00:00','18:00:00','08:00:00','18:00:00','08:00:00','18:00:00'),(4,'JPT',NULL,NULL,NULL,NULL,'00:00:00','23:00:00',NULL,NULL,'09:00:00','20:00:00',NULL,NULL,NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `horario_loja` ENABLE KEYS */;

--
-- Table structure for table `impressora_dispensador`
--

DROP TABLE IF EXISTS `impressora_dispensador`;
CREATE TABLE `impressora_dispensador` (
  `id_impressora` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_impressora`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `impressora_dispensador`
--


/*!40000 ALTER TABLE `impressora_dispensador` DISABLE KEYS */;
LOCK TABLES `impressora_dispensador` WRITE;
INSERT INTO `impressora_dispensador` VALUES (4,'abcv','abc','abc'),(5,'TUP900','STAR','STAR');
UNLOCK TABLES;
/*!40000 ALTER TABLE `impressora_dispensador` ENABLE KEYS */;

--
-- Table structure for table `local_colaborador`
--

DROP TABLE IF EXISTS `local_colaborador`;
CREATE TABLE `local_colaborador` (
  `id_local` int(10) unsigned NOT NULL,
  `id_colaborador` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_local`,`id_colaborador`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `local_colaborador`
--



--
-- Table structure for table `log_accoes`
--

DROP TABLE IF EXISTS `log_accoes`;
CREATE TABLE `log_accoes` (
  `id_log_accoes` int(10) unsigned NOT NULL auto_increment,
  `id_utilizador` int(10) unsigned default NULL,
  `id_loja` int(10) unsigned default NULL,
  `objecto` varchar(45) collate latin1_general_ci NOT NULL,
  `nome_objecto` varchar(45) collate latin1_general_ci NOT NULL,
  `accao` varchar(45) collate latin1_general_ci NOT NULL,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_log_accoes`),
  KEY `id_loja8` (`id_loja`),
  KEY `id_utilizador` (`id_utilizador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='InnoDB free: 3072 kB; (`id_loja`) REFER `q_local/lojas`(`id';

--
-- Dumping data for table `log_accoes`
--


/*!40000 ALTER TABLE `log_accoes` DISABLE KEYS */;
LOCK TABLES `log_accoes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `log_accoes` ENABLE KEYS */;

--
-- Table structure for table `log_acessos`
--

DROP TABLE IF EXISTS `log_acessos`;
CREATE TABLE `log_acessos` (
  `id_acessos` int(11) NOT NULL auto_increment,
  `utilizador` varchar(100) character set latin1 collate latin1_general_ci NOT NULL default '',
  `tipo` varchar(100) character set latin1 collate latin1_general_ci NOT NULL default '',
  `acesso` varchar(20) character set latin1 collate latin1_general_ci NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `endereco` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`id_acessos`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `log_acessos`
--


/*!40000 ALTER TABLE `log_acessos` DISABLE KEYS */;
LOCK TABLES `log_acessos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `log_acessos` ENABLE KEYS */;

--
-- Table structure for table `log_acessos_empregados`
--

DROP TABLE IF EXISTS `log_acessos_empregados`;
CREATE TABLE `log_acessos_empregados` (
  `id_acessos` int(11) NOT NULL auto_increment,
  `id_empregado` int(10) unsigned default NULL,
  `acesso` varchar(20) character set latin1 collate latin1_general_ci NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_balcao` int(10) unsigned default NULL,
  `id_loja` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_acessos`,`id_loja`),
  KEY `id_loja6` (`id_loja`),
  KEY `FK_log_acessos_empregados_2` (`id_empregado`),
  KEY `FK_log_acessos_empregados_3` (`id_balcao`,`id_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 3072 kB; (`id_empregado`) REFER `q_local/empre';

--
-- Dumping data for table `log_acessos_empregados`
--


/*!40000 ALTER TABLE `log_acessos_empregados` DISABLE KEYS */;
LOCK TABLES `log_acessos_empregados` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `log_acessos_empregados` ENABLE KEYS */;

--
-- Table structure for table `log_acessos_utilizadores`
--

DROP TABLE IF EXISTS `log_acessos_utilizadores`;
CREATE TABLE `log_acessos_utilizadores` (
  `id_acessos` int(11) NOT NULL auto_increment,
  `id_utilizador` int(10) unsigned default NULL,
  `acesso` varchar(20) collate latin1_general_ci NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id_acessos`),
  KEY `FK_log_acessos_utilizadores_1` (`id_utilizador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `log_acessos_utilizadores`
--



--
-- Table structure for table `log_actividade_servicos`
--

DROP TABLE IF EXISTS `log_actividade_servicos`;
CREATE TABLE `log_actividade_servicos` (
  `id_log_actividade_servicos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_servico` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(45) NOT NULL default '',
  `id_loja` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_log_actividade_servicos`),
  KEY `FK_log_actividade_servicos_1` (`id_loja`),
  KEY `FK_log_actividade_servicos_2` (`id_servico`),
  KEY `FK_log_actividade_servicos_3` (`id_empregado`),
  KEY `FK_log_actividade_servicos_4` (`id_balcao`,`id_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `log_actividade_servicos`
--


/*!40000 ALTER TABLE `log_actividade_servicos` DISABLE KEYS */;
LOCK TABLES `log_actividade_servicos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `log_actividade_servicos` ENABLE KEYS */;

--
-- Table structure for table `log_atendimentos`
--

DROP TABLE IF EXISTS `log_atendimentos`;
CREATE TABLE `log_atendimentos` (
  `id_log_atendimentos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_servico` int(10) unsigned default NULL,
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(20) NOT NULL default '',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_dispensador` int(10) unsigned default NULL,
  `nome_cliente` varchar(60) default NULL,
  `servico_emissao` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_log_atendimentos`,`id_loja`),
  KEY `id_servico` (`id_servico`),
  KEY `id_loja5` (`id_loja`),
  KEY `FK_log_atendimentos_4` (`id_empregado`),
  KEY `FK_log_atendimentos_5` (`id_balcao`,`id_loja`),
  KEY `FK_log_atendimentos_6` (`id_dispensador`,`id_loja`),
  KEY `FK_log_atendimentos_7` (`servico_emissao`),
  KEY `idx_servico_loja` (`id_servico`,`id_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='InnoDB free: 10240 kB; (`id_loja`) REFER `q_local/lojas`(`i';

--
-- Dumping data for table `log_atendimentos`
--


--
-- Table structure for table `log_atendimentos_hist`
--

DROP TABLE IF EXISTS `log_atendimentos_hist`;
CREATE TABLE `log_atendimentos_hist` (
  `id_log_atendimentos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_servico` int(10) unsigned default NULL,
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(20) collate utf8_unicode_ci NOT NULL default '',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_dispensador` int(10) unsigned default NULL,
  `nome_cliente` varchar(60) collate utf8_unicode_ci default NULL,
  `servico_emissao` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_log_atendimentos`,`id_loja`),
  KEY `id_servico` (`id_servico`),
  KEY `id_loja5` (`id_loja`),
  KEY `FK_log_atendimentos_hist_4` (`id_empregado`),
  KEY `FK_log_atendimentos_hist_5` (`id_balcao`,`id_loja`),
  KEY `FK_log_atendimentos_hist_6` (`id_dispensador`,`id_loja`),
  KEY `FK_log_atendimentos_hist_7` (`servico_emissao`),
  KEY `idx_servico_hst_loja` (`id_servico`,`id_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `log_atendimentos_hist`
--



--
-- Table structure for table `lojas`
--

DROP TABLE IF EXISTS `lojas`;
CREATE TABLE `lojas` (
  `id_loja` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(20) NOT NULL default '',
  `morada` varchar(255) default NULL,
  `horario` int(10) unsigned NOT NULL default '0',
  `previsao_atendimento` tinyint(1) NOT NULL default '0',
  `telefone` int(10) unsigned default NULL,
  `email` varchar(45) default NULL,
  `imprimir_nome` tinyint(1) NOT NULL default '0',
  `imprimir_morada` tinyint(1) NOT NULL default '0',
  `imprimir_telefone` tinyint(1) NOT NULL default '0',
  `imprimir_email` tinyint(1) NOT NULL default '0',
  `endereco` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_loja`),
  KEY `FK_lojas_1` (`horario`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lojas`
--


--
-- Table structure for table `lojas_entidades`
--

DROP TABLE IF EXISTS `lojas_entidades`;
CREATE TABLE `lojas_entidades` (
  `id_lojas_entidades` int(10) unsigned NOT NULL auto_increment,
  `id_loja` int(10) unsigned NOT NULL default '0',
  `id_entidade` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_lojas_entidades`),
  KEY `Index_11` (`id_entidade`,`id_lojas_entidades`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lojas_entidades`
--


--
-- Table structure for table `processador_dispensador`
--

DROP TABLE IF EXISTS `processador_dispensador`;
CREATE TABLE `processador_dispensador` (
  `id_processador` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_processador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `processador_dispensador`
--


/*!40000 ALTER TABLE `processador_dispensador` DISABLE KEYS */;
LOCK TABLES `processador_dispensador` WRITE;
INSERT INTO `processador_dispensador` VALUES (1,'abc','abc','abc'),(2,'VIA 800','VIA','CG'),(3,'VIA 800','VIA','CG');
UNLOCK TABLES;
/*!40000 ALTER TABLE `processador_dispensador` ENABLE KEYS */;

--
-- Table structure for table `promocao`
--

DROP TABLE IF EXISTS `promocao`;
CREATE TABLE `promocao` (
  `id_promocao` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  `texto` varchar(255) NOT NULL default '',
  `imagem` varchar(180) default NULL,
  PRIMARY KEY  (`id_promocao`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `promocao`
--



--
-- Table structure for table `resumodiario`
--

DROP TABLE IF EXISTS `resumodiario`;
CREATE TABLE `resumodiario` (
  `id_resumo` int(10) unsigned NOT NULL auto_increment,
  `data_resumo` date default NULL,
  `id_servico` int(11) default NULL,
  `id_loja` int(11) default NULL,
  `id_balcao` int(11) default NULL,
  `id_empregado` int(11) default NULL,
  `senhas_emitidas` int(11) default NULL,
  `senhas_chamadas` int(11) default NULL,
  `tempo_medio_espera` time default NULL,
  `tempo_medio_atendimento` time default NULL,
  PRIMARY KEY  (`id_resumo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `resumodiario`
--



--
-- Table structure for table `resumodiario_empregado`
--

DROP TABLE IF EXISTS `resumodiario_empregado`;
CREATE TABLE `resumodiario_empregado` (
  `id_resumo_empregado` int(10) unsigned NOT NULL auto_increment,
  `id_servico` int(11) default NULL,
  `id_loja` int(11) default NULL,
  `id_balcao` int(11) default NULL,
  `id_empregado` int(11) default NULL,
  `senhas_chamadas` int(11) default NULL,
  `tempo_medio_atendimento` time default NULL,
  `data_resumo` date default NULL,
  PRIMARY KEY  (`id_resumo_empregado`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `resumodiario_empregado`
--


/*!40000 ALTER TABLE `resumodiario_empregado` DISABLE KEYS */;
LOCK TABLES `resumodiario_empregado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `resumodiario_empregado` ENABLE KEYS */;

--
-- Table structure for table `resumodiario_temp`
--

DROP TABLE IF EXISTS `resumodiario_temp`;
CREATE TABLE `resumodiario_temp` (
  `id_log_atendimentos` int(10) unsigned NOT NULL auto_increment,
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_servico` int(10) unsigned default NULL,
  `numero_senha` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  `tipo` varchar(20) collate utf8_unicode_ci NOT NULL default '',
  `id_empregado` int(10) unsigned default NULL,
  `id_balcao` int(10) unsigned default NULL,
  `id_dispensador` int(10) unsigned default NULL,
  `nome_cliente` varchar(60) collate utf8_unicode_ci default NULL,
  `servico_emissao` int(10) unsigned default NULL,
  PRIMARY KEY  (`id_log_atendimentos`,`id_loja`),
  KEY `id_servico` (`id_servico`),
  KEY `id_loja5` (`id_loja`),
  KEY `FK_log_atendimentos_hist_4` (`id_empregado`),
  KEY `FK_log_atendimentos_hist_5` (`id_balcao`,`id_loja`),
  KEY `FK_log_atendimentos_hist_6` (`id_dispensador`,`id_loja`),
  KEY `FK_log_atendimentos_hist_7` (`servico_emissao`),
  KEY `idx_servico_hst_loja` (`id_servico`,`id_loja`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `resumodiario_temp`
--


/*!40000 ALTER TABLE `resumodiario_temp` DISABLE KEYS */;
LOCK TABLES `resumodiario_temp` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `resumodiario_temp` ENABLE KEYS */;

--
-- Table structure for table `servicos`
--

DROP TABLE IF EXISTS `servicos`;
CREATE TABLE `servicos` (
  `id_servico` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '',
  `identificador` varchar(15) default NULL,
  `limite_clientes` int(10) unsigned default NULL,
  `ordem` int(11) default NULL,
  `nome_ecra_dispensador` varchar(45) NOT NULL default '',
  `horario` int(10) unsigned NOT NULL default '0',
  `id_entidade` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `servicos`
--



--
-- Table structure for table `servicos_balcao`
--

DROP TABLE IF EXISTS `servicos_balcao`;
CREATE TABLE `servicos_balcao` (
  `id_balcao` int(10) unsigned NOT NULL,
  `id_servico` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_balcao`,`id_servico`),
  KEY `id_servico` (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Serviços associados a um balcão';

--
-- Dumping data for table `servicos_balcao`
--



--
-- Table structure for table `servicos_dispensador`
--

DROP TABLE IF EXISTS `servicos_dispensador`;
CREATE TABLE `servicos_dispensador` (
  `id_dispensador` int(10) unsigned NOT NULL,
  `id_servico` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_dispensador`,`id_servico`),
  KEY `id_servico` (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Serviços associados a um dispensador';

--
-- Dumping data for table `servicos_dispensador`
--



--
-- Table structure for table `servicos_ecra`
--

DROP TABLE IF EXISTS `servicos_ecra`;
CREATE TABLE `servicos_ecra` (
  `id_ecra` int(10) unsigned NOT NULL,
  `id_servico` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id_ecra`,`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `servicos_ecra`
--



--
-- Table structure for table `sistema_central`
--

DROP TABLE IF EXISTS `sistema_central`;
CREATE TABLE `sistema_central` (
  `id_sistema_central` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(60) default NULL,
  `endereco` varchar(45) NOT NULL default '',
  `ultima_actualizacao` datetime default NULL,
  PRIMARY KEY  (`id_sistema_central`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sistema_central`
--



--
-- Table structure for table `status_impressora`
--

DROP TABLE IF EXISTS `status_impressora`;
CREATE TABLE `status_impressora` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `text` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `status_impressora`
--


/*!40000 ALTER TABLE `status_impressora` DISABLE KEYS */;
LOCK TABLES `status_impressora` WRITE;
INSERT INTO `status_impressora` VALUES (1,'Normal'),(2,'Desligada/Offline'),(3,'Sem Papel'),(4,'Papel Prox do Fim'),(5,'Erro Desconhecido');
UNLOCK TABLES;
/*!40000 ALTER TABLE `status_impressora` ENABLE KEYS */;

--
-- Table structure for table `status_terminal`
--

DROP TABLE IF EXISTS `status_terminal`;
CREATE TABLE `status_terminal` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `text` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `status_terminal`
--


/*!40000 ALTER TABLE `status_terminal` DISABLE KEYS */;
LOCK TABLES `status_terminal` WRITE;
INSERT INTO `status_terminal` VALUES (1,'Bateria Normal'),(2,'Pouca Bateria');
UNLOCK TABLES;
/*!40000 ALTER TABLE `status_terminal` ENABLE KEYS */;

--
-- Table structure for table `tipo_dispositivo`
--

DROP TABLE IF EXISTS `tipo_dispositivo`;
CREATE TABLE `tipo_dispositivo` (
  `id_tipo_dispositivo` int(10) unsigned NOT NULL auto_increment,
  `modelo` varchar(255) NOT NULL,
  `fabricante` varchar(255) NOT NULL,
  `fornecedor` varchar(255) NOT NULL,
  PRIMARY KEY  (`id_tipo_dispositivo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Informação geral relativa a um dado dispositivo';

--
-- Dumping data for table `tipo_dispositivo`
--


--
-- Table structure for table `tipos_dispensador`
--

DROP TABLE IF EXISTS `tipos_dispensador`;
CREATE TABLE `tipos_dispensador` (
  `id_tipos_dispensador` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(45) NOT NULL default '' COMMENT 'Nome do Tipo,30,52,1,nenhuma,1,0',
  `nome_tabela` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id_tipos_dispensador`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tipos_dispensador`
--


/*!40000 ALTER TABLE `tipos_dispensador` DISABLE KEYS */;
LOCK TABLES `tipos_dispensador` WRITE;
INSERT INTO `tipos_dispensador` VALUES (1,'Base','dispensador_base'),(2,'Bico De Pato','dispensador_manual');
UNLOCK TABLES;
/*!40000 ALTER TABLE `tipos_dispensador` ENABLE KEYS */;

--
-- Table structure for table `tipos_utilizadores`
--

DROP TABLE IF EXISTS `tipos_utilizadores`;
CREATE TABLE `tipos_utilizadores` (
  `id_tipos_utilizadores` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(100) collate latin1_general_ci NOT NULL default '',
  `perm_utilizadores` tinyint(4) NOT NULL default '0',
  `perm_tipos_utilizadores` tinyint(4) NOT NULL default '0',
  `perm_log_acessos_empregados` tinyint(4) NOT NULL default '0',
  `perm_log_acessos_utilizadores` tinyint(3) unsigned NOT NULL default '0',
  `perm_empregados` tinyint(3) unsigned NOT NULL default '0',
  `perm_log_accoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_config_teclado` tinyint(3) unsigned NOT NULL default '0',
  `perm_tipos_terminal` tinyint(3) unsigned NOT NULL default '0',
  `perm_tipos_impressora` tinyint(3) unsigned NOT NULL default '0',
  `perm_tipos_dispensador` tinyint(3) unsigned NOT NULL default '0',
  `perm_terminal` tinyint(3) unsigned NOT NULL default '0',
  `perm_impressora` tinyint(3) unsigned NOT NULL default '0',
  `perm_dispensador` tinyint(3) unsigned NOT NULL default '0',
  `perm_lojas` tinyint(3) unsigned NOT NULL default '0',
  `perm_servicos` tinyint(3) unsigned NOT NULL default '0',
  `perm_balcoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_promocoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_estatisticas` tinyint(3) unsigned NOT NULL default '0',
  `perm_previsoes` tinyint(3) unsigned NOT NULL default '0',
  `perm_ecra` tinyint(3) unsigned NOT NULL default '0',
  `perm_entidade` tinyint(3) NOT NULL default '0',
  `all_perm` tinyint(3) NOT NULL default '0',
  PRIMARY KEY  (`id_tipos_utilizadores`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `tipos_utilizadores`
--


/*!40000 ALTER TABLE `tipos_utilizadores` DISABLE KEYS */;
LOCK TABLES `tipos_utilizadores` WRITE;
INSERT INTO `tipos_utilizadores` VALUES (1,'Gestor',2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1),(2,'Entidade',2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `tipos_utilizadores` ENABLE KEYS */;

--
-- Table structure for table `utilizadores`
--

DROP TABLE IF EXISTS `utilizadores`;
CREATE TABLE `utilizadores` (
  `id_utilizadores` int(10) unsigned NOT NULL auto_increment,
  `id_tipos_utilizadores` int(10) unsigned NOT NULL default '0',
  `nome` varchar(50) collate latin1_general_ci NOT NULL default '',
  `nome_utilizador` varchar(20) collate latin1_general_ci NOT NULL default '',
  `palavra_chave` varchar(20) collate latin1_general_ci NOT NULL default '',
  `estado` tinyint(4) NOT NULL default '0',
  `num_tentativas` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id_utilizadores`),
  UNIQUE KEY `nome_utilizador` (`nome_utilizador`),
  KEY `id_tipos_utilizadores` (`id_tipos_utilizadores`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `utilizadores`
--


/*!40000 ALTER TABLE `utilizadores` DISABLE KEYS */;
LOCK TABLES `utilizadores` WRITE;
INSERT INTO `utilizadores` VALUES (50,1,'Gestor Mobbit','dolce','vita',1,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `utilizadores` ENABLE KEYS */;

--
-- Table structure for table `utilizadores_entidades`
--

DROP TABLE IF EXISTS `utilizadores_entidades`;
CREATE TABLE `utilizadores_entidades` (
  `id_utilizadores_entidades` int(10) unsigned NOT NULL auto_increment,
  `id_utilizadores` int(10) unsigned NOT NULL default '0',
  `id_entidade` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_utilizadores_entidades`),
  KEY `Index_11` (`id_entidade`,`id_utilizadores_entidades`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `utilizadores_entidades`
--


--
-- Table structure for table `utilizadores_lojas`
--

DROP TABLE IF EXISTS `utilizadores_lojas`;
CREATE TABLE `utilizadores_lojas` (
  `id_utilizadores_lojas` int(10) unsigned NOT NULL auto_increment,
  `id_utilizadores` int(10) unsigned NOT NULL default '0',
  `id_loja` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id_utilizadores_lojas`),
  KEY `Index_11` (`id_loja`,`id_utilizadores_lojas`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `utilizadores_lojas`
--


-- Table structure for table `variaveis`
--

DROP TABLE IF EXISTS `variaveis`;
CREATE TABLE `variaveis` (
  `id_variavel` int(10) unsigned NOT NULL auto_increment,
  `nome` varchar(60) NOT NULL default '',
  `valor` varchar(60) NOT NULL default '',
  PRIMARY KEY  (`id_variavel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `variaveis`
--


/*!40000 ALTER TABLE `variaveis` DISABLE KEYS */;
LOCK TABLES `variaveis` WRITE;
INSERT INTO `variaveis` VALUES (1,'tempo_minimo_atendimento','30'),(2,'tempo_maximo_atendimento','3600'),(3,'uri_actualizacao_ecras','/senhas/qmobbit.php');
UNLOCK TABLES;
/*!40000 ALTER TABLE `variaveis` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

