<?php


class EvaluationController extends ControllerBase {

    // Components can be accessed as $this->Component ("ComponentName" => "$this->ComponentName")
    var $components = array();
    // Helpers are located in 'views/helpers'. They will be loaded and provided to the view. Example: "Xml" => $xml
    var $helpers = array();

    //put your code here



    function EvaluationController() {
        parent::__construct();
    }

    function insert() {

        if (!isset($this->request->params['id_ticket'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Missing parameter', true, 500);
        } else if (!isset($this->request->params['id_client'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Client not specified');
            header('Missing parameter', true, 500);
        } else if (!isset($this->request->params['evaluation'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Evaluation not specified');
            header('Missing parameter', true, 500);
        } else {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Evaluation.php");
           
            $evaluation = new Evaluation(); 
            $id_ticket = $this->request->params['id_ticket'];
            $id_client = $this->request->params['id_client'];
            $eval = $this->request->params['evaluation'];

            $evaluation->insert($id_client, $id_ticket, $eval);

            $this->set('success', "TRUE");
            
        }
    }

    function get() {
        $ids;
        $obj_ids = $this->request->params['id'];
        
        if($obj_ids)
            $ids = construcaoVector($obj_ids, ",");

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Evaluation.php");
        $evaluation = new Evaluation();
        $eval_list = $evaluation->get($ids);
  
        $this->set('success', "TRUE");
        $this->set('evaluations', $eval_list);        
        
    }

    function delete() {
        $ids;
        $obj_ids = $this->request->params['id'];
        
        if($obj_ids)
            $ids = construcaoVector($obj_ids, ",");

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Evaluation.php");
        $evaluation = new Evaluation();
        $eval_list = $evaluation->delete($ids);
  
        $this->set('success', "TRUE");     
        
    }

    function construcaoVector($string, $tok)
    {
        $vector = array();
        $token = strtok($string, $tok);
        while($token != "")
        {
            array_push($vector,$token);
            $token = strtok($tok);
        }
        return $vector;
    }  

}

?>
