<?php  

class SatisfactionController extends ControllerBase {

    // Components can be accessed as $this->Component ("ComponentName" => "$this->ComponentName")
    var $components = array('MoblineServer');
    // Helpers are located in 'views/helpers'. They will be loaded and provided to the view. Example: "Xml" => $xml
    var $helpers = array();

    function SatisfactionController() {
        parent::__construct();
    }

    /**
     * collect satisfaction
     * */
    function setSatisfaction() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Satisfaction.php");

        $satisfaction = new Satisfaction();
        $button_id = $this->request->params['id'];
        $satisfaction_level = $this->request->params['satisfaction'];

        $desk_id = $satisfaction->getServiceDesk($button_id);
        $ticket = $satisfaction->getTicket($desk_id);

        if ($desk_id == 0 || $ticket == 0) {
            $this->set('success', 'FALSE');
            header('NOT FOUND', true, 404);
        } else {

            if ($satisfaction->setSatisfaction($ticket, $satisfaction_level)) {
                $this->set('success', "TRUE");
            } else {
                $this->set('success', "FALSE");
                header('INTERNAL ERROR', true, 500);
            }
        }
    }

    /**
     * collect satisfaction
     * */
    function getSatisfaction() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Satisfaction.php");


        $store_id = $this->request->params['store_id'];

        if (!isset($this->request->params['store_id']) || $store_id == 0 || $store_id == '') {
            $this->set('success', 'FALSE');
            header('NOT FOUND', true, 404);
        } else {
            $satisfaction = new Satisfaction();
            $positive_eval = $satisfaction->getStorePositiveCounts($store_id);
            $negative_eval = $satisfaction->getStoreNegativeCounts($store_id);
            $total_counts = $positive_eval + $negative_eval;
            $appreciation_level = ($positive_eval / $total_counts) * 100;
            $this->set('success', "TRUE");
            $this->set('store_id', $store_id);
            $this->set('total_counts', $total_counts);
            $this->set('positive_counts', $positive_eval);
            $this->set('negative_counts', $negative_eval);
            $this->set('appreciation', $appreciation_level);
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=stores.getStores', 'method' => 'getStores');
            $this->set('urls', $urls);
        }
    }

}

?>
