<?php  

class ScreenController extends ControllerBase {

	// Components can be accessed as $this->Component ("ComponentName" => "$this->ComponentName")
	var $components = array('MoblineServer');
	// Helpers are located in 'views/helpers'. They will be loaded and provided to the view. Example: "Xml" => $xml
	var $helpers = array('Xml');

	function ScreenController() {
		parent::__construct();
	}

	function message() {
		
		// Transform the received XML body into an Array
		$parsed_xml = new Xml($this->request->body);
		
		//Array
		//(
		//    [message] => Array
		//        (
		//            [type] => Array
		//                (
		//                    [value] => ticket_call
		//                    [version] => 1.0
		//                )
		//
		//            [id] => 1540
		//            [service_id] => 5
		//            [service_code] => svc_1
		//            [local_id] => 2
		//            [local_code] => local_1
		//            [service_identifier] => A
		//            [ticket_number] => 00054
		//            [destination_label] => Gabinete
		//            [destination_identifier] => 03
		//            [screen_codes] => enfermaria1|enfermaria2|recepcao
		//            [extra] => Array
		//                (
		//                    [customer] => João Silva
		//                    [physician] => Dr. José Santos
		//                )
		//        )
		//)

		$result = $this->MoblineServer->sendCommandB64('MSGECRA', $this->request->body, true);
		$result_str = trim($result);
		$success = false;
		$message = '';
		if ($result === false) {
			$message = 'Error communicating with the Mobline Server';
		} else if (!empty($result_str)) {
			$parts = explode("|", $result_str, 2);
			if (isset($parts[0]) && $parts[0] == '1') {
				$success = true;
			} 
			if (isset($parts[1])) {
				$message = $parts[1];
			}
		}
		
		$this->set('success', $success ? 'true' : 'false');
		$this->set('message', $message);
	}

}

?>