<?php  

class ServiceController extends ControllerBase {

    // Components can be accessed as $this->Component ("ComponentName" => "$this->ComponentName")
    var $components = array('MoblineServer');
    // Helpers are located in 'views/helpers'. They will be loaded and provided to the view. Example: "Xml" => $xml
    var $helpers = array();

    function ServiceController() {
        parent::__construct();
    }

    /**
     * list all services
     * */
    function listServices() {
        $service_type = "normal"; // optional; values: normal, schedule, all
        if (isset($this->request->params['type']) && $this->request->params['type'] != '') {
            $service_type = $this->request->params['type'];
        }
        // convert to DB values
        switch ($service_type) {
            case 'schedule':
                $service_type = "agendamentos";
                break;
        }

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Services.php");
        $servicesObjModel = new Services($this->request);
        $servicesResultSet = $servicesObjModel->getAllServices($service_type);

        $services = array("service" => array());
        foreach ($servicesResultSet AS $serv) {
            $services['service'][] = $this->getServiceFromResultSet($serv, $servicesObjModel);
        }
        $data = array('services' => $services);

        $this->set('data', $data);
    }

    /**
     * gets a service
     * @param id
     * */
    function get() {
        $service_id = $this->request->params['id'];

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Services.php");
        $servicesObjModel = new Services($this->request);
        $servicesResultSet = $servicesObjModel->getServices(array($service_id));

        if (count($servicesResultSet) == 0) {
            $this->set('success', "FALSE");
            $this->set('message', "There is no service identified by '$service_id'!");
            return;
        }

        $services = array("service" => array());
        foreach ($servicesResultSet AS $serv) {
            $services['service'][] = $this->getServiceFromResultSet($serv, $servicesObjModel);
        }
        $data = array('services' => $services);

        $this->set('data', $data);
    }

    private function getServiceFromResultSet($serviceResultSet, $servicesObjModel) {

        $service = array(
            "id" => $serviceResultSet['id_servico'],
            "name" => $serviceResultSet['nome'],
            "type" => "normal",
            "identifier" => $serviceResultSet['identificador'],
            "queue_size" => "",
            "average_waiting_time" => "",
            "next_available_seat" => "",
            "locations" => array(
                "location" => array(),
            ),
        );

        // fix service type
        switch ($serviceResultSet['tipo_servico']) {
            case 'normal':
                $service['type'] = "normal";
                break;
            case 'agendamentos':
                $service['type'] = "schedule";
                break;
        }

        // get locations
        $locations = $servicesObjModel->getServiceLocations($serviceResultSet['id_servico'], $serviceResultSet['id_entidade']);
        if (count($locations) > 0) {
            foreach ($locations AS $location) {
                $service['locations']['location'][] = array(
                    "id" => $location['id_loja'],
                    "name" => $location['nome'],
                );
            }

            // get queue size 
            $service['queue_size'] = $servicesObjModel->getQueueSize($serviceResultSet['id_servico'], $locations[0]['id_loja']); // default for the first location
            // get info about average_waiting_time 
            if (isset($serviceResultSet['previsao_atendimento']) && $serviceResultSet['previsao_atendimento'] != '') {
                $service['average_waiting_time'] = $serviceResultSet['previsao_atendimento'];
            } else {
                $service['average_waiting_time'] = $servicesObjModel->getAverageWaitingTime($serviceResultSet['id_servico'], $locations[0]['id_loja']);
            }

            // calculate what should be the next available seat
            $timeParts = explode(":", $service['average_waiting_time']);
            $waiting_time_seconds = ($timeParts[0] * 60 * 60) + ($timeParts[1] * 60) + $timeParts[2];
            $next_available_seat_seconds = $service['queue_size'] * $waiting_time_seconds;
            $service['next_available_seat'] = date("Y-m-d H:i:s", time() + $next_available_seat_seconds);
        }

        return $service;
    }

    function getLastCalledTicket() {

        if (!isset($this->request->params['id_service'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        } else {
            $service_id = $this->request->params['id_service'];

            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");

            $ticket = new Tickets();
            $last_ticket = $ticket->getLastCalledTicket($_SESSION['sessao_loja'], $service_id);

            $this->set('success', "TRUE");
            $this->set('ticket_result', $last_ticket);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function getQueueLine() {

        if (!isset($this->request->params['id_service'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        } else {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            $service_id = $this->request->params['id_service'];
            $ticket = new Tickets();
            $queue_list = $ticket->GetListaDeEspera($_SESSION["sessao_loja"], $service_id);
            $this->set('success', "TRUE");
            $this->set('tickets', $queue_list);
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
            $this->set('urls', $urls);
        }
    }

    function issueTicketNow() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Tickets.php");
        require_once("services/contactline/Services.php");
        if (isset($this->request->params['id_service'])) {
            $target_service_id = $this->request->params['id_service'];
            $service = new Services();
            if (!$service->isAllowedInServiceDesk($target_service_id, $_SESSION['sessao_balcao'])) {
                $this->set('success', "FALSE");
                $this->set('message', 'Selected service not available in this desk');
                header('Invalid service', true, 500);
            } else {
                $issuer_service_id = '';
                if (!isset($this->request->params['id_issuer_service'])) {
                    $issuer_service_id = $target_service_id;
                } else {
                    $issuer_service_id = $this->request->params['id_issuer_service'];
                }
                $ticket = new Tickets();
                $issued_ticket = $ticket->issueTicketNow($_SESSION['sessao_loja'], $issuer_service_id, $target_service_id);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $issued_ticket);
            }
            
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function issueTicketNowTest() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Tickets.php");
        require_once("services/contactline/Services.php");
        if (isset($this->request->params['id_service'])) {
            $target_service_id = $this->request->params['id_service'];
            $service = new Services();
            if (!$service->isAllowedInServiceDesk($target_service_id, $_SESSION['sessao_balcao'])) {
                $this->set('success', "FALSE");
                $this->set('message', 'Selected service not available in this desk');
                header('Invalid service', true, 500);
            } else {
                $issuer_service_id = '';
                if (!isset($this->request->params['id_issuer_service'])) {
                    $issuer_service_id = $target_service_id;
                } else {
                    $issuer_service_id = $this->request->params['id_issuer_service'];
                }
                $ticket = new Tickets();
                $issued_ticket = $ticket->issueTicketNowTest($_SESSION['sessao_loja'], $issuer_service_id, $target_service_id);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $issued_ticket);
            }
            
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function callTicketNow() {

        if (isset($this->request->params['id_service'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Services.php");
            require_once("services/contactline/Counters.php");

            $target_service_id = $this->request->params['id_service'];
            $service = new Services();
            
            if (!$service->isAllowedInServiceDesk($target_service_id, $_SESSION['sessao_balcao'])) {
                $this->set('success', "FALSE");
                $this->set('message', 'Selected service not available in this desk');
                header('Service not available', true, 500);
            } else {
                $ticket = new Tickets();
                $id_ticket = '';
                if (isset($this->request->params['id_ticket'])) {
                    $id_ticket = $this->request->params['id_ticket'];
                } else {
                    $id_ticket = $ticket->getNextTicketId($_SESSION[sessao_loja], $target_service_id);
                    if (count($id_ticket) != 1) {
                        $issued_ticket = $ticket->issueTicketNow($_SESSION['sessao_loja'], $target_service_id, $target_service_id);
                        $id_ticket = $issued_ticket['id_senha'];
                    }
                }

                if ($ticket->callTicketNow($id_ticket, $_SESSION['sessao_balcao'], $_SESSION['sessao_empregado'])) {
                    $service_desk = new Counters();
                    $service_desk->SetEstado($_SESSION['sessao_balcao'], 1);

                    $this->set('success', "TRUE");
                    $processed_ticket = $ticket->getTicket($id_ticket);
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $this->set('ticket_result', $processed_ticket);

                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call ticket failed");
                    header('Operation failed', true, 500);
                }

            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function recallTicket() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");

            $id_ticket = $this->request->params['id_ticket'];
            $ticket = new Tickets();
            $processed_ticket = $ticket->recallTicket($id_ticket);
            if ($processed_ticket != FALSE) {
                $this->set('success', "TRUE");
                $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation recall ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function suspendTicket() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $id_ticket = $this->request->params['id_ticket'];
            $ticket = new Tickets();
            $processed_ticket = $ticket->suspendTicket($id_ticket);
            if ($processed_ticket != FALSE) {
                $service_desk = new Counters();
                $service_desk->SetEstado($_SESSION['sessao_balcao'], 2);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation suspend ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function callSuspendedTicket() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $ticket = new Tickets();
            $suspended_ticket = $ticket->getTicket($this->request->params['id_ticket']);
            if ($suspended_ticket['status'] != 'Suspensa') {
                $this->set('success', "FALSE");
                $this->set('message', "Ticket not valid");
            } else {

                if ($processed_ticket = $ticket->callTicketNow($suspended_ticket['id_senha'], $_SESSION['sessao_balcao'], $_SESSION['sessao_empregado'])) {
                    $service_desk = new Counters();
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $processed_ticket = $ticket->getTicket($suspended_ticket['id_senha']);
                    $service_desk->SetEstado($_SESSION['sessao_balcao'], 1);
                    $this->set('success', "TRUE");
                    $this->set('ticket_result', $processed_ticket);
                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call suspended ticket failed");
                    header('Operation failed', true, 500);
                }
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function redirectTicket() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Tickets.php");
        require_once("services/contactline/Services.php");
        require_once("services/contactline/Counters.php");

        if (!isset($this->request->params['id_service'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        } else if (!isset($this->request->params['id_target_service'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Redirection Service id not specified');
            header('Misisng parameter', true, 500);
        } else if (!isset($this->request->params['id_ticket'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        } else {
            $source_service_id = $this->request->params['id_service'];
            $target_service_id = $this->request->params['id_target_service'];
            $id_ticket = $this->request->params['id_ticket'];

            $service = new Services();
            $ticket = new Tickets();
            if ($ticket->isRedirectable($id_ticket)){
            if ($service->isAllowedInServiceDesk($target_service_id, $_SESSION['sessao_balcao'])) {
                if ($service->isRedirectionValid($source_service_id, $target_service_id)) {
                    
                    if ($ticket->isForService($id_ticket, $source_service_id)) {

                        $redirection_ticket = $ticket->redirectTicket($id_ticket);
                        
                        if ($redirection_ticket != false) {
                            $newticket = $ticket->issueTicketNow($_SESSION["sessao_loja"], $source_service_id, $target_service_id, $redirection_ticket['observacoes'], $redirection_ticket['nome_cliente'], $redirection_ticket['numero_senha']);
                            $redirected_ticket = $ticket->getTicket($newticket["id_senha"]);
                            $service_desk = new Counters();
                            $service_desk->SetEstado($_SESSION['sessao_balcao'], 4);
                            $this->set('success', "TRUE");
                            $this->set('ticket_result', $redirected_ticket);
                        } else {
                            $this->set('success', "FALSE");
                            $this->set('message', 'Operation redirect failed');
                            header('Operation failed', true, 500);
                        }
                    } else {
                        $this->set('success', "FALSE");
                        $this->set('message', 'Ticket not available for the selected service');
                        header('Ticket not available to service', true, 500);
                    }
                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', 'Invalid redirection');
                    header('Invalid redirection', true, 500);
                }
            } else {
                $this->set('success', "FALSE");
                $this->set('message', 'Service not allowed in this desk');
                header('Service not available for desk', true, 500);
            }
            }else{
                $this->set('success', "FALSE");
                $this->set('message', 'Service not redirectable');
                header('Service not redirectable', true, 500);
            }
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function callFoldedTicket() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $ticket = new Tickets();
            
            if ($ticket->callFoldedTicket($this->request->params['id_ticket'])) {

                if ($ticket->callTicketNow($this->request->params['id_ticket'], $_SESSION['sessao_balcao'], $_SESSION['sessao_empregado'])) {
                    $processed_ticket=$ticket->getTicket($this->request->params['id_ticket']);
                    $service_desk = new Counters();
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $service_desk->SetEstado($_SESSION['sessao_balcao'], 1);
                    $this->set('success', "TRUE");
                    $this->set('ticket_result', $processed_ticket);
                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call folded ticket failed");
                    header('Operation failed', true, 500);
                }
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Ticket not valid");
                header('Invalid ticket', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function foldTicket() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $id_ticket = $this->request->params['id_ticket'];
            $ticket = new Tickets();
            $processed_ticket = $ticket->foldTicket($id_ticket);
            if ($processed_ticket != FALSE) {
                $service_desk = new Counters();
                $service_desk->SetEstado($_SESSION['sessao_balcao'], 4);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation fold ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function terminateTicket() {

        if (isset($this->request->params['id_ticket'])) {

            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $id_ticket = $this->request->params['id_ticket'];
            $ticket = new Tickets();
            $processed_ticket = $ticket->terminateTicket($id_ticket);
            if ($processed_ticket != FALSE) {
                $service_desk = new Counters();
                $service_desk->SetEstado($_SESSION['sessao_balcao'], 4);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation terminate ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    
    function getSuspendedTickets() {

        if (isset($this->request->params['id_service'])) {

            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");

            $target_service_id = $this->request->params['id_service'];
            $ticket = new Tickets();

            $suspended_tickets = $ticket->listSuspendedTickets($target_service_id);
            $this->set('success', "TRUE");
            $this->set('tickets', $suspended_tickets);
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function getFoldedTickets() {

        if (isset($this->request->params['id_service'])) {

            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");

            $target_service_id = $this->request->params['id_service'];
            $ticket = new Tickets();
            $folded_tickets = $ticket->listFoldedTickets($target_service_id);
            $this->set('success', 'TRUE');
            $this->set('tickets', $folded_tickets);
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $this->set('urls', $urls);
    }

    function getRedirectionList() {


        if (isset($this->request->params['id_service'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Services.php");

            $target_service_id = $this->request->params['id_service'];
            $service = new Services();
            $sevices_list = $service->GetRedirectionServiceList($target_service_id);
            $this->set('success', 'TRUE');
            $this->set('services', $sevices_list);
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.redirectTicket', 'method' => 'redirectTicket');
        $this->set('urls', $urls);
    }

    function callTicketNowForTerminal() {

        if (isset($this->request->params['id_service'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Services.php");
            require_once("services/contactline/Counters.php");

            $target_service_id = $this->request->params['id_service'];
            $sessao_balcao = $this->request->params['sessao_balcao'];//$_SESSION['sessao_balcao']
            $sessao_loja = $this->request->params['sessao_loja'];//$_SESSION['sessao_loja']
            $sessao_empregado = $this->request->params['sessao_empregado'];//$_SESSION['sessao_empregado']
            

            $service = new Services();
            
            if (!$service->isAllowedInServiceDesk($target_service_id, $sessao_balcao)) {
                $this->set('success', "FALSE");
                $this->set('message', 'Selected service not available in this desk');
                header('Service not available', true, 500);
            } else {
                $ticket = new Tickets();
                $id_ticket = '';
                if (isset($this->request->params['id_ticket'])) {
                    $id_ticket = $this->request->params['id_ticket'];
                } else {
                    $id_ticket = $ticket->getNextTicketId($sessao_loja, $target_service_id);
                    if (count($id_ticket) != 1) {                        
                            $issued_ticket = $ticket->issueTicketNow($sessao_loja, $target_service_id, $target_service_id);
                            $id_ticket = $issued_ticket['id_senha'];
                        
                    }
                }
                $_ticket = $ticket->getTicket($id_ticket);
                if($_ticket['status'] == 'Emissao') {

                    if ($ticket->callTicketNow($id_ticket, $sessao_balcao, $sessao_empregado)) {
                        $service_desk = new Counters();
                        $service_desk->SetEstadoForTerminal($sessao_balcao, 1, $sessao_empregado, $sessao_loja);

                        $this->set('success', "TRUE");
                        $processed_ticket = $ticket->getTicket($id_ticket);
                        $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                        $this->set('ticket_result', $processed_ticket);

                    } else {
                        $this->set('success', "FALSE");
                        $this->set('message', "Operation call ticket failed");
                        header('Operation failed', true, 500);
                    }
                } else 
                {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call ticket failed");
                    header('Operation failed', true, 500);
                }

            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

   
    function autoCallTicketForTerminal() {
        function getPri($item)
        {
            return $item["servico_prioritario"] == '1';
        }


        if (isset($this->request->params['sessao_balcao'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Services.php");
            require_once("services/contactline/Counters.php");
            
            $sessao_balcao = $this->request->params['sessao_balcao'];//$_SESSION['sessao_balcao']
            $sessao_loja = $this->request->params['sessao_loja'];//$_SESSION['sessao_loja']
            $sessao_empregado = $this->request->params['sessao_empregado'];//$_SESSION['sessao_empregado']
            

            $service = new Services();
            $ticket = new Tickets();
            $servicos = $service->getAvailableServicesInServiceDesk($sessao_balcao);

            $servicos_prioritarios = array_filter($servicos, "getPri");

            $outros_servicos = array_diff_assoc($servicos, $servicos_prioritarios);

            $id_servicos_prioritarios = array();
            $id_outros_servicos = array();
            foreach ($servicos_prioritarios as $arr)
            {
                array_push($id_servicos_prioritarios, $arr["id"]);
            }
            foreach ($outros_servicos as $arr)
            {
                array_push($id_outros_servicos, $arr["id"]);
            }

            $pTickets = count($id_servicos_prioritarios)?$ticket->GetListaDeEspera($loja, $id_servicos_prioritarios, true):array();
            $nTickets = count($id_outros_servicos)?$ticket->GetListaDeEspera($sessao_loja, $id_outros_servicos, true):array();            

            $aLista = array_merge($pTickets, $nTickets);

            $i = 0;
            $ok = false;

            while (!$ok && $i<count($aLista))
            {
                $id_a_chamar = $aLista[$i]["id_senha"];
                
                if ($id_a_chamar)
                {

                    $ok = true;
                }
            }

            if ($ok)
            {
                //echo $id_a_chamar;
                if ($ticket->callTicketNow($id_a_chamar, $sessao_balcao, $sessao_empregado)) {
                    $service_desk = new Counters();
                    $service_desk->SetEstadoForTerminal($sessao_balcao, 1,  $sessao_empregado, $sessao_loja );

                    $this->set('success', "TRUE");
                    $processed_ticket = $ticket->getTicket($id_a_chamar);
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $this->set('ticket_result', $processed_ticket);

                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call ticket failed");
                    header('Operation failed', true, 500);
                }
            }
            else if ($i) echo "0";

            
            /*if (!$service->isAllowedInServiceDesk($target_service_id, $sessao_balcao)) {
                $this->set('success', "FALSE");
                $this->set('message', 'Selected service not available in this desk');
                header('Service not available', true, 500);
            } else {
                $ticket = new Tickets();
                $id_ticket = '';
                if (isset($this->request->params['id_ticket'])) {
                    $id_ticket = $this->request->params['id_ticket'];
                } else {
                    $id_ticket = $ticket->getNextTicketId($sessao_loja, $target_service_id);
                    if (count($id_ticket) != 1) {
                        $issued_ticket = $ticket->issueTicketNow($sessao_loja, $target_service_id, $target_service_id);
                        $id_ticket = $issued_ticket['id_senha'];
                    }
                }

                if ($ticket->callTicketNow($id_ticket, $sessao_balcao, $sessao_empregado)) {
                    $service_desk = new Counters();
                    $service_desk->SetEstado($sessao_balcao, 1);

                    $this->set('success', "TRUE");
                    $processed_ticket = $ticket->getTicket($id_ticket);
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $this->set('ticket_result', $processed_ticket);

                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call ticket failed");
                    header('Operation failed', true, 500);
                }

            }*/
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Desk id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function redirectTicketForTerminal() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Tickets.php");
        require_once("services/contactline/Services.php");
        require_once("services/contactline/Counters.php");

        if (!isset($this->request->params['id_service'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Service id not specified');
            header('Misisng parameter', true, 500);
        } else if (!isset($this->request->params['id_target_service'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Redirection Service id not specified');
            header('Misisng parameter', true, 500);
        } else if (!isset($this->request->params['id_ticket'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        } else if (!isset($this->request->params['sessao_balcao'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Desk id not specified');
            header('Misisng parameter', true, 500);
        } else if (!isset($this->request->params['sessao_loja'])) {
            $this->set('success', "FALSE");
            $this->set('message', 'Store id not specified');
            header('Misisng parameter', true, 500);
        } else {
            $source_service_id = $this->request->params['id_service'];
            $ticket_service_id = $this->request->params['id_ticket_service'];
            $target_service_id = $this->request->params['id_target_service'];
            $sessao_balcao = $this->request->params['sessao_balcao']; //$_SESSION['sessao_balcao']
            $sessao_loja = $this->request->params['sessao_loja']; //$_SESSION['sessao_loja']
            $id_ticket = $this->request->params['id_ticket'];
            $sessao_empregado = $this->request->params['sessao_empregado'];

            $service = new Services();
            $ticket = new Tickets();
            if ($ticket->isRedirectable($id_ticket)){

            if ($service->isAllowedInServiceDesk($target_service_id, $sessao_balcao)) {
                if ($service->isRedirectionValid($source_service_id, $target_service_id)) {
                   
                    if ($ticket->isForService($id_ticket, $source_service_id)) {

                        if (isset($this->request->params['observacoes']) ) {
                            $ticket->addNotesToTicket($id_ticket, $this->request->params['observacoes']);
                        }
                        $redirection_ticket = $ticket->redirectTicket($id_ticket);
                       
                        if ($redirection_ticket != false) {
                            $newticket = $ticket->issueTicketNow($sessao_loja, $ticket_service_id, $target_service_id, $redirection_ticket['observacoes'], $redirection_ticket['nome_cliente'], $redirection_ticket['numero_senha']);

                            $redirected_ticket = $ticket->getTicket($newticket["id_senha"]);
                            $service_desk = new Counters();
                            $service_desk->SetEstadoForTerminal($sessao_balcao, 4, $sessao_empregado, $sessao_loja);
                            $this->set('success', "TRUE");
                            $this->set('ticket_result', $redirected_ticket);
                        } else {
                            $this->set('success', "FALSE");
                            $this->set('message', 'Operation redirect failed');
                            header('Operation failed', true, 500);
                        }  
                    } else {
                        $this->set('success', "FALSE");
                        $this->set('message', 'Ticket not available for the selected service');
                        header('Ticket not available to service', true, 500);
                    }
                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', 'Invalid redirection');
                    header('Invalid redirection', true, 500);
                }
            } else {
                $this->set('success', "FALSE");
                $this->set('message', 'Service not allowed in this desk');
                header('Service not available for desk', true, 500);
            }
            }else{
                $this->set('success', "FALSE");
                $this->set('message', 'Service not redirectable');
                header('Service not redirectable', true, 500);
            }
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function terminateTicketForTerminal() {

        if (isset($this->request->params['id_ticket']) && isset($this->request->params['sessao_balcao'])) {

            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $id_ticket = $this->request->params['id_ticket'];
            $sessao_balcao = $this->request->params['sessao_balcao'];
            $sessao_empregado = $this->request->params['sessao_empregado'];
            $sessao_loja = $this->request->params['sessao_loja']; 

            $ticket = new Tickets();
            if (isset($this->request->params['observacoes']) && $this->request->params['observacoes'] != '') {
                $ticket->addNotesToTicket($id_ticket, $this->request->params['observacoes']);
            }
            $processed_ticket = $ticket->terminateTicket($id_ticket);
            
            if ($processed_ticket != FALSE) {
                $service_desk = new Counters();
                $service_desk->SetEstadoForTerminal($sessao_balcao, 4, $sessao_empregado, $sessao_loja);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation terminate ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function suspendTicketForTerminal() {

        if (isset($this->request->params['id_ticket']) && isset($this->request->params['sessao_balcao'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $id_ticket = $this->request->params['id_ticket'];
            $sessao_balcao = $this->request->params['sessao_balcao'];
            $sessao_empregado = $this->request->params['sessao_empregado'];        
            $sessao_loja = $this->request->params['sessao_loja'];
            $ticket = new Tickets();
            if (isset($this->request->params['observacoes']) && $this->request->params['observacoes'] != '') {
                $ticket->addNotesToTicket($id_ticket, $this->request->params['observacoes']);
            }
            $processed_ticket = $ticket->suspendTicket($id_ticket);
            if ($processed_ticket != FALSE) {
                $service_desk = new Counters();
                $service_desk->SetEstadoForTerminal($sessao_balcao, 2, $sessao_empregado, $sessao_loja);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation suspend ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function foldTicketForTerminal() {

        if (isset($this->request->params['id_ticket']) && isset($this->request->params['sessao_balcao'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $id_ticket = $this->request->params['id_ticket'];
            $sessao_balcao = $this->request->params['sessao_balcao'];
            $sessao_empregado = $this->request->params['sessao_empregado'];        
            $sessao_loja = $this->request->params['sessao_loja'];
            $ticket = new Tickets();
            if (isset($this->request->params['observacoes']) && $this->request->params['observacoes'] != '') {
                $ticket->addNotesToTicket($id_ticket, $this->request->params['observacoes']);
            }
            $processed_ticket = $ticket->foldTicket($id_ticket);
            if ($processed_ticket != FALSE) {
                $service_desk = new Counters();
                $service_desk->SetEstadoForTerminal($sessao_balcao, 4, $sessao_empregado, $sessao_loja);
                $this->set('success', "TRUE");
                $this->set('ticket_result', $processed_ticket);
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Operation fold ticket failed");
                header('Operation failed', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function callSuspendedTicketForTerminal() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $ticket = new Tickets();
            $suspended_ticket = $ticket->getTicket($this->request->params['id_ticket']);
            if ($suspended_ticket['status'] != 'Suspensa') {
                $this->set('success', "FALSE");
                $this->set('message', "Ticket not valid");
            } else {
                
                $sessao_balcao = $this->request->params['sessao_balcao'];
                $sessao_empregado = $this->request->params['sessao_empregado'];
                $sessao_loja = $this->request->params['sessao_loja'];

                if ($processed_ticket = $ticket->callTicketNow($suspended_ticket['id_senha'], $sessao_balcao, $sessao_empregado)) {
                    $service_desk = new Counters();
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $processed_ticket = $ticket->getTicket($suspended_ticket['id_senha']);
                    $service_desk->SetEstadoForTerminal($sessao_balcao, 1, $sessao_empregado, $sessao_loja);
                    $this->set('success', "TRUE");
                    $this->set('ticket_result', $processed_ticket);
                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call suspended ticket failed");
                    header('Operation failed', true, 500);
                }
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

    function callFoldedTicketForTerminal() {

        if (isset($this->request->params['id_ticket'])) {
            require_once("services/MethodBase.class.php");
            require_once("services/contactline/Tickets.php");
            require_once("services/contactline/Counters.php");

            $ticket = new Tickets();
            
            if ($ticket->callFoldedTicket($this->request->params['id_ticket'])) {
                $sessao_balcao = $this->request->params['sessao_balcao'];
                $sessao_empregado = $this->request->params['sessao_empregado'];
                $sessao_loja = $this->request->params['sessao_loja'];

                if ($ticket->callTicketNow($this->request->params['id_ticket'], $sessao_balcao , $sessao_empregado)) {
                    $processed_ticket=$ticket->getTicket($this->request->params['id_ticket']);
                    $service_desk = new Counters();
                    $result = $this->MoblineServer->sendCommand('CHMDSENH', $processed_ticket['id_senha']);
                    $service_desk->SetEstadoForTerminal($sessao_balcao, 1, $sessao_empregado, $sessao_loja);
                    $this->set('success', "TRUE");
                    $this->set('ticket_result', $processed_ticket);
                } else {
                    $this->set('success', "FALSE");
                    $this->set('message', "Operation call folded ticket failed");
                    header('Operation failed', true, 500);
                }
            } else {
                $this->set('success', "FALSE");
                $this->set('message', "Ticket not valid");
                header('Invalid ticket', true, 500);
            }
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Ticket id not specified');
            header('Misisng parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.issueTicketNow', 'method' => 'issueTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.callTicketNow', 'method' => 'callTicketNow');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getSuspendedTickets', 'method' => 'getSuspendedTickets');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getFoldedTickets', 'method' => 'getFoldedTickets');
        $this->set('urls', $urls);
    }

}

?>
