<?php  

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ServiceDeskController
 *
 * @author miguel.sousa
 */
class ServiceDeskController extends ControllerBase {

    // Components can be accessed as $this->Component ("ComponentName" => "$this->ComponentName")
    var $components = array();
    // Helpers are located in 'views/helpers'. They will be loaded and provided to the view. Example: "Xml" => $xml
    var $helpers = array();

    function ServiceDeskController() {
        parent::__construct();
    }

    function getAvailableServices() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Services.php");
        require_once("services/contactline/Horario.php");

        $services = new Services();
        $available_services = $services->getAvailableServicesInServiceDesk($_SESSION["sessao_balcao"]);
        $this->set('success', 'TRUE');
        $this->set('services', $available_services);

        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $this->set('urls', $urls);
    }

    function suspend() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");
        
        $acess_log=new AcessLog();
        $acess_log->Insert("Suspenso", $_SESSION['sessao_empregado'], $_SESSION['sessao_balcao'], $_SESSION['sessao_loja']);
        
        $service_desk = new Counters();
        $service_desk->SetEstado($_SESSION['sessao_balcao'], 2);
        $this->set('success', 'TRUE');
        $this->set('message', 'Service Desk suspended');

        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.resumeSuspension', 'method' => 'resumeSuspension');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $this->set('urls', $urls);
    }

    function resumeSuspension() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");

        $acess_log=new AcessLog();
        $acess_log->Insert("Entrada", $_SESSION['sessao_empregado'], $_SESSION['sessao_balcao'], $_SESSION['sessao_loja']);
        
        $service_desk = new Counters();
        $service_desk->SetEstado($_SESSION['sessao_balcao'], 4);
        $this->set('success', 'TRUE');
        $this->set('message', 'Service Desk available');

        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $this->set('urls', $urls);
    }

    function suspendForInternalService() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");

        $acess_log=new AcessLog();
        $acess_log->Insert("Suspenso", $_SESSION['sessao_empregado'], $_SESSION['sessao_balcao'], $_SESSION['sessao_loja']);
        
        $service_desk = new Counters();
        $service_desk->SetEstado($_SESSION['sessao_balcao'], 5);
        $this->set('success', 'TRUE');
        $this->set('message', 'Service Desk suspended for internal service');

        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.resumeSuspension', 'method' => 'resumeSuspension');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $this->set('urls', $urls);
    }

    function getAvailableServicesForTerminal() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Services.php");
        require_once("services/contactline/Horario.php");


         if (isset($this->request->params['sessao_loja'])) {
            $sessao_loja = $this->request->params['sessao_loja'];

            $services = new Services();
            $available_services = $services->getAvailableServicesInServiceDeskAllData($sessao_loja);
            $this->set('success', 'TRUE');
            $this->set('services_terminal', $available_services);
            

            //$urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
            //$urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
            //$this->set('urls', $urls);
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Store id not specified');
            header('Missing parameter', true, 500);
        }
    }

    function getAvailableServicesForTerminalTest() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Services.php");
        require_once("services/contactline/Horario.php");


        $services = new Services();
        $available_services = $services->getAvailableServicesInServiceDeskAllData($_SESSION["sessao_balcao"]);
        $this->set('success', 'TRUE');
        $this->set('services_terminal', $available_services);

        

        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $this->set('urls', $urls);
    }

    function suspendForTerminal() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");
        
        if (isset($this->request->params['sessao_empregado']) && isset($this->request->params['sessao_balcao']) && isset($this->request->params['sessao_loja'])) {
            $sessao_empregado = $this->request->params['sessao_empregado'];
            $sessao_balcao = $this->request->params['sessao_balcao'];
            $sessao_loja = $this->request->params['sessao_loja'];
            
            $acess_log=new AcessLog();
            $acess_log->Insert("Suspenso", $sessao_empregado, $sessao_balcao, $sessao_loja);
            
            $service_desk = new Counters();
            $service_desk->SetEstadoForTerminal($sessao_balcao, 2, $sessao_empregado, $sessao_loja);
            $this->set('success', 'TRUE');
            $this->set('message', 'Service Desk suspended');

            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.resumeSuspension', 'method' => 'resumeSuspension');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
            $this->set('urls', $urls);
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Session id not specified');
            header('Misisng parameter', true, 500);
        }
    }

    function resumeSuspensionForTerminal() {
        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");

        if (isset($this->request->params['sessao_empregado']) && isset($this->request->params['sessao_balcao']) && isset($this->request->params['sessao_loja'])) {
            $sessao_empregado = $this->request->params['sessao_empregado'];
            $sessao_balcao = $this->request->params['sessao_balcao'];
            $sessao_loja = $this->request->params['sessao_loja'];
            
            $acess_log=new AcessLog();
            $acess_log->Insert("Entrada", $sessao_empregado, $sessao_balcao, $sessao_loja);
            
            $service_desk = new Counters();
            $service_desk->SetEstadoForTerminal($sessao_balcao, 4, $sessao_empregado, $sessao_loja);
            $this->set('success', 'TRUE');
            $this->set('message', 'Service Desk available');

            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
            $this->set('urls', $urls);
        } else {
            $this->set('success', "FALSE");
            $this->set('message', 'Session id not specified');
            header('Misisng parameter', true, 500);
        }
    }

}

?>
