<?php  

class UserController extends ControllerBase {

    // Components can be accessed as $this->Component ("ComponentName" => "$this->ComponentName")
    var $components = array();
    // Helpers are located in 'views/helpers'. They will be loaded and provided to the view. Example: "Xml" => $xml
    var $helpers = array();

    function UserController() {
        parent::__construct();
    }

    /** Logs in a user given his username/password match and machine name 
      Retorna true ou false consoante a realização ou não do login, enviando
      o erro quando devolve false e enviando a session quando retorna true */
    function login() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/User.php");
        require_once("services/contactline/AcessLog.php");
        require_once("services/contactline/Utils.php");
        require_once("services/contactline/Store.php");
        require_once("services/contactline/Entity.php");

        $username = $this->request->params['username'];
        $password = $this->request->params['password'];

        $service_desk = new Counters();

        $service_desk->ClearMachine($_SERVER['REMOTE_ADDR']);

        $user = new User();
        $utils = new Utils();

        $rs = $user->checkLoginDetails($username, $password);
        

        if (strcasecmp($rs, "ok") != 0) {
            $utils->iniciaVariaveisSessao();
            $this->set('success', 'FALSE');
            $this->set('message', $utils->translateError($rs));
            header('Login error', true, 500);
        } else {
            $store = new Store();
            $stores = $store->getEmployeeStores($_SESSION["sessao_empregado"]);

            $_SESSION["sessao_loja"] = $stores[0];
            $_SESSION["sessao_campos"]["loja"] = $_SESSION["sessao_loja"];

            $entity = new Entity();
            $entities = $entity->getEmployeeEntities($_SESSION["sessao_empregado"]);

            $_SESSION["sessao_entidade"] = $entities[0];
            $_SESSION["sessao_campos"]["entidade"] = $_SESSION["sessao_entidade"];

            $acess_log = new AcessLog();
            $acess_log->UserLogin($username, $_SERVER["REMOTE_ADDR"]);
            $this->set('success', 'TRUE');
            $this->set('user_id', $_SESSION["sessao_empregado"]);
            $this->set('username', $_SESSION['sessao_login']);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.logout', 'method' => 'logout');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.assignServiceDesk', 'method' => 'assignServiceDesk');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.getAvailableServiceDesks', 'method' => 'getAvailableServiceDesks');
        $this->set('urls', $urls);
    }

    /** Log Off the user */
    function logout() {



        require_once("services/MethodBase.class.php");
        require_once("services/contactline/AcessLog.php");
        require_once("services/contactline/Utils.php");
        require_once("services/contactline/Counters.php");

        $utils = new Utils();
        $acess_log = new AcessLog();
        $lastAccess = $acess_log->GetLastAcessRegister($_SESSION["sessao_empregado"]);
        $acess_log->UserLogout($_SESSION["sessao_empregado"], $_SERVER["REMOTE_ADDR"]);
        if ( $_SESSION["sessao_balcao"]!='' && $lastAccess["acesso"] == "Entrada") {
            $rs = $acess_log->Insert("Saida", $_SESSION['sessao_empregado'], $_SESSION['sessao_balcao'], $_SESSION['sessao_loja']);
            $service_desk = new Counters();
            $service_desk->SetEstado($_SESSION["sessao_balcao"], 3);
        }
        
        
        @session_start();
        session_destroy();

        $this->set('success', 'TRUE');
        $this->set('message', 'Disconnected');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.login', 'method' => 'login');
        $this->set('urls', $urls);
    }

    function assignServiceDesk() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");
        if (isset($this->request->params['id_service_desk'])) {
            $id_service_desk = $this->request->params['id_service_desk'];
            $service_desk = new Counters();
            $logAcesso = new AcessLog();             

            $service_desk_name = $service_desk->GetNome($id_service_desk);

            $assigned_store = $service_desk->GetLoja($id_service_desk);

            if ($service_desk_name == '') {
                $this->set('success', 'FALSE');
                $this->set('message', 'Selected service desk doesn t exist');
                header('Service desk result null', true, 500);
            } else if ($assigned_store == '') {
                $this->set('success', 'FALSE');
                $this->set('message', 'Selected service desk is not assigned to a store');
                header('Not assigned to store', true, 500);
            } else if (!$service_desk->isServiceDeskAvailable($id_service_desk, $_SESSION["sessao_campos"]["loja"], $_SESSION["sessao_campos"]["entidade"])) {

                $this->set('success', 'FALSE');
                $this->set('message', 'Service desk not available to the user');
                header('Not available to user', true, 500);
            } else {                
                $_SESSION["sessao_balcao"] = $id_service_desk;
                $_SESSION["sessao_nome_balcao"] = $service_desk_name;
                $_SESSION["sessao_loja"] = $assigned_store;
                $_SESSION["sessao_piso"] = $service_desk->GetPiso($id_service_desk);

                $acess_log = new AcessLog();
                $rs = $acess_log->Insert("Entrada", $_SESSION['sessao_empregado'], $_SESSION['sessao_balcao'], $_SESSION['sessao_loja']);

                $service_desk = new Counters();
                $service_desk->SetEstado($id_service_desk, 4);
                
                $this->set('success', 'TRUE');
                $this->set('service_desk_result', $_SESSION["sessao_balcao"]);
            }

        } else {
            $this->set('success', 'FALSE');
            $this->set('message', 'Missing parameter "id_service_desk", you need to specify the id of the service desk');
            header('Missing parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.closeServiceDesk', 'method' => 'closeServiceDesk');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=serviceDesk.getAvailableServices', 'method' => 'getAvailableServices');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $this->set('urls', $urls);
    }

    function getAvailableServiceDesks() {        

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");        
        $service_desk = new Counters();


        $service_desks = $service_desk->listDesksByUser($this->request->params['user_id']);
        
        if(!$service_desks)
            $service_desks = $service_desk->listServiceDesks($_SESSION["sessao_campos"]["loja"], $_SESSION["sessao_campos"]["entidade"]);
        //var_dump($service_desks);die();
        if (!isset($service_desks['erro'])) {
            $this->set('success', 'TRUE');
            $this->set('service_desks', $service_desks);
        } else {
            $this->set('success', 'FALSE');
            $this->set('message', $service_desks['erro']);
            header('Error', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.assignServiceDesk', 'method' => 'assignServiceDesk');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.logout', 'method' => 'logout');
        $this->set('urls', $urls);
    }

    function getAvailableServiceDesksForTerminal() {        

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        $service_desk = new Counters();



        if (isset($this->request->params['loja']) && isset($this->request->params['entidade'])) {
            $id_loja = $this->request->params['loja'];
             $entidade = $this->request->params['entidade'];

            $service_desks = $service_desk->listServiceDesks($id_loja, $entidade);

            if (!isset($service_desks['erro'])) {
                $this->set('success', 'TRUE');
                $this->set('service_desks', $service_desks);
            } else {
                $this->set('success', 'FALSE');
                $this->set('message', $service_desks['erro']);
                header('Error', true, 500);
            }
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.assignServiceDesk', 'method' => 'assignServiceDesk');
            $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.logout', 'method' => 'logout');
            $this->set('urls', $urls);
        } else {
            $this->set('success', 'FALSE');
            $this->set('message', 'Missing parameter "loja", "entidade"');
            header('Error', true, 500);
        }
    }

    function closeServiceDesk() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");

        $acess_log = new AcessLog();
        $rs = $acess_log->Insert("Saida", $_SESSION['sessao_empregado'], $_SESSION['sessao_balcao'], $_SESSION['sessao_loja']);
        $service_desk = new Counters();
        $service_desk->SetEstado($_SESSION['sessao_balcao'], 3);
        unset($_SESSION['sessao_balcao']);
        $this->set('success', 'TRUE');
        $this->set('message', 'Service Desk closed');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.assignServiceDesk', 'method' => 'assignServiceDesk');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.logout', 'method' => 'logout');
        $this->set('urls', $urls);
    }

    /*For Terminal */

    function loginForTerminal() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/User.php");
        require_once("services/contactline/AcessLog.php");
        require_once("services/contactline/Utils.php");
        require_once("services/contactline/Store.php");
        require_once("services/contactline/Entity.php");

        $username = $this->request->params['username'];
        $password = $this->request->params['password'];

        $service_desk = new Counters();

        //$service_desk->ClearMachine($_SERVER['REMOTE_ADDR']);

        $user = new User();
        $utils = new Utils();

        $rs = $user->checkLoginDetailsForTerminal($username, $password, $nome, $utilizador, $id_empregado, $tipo, $auto, $refresh_time, $desistir_after, $ranking, $language);
        

        if (strcasecmp($rs, "ok") != 0) {
            //$utils->iniciaVariaveisSessao();
            $this->set('success', 'FALSE');
            $this->set('message', $utils->translateError($rs));
            header('Login error', true, 500);
        } else {
            $store = new Store();
            $stores = $store->getEmployeeStores($id_empregado/*$_SESSION["sessao_empregado"]*/);

            $sessao_loja = $stores[0];
            //$_SESSION["sessao_loja"] = $stores[0];
            //$_SESSION["sessao_campos"]["loja"] = $_SESSION["sessao_loja"];

            $entity = new Entity();
            $entities = $entity->getEmployeeEntities($id_empregado/*$_SESSION["sessao_empregado"]*/);
            $entity_session = $entities[0];
            //$_SESSION["sessao_entidade"] = $entities[0];
            //$_SESSION["sessao_campos"]["entidade"] = $_SESSION["sessao_entidade"];

            $acess_log = new AcessLog();
            $acess_log->UserLogin($username, $_SERVER["REMOTE_ADDR"]);
            $this->set('success', 'TRUE');
            $this->set('user_id', $id_empregado/*$_SESSION["sessao_empregado"]*/);
            $this->set('username', $username/*$_SESSION['sessao_login']*/);
            $this->set('store_session', $sessao_loja);
            $this->set('entity_session', $entity_session);
            $this->set('name', $utilizador);
            $this->set('auto', $auto);
            $this->set('refresh_time', $refresh_time);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.logout', 'method' => 'logout');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.assignServiceDesk', 'method' => 'assignServiceDesk');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.getAvailableServiceDesks', 'method' => 'getAvailableServiceDesks');
        $this->set('urls', $urls);
    }

    function logoutForTerminal() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/AcessLog.php");
        require_once("services/contactline/Utils.php");
        require_once("services/contactline/Counters.php");

        $sessao_empregado = $this->request->params['sessao_empregado'];
        $sessao_balcao = $this->request->params['sessao_balcao'];
        $sessao_loja = $this->request->params['sessao_loja'];

        $utils = new Utils();
        $acess_log = new AcessLog();
        $lastAccess = $acess_log->GetLastAcessRegister($sessao_empregado);
        $acess_log->UserLogout($sessao_empregado, $_SERVER["REMOTE_ADDR"]);
        if ( $sessao_balcao!='' && $lastAccess["acesso"] == "Entrada") {
            $rs = $acess_log->Insert("Saida", $sessao_empregado, $sessao_balcao, $sessao_loja);
            $service_desk = new Counters();

            $service_desk->SetEstadoForTerminal($sessao_balcao, 3, $sessao_empregado, $sessao_loja);
        }
        
        
        //@session_start();
        //session_destroy();

        $this->set('success', 'TRUE');
        $this->set('message', 'Disconnected');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.login', 'method' => 'login');
        $this->set('urls', $urls);
    }

    function assignServiceDeskForTerminal() {

        require_once("services/MethodBase.class.php");
        require_once("services/contactline/Counters.php");
        require_once("services/contactline/AcessLog.php");
        if (isset($this->request->params['id_service_desk'])) {
            $id_service_desk = $this->request->params['id_service_desk'];
            $id_loja = $this->request->params['id_loja'];
            $id_entidade = $this->request->params['id_entidade'];
            $id_user_session = $this->request->params['id_user_session'];
            $service_desk = new Counters();
            $logAcesso = new AcessLog();             

            $service_desk_name = $service_desk->GetNome($id_service_desk);

            $assigned_store = $service_desk->GetLoja($id_service_desk);
            $store_name = $service_desk->GetLojaNome($id_service_desk);
            $entity_name= $service_desk->GetEntidadeNome($id_service_desk);

            if ($service_desk_name == '') {
                $this->set('success', 'FALSE');
                $this->set('message', 'Selected service desk doesn t exist');
                header('Service desk result null', true, 500);
            } else if ($assigned_store == '') {
                $this->set('success', 'FALSE');
                $this->set('message', 'Selected service desk is not assigned to a store');
                header('Not assigned to store', true, 500);
            } else if (!$service_desk->isServiceDeskAvailable($id_service_desk, $id_loja, $id_entidade)) {

                $this->set('success', 'FALSE');
                $this->set('message', 'Service desk not available to the user');
                header('Not available to user', true, 500);
            } else {                
                //$_SESSION["sessao_balcao"] = $id_service_desk;
                //$_SESSION["sessao_nome_balcao"] = $service_desk_name;
                //$_SESSION["sessao_loja"] = $assigned_store;
                //$_SESSION["sessao_piso"] = $service_desk->GetPiso($id_service_desk);

                $acess_log = new AcessLog();
                $rs = $acess_log->Insert("Entrada", $id_user_session, $id_service_desk, $assigned_store);

                $service_desk = new Counters();
                $service_desk->SetEstadoForTerminal($id_service_desk, 4, $id_user_session, $id_loja);
                
                $this->set('success', 'TRUE');
                $this->set('service_desk_result', $id_service_desk);
                $this->set('service_desk_name', $service_desk_name);
                $this->set('store_name', $store_name);
                $this->set('entity_name', $entity_name);
            }

        } else {
            $this->set('success', 'FALSE');
            $this->set('message', 'Missing parameter "id_service_desk", you need to specify the id of the service desk');
            header('Missing parameter', true, 500);
        }
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.closeServiceDesk', 'method' => 'closeServiceDesk');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=serviceDesk.getAvailableServices', 'method' => 'getAvailableServices');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=Service.getQueueLine', 'method' => 'getQueueLine');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspend', 'method' => 'suspend');
        $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=ServiceDesk.suspendForInternalService', 'method' => 'suspendForInternalService');
        $this->set('urls', $urls);
    }

}

?>
