<?php  

class MoblineServerComponent {

    var $controller;

    function MoblineServerComponent(&$controller = null, $args = null) {
        $this->controller = $controller;
    }

    function sendCommand($command, $args, $waitResponse = false) {
        if (!is_array($args))
            $args = array($args);

        // The command string, all args are separated by a space
        $string = $command . " " . implode(" ", $args) . "\0";
        return $this->processCommand($string, $waitResponse);
    }

    function sendCommandB64($command, $arg, $waitResponse = false) {
        $string = "B64" . base64_encode($arg);
        return $this->sendCommand($command, array($string), $waitResponse);
    }

    /**
     *
     * @param type $buffer    The text (command and arguments) to send
     * @return type 
     */
    private function processCommand($buffer, $waitResponse = false) {

        global $NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL;

        $socket = @socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        if ($socket === false) {
            debug("Could not create a socket for a subsequent MoblineServer connection.");
            return false;
        }

        $result = @socket_connect($socket, $NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL);
        if ($result === false) {
            debug("Could not connect to the Central server at $NOME_SERVIDOR_CENTRAL:$PORTO_SERVIDOR_CENTRAL");
            return false;
        }

        // Send the command to the MoblineServer
        socket_write($socket, $buffer, strlen($buffer) + 1);

        $buffer = '';
        if ($waitResponse) {
            // Read the server response
            $buffer = socket_read($socket, 2048, PHP_BINARY_READ);
        }
        socket_close($socket);

        return $buffer;
    }

}

?>