<?php  

require_once 'core/ResponseObject.php';

class ControllerBase {

    var $_db;
    var $layout = null;
    protected $request;
    protected $response;
    protected $viewVariables;

    function ControllerBase() {
        // $this->_db = new DBAccess(NOME_SERVIDOR, USERNAME, PASSWORD, NOME_BD);
        $this->viewVariables = array();
        
    }

   

    function __setup($requestObject) {
        $this->request = $requestObject;
        $this->response = new ResponseObject($requestObject);
        //$this->response->setHeaders(); // default http status code = 200
        $this->response->setStatus(200);

        if ($this->layout == null) {
            $this->layout = 'default';
        }
        
    }

    
 
    /**
     * Set variables that should be transported to the view
     * @param mixed $key    Either a string defining the variable name or an 
     *                      associative array so that multiple variables/values are stored at once
     * @param type $value   If the $key is a variable name (string) this defines the respective value
     */
    function set($key, $value = null) {
        if (is_array($key)) {
            $this->viewVariables = array_merge($this->viewVariables, $key);
        } else {
            $this->viewVariables[$key] = $value;
        }
    }

    // Unset an already set variable
    function delete($key) {
        unset($this->viewVariables[$key]);
    }

    // Get the variables the variables
    // that should be transported to the view
    function getViewVariables() {
        return $this->viewVariables;
    }

    function render($action = null, $layout = null) {
        if ($action != null) {
            $this->view->view = $action;
        } else {
            $this->view->view = $this->request->getAction();
        }
        if ($layout != null) {
            $this->view->layout = $layout;
        } else {
            $this->view->layout = $this->layout;
        }

        $this->view->contentType = 'xml';
        $this->view->variables = $this->getViewVariables();
        
        
        
        $this->view->render();

        exit();
    }

   

}

?>