<?php  

class Gateway {

    var $requestObject;
    var $controller;
    var $view;

    function Gateway() {
        
    }

    function process() {

        $this->buildRequestObject();

        // this must be fixed to take into account the relative path
        $methodClassPath = $this->requestObject->getMethodClassPath();
        if ($methodClassPath === false) {
            // TODO
            // param method not defined, return or throw an error
            exit();
        }


        // TODO we should be using __autoload() for this or rather 
        // spl_autoload_register() (http://de3.php.net/manual/en/function.spl-autoload-register.php)
        // in order to allow more than one autoload
        $result = require_once('controllers/' . $methodClassPath);
        if ($result === false) {
            // TOD0
            // Service not found, return or throw an error
            exit();
        }

        // Instantiate the Service handler class according to the required "method" url param
        $className = $this->requestObject->getControllerName();
        $this->controller = new $className();
        $this->controller->__setup($this->requestObject);

        $this->view = new View();
        $this->view->controller = $this->requestObject->getController();
        $this->controller->view = $this->view;
        $this->loadHelpers($this->controller, $this->view); // Load the view helpers
        // Check if requested method needs authentication, if it does execute the following line
        $this->authenticate(); // Logic not yet implemented
        header("Access-Control-Allow-Origin: *");//permitir cors !!!
        $this->validate();
        // Logic not yet implemented
        // Load the controller components

        $this->loadComponents($this->controller);
        
        // Call the actual method that the client requested
        $this->controller->{$this->requestObject->getAction()}();
        
        $this->controller->render();

        //return $responseObject;
    }

    function authenticate() {

      if (strtolower($this->requestObject->getMethod()) != 'user.login' && strtolower($this->requestObject->getMethod()) != 'user.loginforterminal' && strtolower($this->requestObject->getMethod()) != 'satisfaction.setsatisfaction' && strtolower($this->requestObject->getMethod()) != 'satisfaction.getsatisfaction' && strtolower($this->requestObject->getMethod()) != 'stores.getstores' && strtolower($this->requestObject->getMethod()) != 'stores.getstoreservicesansweringtimes' && strtolower($this->requestObject->getMethod()) != 'servicedesk.getavailableservicesforterminal'  && strtolower($this->requestObject->getMethod()) != 'user.getavailableservicedesksforterminal' && strtolower($this->requestObject->getMethod()) != 'user.assignservicedeskforterminal' && strtolower($this->requestObject->getMethod()) != 'user.logoutforterminal' && strtolower($this->requestObject->getMethod()) != 'service.autocallticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.callticketnowforterminal' && strtolower($this->requestObject->getMethod()) != 'ticket.getticket' && strtolower($this->requestObject->getMethod()) != 'service.terminateticketforterminal' && strtolower($this->requestObject->getMethod()) != 'ticket.getform' && strtolower($this->requestObject->getMethod()) != 'service.recallticket' && strtolower($this->requestObject->getMethod()) != 'service.suspendticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.callsuspendedticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.callfoldedticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.foldticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.redirectticketforterminal' && strtolower($this->requestObject->getMethod()) != 'servicedesk.suspendforterminal' && strtolower($this->requestObject->getMethod()) != 'servicedesk.resumesuspensionforterminal' && strtolower($this->requestObject->getMethod()) != 'evaluation.insert'){
            $header = apache_request_headers();
            session_id($header['X-Mobbit-Contactline']);
            @session_start();
            if (session_id() == '' || $_SESSION['sessao_empregado'] == '') {
                $this->controller->set('success', 'FALSE');
                $this->controller->set('message', 'Authentication required');
                $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=User.login', 'method' => 'login');
                $this->controller->set('urls', $urls);
                header('Authentication required', true, 401);
                $this->controller->render();
                exit();
            }
        }
    }

    function validate() {
        //if requires an assigned deskg
        if (strtolower($this->requestObject->getMethod()) != 'user.login' && strtolower($this->requestObject->getMethod()) != 'user.loginforterminal' && strtolower($this->requestObject->getMethod()) != 'user.logout' && strtolower($this->requestObject->getMethod()) != 'user.getavailableservicedesks' && strtolower($this->requestObject->getMethod()) != 'user.getavailableservicedesksforterminal'  && strtolower($this->requestObject->getMethod()) != 'user.assignservicedesk' && strtolower($this->requestObject->getMethod()) != 'satisfaction.setsatisfaction' && strtolower($this->requestObject->getMethod()) != 'satisfaction.getsatisfaction' && strtolower($this->requestObject->getMethod()) != 'stores.getstores' && strtolower($this->requestObject->getMethod()) != 'stores.getstoreservicesansweringtimes' && strtolower($this->requestObject->getMethod()) != 'servicedesk.getavailableservicesforterminal' && strtolower($this->requestObject->getMethod()) != 'user.assignservicedeskforterminal' && strtolower($this->requestObject->getMethod()) != 'user.logoutforterminal' && strtolower($this->requestObject->getMethod()) != 'service.autocallticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.callticketnowforterminal' && strtolower($this->requestObject->getMethod()) != 'ticket.getticket' && strtolower($this->requestObject->getMethod()) != 'service.terminateticketforterminal' && strtolower($this->requestObject->getMethod()) != 'ticket.getform' && strtolower($this->requestObject->getMethod()) != 'service.recallticket' && strtolower($this->requestObject->getMethod()) != 'service.suspendticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.callsuspendedticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.callfoldedticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.foldticketforterminal' && strtolower($this->requestObject->getMethod()) != 'service.redirectticketforterminal' && strtolower($this->requestObject->getMethod()) != 'servicedesk.suspendforterminal' && strtolower($this->requestObject->getMethod()) != 'servicedesk.resumesuspensionforterminal' && strtolower($this->requestObject->getMethod()) != 'evaluation.insert' && strtolower($this->requestObject->getMethod()) != 'evaluation.get' && strtolower($this->requestObject->getMethod()) != 'evaluation.delete') {
            if (!isset($_SESSION['sessao_balcao']) || $_SESSION['sessao_balcao'] == '') {
                $this->controller->set('success', 'FALSE');
                $this->controller->set('message', 'Requires an assigned service desk');
                $urls[] = array('url' => 'http://' . $_SERVER["SERVER_NAME"] . $_SERVER['PHP_SELF'] . '?method=user.assignServiceDesk', 'method' => 'assignServiceDesk');
                $this->controller->set('urls', $urls);
                header('Requires assigned service desk', true, 500);
                $this->controller->render();
                exit();
            }
        }
        
        
    }

    private function buildRequestObject() {

        $this->requestObject = new RequestObject();
        $this->requestObject->headers = getallheaders();
        $this->requestObject->method = $_GET['method'];
        $this->requestObject->body = @file_get_contents('php://input');
        $this->requestObject->params = array_merge($_GET, $_POST);
        unset($this->requestObject->params['method']);

        //$this->requestObject->apiKey = $_GET[''];
        //$this->requestObject->signature = $_GET[''];
    }

    /**
     * Loads the components required by the current controller
     * and sets them in an instance variable with the comopnents name
     * Thus, if we have the "Test" component we can access it
     * in the controller with $this->test
     * 
     * @param type $controller 
     */
    private function loadComponents($controller) {

        $components = $controller->components;
        foreach ($components as $component) {

            $className = $component . "Component";
            $componentName = $component;

            $controller->$componentName = new $className($controller);
        }
    }

    private function loadHelpers($controller, $view) {

        $helpers = $controller->helpers;
        if (!is_array($helpers))
            return;
        foreach ($helpers as $helper) {
            $className = $helper . "Helper";
            $helperName = $helper;

            $view->$helperName = new $className();
        }
    }

}

?>