<?php  

class RequestObject {

	var $headers; // Array with all the HTTP Headers
	var $apiKey;
	var $signature;
	var $method;
	var $params;
	var $body;
	private $_requestMethodInvalid = false;
	private $_requestMethodInfo = array('controller' => null, 'action' => null);

	function RequestObject() {
		
	}

        function getMethod(){
            return $this->method;
        }
        
	function getMethodClassPath() {
		// Transform $this->method into the corresponding Class's path
		// Ex.: "contactline.services.listQueue" becomes "contactline/Services.php" 
		$info = $this->_getRequestMethodInfo();
		if (!$info)
			return false;

		return $this->getControllerName() . '.php';
	}

	function getController() {
		// Transform $this->method into the corresponding Class name
		// Ex.: "contactline.services.listQueue" becomes "Services"
		$info = $this->_getRequestMethodInfo();
		if (!$info)
			return false;

		return $info['controller'];
	}

	function getControllerName() {
		return ucfirst($this->getController()) . 'Controller';
	}

	function getAction() {		
		// Transform $this->method into the corresponding function that will be executed on the Class
		// Ex.: "contactline.services.listQueue" becomes "listQueue"
		$info = $this->_getRequestMethodInfo();

		if (!$info)
			return false;

		return $info['action'];
	}

	/**
	 * Builds the array that holds all the parts of the request method. 
	 * The $method variable must be correctly set before calling this method
	 * the first time.
	 * 
	 * @return type 
	 */
	private function _getRequestMethodInfo() {
		// Builds the array that holds all the parts of the request method

		if ($this->_requestMethodInvalid)
			return false;
		if (isset($this->_requestMethodInfo['controller']))
			return $this->_requestMethodInfo;

		if (empty($this->method)) {
			$this->_requestMethodInvalid = true;
			return false;
		}
		$parts = explode('.', $this->method);
		if (count($parts) != 2) {
			$this->_requestMethodInvalid = true;
			return false;
		}

		$this->_requestMethodInfo['controller'] = $parts[0]; // e.g. 'terminal'
		$this->_requestMethodInfo['action'] = $parts[1];	 // e.g. 'view'

		return $this->_requestMethodInfo;
	}

}

?>
