<?php  


class View {
	
	var $layout;      // The layout name, 'default' by default
	var $controller;  // The controller name
	var $view;        // The view name
	var $contentType; // Response content type
	
	var $variables;   // The variables set in the controller
	var $helpers;     // The helper classes to be used in the view (as defined in the $helpers array of the called controller)
	
	function View() {
		
	}
	
	function render() {
		ob_start();
		
		if (empty($this->contentType)) {
			$view = 'views/' . $this->controller . '/' . $this->view . '.php';
			if(!file_exists($view)){
				$view = 'views/' . $this->controller . '/default.php';
				if(!file_exists($view)){
					$view = 'views/view/default.php';
				} 
			}

			$layout = 'views/layout/default.php';
		}
		else {
			$view = 'views/' . $this->controller . '/' . $this->contentType . '/' . $this->view . '.php';
			if(!file_exists($view)){
				$view = 'views/' . $this->controller . '/' . $this->contentType . '/default.php';
				if(!file_exists($view)){
					$view = 'views/view/' . $this->contentType . '/default.php';
				} 
			} 

			$layout = 'views/layout/' . $this->contentType . '/' . 'default.php';
		}
		
		if (!empty($this->variables)) {
			extract($this->variables);
		}

		include($view);
		
		$content_for_layout = ob_get_clean();
		
		@include($layout);
		
	}
	
	
}


?>