<?php  

function api_autoload($className) {

    // ends with "Component" but is not just "Component"?
    // strlen "Component" = 9
    if (strlen($className) > 9 && substr_compare($className, "Component", -9, 9) === 0) {
        include 'controllers/components/' . $className . '.php';
    }
    // strlen "Controller" = 10
    else if (strlen($className) > 10 && substr_compare($className, "Controller", -10, 10) === 0) {
        include 'controllers/' . $className . '.php';
    }
    // strlen "Helper" = 6
    else if (strlen($className) > 6 && substr_compare($className, "Helper", -6, 6) === 0) {
        include 'views/helpers/' . $className . '.php';
    }
}

// Register the autoload funciton
spl_autoload_register('api_autoload'); // As of PHP 5.1.2

?>