<?php  

class Counters extends MethodBase {
    function Counters() {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
        $this->_db = new AcessoBD($conn);
    }
    function listByUser() {
        
        if (empty($this->request->params['user_id']))
            $this->response->setStatus(400);
        else {
            $list = array();
            $result = $this->_db->executarSQL('SELECT id_balcao FROM empregados WHERE id_empregado = ' . $this->request->params['user_id']);

            if (count($result) > 0 && $result[0]['id_balcao'] != NULL) {
                $list[] = $result[0]['id_balcao'];
            } else {
                $result = $this->_db->executarSQL('SELECT DISTINCT l.id_loja id_loja FROM lojas l INNER JOIN local_colaborador lc ON lc.id_local = l.id_loja WHERE lc.id_colaborador = ' . $this->request->params['user_id']);
                $lojas = array(0);
                foreach ($result as $loja)
                    $lojas[] = $loja['id_loja'];
                $result = $this->_db->executarSQL('SELECT id_balcao FROM balcoes WHERE id_loja IN (' . implode(',', $lojas) . ')');
                foreach ($result as $balcao)
                    $list[] = $balcao['id_balcao'];
            }
            $this->response->setBody($list);
        }
        return $this->response;
    }

    function listDesksByUser($id) {
    
        if (empty($id))
            return null;
        else {
            $list = array();
            $sql = 'SELECT e.id_balcao, b.nome FROM empregados e inner join balcoes b on e.id_balcao = b.id_balcao WHERE id_empregado = ' . $id;
            if ($rs = $this->_db->getRows($sql)) {
                for ($i = 0; $i < count($rs); $i++) {
                    $list[] = Array('id' => $rs[$i]["id_balcao"], 'nome' => $rs[$i]["nome"]);
                }
            }
            
            if (count($list) > 0 && $list[0]['id'] != NULL) {
                return $list;
            } else {
                return null;
            }
           
        }
        return $list;
    }


    function addUser() {
        if (empty($this->request->params['counter_id']) || empty($this->request->params['user_id'])) {
            $this->response->setStatus(400);
        } else {
            $result = $this->_db->executarSQL('SELECT id_loja FROM balcoes WHERE id_balcao = ' . $this->request->params['counter_id']);
            if (count($result) > 0) {
                $result2 = $this->_db->executarSQL('SELECT id_local, id_colaborador FROM local_colaborador WHERE id_local=' . $result[0]['id_loja'] . ' AND id_colaborador=' . $this->request->params['user_id']);
                if (count($result2) == 0)
                    $this->_db->executarSQL('INSERT INTO local_colaborador(id_local, id_colaborador) VALUES(' . $result[0]['id_loja'] . ',' . $this->request->params['user_id'] . ')');

                $result3 = $this->_db->executarSQL('SELECT id_balcao FROM empregados WHERE id_empregado=' . $this->request->params['user_id']);

                if (count($result3) > 0 && empty($result3[0]['id_balcao']))
                    $this->_db->executarSQL('UPDATE empregados SET id_balcao=' . $this->request->params['counter_id'] . ' WHERE id_empregado=' . $this->request->params['user_id']);
            }
            else
                $this->response->setStatus(304);
        }
        return $this->response;
    }

    function GetNome($id) {
        $sql = "select nome from balcoes where id_balcao=" . $id;
        $rs = $this->_db->getRows($sql);
        if (count($rs) == 0) {
            return 0;
        }
        else
            return $rs[0]["nome"];
    }

    function ClearMachine($machname) {
        $this->_db->executarSQL("UPDATE balcoes SET machine=null WHERE machine='" . $machname . "'");

    }

    function SetMachine($id, $machname) {
        $sql = "update balcoes set machine='" . $machname . "' where id_balcao='" . $id . "'";
        $this->_db->executarSQL($sql);
    }

    function updateTimers($current_state, $future_state, $user = "", $local = "") {
        require_once('TimerManager.php');
        $time_log = new TimerManager();
        $id_empregado = $user && $user != '' ? $user : $_SESSION["sessao_empregado"];

        if (date("Y-m-d") != date("Y-m-d", $current_state['time']) && ( $current_state['id'] == '1' || $current_state['id'] == '2' || $current_state['id'] == '4' || $current_state['id'] == '5') && $current_state['id'] != '') {
            //echo "<p>data do estado anterior=".date("Y-m-d", $current_state['time'])." data actual=".date("Y-m-d")."</p>"; exit;

            $startTimeStamp = mktime(0, 0, 0, date("m", $current_state['time']), date("d", $current_state['time']), date("Y", $current_state['time']));
            $actualTimeStamp = $startTimeStamp;
            $endDateTimeStamp = mktime(0, 0, 0, date("m"), date("d"), date("Y"));

            //enche o q falta p o resto do 1o dia
            $interval = 0;
            while ($actualTimeStamp < $endDateTimeStamp) {

                if ($actualTimeStamp == $startTimeStamp) {
                    $interval = 86400 - $current_state['seconds'];
                } else {
                    $interval = 86400;
                }

                switch ($current_state['id']) {
                    //se esta ha mais de um dia em atendimento
                    case 1:
                        $time_log->updateTempoAtendimento($id_empregado, $interval, $actualTimeStamp, $local);
                        break;
                    //se esta ha mais de um dia suspenso
                    case 2:
                        $time_log->updateTempoSuspenso($id_empregado, $interval, $actualTimeStamp, $local);
                        break;
                }
                $time_log->updateTempoSessao($id_empregado, $interval, $actualTimeStamp, $local);

                $actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp) + 1, date("Y", $actualTimeStamp));
            }
        }


        //terminou um atendimento
        if ($current_state['id'] == '1' && ($future_state == '4' || $future_state == '3' || $future_state == '5')) {
            $interval = time() - $current_state['time'];
            $time_log->updateTempoAtendimento($id_empregado, $interval, time(), $local);
        }
        //terminou suspensao
        if ($current_state['id'] == '2' && ($future_state == '4' || $future_state == '3' || $future_state == '5')) {
            $interval = time() - $current_state['time'];
            $time_log->updateTempoSuspenso($id_empregado, $interval, time(), $local);
        }
        if ($current_state['id'] == '5' && ($future_state == '4' || $future_state == '3' || $future_state == '2')) {
            $interval = time() - $current_state['time'];
            $time_log->updateTempoServicoInterno($id_empregado, $interval, time(), $local);
        }
        if ($current_state['id'] != '3') {
            $interval = time() - $current_state['time'];
            $time_log->updateTempoSessao($id_empregado, $interval, time(), $local);
        }
    }

    function GetEstado($id) {
        $sql = "select estado from balcoes where id_balcao='" . $id . "'";

        if (!$rs = $this->_db->executarSQL($sql)) {
            return 0;
        }
        else
            return $rs[0]["estado"];
    }

    function GetEstadoTime($id) {
        require_once('User.php');
        require_once('TimerManager.php');
        $sql = "select estado, UNIX_TIMESTAMP(data_hora) as data_hora, TIME_TO_SEC(TIME(data_hora)) as seconds from balcoes where id_balcao='" . $id . "'";

        if (!$res = $this->_db->executarSQL($sql)) {
            return 0;
        }

        $estado = array();
        $rs =$this->_db->obterRegisto($res);
        $estado['id'] = $rs["estado"];
        $estado['time'] = $rs["data_hora"];
        $estado['seconds'] = $rs["seconds"];
        return $estado;
    }

    function SetEstado($id, $s) {
 
        $current_s = $this->GetEstadoTime($id);
        if ($current_s['id'] != $s) {
            
            $sql = "update balcoes set estado='" . $s . "', data_hora=now() where id_balcao='" . $id . "'";
            $rs = $this->_db->executarSQL($sql);

            $this->updateTimers($current_s, $s);
            $e = new User();
            $e->updateEstado($_SESSION["sessao_empregado"], $s, $id, $_SESSION['sessao_loja']);
            
        }
    }

    function SetEstadoForTerminal($id, $s, $sessao_empregado, $sessao_loja) {
 
        $current_s = $this->GetEstadoTime($id);
        if ($current_s['id'] != $s) {
            
            $sql = "update balcoes set estado='" . $s . "', data_hora=now() where id_balcao='" . $id . "'";
            $rs = $this->_db->executarSQL($sql);

            $this->updateTimers($current_s, $s, $sessao_empregado, $sessao_loja);
            $e = new User();
            $e->updateEstado($sessao_empregado, $s, $id, $sessao_loja);
            
        }
    }

    function GetLoja($id_balcao) {
        $sql = "select id_loja
			from balcoes
			where id_balcao='" . $id_balcao . "'";
        $res = $this->_db->executarSQL($sql);
        $rs =$this->_db->obterRegisto($res);
        return $rs["id_loja"];
    }

    function GetServicos24h($id_balcao) {
        require_once('Services.php');
        if (empty($id_balcao))
            return;

        $servico = new Services();
        $servicos = $servico->getAvailableServicesInServiceDesk($id_balcao);
        $num_svcs = count($servicos);

        $servicos24h = array();
        for ($i = 0; $i < $num_svcs; $i++) {
            if (!isset($servicos24h[$servicos[$i]["id"]])) {
                $servicos24h[$servicos[$i]["id"]] = $servico->Is24HourService($servicos[$i]["id"]);
            }
        }

        return $servicos24h;
    }

    function GetPiso($id) {
        $sql = "select piso from balcoes where id_balcao='" . $id . "'";
        $res = $this->_db->executarSQL($sql);
        $rs =$this->_db->obterRegisto($res);
        return $rs["piso"];
    }

    function GetServicosPrioritarios($id_balcao) {
        require_once 'Services.php';
        if (empty($id_balcao))
            return;


        $servico = new Services();
        $servicos = array();

        $sql = "select sb.id_servico id, s.nome nome, s.prioridade prioridade, e.nome entidade 
		  from servicos_balcao sb
		  inner join servicos s on s.id_servico=sb.id_servico
		  inner join entidades e on e.id_entidade=s.id_entidade
		  WHERE sb.id_balcao='" . $id_balcao . "'
		  AND sb.servico_prioritario=1";

        if (!$rs = $this->_db->getRows($sql)) {            
            return $servicos;
        }


        $num_svcs = count($rs);
        for ($i = 0; $i < $num_servicos; $i++) {
            $servicos[] = $rs[0];
        }
        $servicosPrioritarios = array();
        for ($i = 0; $i < $num_svcs; $i++) {
            if (!isset($servicosPrioritarios[$servicos_prioritarios[$i]["id"]])) {
                $servicosPrioritarios[$servicos[$i]["id"]] = true;
            }
        }

        return $servicosPrioritarios;
    }

    //get all desks in a specific store and entity
    function listServiceDesks($loja, $entidade) {
        $lista = Array();
        $sql = "SELECT id_balcao, nome FROM balcoes where id_loja=$loja and id_entidade=$entidade";
        if ($rs = $this->_db->getRows($sql)) {
            $lista = array();

            for ($i = 0; $i < count($rs); $i++) {
                $lista[] = Array('id' => $rs[$i]["id_balcao"], 'nome' => $rs[$i]["nome"]);
            }
            return $lista;
        } else {
            $lista['erro'] = 'Error when trying to retrieve the service desks from the database';
            return $erro;
        }
    }

    //check if a desk is set to a specific sotre and entity
    function isServiceDeskAvailable($desk, $loja, $entidade) {

        $sql = "SELECT count(*) as counter FROM balcoes where id_loja=$loja and id_entidade=$entidade and id_balcao=$desk";
        $res = $this->_db->executarSQL($sql);
        $rs =$this->_db->obterRegisto($res);
        if ($rs['counter'] > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function GetLojaNome($id_balcao) {
        $sql = "select l.nome
            from balcoes as b
            inner join lojas as l on b.id_loja = l.id_loja
            where id_balcao='" . $id_balcao . "'";
        $res = $this->_db->executarSQL($sql);
        $rs =$this->_db->obterRegisto($res);
        return $rs["nome"];
    }

    function GetEntidadeNome($id_balcao) {
        $sql = "select l.nome
            from balcoes as b
            inner join entidade as e on b.id_entidade = e.id_entidade
            where b.id_balcao='" . $id_balcao . "'";

        $sql = "select e.nome entidade 
          from servicos_balcao sb
          inner join servicos s on s.id_servico=sb.id_servico
          inner join entidades e on e.id_entidade=s.id_entidade
          WHERE sb.id_balcao='" . $id_balcao . "'
          ";

        $res = $this->_db->executarSQL($sql);
        $rs =$this->_db->obterRegisto($res);
        return $rs["entidade"];
    }

}

?>