<?php  

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Horario
 *
 * @author miguel.sousa
 */
class Horario1 extends MethodBase{
    var $_db;
    var $horarioBase;
    function Horario1() {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
        $this->_db = new AcessoBD($conn);
        
    }

    function GetHorarios($id="")
	{
            // TODO test this new return methodology
            $this->get($id);
            return $this;
            // Changed from...
            //return $this->bd->getRows($sql);
	}

    function get($id) {

        $sql = "SELECT horario.id horario_id, ";
        $sql.= "horario.nome horario_nome, ";
        $sql.= "horario.id_horario_base horario_id_horario_base, ";
        $sql.= "horario.listavel horario_listavel, ";

        $sql.= "horario_semana.id horario_semana_id, ";
        $sql.= "UNIX_TIMESTAMP(horario_semana.start_date) horario_semana_start_date, ";
        $sql.= "horario_semana.id_horario horario_semana_id_horario, ";

        $sql.= "periodo.id periodo_id, ";
        $sql.= "periodo.dia_inteiro periodo_dia_inteiro, ";
        $sql.= "periodo.inicio periodo_inicio, ";
        $sql.= "periodo.fim periodo_fim, ";
        $sql.= "periodo.dia periodo_dia, ";
        $sql.= "periodo.tipo periodo_tipo, ";
        $sql.= "periodo.id_horario_semana period_horario_semana_id ";

        $sql.= "FROM horario ";
        $sql.= "LEFT JOIN horario_semana ";
        $sql.= "ON horario.id = horario_semana.id_horario ";
        $sql.= "LEFT JOIN periodo ";
        $sql.= "ON horario_semana.id = periodo.id_horario_semana ";
        $sql.= "WHERE horario.id = $id"; // Add the id of the horario here
        // Get the horario that corresponds to the passed id
 
        $rows =  $this->_db->getRows($sql);
        
        // Map the SQL result to the actual Horario/HorarioSemana/Periodo
        $this->mapDatabaseToObject($rows);
        

        if ($this->horarioBase > 0) {
            // Yes, this Horario inherits from a base Horario.
            // Read that horario as well.
            $rows = $this->bd->getRows($sql . $this->horarioBase);
            $horarioBase = new Horario();
            $this->mapDatabaseToObject($rows, $horarioBase);
            $this->horarioBase = $horarioBase;
        }
    }
    
    
    function getHorarioSemana($year, $week, $baselineOnNotFound = true) {
        $yearWeek = $year."-".$week;
        $baseHorarioSemana = null;
        foreach ($this->horariosSemana as $hs) {
            if ($hs->getYearWeek() == $yearWeek) {
                return $hs;
            }
            if ($hs->data == null) {
                // Temporarily store the base horario semana which we will
                // return if no exception horarioSemana is found for
                // the given week
                $baseHorarioSemana = $hs;
            }
        }
        if ($baselineOnNotFound) {
            return $baseHorarioSemana;
        }
        return null;
    }

    /**
     * Gets the valid HorarioSemana object for the given week
     *
     * @param string $timestamp            The year of the week
     * @param string $baselineOnNotFound   Whether or not to return the baseline / baseweek if
     *                                     no HorarioSemana exception for the given time is found.
     * @return HorarioSemana               The valid HorarioSemana object for the given week.
     *                                     It can be an exception HorarioSemana if one is found
     *                                     or it will be the base HorarioSemana otherwise.
     */
    function getHorarioSemanaByTimestamp($timestamp, $baselineOnNotFound = true) {
        $year = date("Y", $timestamp);
        $week = date("W", $timestamp);
        return $this->getHorarioSemana($year, $week, $baselineOnNotFound);
    }

    function getHorarioSemanaCurrent() {
	    return $this->getHorarioSemanaByTimestamp(time());
    }
        
        
    function isContinuouslyOpenToday() {
        $currWeek = $this->getHorarioSemanaCurrent();
        if ($currWeek == null) {
    	    return false;
        }
        return $currWeek->isContinuouslyOpenToday();
    }

    private function mapDatabaseToObject($rows, $horarioTarget = null) {

        if ($horarioTarget == null) {
            $horarioTarget = $this;
        }

        if (empty($rows)) {
            return false;
        }

        // First set up the Horario
        $firstRow = $rows[0];
        $horarioTarget->id = $firstRow['horario_id'];
        // The horario from which this horario inherits might or might not exist.
        // Here we temporarily store the id and later this method's caller
        // will have to load the actual Horario object and store it in here.
        $horarioTarget->horarioBase = $firstRow['horario_id_horario_base'];
        $horarioTarget->horariosSemana = array();
        $horarioTarget->listavel = $firstRow['horario_listavel'];
        $horarioTarget->nome = $firstRow['horario_nome'];

        // Store the horarioSemana objects indexed by their ids
        $readHorarioSemanaIds = array();

        foreach ($rows as $row) {
            // Each row has
            // - the same horario information -> ignore
            // - all the different horariSemana information
            // - all the different periodo information


            if ($row['horario_semana_id'] == null) {
                // for some weird reason there is no horarioSemana in this
                // result row, ignore it
                continue;
            }

            if (isset($readHorarioSemanaIds[$row['horario_semana_id']])) {
                // we already read and stored this HorarioSemana object
                $horarioSemana = $readHorarioSemanaIds[$row['horario_semana_id']];
            }
            else {
                $horarioSemana = new HorarioSemana();
                $horarioSemana->setId($row['horario_semana_id']);
                $horarioSemana->setData($row['horario_semana_start_date']);
                $horarioSemana->setHorario($horarioTarget);

                $horarioTarget->horariosSemana[] = $horarioSemana;

                // Indicate that this horarioSemana has already been read and stored
                $readHorarioSemanaIds[$row['horario_semana_id']] = $horarioSemana;
            }

            if ($row['periodo_id'] != null) {
                // Only create and add the periodo if the current
                // HorarioSemana actually has periods. Although it
                // should always have at least one period.

                $periodo = new Periodo();
                $periodo->setId($row['periodo_id']);
                $periodo->setDiaInteiro($row['periodo_dia_inteiro']);
                $periodo->setInicio($row['periodo_inicio']);
                $periodo->setFim($row['periodo_fim']);
                $periodo->setDia($row['periodo_dia']);
                $periodo->setTipo(($row['periodo_tipo']));
                $periodo->setHorarioSemana($horarioSemana);

                $horarioSemana->addPeriodo($periodo);
            }

        }
    }
        
}

?>
