<?php  

class Services extends MethodBase {

    var $validate = array(
        '_all_' => array(
        // validation rules that apply to all requests
        ),
        'listQueue' => array(// validation rules that apply only to listQueue()
            'service_id' => array(
                'alphaNumeric' => array(
                    'rule' => 'alphaNumeric',
                    'required' => true,
                    'message' => 'Alphabets and numbers only'
                )
            ),
            'status' => array(
                'allowedChoice' => array(
                    'rule' => array('inList', array('waiting', 'suspended', 'withdrawn')),
                    'message' => 'Status must be either waiting, suspended or withdrawn.'
                )
            )
        )
    );

    function Services() {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
        $this->_db = new AcessoBD($conn);
    }

    function validate($requestObject) {
        // parent::validate(requestObject);
        // Match the requestObject params against the $this->validate array
    }

    function listQueue($requestObject) {
        // List the queue according to the received parameters
        // SELECT * FROM senhas WHERE servico_destino = $requestObject->params['service_id'];
        // Create a JSON object representing the query result
        // Create a ReturnObject
        // Set the ReturnObject fields and set the JSON object as its body
        // return $returnObject;
    }

    function getServices($ids = array(), $service_type = 'normal') {

        $sql = "SELECT * " .
                "FROM servicos ";
        if (count($ids) > 0) {
            $sql .= " WHERE id_servico IN (" . implode(", ", $ids) . ") ";
        } else if ($service_type != 'all') {
            $sql .= " WHERE tipo_servico = '$service_type' ";
        }

        $result = $this->_db->getRows($sql);

        return $result;
    }

    function getAllServices($service_type = 'normal') {
        return $this->getServices(array(), $service_type);
    }

    function getServiceLocations($service_id, $entity_id = null) {
        if (is_null($entity_id)) {
            $service = $this->getServices(array($service_id));
            $entity_id = $service[0]['id_entidade'];
        }

        $sql = "SELECT l.id_loja, l.nome " .
                "FROM lojas AS l " .
                "INNER JOIN lojas_entidades AS le ON le.id_loja = l.id_loja " .
                "WHERE le.id_entidade = " . $entity_id;
        $result = $this->_db->getRows($sql);

        return $result;
    }

    function getQueueSize($service_id, $location_id) {

        $sql = "SELECT COUNT(*) AS queuesize " .
                "FROM senhas " .
                "WHERE	data = CURDATE() AND " .
                "	servico_destino = $service_id AND " .
                "	id_loja = $location_id AND " .
                "	status = '" . SENHA_EMISSAO . "' ";
        $result = $this->_db->getRows($sql);

        return $result['queuesize'];
    }

    function getAverageWaitingTime($service_id, $location_id) {

        $sql = "SELECT AVG(tempo_espera) AS avg_tempo_espera " .
                "FROM senhas " .
                "WHERE	data = CURDATE() AND " .
                "	servico_destino = $service_id AND " .
                "	id_loja = $location_id AND " .
                "	(	status = '" . SENHA_CHAMADA . "' OR " .
                "		status = '" . SENHA_RECHAMADA . "' OR " .
                "		status = '" . SENHA_SUSPENSA . "' OR " .
                "		status = '" . SENHA_TERMINADA . "' OR " .
                "		status = '" . SENHA_REDIRECCAO . "' OR " .
                "		status = '" . SENHA_DESISTIDA . "') AND " .
                "	emissao > DATE_SUB(NOW(), INTERVAL 1 HOUR) ";
        $rs = $this->_db->executarSQL($sql);
        $result = $this->_db->obterRegisto($rs);
        if (!isset($result['avg_tempo_espera']) || $result['avg_tempo_espera'] == null) {
            return "";
        }

        return $result['avg_tempo_espera'];
    }

    function getAvailableServicesInServiceDesk($id_balcao) {
        require_once("Horario.php");

        $diaSemana = date("N") + 1; // 2 (Segunda) a 8 (Domingo)
        if ($diaSemana == 7)
            $diaSemana = 0; // sabado
        if ($diaSemana == 8)
            $diaSemana = 1; // domingo	
        $diaAnterior = ($diaSemana == 0) ? 6 : ($diaSemana - 1);

        $sql = "select sb.id_servico id, s.nome nome, s.prioridade prioridade, e.nome entidade, sb.servico_prioritario, s.horario as id_horario ";
        $sql.= "from servicos_balcao sb
					inner join servicos s on sb.id_servico=s.id_servico
					inner join entidades e on e.id_entidade = s.id_entidade
					where sb.id_balcao='" . $id_balcao . "'";

        $rs = $this->_db->getRows($sql);
        $servicos = array();

        for ($i = 0; $i < count($rs); $i++) {

            $servicos[] = Array('id' => $rs[$i]["id"], 'nome' => $rs[$i]["nome"], 'prioridade' => $rs[$i]["prioridade"], 'entidade' => $rs[$i]["entidade"], 'servico_prioritario' => $rs[$i]["servico_prioritario"], 'id_horario' => $rs[$i]["id_horario"]);

            $horario = new Horario1(); 
            $horario->get($servicos[$i]["id_horario"]);
            $servicos[$i]["24h"] = $horario->isContinuouslyOpenToday();
            
        }

        return $servicos;
    }

    function Is24HourService($servico) {
        require_once './Terminal/horarios/Horario.class.php';

        $sql = "SELECT s.horario As id_horario " .
                "FROM servicos AS s " .
                "WHERE s.id_servico = " . $servico;

        $res = $this->_db->getRows($sql);
        $idHorario = $res[0]["id_horario"];
        $horario = new Horario();
        $horario->get($idHorario);

        if ($horario->isContinuouslyOpenToday()) {
            return 1;
        }
        return 0;
    }

    function openService($id_servico) {
        require_once 'ServiceActivityLog.php';

        $log_actividade = new ServiceActivityLog();

        if ($log_actividade->estadoServico($id_servico) == "Abertura")
            $rs = $log_actividade->fechaServico();
        else
            $rs = $log_actividade->abreServico($id_servico);
        $_SESSION['sessao_servico'] = $id_servico;
    }

    function GetRedirectionServiceList($id_service) {
        $sql = "select id_servico as id, nome, prioridade from servicos inner join servicos_redireccao on servicos_redireccao.destination_id=servicos.id_servico where servicos_redireccao.source_id=" . $id_service;
        $res = $this->_db->getRows($sql);
        $servicos = array();
        $i = 0;
        while ($i < count($res)) {
            $servicos[] = $res[$i];
            $i++;
        }
        return $servicos;
    }

    function isAllowedInServiceDesk($id_service, $id_service_desk) {

        $sql = "select count(*) as num_results from servicos_balcao where id_balcao=$id_service_desk and id_servico=$id_service";
        $rs = $this->_db->getRows($sql);
        if ($rs[0]['num_results'] > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function isRedirectionValid($id_service, $id_destination_service) {

        $sql = "select count(*) as num_results from servicos_redireccao where source_id=$id_service and destination_id=$id_destination_service";
        $rs = $this->_db->getRows($sql);
        if ($rs[0]['num_results'] > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function getAvailableServicesInServiceDeskAllData($id_loja) {
        require_once("Tickets.php");
        require_once("Services.php");

        $diaSemana = date("N") + 1; // 2 (Segunda) a 8 (Domingo)
        if ($diaSemana == 7)
            $diaSemana = 0; // sabado
        if ($diaSemana == 8)
            $diaSemana = 1; // domingo  
        $diaAnterior = ($diaSemana == 0) ? 6 : ($diaSemana - 1);

        $ticket = new Tickets();
        $service = new Services();

        $sql = "select s.id_servico id, s.nome nome, s.prioridade prioridade, e.nome entidade, s.horario as id_horario, se.numero_senha as numero_senha_ultima_chamada, COUNT(seespera.id_senha) as em_espera ";//
        $sql.= "from servicos s 
                    inner join entidades e on e.id_entidade = s.id_entidade
                    left join senhas se on se.id_senha = (select max(id_senha) from senhas se1 where se1.servico_destino = s.id_servico and se1.data = curdate() and (se1.status='Terminado' or se1.status='Suspensa' or se1.status='Redireccao' or se1.status='Desistencia') ) 
                    left join senhas seespera on seespera.id_senha in (select id_senha from senhas se2 where se2.servico_destino = s.id_servico and se2.data = curdate() and se2.status='Emissao' ) 
                              
                    group by s.id_servico, se.numero_senha
                    order by s.id_servico
                    ";
//where sb.id_balcao='" . $id_balcao . "' 
        $rs = $this->_db->getRows($sql);
        $servicos = array();

        for ($i = 0; $i < count($rs); $i++) {
            $queue_list = array();
            $suspended_list = array();
            $folded_list = array();
            $redirect_list = array();
            $desk_list = array();

            if(isset($rs[$i]["em_espera"]) && intval($rs[$i]["em_espera"]) > 0)
                $queue_list = $ticket->GetListaDeEspera($id_loja, $rs[$i]["id"]);

            $last_ticket = $ticket->getLastCalledTicket($id_loja, $rs[$i]["id"]);

            $suspended_list = $ticket->listSuspendedTicketsToday($rs[$i]["id"], $id_loja);
            $folded_list = $ticket->listFoldedTicketsToday($rs[$i]["id"], $id_loja);
            $redirect_list = $service->GetRedirectionServiceList($rs[$i]["id"]);
            $desk_list = $service->getDesksWithService($rs[$i]["id"]);

            $servicos[] = Array('id' => $rs[$i]["id"], 'nome' => $rs[$i]["nome"], 'prioridade' => $rs[$i]["prioridade"], 'entidade' => $rs[$i]["entidade"], 'servico_prioritario' => $rs[$i]["servico_prioritario"], 'id_horario' => $rs[$i]["id_horario"], 'numero_senha_ultima_chamada' => $rs[$i]["numero_senha_ultima_chamada"], 'em_espera' => $rs[$i]["em_espera"], 'lista_espera' => $queue_list, 'ultima_chamada' => $last_ticket, 'senhas_suspensas' => $suspended_list, 'senhas_canceladas' => $folded_list, 'redirect_lista' => $redirect_list,
                'balcoes_lista' => $desk_list
            );

            $horario = new Horario1(); 
            $horario->get($servicos[$i]["id_horario"]);
            $servicos[$i]["24h"] = $horario->isContinuouslyOpenToday();


        }

        return $servicos;
    }

    function getDesksWithService($id_servico) {

        $sql = "select sb.id_balcao as id ";
        $sql.= "from servicos_balcao sb
                    inner join servicos s on sb.id_servico=s.id_servico
                    inner join entidades e on e.id_entidade = s.id_entidade
                    where sb.id_servico='" . $id_servico . "'";

        return $this->_db->getRows($sql);
    }

     

}

?>
