<?php  

class Tickets extends MethodBase {

    function Tickets() {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
        $this->_db = new AcessoBD($conn);
    }

    function my_real_escape_string($text) {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $mysqli = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
        return $mysqli->real_escape_string($text);
    }

    private function callTicket($id_loja, $id_servico, $id_senha = 0) {
        $senhas = new Senhas;
        if ($id_senha == 0)
            $senhas->GetIdProximaSenha($id_loja, $id_servico);

        $result = $this->_db->executarSQL('select id_colaborador from senhas WHERE id_senha=' . $id_senha);
        $tuplo = $this->_db->obterRegisto($result);
        if (count($tuplo) == 1) {
            $senhas->ChamaSenha($senha, $this->request->params['counter_id'], $tuplo['id_colaborador']);
            $senhas->TerminaSenha($senha, 'Terminado');

            $logatendimento = new LogAtendimento;
            $logatendimento->notificarServidorCentral($senha); // envia o CHMDSENHA
            return TRUE;
        }
        return FALSE;
    }

    function callNext() {
        $sql = 'SELECT b.id_loja loja, sb.id_servico servico FROM balcoes b JOIN servicos_balcao sb ON b.id_balcao=sb.id_balcao';
        if (!empty($this->request->params['counter_id']))
            $sql.=' AND b.id_balcao=' . $this->request->params['counter_id'];
        $sql.=' LIMIT 1';
        $result = $this->_db->executarSQL($sql);
        $tuplo = $this->_db->obterRegisto($result);
        if (count($tuplo) > 0) {
            if (!$this->callTicket($tuplo['loja'], $tuplo['servico']))
                $this->response->setStatus(304);
        }
        else
            $this->response->setStatus(404);
        return $this->response;
    }

    function callByService() {
        if (!empty($this->request->params['ticket_id'])) {
            if (!$this->callTicket(0, 0, $this->request->params['ticket_id']))
                $this->response->setStatus(304);
        }
        else {
            if (!empty($this->request->params['service_id'])) {
                $result = $this->_db->executarSQL('SELECT b.id_loja loja FROM balcoes b JOIN servicos_balcao sb ON b.id_balcao=sb.id_balcao AND sb.id_servico=' . $this->request->params['service_id'] . ' LIMIT 1');
                $tuplo = $this->_db->obterRegisto($result);
                if (count($tuplo) > 0) {
                    if (!$this->callTicket($tuplo['loja'], $this->request->params['service_id']))
                        $this->response->setStatus(304);
                }
                else
                    $this->response->setStatus(304);
            }
            else
                $this->response->setStatus(304);
        }
        return $this->response;
    }

    function setState() {
        $states =
                array
                    (
                    'suspended' => 'Suspensa',
                    'withdrawn' => 'Desistencia',
                    'terminated' => 'Terminado'
        );
        $senhas = new Senhas;
        $state = strtr(strtolower($this->request->params['status']), $states);
        if (in_array($state, $states))
            $senhas->SetStatus_Terminal($this->request->params['ticket_id'], $state, false);
        else
            $this->response->setStatus(400);
        return $this->response;
    }

    function getTicketByCode($ticketCode) {
        $sql = "SELECT	senhas.id_senha AS senhas_id_senha, " .
                "	senhas.servico_destino AS senhas_servico_destino, " .
                "	servico_destino.nome AS servico_destino_nome, " .
                "	servico_emissao.tipo_servico AS servico_emissao_tipo_servico, " .
                "	senhas.id_senha_agendamento AS senhas_id_senha_agendamento, " .
                "	senhas.numero_senha AS senhas_numero_senha, " .
                "	servico_emissao.identificador AS servico_emissao_identificador, " .
                "	senhas.scheduled AS senhas_scheduled, " .
                "	UNIX_TIMESTAMP(senhas.scheduled) AS senhas_scheduled_timestamp, " .
                "	senhas.status AS senhas_status, " .
                "	senhas.nome_cliente AS senhas_nome_cliente, " .
                "	senhas.observacoes AS senhas_observacoes " .
                "FROM senhas AS senhas " .
                "INNER JOIN servicos AS servico_destino ON servico_destino.id_servico = senhas.servico_destino " .
                "INNER JOIN servicos AS servico_emissao ON servico_emissao.id_servico = senhas.servico_emissao " .
                "WHERE senhas.id_senha = $ticketCode";
        //$ticket = $this->_db->executarSQL($sql);
        //$result = $this->_db->obterRegisto($ticket);
        $result = $this->_db->getRows($sql);

        return $result;
    }

    function createTicket($ticket) {

        $sql = "INSERT INTO senhas (data, numero_senha, id_loja, servico_emissao, servico_destino, emissao, status, observacoes, data_string, nome_cliente, scheduled) " .
                "VALUES (" .
                "	CURDATE(), " .
                "	$ticket[numero_senha], " .
                "	$ticket[id_loja], " .
                "	$ticket[servico_emissao], " .
                "	$ticket[servico_destino], " .
                "	NOW(), " .
                "	'$ticket[status]', " .
                "	'$ticket[observacoes]', " .
                "	CURDATE(), " .
                "	'$ticket[nome_cliente]', " .
                "	'$ticket[scheduled]' " .
                ")";
        $res = $this->_db->executarSQL($sql);

        return $this->_db->lastInsertId();
    }

    function getLastCalledTicket($id_loja, $servico_destino, $is24 = false) {

        $sql = "select max(s.id_senha) max from senhas as s inner join servicos AS se ON se.id_servico = s.servico_emissao where s.id_loja='" . $id_loja . "'
            and s.servico_destino='" . $servico_destino . "'
            and se.tipo_servico != 'agendamentos' 
            and (s.status='Terminado' or s.status='Suspensa' or s.status='Redireccao' or s.status='Desistencia') ";
        if (!$is24)
            $sql .= "and (s.data = curdate() OR s.data = date_add(curdate(), INTERVAL -1 DAY))";
        else
            $sql .= "and data = curdate()";

        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);

        
        $maxSenha = $rs["max"];
        $identificador = $rs["identificador"];

        $sql = "select id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status, se.identificador
            from senhas as s inner join servicos as se ON s.servico_emissao = se.id_servico 
            where id_senha='" . $maxSenha . "'";

        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);
        return $rs;
    }

    function getCurrentTicket($id_loja, $servico_emissao, $numero_senha) {
        $sql = "select id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status, nome_cliente
			from senhas
			where id_loja='" . $id_loja . "'
			and servico_emissao='" . $servico_emissao . "'
			and numero_senha='" . $numero_senha . "'
			and (status='Chamada' or status='Rechamada')
			order by emissao desc limit 1";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);
        return $rs;
    }

    function getNextIssuedTicketNumber($id_loja, $servico_emissao) {
        $sql = "SELECT IF(MAX(numero_senha) IS NULL, 1, (MAX(numero_senha) + 1)) AS numero_senha
			FROM senhas
			WHERE data = CURRENT_DATE()
			AND servico_emissao = '" . $servico_emissao . "'
			AND servico_emissao = servico_destino
			AND id_loja = '" . $id_loja . "'";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);
        return $rs["numero_senha"];
    }

    function GetLastFinishedTicket($balcao) {
        $sql = "select max(id_senha) max from senhas where id_balcao='" . $balcao . "'
			and status='Terminado' and (data = curdate() OR data = date_add(curdate(), INTERVAL -1 DAY))";

        $res = $this->_db->Query($sql);
        return $res[0]["max"];
    }

    function getNextTicketId($id_loja, $servico_destino, $is24 = false) {
        $sql = "select min(id_senha) id_senha
            from senhas
            where id_loja='" . $id_loja . "'
            and servico_destino='" . $servico_destino . "'
            and status='Emissao' ";
        if ($is24)
            $sql .= "and (data = curdate() OR data = date_add(curdate(), INTERVAL -1 DAY))";
        else
            $sql .= "and data = curdate()";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);
        return $rs["id_senha"];
    }

    function GetListaDeEspera($id_loja, $servico_destino, $is24 = false) {
        // aqui estou a negligenciar o tempo de atendimento de uma senha redireccionada (tempo de espera = tempo decorrido desde a emissao até agora)
        $sql = "select t.id_senha, t.emissao, t.numero_senha, t.servico_emissao, t.data, t.id_dispensador, t.servico_destino, t.id_loja, t.status, t.observacoes observacoes, t.nome_cliente nome_cliente,
			timediff(now(), t.emissao) tempo_espera,
			sec_to_time(time_to_sec(timediff(now(), t.emissao))*s.prioridade) tempo_espera_alt,
			t.scheduled, s.identificador
			from senhas t
			inner join servicos s on s.id_servico=t.servico_emissao
			where t.id_loja='" . $id_loja . "'";

        if (is_array($servico_destino)) {
            $sArr = implode(", ", $servico_destino);
            $sql .= " and t.servico_destino in (" . $sArr . ")";
        } else {
            $sql .= " and t.servico_destino='" . $servico_destino . "'";
        }
        $sql .= " and t.status='Emissao'";
        if ($is24)
            $sql .= " and (t.data = curdate() OR t.data = date_add(curdate(), INTERVAL -1 DAY))";
        else
            $sql .= " and t.data = curdate()";
        $sql .= " order by scheduled DESC, tempo_espera_alt desc";
        
        
        return $this->_db->getRows($sql);
    }

    function issueTicketNow($id_loja, $servico_emissao, $servico_destino, $observacoes = "", $nome_cliente = null, $numero_senha=0) {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $mysqli = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);        

        if (!$numero_senha) $numero_senha = $this->getNextIssuedTicketNumber($id_loja, $servico_destino);

        $sql = "lock tables senhas write";
        $this->_db->executarSQL($sql);

        $sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, servico_destino, emissao, tempo_espera, status, observacoes, nome_cliente)
            values (
                curdate(),
                '" . $numero_senha . "',
                '" . $id_loja . "',
                '" . $servico_emissao . "',
                '" . $servico_destino . "',
                now(),
                '00:00:00',
                'Emissao',
                '" . $mysqli->real_escape_string($observacoes) . "',
                '$nome_cliente')";
             
        $this->_db->executarSQL($sql);

        $sql = "select * from senhas
			order by id_senha desc limit 1";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);

        $sql = "unlock tables";
        $this->_db->executarSQL($sql);
        return $rs;
    }

   
    function issueTicketNowTest($id_loja, $servico_emissao, $servico_destino, $observacoes = "", $nome_cliente = null, $numero_senha=0) {

        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $mysqli = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);        

        if (!$numero_senha) $numero_senha = $this->getNextIssuedTicketNumber($id_loja, $servico_destino);

        $sql = "lock tables senhas write";
        $this->_db->executarSQL($sql);

        $sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, servico_destino, emissao, tempo_espera, status, observacoes, nome_cliente)
            values (
                curdate(),
                '" . $numero_senha . "',
                '" . $id_loja . "',
                '" . $servico_emissao . "',
                '" . $servico_destino . "',
                now(),
                '00:00:00',
                'Emissao',
                '" . $mysqli->real_escape_string($observacoes) . "',
                '$nome_cliente')";
                
        $this->_db->executarSQL($sql);

        $sql = "select * from senhas
            order by id_senha desc limit 1";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);

        $sql = "unlock tables";
        $this->_db->executarSQL($sql);

        //SendPush Notifications
        //"createTime": "2023-04-03T09:06:30.127202Z",
        $str_time = date('Y') . '-' . date('m') . '-' . date('d') . 'T' . date('H') . ':' . date('i') . ':' . date('s') . '.127202Z';

        $firestore_data  = [
            "numero_senha" => ["stringValue" => "A6"],
           "createMoment" => ["timestampValue" => $str_time ]      
        ];
        $data = ["fields" => (object)$firestore_data];

        $json = json_encode($data);
        //$Enter your firestore unique key: below is a sample
        $firestore_key = "AIzaSyC539pz4C_nzYZqsmq_vxGyRpZdVjaC8MA";
        #Provide your firestore project ID Here
        $project_id = "zqueue-api";

        $str=rand(20,20);
        $result = md5($str);
        $object_unique_id = substr($result, 0, 20);// random_int(1,300);

        $url = "https://firestore.googleapis.com/v1beta1/projects/zqueue-api/databases/(default)/documents/users";

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
           
            CURLOPT_URL => $url . '?key='.$firestore_key,

        ));

        $response = curl_exec( $curl );

        curl_close( $curl );

        // Show result
        //echo $response . "\n";

        $users = json_decode($response, true);
      
        foreach($users['documents'] as $key=>$value) {            
            $pushToken = $value['fields']["expoPushToken"]["stringValue"]; 
            echo $pushToken;
            echo 'inti';
            $payload = array(
            'to' => $pushToken,
            'sound' => 'default',
            'body' => 'Nova senha: ' . $numero_senha,
            );
            $curl = curl_init();

            curl_setopt_array($curl, array(
              CURLOPT_URL => "https://exp.host/--/api/v2/push/send",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "POST",
              CURLOPT_POSTFIELDS => json_encode($payload),
              CURLOPT_HTTPHEADER => array(
                "Accept: application/json",
                "Accept-Encoding: gzip, deflate",
                "Content-Type: application/json",
                "cache-control: no-cache",
                "host: exp.host"
              ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            /*if ($err) {
              echo "cURL Error #:" . $err;
            } else {
              echo $response;
            }*/
        }

        return $rs;       
        
        
    }

    function insetTicketinFirestore($id_loja, $servico_emissao, $servico_destino, $observacoes = "", $nome_cliente = null, $numero_senha=0) {
        echo 'init';
        //"createTime": "2023-04-03T09:06:30.127202Z",
        $str_time = date('Y') . '-' . date('m') . '-' . date('d') . 'T' . date('H') . ':' . date('i') . ':' . date('s') . '.127202Z';

        $firestore_data  = [
            "numero_senha" => ["stringValue" => "A6"],
           "createMoment" => ["timestampValue" => $str_time ]      
        ];
        $data = ["fields" => (object)$firestore_data];

        $json = json_encode($data);
        //$Enter your firestore unique key: below is a sample
        $firestore_key = "AIzaSyC539pz4C_nzYZqsmq_vxGyRpZdVjaC8MA";
        #Provide your firestore project ID Here
        $project_id = "zqueue-api";

        $str=rand(20,20);
        $result = md5($str);
        $object_unique_id = substr($result, 0, 20);// random_int(1,300);

        $url = "https://firestore.googleapis.com/v1beta1/projects/zqueue-api/databases/(default)/documents/tickets/".$object_unique_id;

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array('Content-Type: application/json',
                'Content-Length: ' . strlen($json),
                'X-HTTP-Method-Override: PATCH'),
            CURLOPT_URL => $url . '?key='.$firestore_key,
            CURLOPT_USERAGENT => 'cURL',
            CURLOPT_POSTFIELDS => $json
        ));

        $response = curl_exec( $curl );

        curl_close( $curl );

        // Show result
        echo $response . "\n";


        
    }

    
    function callTicketNow($id_senha, $id_balcao, $id_colaborador) {
        $sql = "lock tables senhas write";
        $this->_db->executarSQL($sql);

        $sql = "update senhas set
			tempo_espera = '" . $this->GetTempoEsperaAtendimento($id_senha) . "',
			id_balcao = '" . $id_balcao . "',
			id_colaborador = '" . $id_colaborador . "',
			status = 'Chamada' where id_senha = '" . $id_senha . "'
			and status!='Chamada'
			and status!='Rechamada'";
        
        $res = $this->_db->executarSQL($sql);

        if ($res) {
            $ret = true;
        } else {
            $ret = false;
        }
        $sql = "unlock tables";
        $this->_db->executarSQL($sql);

        return $ret;
    }

    function getTicket($id) {
        //$sql = "select id_senha, emissao, numero_senha, servico_emissao, id_dispensador, servico_destino, id_loja, status, observacoes, nome_cliente, if(CURDATE() = data, 1, 0) as issued_today
		//	from senhas where id_senha=$id";
        $sql = "select id_senha, emissao, numero_senha, se.identificador, servico_emissao, id_dispensador, servico_destino, id_loja, status, observacoes, nome_cliente, tempo_espera, if(CURDATE() = data, 1, 0) as issued_today, sd.id_form from senhas as s inner join servicos as se ON s.servico_emissao = se.id_servico 
            inner join servicos as sd ON s.servico_destino = sd.id_servico
            where id_senha=$id";
 
        $res = $this->_db->executarSQL($sql);
        $result = $this->_db->obterRegisto($res);
        
        $result['code']=$this->getTicketCode($id);

        return $result;
    }

    function getNextTicket($id, $n_next_ticket) {
        //$sql = "select id_senha, emissao, numero_senha, servico_emissao, id_dispensador, servico_destino, id_loja, status, observacoes, nome_cliente, if(CURDATE() = data, 1, 0) as issued_today
        //  from senhas where id_senha=$id";
        $sql = "select id_senha, emissao, numero_senha, se.identificador, servico_emissao, id_dispensador, servico_destino, id_loja, status, observacoes, nome_cliente, tempo_espera, if(CURDATE() = data, 1, 0) as issued_today, se.id_form from senhas as s inner join servicos as se ON s.servico_destino = se.id_servico where id_senha=$id";
 
        $res = $this->_db->executarSQL($sql);
        $result = $this->_db->obterRegisto($res);

        $numero = intval($result['numero_senha']) + intval($n_next_ticket);
        $identificador = $result['identificador'];

        $sql = "select id_senha, numero_senha, se.identificador, numero from senhas as s inner join servicos as se ON s.servico_destino = se.id_servico where data = CURDATE() and se.identificador = '$identificador' and numero_senha = $numero  ";

        $res = $this->_db->executarSQL($sql);
        $result = $this->_db->obterRegisto($res);
        

        //if($result)
        //{
        //    if($result['numero'])
        //        return $result['numero'];
        //}

        return $result;
    }

    function GetTempoEsperaAtendimento($id_senha, $espera = true) {
        
        $sql = "select tempo_espera, tempo_atendimento from senhas where id_senha='" . $id_senha . "'";
        $rs = $this->_db->executarSQL($sql);
        
        $res = $this->_db->obterRegisto($rs);

        $tempo_espera = ($res) ? $res["tempo_espera"] : "00:00:00";
        $tempo_atendimento = ($res) ? $res["tempo_atendimento"] : "00:00:00";

        $sql = "select sec_to_time(
			" . (($espera && $tempo_espera) ? "time_to_sec(tempo_espera) + " : (!$espera && $tempo_atendimento ? "time_to_sec(tempo_atendimento) + " : "")) . "
			timestampdiff(
				second,
				timestampadd(
					second,
					time_to_sec(" . ($tempo_espera ? "tempo_espera" : "'00:00:00'") . ") + time_to_sec(" . ($tempo_atendimento ? "tempo_atendimento" : "'00:00:00'") . "),
					timestamp(emissao)),
				now())) as tempo from senhas where id_senha='" . $id_senha . "'";
        //debug("espera: ".$sql);
        $rs = $this->_db->executarSQL($sql);
        $res = $this->_db->obterRegisto($rs);
        return ($res) ? $res["tempo"] : 0;
    }

    function addNotesToTicket($id_ticket, $notes) {
        $sql = "update senhas set observacoes='$notes' WHERE id_senha = $id_ticket";
        $res = $this->_db->executarSQL($sql);
    }

    function terminateTicket($ticket_id) {

        $sql = "UPDATE senhas SET tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($ticket_id, false) . "', status = 'Terminado' where id_senha = $ticket_id";

        $res = $this->_db->executarSQL($sql);
        if ($res) {
            return $this->getTicket($ticket_id);
        } else {
            return false;
        }
    }

    

    function redirectTicket($ticket_id) {

        $sql = "update senhas set tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($ticket_id, false) . "', status = 'Redireccao' where id_senha = $ticket_id";
        $res = $this->_db->executarSQL($sql);
        if ($res) {
            return $this->getTicket($ticket_id);
        } else {
            return false;
        }
    }

    function listSuspendedTickets($service_id) {
        $sql = "SELECT id_senha, emissao, numero_senha, data, servico_emissao, servico_destino, id_loja, status, observacoes
				from senhas
				WHERE servico_destino = $service_id
				AND status='Suspensa'" .
                " AND id_loja=" . $_SESSION['sessao_loja'] .
                " ORDER BY emissao DESC";

        return $this->_db->getRows($sql);
    }

    function listFoldedTickets($service_id) {
        $sql = "SELECT id_senha, emissao, numero_senha, data, servico_emissao, servico_destino, id_loja, status, observacoes
				FROM senhas
				WHERE servico_destino = " . $service_id . "
				AND status='Desistencia'" .
                " AND id_loja=" . $_SESSION['sessao_loja'] .
                " ORDER BY emissao DESC";

        return $this->_db->getRows($sql);
    }

    function recallTicket($ticket_id) {

        $sql = "update senhas set tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($ticket_id, false) . "', status = 'Rechamada' where id_senha = $ticket_id";
        $res = $this->_db->executarSQL($sql);
        if ($res) {
            return $this->getTicket($ticket_id);
        } else {
            return false;
        }
    }

    function suspendTicket($id_ticket) {
        $sql = "update senhas set
            tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($id_ticket, false) . "',
            status = 'Suspensa'
            where id_senha = $id_ticket";
        $res = $this->_db->executarSQL($sql);
        if ($res) {
            return $this->getTicket($id_ticket);
        } else {
            return false;
        }
    }

    function foldTicket($ticket_id) {

        $sql = "update senhas set
            tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($ticket_id, false) . "',
            status = 'Desistencia'
            where id_senha = $ticket_id";
        $res = $this->_db->executarSQL($sql);
        if ($res) {
            return $this->getTicket($ticket_id);
        } else {
            return false;
        }
    }

    function callFoldedTicket($ticket_id) {
        $sql = "SELECT id_senha	FROM senhas WHERE id_senha = $ticket_id AND status='Desistencia' ORDER BY emissao DESC LIMIT 1";

        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);

            $id_senha = $rs["id_senha"];

            $sql = "update senhas
				set emissao=TIMESTAMPADD(
					second, 
					-time_to_sec(if(tempo_espera,tempo_espera,'00:00:00')), 
					now()),
				tempo_atendimento=null
				where id_senha='" . $ticket_id . "'";
            $res = $this->_db->executarSQL($sql);
            if ($res) {
                return true;
            } else {
                return false;
            }
        
    }

    function AnulaSenhasPenduradasPorColaborador($utilizador) {
        $sql = "update senhas
			set status='Anulada'
			where (status='Chamada' or status='Rechamada')
			and id_colaborador='" . $utilizador . "'";

        $res = $this->_db->executarSQL($sql);
    }

    function isForService($ticket_id, $service_id) {
        $sql = "select count(*) as num_results from senhas where id_senha=$ticket_id and servico_destino=$service_id";

        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);

        if ($rs['num_results'] > 0) {
            return true;
        } else {
            return false;
        }
    }

    function getTicketCode($id_ticket) {
   
        $sql = "select senhas.id_senha, senhas.servico_emissao, senhas.numero_senha, servicos.identificador from senhas inner join servicos on senhas.servico_emissao=servicos.id_servico where senhas.id_senha=$id_ticket";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);
        $ticket_code='';
        $ticket_number=$rs['numero_senha'];
        if(strlen($ticket_number) < TICKET_MAX_DIGITS){
           $ticket_number=str_pad($ticket_number, TICKET_MAX_DIGITS, '0', STR_PAD_LEFT);
        }

        switch (TICKET_FORMAT) {
            case 'service_id__ticket_number':
                $ticket_code=$rs[0]['identificador'].$ticket_number;
                break;
            case 'service_id__place_id__ticket_number':
                //$ticket_code=$rs[0]['identificador'].$ticket_number;
                break;
            default:
                break;
        }
        return $ticket_code;
    }
    
    function isRedirectable($id_ticket){
        $sql = "select senhas.servico_destino, servicos.reencaminhavel from senhas inner join servicos on senhas.servico_destino=servicos.id_servico where senhas.id_senha=$id_ticket";
        $res = $this->_db->executarSQL($sql);
        $rs = $this->_db->obterRegisto($res);
        if($rs['reencaminhavel']=='1'){
            return true;
        }else{
            return false;
        }
    }

    function listSuspendedTicketsToday($service_id, $sessao_loja) {
        $sql = "SELECT id_senha, emissao, numero_senha, data, servico_emissao, servico_destino, id_loja, status, observacoes, s.identificador, s.nome
                from senhas as t
                inner join servicos s on s.id_servico=t.servico_emissao
                WHERE t.servico_destino = $service_id
                AND status='Suspensa'
                AND data = curdate() " .
                " AND id_loja=" . $sessao_loja .
                " ORDER BY emissao DESC";

        return $this->_db->getRows($sql);
    }

    function listFoldedTicketsToday($service_id, $sessao_loja) {
        $sql = "SELECT id_senha, emissao, numero_senha, data, servico_emissao, servico_destino, id_loja, status, observacoes, s.identificador, s.nome
                FROM senhas as t
                inner join servicos s on s.id_servico=t.servico_emissao
                WHERE t.servico_destino = $service_id 
                AND status='Desistencia'
                AND data = curdate() " .
                " AND id_loja=" . $sessao_loja .
                " ORDER BY emissao DESC";

        return $this->_db->getRows($sql);
    }

}

?>
