<?php
	
/* Classe de Gestao de Atendimentos em Curso */

class Atendimento
{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Atendimento() {
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	function EstatisticasDoDia($grupo, $subgrupo) {
		$estatistica = new Estatistica();
		$data_actual = date("Y-m-d");
		$limite_inf = $data_actual . " 00:00:00";
		$limite_sup = $data_actual . " 23:59:59";
		// dados para gerar as estatisticas
		$dados = array();
		$dados["inicio"] = $limite_inf;
		$dados["fim"] = $limite_sup;			
		$dados["medidas"] = array("atendimento", "espera", "numero_atendimento", "produtividade");
		$dados["grupo"] = $grupo;
		$dados["subgrupo"] = $subgrupo;	
		// caso exista um filtro para o servico
		if ($_GET["servico"]) {
			$dados["servico"] = $_GET["servico"];
		}
		// gera a estatistica
		//$estatistica->GeraEstatistica($dados);
	}

	
/*
		Escreve no ficheiro indicado um gr�fico
 		de acordo com os valores guar$dados
		nas vari�veis de sess�o.
		
		N�o esquecer de chamar fun��o GeraEstatistica antes.
	*/
	
	//grafico que gera os numeros de senhas atendidas por ora 
	function GeraImagemSenhas($filepath , $data, $hist=false)
	{
		$arrLoja = $_SESSION["sessao_campos"]["lojas_id"];
		$arrServico = $_SESSION["sessao_campos"]["servicos_id"];
		
		$x = array("04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24");
		
		$numservicos = count($arrServico);
		$numlojas = count($arrLoja);
		$chart = new LineChart(1450 , 600);
		
		$stat = new EstatisticaAtendimentos;
		
		for ($i=0; $i<$numlojas; $i++)
		{
			for ($j=0; $j<$numservicos; $j++)
			{
				$gline[$i][$j] = new XYDataSet();
				for ($k=0; $k<count($x)-1; $k++)
				{
					$gline[$i][$j]->addPoint(new Point($x[$k+1] . ":00" , $stat->GetNumeroSenhasChamadasBetweenTime($data, $x[$k] . ":00:00", $x[$k+1] . ":00:00", $hist, $arrLoja[$i], $arrServico[$j])));
				}
			}
		}
		
		unset($stat);

		
		$dataSet = new XYSeriesDataSet();
	 	for($i = 0; $i < $numlojas; $i ++)
		{
			for ($j=0; $j<$numservicos; $j++)
			{
				$dataSet->addSerie(GetNomeServico($arrServico[$j]) . " / " . GetNomeLoja($arrLoja[$i]), $gline[$i][$j]);
			}
		}
		
		$chart->setDataSet($dataSet);
		$chart->setTitle(translate('word_numero_chamadas_hora', true)  .":");
	 	$chart->getPlot()->setGraphCaptionRatio(0.65);		
		$chart->render($filepath);
        
        unset($dataSet);
        unset($chart);
	}

	//~ function GeraImagemSenhas($filepath , $data){	
		//~ $numservicos = count($data);
		//~ $chart = new LineChart(1450 , 600);
		
		//~ for($y = 0; $y < $numservicos; $y ++){
			//~ $serie1[$y] = new XYDataSet();
			//~ for($k = 0; $k<count($data[$y]["calculo"]); $k++)
					//~ $serie1[$y]->addPoint(new Point($data[$y]["calculo"][$k]["ora"].":00" , $data[$y]["calculo"][$k]["emissao"]));
				
		//~ }		
		
		//~ $dataSet = new XYSeriesDataSet();
	 	//~ for($j = 0; $j < $numservicos; $j ++)
			//~ $dataSet->addSerie($data[$j]["nomeservico"]."/".$data[$j]["nomelocal"] , $serie1[$j]);
		
		//~ $chart->setDataSet($dataSet);
		//~ $chart->setTitle("Numero de senhas emitidas por hora:");
	 	//~ $chart->getPlot()->setGraphCaptionRatio(0.65);		
		//~ $path = pathinfo($filepath);
		//~ $chart->render($path["dirname"]."/".basename($filepath,".".$path["extension"])."2".".".$path["extension"]);
	
	
	//~ }
	
	
	//gera o grafico da media de atendimento  de cada serviço  por ora  
	function GeraImagemMediaAtendimento($filepath , $data, $hist=false)
	{
 		$arrLoja = $_SESSION["sessao_campos"]["lojas_id"];
		$arrServico = $_SESSION["sessao_campos"]["servicos_id"];
		
        //~ debug(print_r($arrLoja,true));
        //~ debug(print_r($arrServico,true));
        
		$x = array("04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24");
		
		$numservicos = count($arrServico);
		$numlojas = count($arrLoja);
		$chart = new LineChart(1450 , 600);
		
		$stat = new EstatisticaAtendimentos;
		
		for ($i=0; $i<$numlojas; $i++)
		{
			for ($j=0; $j<$numservicos; $j++)
			{
				$gline[$i][$j] = new XYDataSet();
				for ($k=0; $k<count($x); $k++)
				{
					$gline[$i][$j]->addPoint(new Point($x[$k] . ":00" , GetSecondsFromTimeString($stat->GetTempoMedioAtendimento($arrLoja[$i], $arrServico[$j], $data, "", $hist, $x[0].":00:00", $x[$k].":00:00"))));
				}
			}
		}
		
		unset($stat);

		
		$dataSet = new XYSeriesDataSet();
	 	for($i = 0; $i < $numlojas; $i ++)
		{
			for ($j=0; $j<$numservicos; $j++)
			{
				$dataSet->addSerie(GetNomeServico($arrServico[$j]) . " / " . GetNomeLoja($arrLoja[$i]), $gline[$i][$j]);
			}
		}
		
		$chart->setDataSet($dataSet);
		$chart->setTitle("".translate('word_tempo_medio_atendimento_hora', true).":");
	 	$chart->getPlot()->setGraphCaptionRatio(0.65);		
		$chart->render($filepath);
        
        unset($dataSet);
        unset($chart);
    }
	
    //~ function GeraImagemMediaAtendimento($filepath , $data){	
		//~ $numservicos = count($data);
		//~ $chart = new LineChart(1450 , 600);
		
		//~ for($y = 0; $y < $numservicos; $y ++){
			//~ $serie1[$y] = new XYDataSet();
			//~ for($k = 0; $k<count($data[$y]["calculo"]); $k++){
				//~ if($data[$y]["calculo"][$k]["valorAtendimento"] < 0)
					//~ $serie1[$y]->addPoint(new Point($data[$y]["calculo"][$k]["ora"].":00" , 0));
				//~ else{
					//~ $valor_em_minutos = (int)($data[$y]["calculo"][$k]["valorAtendimento"]/60);
					//~ $serie1[$y]->addPoint(new Point($data[$y]["calculo"][$k]["ora"].":00" , $valor_em_minutos));
				
				//~ }
			//~ }
		//~ }		
		
		//~ $dataSet = new XYSeriesDataSet();
	 	//~ for($j = 0; $j < $numservicos; $j ++)
			//~ $dataSet->addSerie($data[$j]["nomeservico"]."/".$data[$j]["nomelocal"] , $serie1[$j]);
		
		//~ $chart->setDataSet($dataSet);
		//~ $chart->setTitle("Media do tempo de Atendimento em minutos:");
	 	//~ $chart->getPlot()->setGraphCaptionRatio(0.65);		
		//~ $path = pathinfo($filepath);
		//~ $chart->render($path["dirname"]."/".basename($filepath,".".$path["extension"])."1".".".$path["extension"]);
	
	
	//~ }
    
	//gera o grafico da media de espera  de cada serviço  por ora  
 	function GeraImagemMediaEspera($filepath , $data, $hist=false)
	{
 		$arrLoja = $_SESSION["sessao_campos"]["lojas_id"];
		$arrServico = $_SESSION["sessao_campos"]["servicos_id"];
		
        //~ debug(print_r($arrLoja,true));
        //~ debug(print_r($arrServico,true));
        
		$x = array("04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24");
		
		$numservicos = count($arrServico);
		$numlojas = count($arrLoja);
		$chart = new LineChart(1450 , 600);
		
		$stat = new EstatisticaAtendimentos;
		
		for ($i=0; $i<$numlojas; $i++)
		{
			for ($j=0; $j<$numservicos; $j++)
			{
				$gline[$i][$j] = new XYDataSet();
				for ($k=0; $k<count($x); $k++)
				{
					$gline[$i][$j]->addPoint(new Point($x[$k] . ":00" , GetSecondsFromTimeString($stat->GetTempoMedioEspera($arrLoja[$i], $arrServico[$j], $data, "", $hist, $x[0].":00:00", $x[$k].":00:00"))));
				}
			}
		}
		
		unset($stat);

		
		$dataSet = new XYSeriesDataSet();
	 	for($i = 0; $i < $numlojas; $i ++)
		{
			for ($j=0; $j<$numservicos; $j++)
			{
				$dataSet->addSerie(GetNomeServico($arrServico[$j]) . " / " . GetNomeLoja($arrLoja[$i]), $gline[$i][$j]);
			}
		}
		
		$chart->setDataSet($dataSet);
		$chart->setTitle(translate('word_time_for_waiting', true).":");
	 	$chart->getPlot()->setGraphCaptionRatio(0.65);		
		$chart->render($filepath);
        //~ debug('mediaespera' . $filepath);
        
        unset($dataSet);
        unset($chart);
	}
    
    //~ function GeraImagemMediaEspera($filepath , $data)
	//~ {
 		//~ //$calculo = $data[0]["calculo"];
		//~ $numservicos = count($data);
		//~ $chart = new LineChart(1450 , 600);
		
		//~ for($y = 0; $y < $numservicos; $y ++){
			//~ $serie1[$y] = new XYDataSet();
			//~ for($k = 0; $k<count($data[$y]["calculo"]); $k++){
				//~ if($data[$y]["calculo"][$k]["valorEspera"] < 0)
					//~ $serie1[$y]->addPoint(new Point($data[$y]["calculo"][$k]["ora"].":00" , 0));
				//~ else{ 
					//~ $valor_em_minutos = (int) ($data[$y]["calculo"][$k]["valorEspera"]/60);
					//~ $serie1[$y]->addPoint(new Point($data[$y]["calculo"][$k]["ora"].":00" , $valor_em_minutos));
				//~ }
			//~ }
		//~ }		
		
		//~ $dataSet = new XYSeriesDataSet();
	 	//~ for($j = 0; $j < $numservicos; $j ++)
			//~ $dataSet->addSerie($data[$j]["nomeservico"]."/".$data[$j]["nomelocal"] , $serie1[$j]);
		
		//~ $chart->setDataSet($dataSet);
		//~ $chart->setTitle("Media do tempo de espera em minutos:");
	 	//~ $chart->getPlot()->setGraphCaptionRatio(0.65);		
		//~ $path = pathinfo($filepath);
		//~ $chart->render($path["dirname"]."/".basename($filepath,".".$path["extension"])."0".".".$path["extension"]);

	//~ }
	
//Função que gera o grafico da media de atendimento e de espera	
	
	function GeraImagemMedia($filepath, $data='')
	{
		$chart = new VerticalBarChart(1450 , 600);
		$serie1 = new XYDataSet();
		$serie2 = new XYDataSet();

		$arrLoja = $_SESSION["sessao_campos"]["lojas_id"];
		$arrServico = $_SESSION["sessao_campos"]["servicos_id"];
		
		$stat = new EstatisticaAtendimentos;
		
		if (strlen($data))
		{
			for ($i = 0; $i < count($arrServico); $i++)
			{
				if (count($arrLoja) > 1)
				{
					$serie1->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioEsperaFromResumo($data, "", $arrServico[$i]))));
					$serie2->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioAtendimentoFromResumo($data, "", $arrServico[$i]))));
				}
				else
				{
					$serie1->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioEsperaFromResumo($data, $arrLoja[0], $arrServico[$i]))));
					$serie2->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioAtendimentoFromResumo($data, $arrLoja[0], $arrServico[$i]))));
				}
			}
		}
		else
		{
			for ($i = 0; $i < count($arrServico); $i++)
			{
				if (count($arrLoja) > 1)
				{
					$serie1->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioEspera("", $arrServico[$i], date("Y-m-d"))))); //($local="", $servico, $data, $balcao="", $hist=false, $iTime='', $fTime='')
					$serie2->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioAtendimento("", $arrServico[$i], date("Y-m-d")))));
				}
				else
				{
					$serie1->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioEspera($arrLoja[0], $arrServico[$i], date("Y-m-d")))));
					$serie2->addPoint(new Point(GetNomeServico($arrServico[$i]), GetSecondsFromTimeString($stat->GetTempoMedioAtendimento($arrLoja[0], $arrServico[$i], date("Y-m-d")))));
				}
			}
			
			//~ for ($i = 0; $i < count($arrLoja); $i++)
			//~ {
				//~ $local = $arrLoja[$i];
				
				//~ for ($j = 0; $j < count($arrServico); $j++)
				//~ {
					//~ $servico = $arrServico[$j];
					//~ $arrSenhas = $this->GetSenhasDoDia($local, $servico);
					//~ $atendidas[$local][$servico] += $this->GetAtendidas($local, $servico);
					
					//~ for ($k = 0; $k < count($arrSenhas); $k++)
						//~ $tempoAtendimento[$local][$servico] += $this->GetTempoAtendimento($local, $servico, $arrSenhas[$k]);
				
					//~ for ($k = 0; $k < count($arrSenhas); $k++)
						//~ $tempoEspera[$local][$servico] += $this->GetTempoEspera($local, $servico, $arrSenhas[$k]);
				//~ }
			//~ }
			
			//~ for ($i = 0; $i < count($arrLoja); $i++)
			//~ {
				//~ for ($j = 0; $j < count($arrServico); $j++)
				//~ {
					//~ $totalTempoEspera[$arrServico[$j]] += $tempoEspera[$arrLoja[$i]][$arrServico[$j]];
					//~ $totalTempoAtendimento[$arrServico[$j]] += $tempoAtendimento[$arrLoja[$i]][$arrServico[$j]];
					//~ $totalAtendidas[$arrServico[$j]] += $atendidas[$arrLoja[$i]][$arrServico[$j]];
				//~ }
			//~ }
			//~ for ($i = 0; $i < count($arrServico); $i++)
			//~ {
				//~ if ($totalAtendidas[$arrServico[$i]])
				//~ {
					//~ $serie1->addPoint(new Point(GetNomeServico($arrServico[$i]), (int)($totalTempoEspera[$arrServico[$i]] / $totalAtendidas[$arrServico[$i]])));
					//~ $serie2->addPoint(new Point(GetNomeServico($arrServico[$i]), (int)($totalTempoAtendimento[$arrServico[$i]] / $totalAtendidas[$arrServico[$i]])));
				//~ }
			//~ }
		}
		
		$dataSet = new XYSeriesDataSet();
		$dataSet->addSerie('espera', $serie1);
		$dataSet->addSerie('atendimento', $serie2);
		$chart->setDataSet($dataSet);
		$chart->getPlot()->setGraphCaptionRatio(0.65);

		$chart->setTitle(translate('word_media_in_seconds', true).":");
		$path = pathinfo($filepath);
		$chart->render($filepath);
        
        unset($dataSet);
        unset($chart);
	unset($stat);
	}
	
	/*
	function GeraImagemMedia($filepath)
	{
		$res1 = $_SESSION["espera"];
		$_SESSION["espera"] = 0;
   	$res2 = $_SESSION["atendimento"];
   	$_SESSION["atendimento"] = 0;
   	$Servico = $_SESSION["servico"];
   	$_SESSION["servico"] = 0;	
   	//	file_put_contents("/tmp/debug.txt","\n nome servizio: ".$res1[0]["nomeservico"]."    valore: ".$res1[0]["valor"], FILE_APPEND);
		$chart = new VerticalBarChart(1200, 400);
		$serie1 = new XYDataSet();
		$serie2 = new XYDataSet();	
		
		for( $i = 0 ; $i < $Servico ; $i++){
			if($res1[$i]["valor"] > 0){
				$valor_em_minutos = (int)($res1[$i]["valor"]/60);
				$serie1->addPoint(new Point($res1[$i]["nomeservico"] . "\n" . $res1[$i]["nomelocal"] , $valor_em_minutos));
			}				
			else
				$serie1->addPoint(new Point($res1[$i]["nomeservico"] . "\n" . $res1[$i]["nomelocal"] , 0 ));
		}		
						
		for( $j = 0 ; $j < $Servico ; $j++){
			if($res2[$j]["valor"] > 0) {
				$valor_em_minutos = (int)($res2[$j]["valor"]/60);
				$serie2->addPoint(new Point($res2[$i]["nomeservico"] ."\n" . $res2[$i]["nomelocal"],  $valor_em_minutos));	
			}
			else
				$serie2->addPoint(new Point($res2[$i]["nomeservico"] ."\n" . $res2[$i]["nomelocal"], 0 ));
		}
		
		$dataSet = new XYSeriesDataSet();
		$dataSet->addSerie("Tempo Médio de Espera" , $serie1);
		$dataSet->addSerie("Tempo Médio de Atendimento" , $serie2);		
		$chart->setDataSet($dataSet);
		$chart->getPlot()->setGraphCaptionRatio(0.65);

		$chart->setTitle("Media em minutos:");
		
		$path = pathinfo($filepath);
		$chart->render($filepath);
		
	}
	*/
	
	// funçóes de consulta de dados para a tabela
	function IsSuspensa($local, $servico, $senha)
	{
		global $ERROS;
		
		$sql = "select count(*) as n
			from log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_', numero_senha, servico_emissao)='" . $senha . "'
			and tipo='Suspensa'
			and id_log_atendimentos=(
				select max(id_log_atendimentos)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and concat_ws('_', numero_senha, servico_emissao)='" . $senha . "')";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."IsSuspensa". $ERROS[0] . " </div>";
			return false;
		}
		else return ($this->bd->obterValor($rs, "n"))?true:false;
	}
	
	function GetSuspensas($local, $servico)
	{
		global $ERROS;
		$suspensas = 0;
		
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			AND numero_senha != 0
			AND data_hora >= CURDATE()";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetSuspensas". $ERROS[0] . " </div>";
			return false;
		}
		else
		{
			$senhas = array();
			while ($row = $this->bd->obterRegisto($rs))
			{
				array_push($senhas, $row['senha']);
			}
			for ($i = 0; $i < count($senhas); $i++)
			{
				if ($this->IsSuspensa($local, $servico, $senhas[$i])) $suspensas++;
			}
		}
		return $suspensas;
	}
	
	function GetUltimaSenha($local, $servico) // não é usada, nem sei se está bem feita... mas deixo ficar aqui para o que for necessário.
	{
		global $ERROS;
		
		$sql = "SELECT MAX(numero_senha) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and numero_senha not in
				(select distinct numero_senha
				from log_atendimentos
				where tipo='Anulada')";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " .translate('word_last', true). $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "n");
	}
	
	function GetEmitidas($local, $servico)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and
				(tipo='Emissao'
				or tipo='Redireccao')
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " .translate('word_emition', true). $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "n");
	}
	
	function GetEmitidasByBalcao($local, $servico, $balcao)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and
				(tipo='Emissao'
				or tipo='Redireccao')
			AND numero_senha != 0
			AND data_hora <= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora <= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " .translate('word_emition', true). $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "n");
	}
	
	function GetAtendidas($local, $servico)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " .translate('word_finished', true). $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "n");
	}
	
	function GetAtendidasByBalcao($local, $servico, $balcao)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora <= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora <= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."Terminado". $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "n");
	}
	
	function GetEmEspera($local, $servico)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and
				(tipo='Emissao'
				or tipo='Redireccao')
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and (tipo='Anulada'
				or tipo='Chamada')
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetEmEspera". $ERROS[0] . " </div>";
			return false;
		}
		else return ($this->bd->obterValor($rs, "n") + $this->GetSuspensas($local, $servico));
	}
	
	function GetEmAtendimento($local, $servico)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Chamada'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and (tipo='Terminado'
				or tipo='Desistencia')
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetEmAtendimento". $ERROS[0] . " </div>";
			return false;
		}
		else return ($this->bd->obterValor($rs, "n") - $this->GetSuspensas($local, $servico));
	}
	
	function GetEmAtendimentoByBalcao($local, $servico, $balcao)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and tipo='Chamada'
			AND numero_senha != 0
			AND data_hora <= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and (tipo='Terminado'
				or tipo='Desistencia')
				AND numero_senha != 0
				AND data_hora <= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetEmAtendimento". $ERROS[0] . " </div>";
			return false;
		}
		else return ($this->bd->obterValor($rs, "n") - $this->GetSuspensas($local, $servico));
	}
	
	function GetDesistencias($local, $servico)
	{
		global $ERROS;
		
		$sql = "SELECT COUNT(distinct concat_ws('_', numero_senha, servico_emissao)) as n
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Desistencia'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " .translate('word_give_up', true). $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "n");
	}
	
	function GetTempoProxSenha($local, $servico)
	{
		$sql = "select timediff(now(),data_hora) as espera
			from log_atendimentos
			where id_log_atendimentos=
				(SELECT min(id_log_atendimentos) as id
				FROM log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and
					(tipo='Emissao'
					or tipo='Redireccao')
				AND numero_senha != 0
				AND data_hora >= CURDATE()
				and concat_ws('_', numero_senha, servico_emissao) not in
					(select distinct concat_ws('_', numero_senha, servico_emissao)
					from log_atendimentos
					WHERE id_servico = '" . $servico . "'
					and id_loja= '" . $local . "'
					and
						(tipo='Anulada'
						or tipo='Chamada')
					AND numero_senha != 0
					AND data_hora >= CURDATE()))";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoProxSenha". $ERROS[0] . " </div>";
			return false;
		}
		else return $this->bd->obterValor($rs, "espera");
	}
	
	function GetTempoEspera($local, $servico, $senha)
	{
		//~ echo 'serv: ' . $servico . '<br/>';
		$test_serv = 0;
		if ($servico == $test_serv) echo 'senha: ' . $senha . '<br/>';
		
		$sql = "SELECT data_hora
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and
				(tipo='Emissao'
				or tipo='Redireccao')";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera1". $ERROS[0] . " </div>";
			return false;
		}
		$data_emissao = strtotime($this->bd->obterValor($rs, "data_hora"));
		
		if ($servico == $test_serv) echo 'Emissao: ' . date('H:i:s', $data_emissao) . '<br/>';

		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Chamada'
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera2". $ERROS[0] . " </div>";
			return false;
		}
		$datas_chamada = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_chamada, strtotime($row['data_hora']));
		}
		
		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Suspensa'
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera3". $ERROS[0] . " </div>";
			return false;
		}
		$datas_suspensa = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_suspensa, strtotime($row['data_hora']));
		}
		
		$tempoEspera = $datas_chamada[0] - $data_emissao;
		
		if ($servico == $test_serv) echo translate('word_chamada',true).':' . date('H:i:s', $datas_chamada[0]) . '<br/>';
		if ($servico == $test_serv) echo translate('word_diff',true).':' . date('H:i:s', $datas_chamada[0] - $data_emissao - 3600) . '<br/>';
		
		for ($i = 0; $i < count($datas_suspensa); $i++)
		{
			if ($servico == $test_serv) echo translate('word_suspensa',true).':' . date('H:i:s', $datas_suspensa[$i]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_chamada',true).':' . date('H:i:s', $datas_chamada[$i + 1]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_diff',true).':' . date('H:i:s', $datas_chamada[$i + 1] - $datas_suspensa[$i] - 3600) . '<br/>';
			$tempoEspera += ($datas_chamada[$i + 1] - $datas_suspensa[$i]);
		}
		
		if ($servico == $test_serv) echo translate('word_tempo_total_espera',true).':' . date('H:i:s', $tempoEspera - 3600) . '<br/>';
		
		return $tempoEspera;
	}
	
	function GetTempoEsperaByBalcao($local, $servico, $balcao, $senha)
	{
		//~ echo 'serv: ' . $servico . '<br/>';
		$test_serv = 0;
		if ($servico == $test_serv) echo 'senha: ' . $senha . '<br/>';
		
		$sql = "SELECT data_hora
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and
				(tipo='Emissao'
				or tipo='Redireccao')";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera1". $ERROS[0] . " </div>";
			return false;
		}
		$data_emissao = strtotime($this->bd->obterValor($rs, "data_hora"));
		
		if ($servico == $test_serv) echo 'Emissao: ' . date('H:i:s', $data_emissao) . '<br/>';

		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Chamada'
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera2". $ERROS[0] . " </div>";
			return false;
		}
		$datas_chamada = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_chamada, strtotime($row['data_hora']));
		}
		
		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Suspensa'
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera3". $ERROS[0] . " </div>";
			return false;
		}
		$datas_suspensa = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_suspensa, strtotime($row['data_hora']));
		}
		
		$tempoEspera = $datas_chamada[0] - $data_emissao;
		
		if ($servico == $test_serv) echo translate('word_chamada',true).':' . date('H:i:s', $datas_chamada[0]) . '<br/>';
		if ($servico == $test_serv) echo translate('word_diff',true).':' . date('H:i:s', $datas_chamada[0] - $data_emissao - 3600) . '<br/>';
		
		for ($i = 0; $i < count($datas_suspensa); $i++)
		{
			if ($servico == $test_serv) echo translate('word_suspensa',true).':' . date('H:i:s', $datas_suspensa[$i]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_chamada',true).':' . date('H:i:s', $datas_chamada[$i + 1]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_diff',true).':' . date('H:i:s', $datas_chamada[$i + 1] - $datas_suspensa[$i] - 3600) . '<br/>';
			$tempoEspera += ($datas_chamada[$i + 1] - $datas_suspensa[$i]);
		}
		
		if ($servico == $test_serv) echo translate('word_tempo_total_espera',true).':' . date('H:i:s', $tempoEspera - 3600) . '<br/>';
		
		return $tempoEspera;
	}
	
	function GetTempoMedioEspera($local, $servico)
	{
		$total_esperas = $this->GetAtendidas($local, $servico) + $this->GetEmAtendimento($local, $servico);
		
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoMedioEspera". $ERROS[0] . " </div>";
			return false;
		}
		$senhas = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Chamada'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and (tipo='Terminado'
				or tipo='Desistencia')
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoMedioEspera". $ERROS[0] . " </div>";
			return false;
		}
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		
		$totalTemposEspera = 0;
		for ($i = 0; $i < count($senhas); $i++)
		{
			//~ echo 'senha: ' . $senhas[$i] . '<br/>';
			$tempoEsperaSenha = $this->GetTempoEspera($local, $servico, $senhas[$i]);
			//~ echo 'tempo Espera: ' . $tempoEsperaSenha . '<br/>';
			$totalTemposEspera += $tempoEsperaSenha;
		}
		//~ echo date('H:i:s', ($totalTemposEspera / $total_esperas) - 3600);
		//~ echo '<br/>';
		return date('H:i:s', ($totalTemposEspera / $total_esperas) - 3600);
	}
	
	function GetTempoMedioEsperaByBalcao($local, $servico, $balcao)
	{
		$total_esperas = $this->GetAtendidasByBalcao($local, $servico, $balcao) + $this->GetEmAtendimentoByBalcao($local, $servico, $balcao);;
		
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora <= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora <= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoMedioEspera". $ERROS[0] . " </div>";
			return false;
		}
		$senhas = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and tipo='Chamada'
			AND numero_senha != 0
			AND data_hora <= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and (tipo='Terminado'
				or tipo='Desistencia')
				AND numero_senha != 0
				AND data_hora <= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoMedioEspera". $ERROS[0] . " </div>";
			return false;
		}
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		
		$totalTemposEspera = 0;
		for ($i = 0; $i < count($senhas); $i++)
		{
			//~ echo 'senha: ' . $senhas[$i] . '<br/>';
			$tempoEsperaSenha = $this->GetTempoEsperaByBalcao($local, $servico, $balcao, $senhas[$i]);
			//~ echo 'tempo Espera: ' . $tempoEsperaSenha . '<br/>';
			$totalTemposEspera += $tempoEsperaSenha;
		}
		//~ echo date('H:i:s', ($totalTemposEspera / $total_esperas) - 3600);
		//~ echo '<br/>';
		return date('H:i:s', ($totalTemposEspera / $total_esperas) - 3600);
	}
	
	function GetTempoAtendimento($local, $servico, $senha)
	{
		//~ echo 'serv: ' . $servico . '<br/>';
		$test_serv = 0;
		if ($servico == $test_serv) echo 'senha: ' . $senha . '<br/>';
		
		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Chamada'
			and time(data_hora)<=(
				select min(time(data_hora))
				FROM log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
				and tipo='Terminado')
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera2". $ERROS[0] . " </div>";
			return false;
		}
		$datas_chamada = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_chamada, strtotime($row['data_hora']));
		}
		
		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Suspensa'
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera3". $ERROS[0] . " </div>";
			return false;
		}
		$datas_suspensa = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_suspensa, strtotime($row['data_hora']));
		}
		
		$tempoAtendimento = 0;
		for ($i = 0; $i < count($datas_suspensa); $i++)
		{
			if ($servico == $test_serv) echo translate('word_suspensa',true).':' . date('H:i:s', $datas_suspensa[$i]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_chamada',true).':' . date('H:i:s', $datas_chamada[$i + 1]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_diff',true).':' . date('H:i:s', $datas_chamada[$i + 1] - $datas_suspensa[$i] - 3600) . '<br/>';
			$tempoAtendimento += ($datas_suspensa[$i] - $datas_chamada[$i]);
		}
		
		$sql = "SELECT data_hora
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Terminado'";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera1". $ERROS[0] . " </div>";
			return false;
		}
		$data_terminado = strtotime($this->bd->obterValor($rs, "data_hora"));
		
		if ($servico == $test_serv) echo 'Terminado: ' . date('H:i:s', $data_terminado) . '<br/>';
		
		$tempoAtendimento += ($data_terminado - $datas_chamada[count($datas_chamada) - 1]);
		
		if ($servico == $test_serv) echo 'Tempo total de atendimento: ' . date('H:i:s', $tempoAtendimento - 3600) . '<br/>';
		
		return $tempoAtendimento;
	}
	
	function GetTempoAtendimentoByBalcao($local, $servico, $balcao, $senha)
	{
		//~ echo 'serv: ' . $servico . '<br/>';
		$test_serv = 0;
		if ($servico == $test_serv) echo 'senha: ' . $senha . '<br/>';
		
		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Chamada'
			and time(data_hora)<=(
				select min(time(data_hora))
				FROM log_atendimentos_hist
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
				and tipo='Terminado')
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera2". $ERROS[0] . " </div>";
			return false;
		}
		$datas_chamada = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_chamada, strtotime($row['data_hora']));
		}
		
		$sql = "select data_hora
			from log_atendimentos
			where id_servico='" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Suspensa'
			and time(data_hora)<=(
				select time(data_hora)
				FROM log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
				and tipo='Terminado')
			order by id_log_atendimentos";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera3". $ERROS[0] . " </div>";
			return false;
		}
		$datas_suspensa = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($datas_suspensa, strtotime($row['data_hora']));
		}
		
		$tempoAtendimento = 0;
		for ($i = 0; $i < count($datas_suspensa); $i++)
		{
			if ($servico == $test_serv) echo translate('word_suspensa',true).':' . date('H:i:s', $datas_suspensa[$i]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_chamada',true).':' . date('H:i:s', $datas_chamada[$i + 1]) . '<br/>';
			if ($servico == $test_serv) echo translate('word_diff',true).':' . date('H:i:s', $datas_chamada[$i + 1] - $datas_suspensa[$i] - 3600) . '<br/>';
			$tempoAtendimento += ($datas_suspensa[$i] - $datas_chamada[$i]);
		}
		
		$sql = "SELECT data_hora
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and concat_ws('_',numero_senha,servico_emissao)='" . $senha . "'
			and tipo='Terminado'";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoEspera1". $ERROS[0] . " </div>";
			return false;
		}
		$data_terminado = strtotime($this->bd->obterValor($rs, "data_hora"));
		
		if ($servico == $test_serv) echo 'Terminado: ' . date('H:i:s', $data_terminado) . '<br/>';
		
		$tempoAtendimento += ($data_terminado - $datas_chamada[count($datas_chamada) - 1]);
		
		if ($servico == $test_serv) echo 'Tempo total de atendimento: ' . date('H:i:s', $tempoAtendimento - 3600) . '<br/>';
		
		return $tempoAtendimento;
	}
	
	function GetTempoMedioAtendimento($local, $servico)
	{
		$total_atendidas = $this->GetAtendidas($local, $servico);
		
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoMedioEspera". $ERROS[0] . " </div>";
			return false;
		}
		$senhas = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		
		$totalTemposEspera = 0;
		for ($i = 0; $i < count($senhas); $i++)
		{
			//~ echo 'senha: ' . $senhas[$i] . '<br/>';
			$tempoAtendimentoSenha = $this->GetTempoAtendimento($local, $servico, $senhas[$i]);
			//~ echo 'tempo Espera: ' . $tempoEsperaSenha . '<br/>';
			$totalTemposAtendimento += $tempoAtendimentoSenha;
		}
		//~ echo date('H:i:s', ($totalTemposEspera / $total_esperas) - 3600);
		//~ echo '<br/>';
		return date('H:i:s', ($totalTemposAtendimento / $total_atendidas) - 3600);
	}
	
	function GetTempoMedioAtendimentoByBalcao($local, $servico, $balcao)
	{
		$total_atendidas = $this->GetAtendidasByBalcao($local, $servico, $balcao);
		
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_balcao= '" . $balcao . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora <= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_balcao= '" . $balcao . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora <= CURDATE())";
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetTempoMedioEspera". $ERROS[0] . " </div>";
			return false;
		}
		$senhas = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		
		$totalTemposEspera = 0;
		for ($i = 0; $i < count($senhas); $i++)
		{
			//~ echo 'senha: ' . $senhas[$i] . '<br/>';
			$tempoAtendimentoSenha = $this->GetTempoAtendimentoByBalcao($local, $servico, $balcao, $senhas[$i]);
			//~ echo 'tempo Espera: ' . $tempoEsperaSenha . '<br/>';
			$totalTemposAtendimento += $tempoAtendimentoSenha;
		}
		//~ echo date('H:i:s', ($totalTemposEspera / $total_esperas) - 3600);
		//~ echo '<br/>';
		return date('H:i:s', ($totalTemposAtendimento / $total_atendidas) - 3600);
	}
	
	/*
		Função que cria a tabela que contem a listagem das senhas 
		atendidas/suspensas em determinado(s) serviço(s), no dia actual.
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Listar()
	{
		//array utilizado para gravar todos os dados da sessao actual 
		$_SESSION["dados"] = array();
		
		// TODO: obter limites pela tabela horarios da bd
		$data_actual = date("Y-m-d");
		$limite_inf = $data_actual . " 00:00:00";
		$limite_sup = $data_actual . " 23:59:59";
		
		//$sql_servicos = "SELECT sp.id_loja, sp.id_servico, l.nome as lojas , s.nome as servico FROM servicos_prestados sp, 
		//						servicos s, lojas l WHERE sp.id_servico= s.id_servico and sp.id_loja= l.id_loja ";
		
		$sql_servicos = "SELECT le.id_loja, s.id_servico, l.nome as lojas , s.nome as servico, e.id_entidade, e.nome AS entidade
                                                                FROM servicos s, lojas l, entidades e, lojas_entidades le 
                                                                        WHERE s.id_entidade= e.id_entidade AND s.id_entidade = le.id_entidade AND le.id_loja= l.id_loja ";

		if($_REQUEST["servico"] != "")
			$sql_servicos = $sql_servicos."AND s.id_servico = ".$_REQUEST["servico"]." ";
		if($_REQUEST["loja"] != "")
			$sql_servicos = $sql_servicos."AND l.id_loja = ".$_REQUEST["loja"]." ";
	      
		if(strcasecmp($_GET['campo'] , "loja") == 0)
			$sql_servicos = $sql_servicos."ORDER BY l.nome";
		if(strcasecmp($_GET['campo'] , "servico") == 0)
			$sql_servicos = $sql_servicos."ORDER BY s.nome";
		if(strcasecmp($_GET['campo'] , "loja") != 0 &&  strcasecmp($_GET['campo'] , "servico") != 0)	  		
			$sql_servicos = $sql_servicos."ORDER BY l.id_loja, s.id_servico";
		if($_GET['ordem'] == 0)      
			$sql_servicos = $sql_servicos." ASC;";
		if($_GET['ordem'] == 1)  
			$sql_servicos = $sql_servicos." DESC;";
			  
		if(!$rsserv = $this->bd->executarSQL($sql_servicos))
		{
			// erro da bd
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}
		$atendimentos = array();
        while ($row = $this->bd->obterRegisto($rsserv)) array_push($atendimentos, $row);


		global $ERROS, $N_REGISTOS;
		$n = 1;
		$numRegPag =20;
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rsserv); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0) {
			echo "<div class='empty_msg'>".translate('word_nao_existem', true) . "registos de senhas no sistema com os filtros seleccionados!</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
		 			<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
		 						<td class='button_page' colspan='6'>";
			 					
		$pagina = 1;
		if($_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];
						
		$url2spread = "?servico=" . $_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'];
		echo drawPaginas($url2spread . "?campo=$_REQUEST[campo]&ordem=$_REQUEST[ordem]", $numPaginas, $pagina);
								
		$n = ($pagina - 1) * $numRegPag;
		$incremento = $n;
		if($pagina == $numPaginas && ($numTuplos % $numRegPag != 0))
			$numRegPag = $numTuplos % $numRegPag;
				
		echo "			
					</td>
				</tr>";				
		
		/* primeira linha da tabela com os titulos dos campos */
		
		echo "<tr class='column_row'>";
			
		if (strcmp($_GET['campo'], "loja") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "</div></a></td>";
		
		if (strcmp($_GET['campo'], "servico") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service") ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
 				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."</div></a></td>";
			
	 	if (strcmp($_GET['campo'], "emitida") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=emitida&ordem=0&loja=". $_REQUEST['loja']  . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_issued")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=emitida&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_issued")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=emitida&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_issued")  ."</div></a></td>";
		
		if (strcmp($_GET['campo'], "chamada") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."</div></a></td>";

		if (strcmp($_GET['campo'], "espera") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=espera&ordem=0&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_waiting")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=espera&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_waiting")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=espera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_waiting")  ."</div></a></td>";
	 
		 if (strcmp($_GET['campo'], "em_atendimento") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=em_atendimento&ordem=0&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_in_attendance")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=em_atendimento&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_in_attendance")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=em_atendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_in_attendance")  ."</div></a></td>";
						
		if (strcmp($_GET['campo'], "desistida") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=desistida&ordem=0&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".htmlString(translate('word_retirements', true))."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=desistida&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".htmlString(translate('word_retirements', true))."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=desistida&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".htmlString(translate('word_retirements', true))."</div></a></td>";
					
					
		if (strcmp($_GET['campo'], "tempo") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=tempo&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_prox_ticket', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=tempo&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_prox_ticket', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=tempo&ordem=0&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_prox_ticket', true)."</div></a></td>";
	
		//Colonna per Tempo Medio di Espera
		if (strcmp($_GET['campo'], "mediaespera") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaespera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_waiting', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaespera&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_waiting', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaespera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_waiting', true)."</div></a></td>";

		//Colonna per Tempo Medio di Attendimento
		if (strcmp($_GET['campo'], "mediaatendimento") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true)."</div></a></td>";
	
		echo "</tr>";
		echo "</tr>";	
		
		$Fuso = 3600;
		$numTotal_chamada = 0;
		$numTotal_emitida = 0;
		$numTotal_espera = 0;
		$tot_num_terminado=0;
		$Somma_total2=0;		   
		$Somma_total=0;
		$numTotal_em_atendimento = 0;

		$Array_senhas_chamada = array();
		
		$totalMediaEspera = 0;
		$totalMediaAtendimento = 0;
		
		$stat = new EstatisticaAtendimentos;
		
		/* populamento da tabela */
		//while($n < ($numRegPag + $incremento))
		//{
		for ($i=$n; $i<$numRegPag + $incremento; $i++)
        {
			//$this->bd->moverRegisto($rsserv,$n);
			$id_l = $atendimentos[$i]["id_loja"] /*$this->bd->obterValor($rsserv, "id_loja")*/;
			$id_s = $atendimentos[$i]["id_servico"] /*$this->bd->obterValor($rsserv, "id_servico")*/;

			$chamada = $stat->GetNumeroSenhasChamadas($id_l, $id_s, date("Y-m-d")); //(int)  $this->bd->obterValor($rschamada, "numero_senha");
			$emitida = $stat->GetNumeroSenhasEmitidas($id_l, $id_s, date("Y-m-d")); //$this->GetEmitidas($id_l, $id_s); //((int) $this->bd->obterValor($rsemitida, "numero_senha")) - $anulada;
			$terminado = $stat->GetNumeroSenhasAtendidas($id_l, $id_s, date("Y-m-d")); //$this->GetAtendidas($id_l, $id_s); //(int) $this->bd->obterValor($rsterminata, "numero_senha");
			$espera = $stat->GetNumeroSenhasEmEspera($id_l, $id_s, date("Y-m-d")); //$this->GetEmEspera($id_l, $id_s); //$emitida - $chamada;
					
			if($chamada == null)
				$chamada = 0;
			if($emitida == null)
				$emitida = 0;
			
			$desistida = $stat->GetNumeroSenhasDesistidas($id_l, $id_s, date("Y-m-d")); //$this->GetDesistencias($id_l, $id_s); //(int)  $this->bd->obterValor($rsdesistida, "numero_senha");
			
			$em_atendimento = $stat->GetNumeroSenhasEmAtendimento($id_l, $id_s, date("Y-m-d")); //$this->GetEmAtendimento($id_l, $id_s); //$chamada - $terminado - $desistida;
			
			$tempo = $this->GetTempoProxSenha($id_l, $id_s);
			
			$Array_loja[$n] = $atendimentos[$i]["lojas"] /*$this->bd->obterValor($rsserv, "lojas")*/;
			$Array_servico[$n] = $atendimentos[$i]["servico"] /* $this->bd->obterValor($rsserv, "servico")*/;
			$Array_idloja[$n] = $atendimentos[$i]["id_loja"] /* $this->bd->obterValor($rsserv, "id_loja")*/;
			$Array_idservico[$n] = $atendimentos[$i]["id_servico"] /*$this->bd->obterValor($rsserv, "id_servico")*/;		
			$Array_senhas_chamada[$n] = $chamada;
			$Array_senhas_terminado[$n] = $terminado;
			$Array_senhas_emitida[$n] = $emitida;
			$Array_senhas_espera[$n] = $espera;
			$Array_senhas_em_atendimento[$n] = $em_atendimento;
			$Array_senhas_desistida[$n] = $desistida;	
			
			if($tempo == null)
	 			$Array_tempo[$n]='00:00:00';
	 		else
	 			$Array_tempo[$n] = $tempo;
			
			$Array_Media_espera[$n] = $stat->GetTempoMedioEspera($id_l, $id_s, date("Y-m-d")); //$this->GetTempoMedioEspera($id_l, $id_s); //(int) ($tot_Espera/($num_chamada - 1));
			$totalMediaEspera += GetSecondsFromTimeString($Array_Media_espera[$n]);
			$Somma_total = $Somma_total + ($tot_Espera);			
			$tot_Espera = 0;			

			$Array_Media_atendimento[$n] = $stat->GetTempoMedioAtendimento($id_l, $id_s, date("Y-m-d")); //$this->GetTempoMedioAtendimento($id_l, $id_s); //(int)($tot_Terminado/($num_terminado - 1));
			$totalMediaAtendimento += GetSecondsFromTimeString($Array_Media_atendimento[$n]);
			$Somma_total2 = $Somma_total2 + $tot_Terminado;
			$tot_Terminado = 0;
			
			$numTotal_chamada = $numTotal_chamada + $chamada;
			$numTotal_emitida = $numTotal_emitida	+$emitida;
			$numTotal_espera = $numTotal_espera + $espera;
			$tot_num_terminado = $tot_num_terminado + $terminado;
			$num_total_desistida += $desistida;
			$numTotal_em_atendimento += $em_atendimento;
			
			$n++;
		}
		unset($stat);
		
		$medias['media_espera'] = date('H:i:s', ($totalMediaEspera / $n) - 3600);
		$medias['media_atendimento'] = date('H:i:s', ($totalMediaAtendimento / $n) - 3600);
		
		$ordem = array();//array utilizado para estabelecer o criterio de ordenaçao dos dados do grafico;
		$i = 0;		
		switch($_GET['campo'])
		{	
			case "emitida":
				$array1 = ordenacao($Array_senhas_emitida , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1))
				{			
					echo
						"<tr>
						<td>". $Array_loja[$chiave] . "</td>
						<td>". $Array_servico[$chiave] . "</td>
						<td>".$valore  . "</td>
						<td>" . $Array_senhas_terminado[$chiave] . "</td>
						<td>". $Array_senhas_espera[$chiave] . "</td>
						<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
						<td>".$Array_senhas_desistida[$chiave]."</td>
						<td>". $Array_tempo[$chiave] . "</td>
						<td>". $Array_Media_espera[$chiave] ."</td>
						<td>". $Array_Media_atendimento[$chiave] ."</td>
						</tr>";
					$ordem[$i] = $chiave;
					$i++;
				}
				break;
					
			case "chamada":
				$array1 = ordenacao($Array_senhas_terminado , $_GET['ordem']);
				while (list($chiave, $valore) = each($array1))
				{
					echo
						"<tr>
						<td>". $Array_loja[$chiave] . "</td>
						<td>". $Array_servico[$chiave] . "</td>
						<td>". $Array_senhas_emitida[$chiave] . "</td>
						<td>". $valore . "</td>
						<td>". $Array_senhas_espera[$chiave] . "</td>
						<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
						<td>".$Array_senhas_desistida[$chiave]."</td>
						<td>". $Array_tempo[$chiave] . "</td>
						<td>". $Array_Media_espera[$chiave] ."</td>
						<td>". $Array_Media_atendimento[$chiave] ."</td>
						</tr>";
					$ordem[$i] = $chiave;
					$i++;
				}
				break;
				
			case "espera":
			 	$array1 = ordenacao($Array_senhas_espera , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	
 			   	echo"<tr>
							<td>". $Array_loja[$chiave] . "</td>
							<td>". $Array_servico[$chiave] . "</td>
							<td>". $Array_senhas_emitida[$chiave] . "</td>
               		<td>" . /*($Array_senhas_chamada[$chiave] - $Array_senhas_desistida[$chiave])*/ $Array_senhas_terminado[$chiave] . "</td>
               		<td>". $valore . "</td>
			<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
               		<td>".$Array_senhas_desistida[$chiave]."</td>
							<td>". $Array_tempo[$chiave] . "</td>
							<td>". $Array_Media_espera[$chiave] ."</td>
							<td>". $Array_Media_atendimento[$chiave] ."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
				case "em_atendimento":
			 	$array1 = ordenacao($Array_senhas_em_atendimento , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	
 			   	echo"<tr>
							<td>". $Array_loja[$chiave] . "</td>
							<td>". $Array_servico[$chiave] . "</td>
							<td>". $Array_senhas_emitida[$chiave] . "</td>
               		<td>" . /*($Array_senhas_chamada[$chiave] - $Array_senhas_desistida[$chiave])*/ $Array_senhas_terminado[$chiave] . "</td>
               		<td>". $Array_senhas_espera[$chiave] . "</td>
			<td>". $valore . "</td>
               		<td>".$Array_senhas_desistida[$chiave]."</td>
							<td>". $Array_tempo[$chiave] . "</td>
							<td>". $Array_Media_espera[$chiave] ."</td>
							<td>". $Array_Media_atendimento[$chiave] ."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
				case "desistida":
					$array1 = ordenacao($Array_senhas_desistida , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	
 			   	echo"<tr>
							<td>". $Array_loja[$chiave] . "</td>
							<td>". $Array_servico[$chiave] . "</td>
							<td>".$Array_senhas_emitida[$chiave] . "</td>
               		<td>" . /*($Array_senhas_chamada[$chiave] - $valore)*/ $Array_senhas_terminado[$chiave] . "</td>
               		<td>". $Array_senhas_espera[$chiave] . "</td>
			<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
               		<td>". $valore ."</td>
							<td>". $Array_tempo[$chiave] . "</td>
							<td>". $Array_Media_espera[$chiave] ."</td>
							<td>". $Array_Media_atendimento[$chiave] ."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
				case "tempo":
					$array1 = ordenacao($Array_tempo , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	
 			   	echo"<tr>
							<td>". $Array_loja[$chiave] . "</td>
							<td>". $Array_servico[$chiave] . "</td>
							<td>".$Array_senhas_emitida[$chiave] . "</td>
               		<td>" . /*($Array_senhas_chamada[$chiave] - $Array_senhas_desistida[$chiave])*/ $Array_senhas_terminado[$chiave] . "</td>
               		<td>". $Array_senhas_espera[$chiave] . "</td>
			<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
               		<td>". $Array_senhas_desistida[$chiave] ."</td>
							<td>". $valore . "</td>
							<td>". $Array_Media_espera[$chiave] ."</td>
							<td>". $Array_Media_atendimento[$chiave] ."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
				case "mediaespera":
					$array1 = ordenacao($Array_Media_espera , $_GET['ordem']);
					while (list($chiave, $valore) = each($array1)) {			
 			   	
 			   	echo"<tr>
							<td>". $Array_loja[$chiave] . "</td>
							<td>". $Array_servico[$chiave] . "</td>
							<td>".$Array_senhas_emitida[$chiave] . "</td>
               		<td>" . /*($Array_senhas_chamada[$chiave] - $Array_senhas_desistida[$chiave])*/ $Array_senhas_terminado[$chiave] . "</td>
               		<td>". $Array_senhas_espera[$chiave] . "</td>
			<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
               		<td>". $Array_senhas_desistida[$chiave] ."</td>
							<td>". $Array_tempo[$chiave] . "</td>
							<td>". $valore ."</td>
							<td>". $Array_Media_atendimento[$chiave] ."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
				case "mediaatendimento":
					$array1 = ordenacao($Array_Media_atendimento , $_GET['ordem']);
					while (list($chiave, $valore) = each($array1)) {			
 			   	
 			   	echo"<tr>
							<td>". $Array_loja[$chiave] . "</td>
							<td>". $Array_servico[$chiave] . "</td>
							<td>".$Array_senhas_emitida[$chiave] . "</td>
               		<td>" . /*($Array_senhas_chamada[$chiave] - $Array_senhas_desistida[$chiave])*/ $Array_senhas_terminado[$chiave] . "</td>
               		<td>". $Array_senhas_espera[$chiave] . "</td>
			<td>". $Array_senhas_em_atendimento[$chiave] . "</td>
               		<td>". $Array_senhas_desistida[$chiave] ."</td>
							<td>". $Array_tempo[$chiave] . "</td>
							<td>". $Array_Media_espera[$chiave] ."</td>
							<td>". $valore ."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
								
			default:
				for($i=0; $i<count($Array_servico); $i++){
					echo"<tr>
							<td>" . $Array_loja[$i] . "</td>
							<td>" . $Array_servico[$i] . "</td>
							<td>" . $Array_senhas_emitida[$i] . "</td>
          		      <td>" .  /*($Array_senhas_chamada[$i] - $Array_senhas_desistida[$i])*/ $Array_senhas_terminado[$i] . "</td>
              		   <td>" . $Array_senhas_espera[$i] . "</td>
			   <td>". $Array_senhas_em_atendimento[$i] . "</td>
               		<td>".$Array_senhas_desistida[$i]."</td>
							<td>" . $Array_tempo[$i] . "</td>
							<td>". $Array_Media_espera[$i] ."</td>
							<td>". $Array_Media_atendimento[$i] ."</td>
						  </tr>";
						  $ordem[$i] = $i;
						 
		
				}
				break;
		}
		
		echo
			"<tr>
				<td></td>
				<td></td>
				<td>---------</td>
				<td>---------</td>
				<td>---------</td>  
				<td>---------</td>
				<td>---------</td>
			</tr>
			<tr>
				<td></td>
				<td></td>
				<td>".$numTotal_emitida."</td>
				<td>"./*($numTotal_chamada - $num_total_desistida)*/ $tot_num_terminado ."</td>
				<td>".$numTotal_espera."</td>	
				<td>".$numTotal_em_atendimento."</td>	
				<td>".$num_total_desistida."</td>	
			</tr>";
		 
		if($numTotal_chamada != 0 )
		{	 
			$Somma_total = ($Somma_total)/$numTotal_chamada;
			$Somma_total = strftime("%X",$Somma_total - $Fuso);
			$Somma_total2 = ( $Somma_total2) / $tot_num_terminado;
			$Somma_total2 = strftime("%X",$Somma_total2 - $Fuso);		
			$ris = array("media_espera"=>$Somma_total, "media_atendimento"=>$Somma_total2);
		}
		
		echo
			"</table>
			</td>
			</tr>											
			</table>";
			
		$dados = $_SESSION["dados"];
		$dataActual = strtotime(date("Y-m-d"));
		$k = 0;
		$i = 0;
		$this -> bd -> moverRegisto($rsserv  , 0);
		while($i < count($dados))
		{
			if(strcasecmp($dados[$i]["local"] , $atendimentos[$i]["lojas"] /*$this -> bd -> obterValor($rsserv , "lojas")*/) == 0 || strcasecmp($dados[$i]["servico"] , $atendimentos[$i]["servico"] /*$this -> bd -> obterValor($rsserv , "servico")*/) == 0 || $numTuplos == count($dados))
			{
				if(strtotime($dados[$i]["espera"]) > 0)
					$Espera[$k] = strtotime($dados[$i]["espera"]) - $dataActual;
				else
					$Espera[$k] = strtotime($dados[$i]["espera"]);
				if(strtotime($dados[$i]["atendimento"]) > 0)	
 					$Atendimento[$k] = strtotime($dados[$i]["atendimento"]) - $dataActual;
				else
					$Atendimento[$k] = strtotime($dados[$i]["atendimento"]);
					
				$nomeServico[$k] = $dados[$i]["servico"];
				$nomeLocal[$k] = $dados[$i]["local"];
				$k ++;	
			}	
			$i++;	
		}
		
		for($i=0;$i< count($dados);$i++)
			$array_idservicos[$i] = $dados[$i]["idservico"]; 
			
		$temp1 = array();
		$temp2 = array();
		for($k =0; $k<count($ordem); $k++)
		{
			$chiave = $ordem[$k];
			$temp1[$k]["nomelocal"] = $Array_loja[$chiave];
			$temp1[$k]["nomeservico"] = $Array_servico[$chiave];
			$temp1[$k]["valor"] = (int)$Array_Media_espera[$chiave];
			$temp2[$k]["nomelocal"] = $Array_loja[$chiave];
			$temp2[$k]["nomeservico"] = $Array_servico[$chiave];
			$temp2[$k]["valor"] = (int)$Array_Media_atendimento[$chiave];

		}
 	 	 	
		$_SESSION["espera"] = $temp1;
		$_SESSION["atendimento"] = $temp2;
		$_SESSION["servico"] = $numTuplos;
  	
		unset($Array_loja,$Array_servico,$Array_senhas_emitida,$Array_senhas_chamada,$Array_senhas_espera,$Array_senhas_desistida,$Array_tempo,$Array_Media_espera,$Array_Media_atendimento,$ordem,$temp1,$temp2);
		//~ return $ris;
		
		return $medias;
	}
	
	function GeraResumo($data){
   		// TODO: obter limites pela tabela horarios da bd
		$data_actual =(int) strtotime(date("Y-m-d"));
		$fuso = 3600;
 		$sql_servicos = "SELECT sp.id_loja, sp.id_servico, l.nome as loja , s.nome as servico FROM servicos_prestados sp,
								 servicos s, lojas l where sp.id_servico= s.id_servico and sp.id_loja= l.id_loja ";
       
      if($_GET["servico"] != "")
			$sql_servicos = $sql_servicos."AND s.id_servico = ".$_GET["servico"]." ";
      if($_GET["loja"] != "")
      	$sql_servicos = $sql_servicos."AND l.id_loja = ".$_GET["loja"]." ";		
      	$sql_servicos = $sql_servicos."ORDER BY sp.id_loja, sp.id_servico ;";
      	
      if(!$rsserv = $this->bd->executarSQL($sql_servicos)) {
         // erro da bd
         echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
         return;
      }
      
      
		
		$sql = "SELECT * FROM resumodiario WHERE data_resumo ='".$data."';";
		
		if(!$rs = $this->bd->executarSQL($sql)) {
    	   echo "<div id='msg_erro' class='error_space'> ".translate('word_error_sql_resume_daily', true). "  " . $ERROS[0] . " </div>";
      	return;
   	}
   	$numResumo = $this->bd->obterNumRegistos($rs);
		// caso n�o existam registos
	 	if($numResumo == 0) {
			echo "<div class='empty_msg'>".translate('word_number_registers')."!</div>";
			return;
		}      
      

	       
		global $ERROS, $N_REGISTOS;

		$n = 1;
      $numRegPag =20;
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rsserv); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_GET["pagina"]-1))
			$_GET["pagina"] -= 1;
		
		
		
		if($numTuplos == 0) {
			echo "<div class='empty_msg'>".translate('word_number_registers')."!</div>";
			return;
		}
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'>";
								
		$pagina = 1;
		if($_GET['pagina'] != '')
			$pagina = $_GET['pagina'];
							
		$url2spread = "?servico=" . $_GET['servico'] . "&tipo=" . $_GET['tipo'];
		echo drawPaginas($url2spread . "?campo=$_REQUEST[campo]&ordem=$_REQUEST[ordem]", $numPaginas, $pagina);
						
		$n = ($pagina - 1) * $numRegPag;
		$incremento = $n;
		if($pagina == $numPaginas && ($numTuplos % $numRegPag != 0))
			$numRegPag = $numTuplos % $numRegPag;
					
		echo "			
					</td>
				</tr>";				
		
		/* primeira linha da tabela com os titulos dos campos */
		
		echo "<tr class='column_row'>";
		
		//colanna per i locali	
		if (strcmp($_GET['campo'], "loja") == 0)
         if ($_GET['ordem'] == 1)
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=loja&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
      else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "</div></a></td>";
		
		//colanna per i servizi	
		if (strcmp($_GET['campo'], "servico") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=servico&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
 				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=servico&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=servico&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."</div></a></td>";
 		
 		//colonna per le chiamate attendite
		if (strcmp($_GET['campo'], "chamada") == 0)
				if ($_GET['ordem'] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met") ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=chamada&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met") ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."</div></a></td>";


		if (strcmp($_GET['campo'], "desistida") == 0)
				if ($_GET['ordem'] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=desistida&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_retirements") ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=desistida&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_retirements") ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=desistida&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_retirements") ."</div></a></td>";
			


	//Colonna per Tempo Medio di Espera
     if (strcmp($_GET['campo'], "mediaespera") == 0)
         if ($_GET['ordem'] == 1)
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=mediaespera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_time_middle_waiting") ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=mediaespera&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_time_middle_waiting") ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
     else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=mediaespera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_time_middle_waiting") ."</div></a></td>";

	//Colonna per Tempo Medio di Attendimento
     if (strcmp($_GET['campo'], "mediaatendimento") == 0)
         if ($_GET['ordem'] == 1)
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_time_middle_attendance") ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=mediaatendimento&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_time_middle_attendance") ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
     else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$_GET["data"]."&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_time_middle_attendance") ."</div></a></td>";
	
		echo "</tr>";	
			
		$k=0;
		$Loja = array(); 
		$Servico = array(); 
		$Atendimento= array(); 
		$Espera = array(); 
		$Chamada= array();
		$Desistida= array();
		
		/*
		my way of doing things:
		*/
		$stat = new EstatisticaAtendimentos;
		while ($k < $numTuplos)
		{
			$this -> bd -> moverRegisto($rsserv , $k);
			$id_l = $this->bd->obterValor($rsserv, "id_loja");
		  	$id_s =$this->bd->obterValor($rsserv, "id_servico");
			
			
			
			$stat->GetNumeroSenhasAtendidasFromResumo($data, $id_l, $id_s);
			
			$Loja[$k] = $this->bd->obterValor($rsserv , "loja");
			$Servico[$k] = $this->bd->obterValor($rsserv, "servico"); 
			$Atendimento[$k] = GetSecondsFromTimeString($stat->GetTempoMedioAtendimentoFromResumo($data, $id_l, $id_s));
			$Espera[$k] = GetSecondsFromTimeString($stat->GetTempoMedioEsperaFromResumo($data, $id_l, $id_s));
			$Chamada[$k] = $stat->GetNumeroSenhasAtendidasFromResumo($data, $id_l, $id_s);
			$Desistida[$k] = $stat->GetNumeroSenhasDesistidasFromResumo($data, $id_l, $id_s);
			$tot_senhas += $Chamada[$k];
			$tot_desistidas += $Desistida[$k];
			
			$k++;
		}
		unset($stat);
		/*
		/my way of doing things
		*/
		
		
		//~ while($k < $numTuplos){
			//~ $this -> bd -> moverRegisto($rsserv , $k);
			//~ $id_l = $this->bd->obterValor($rsserv, "id_loja");
		  	//~ $id_s =$this->bd->obterValor($rsserv, "id_servico");
			
			//~ $sql_resumo = "SELECT * FROM resumodiario WHERE data_resumo = '".$data."' AND id_servico = ".$id_s." AND id_loja = ".$id_l.";";
					
			//~ if(!$resumo = $this->bd->executarSQL($sql_resumo))
    	   	//~ $num_resumo = 0;
			//~ else
				//~ $num_resumo = $this -> bd -> obterNumRegistos($resumo);	
			
		
				
			//~ $j = 0;
			//~ $tot_atendimento=0;
			//~ $tot_espera = 0;
			//~ $tot_senhas_chamadas = 0;
			//~ while($j < $num_resumo ){
				//~ $this -> bd -> moverRegisto($resumo , $j); 
    	   	//~ $tot_senhas_chamadas += (int)$this -> bd -> obterValor($resumo , "senhas_chamadas");
    	   	//~ $tot_atendimento += (int)strtotime($this -> bd -> obterValor($resumo , "tempo_medio_atendimento")) - $data_actual;
    	   	//~ $tot_espera += (int)strtotime($this -> bd -> obterValor($resumo , "tempo_medio_espera")) - $data_actual;
    			//~ $j++;			
			//~ }
			
			//~ if($num_resumo == 0)
				//~ $num_resumo = 1;
			
						
			//~ $Loja[$k] = $this->bd->obterValor($rsserv , "loja");
			//~ $Servico[$k] = $this->bd->obterValor($rsserv, "servico"); 
			//~ $Atendimento[$k] = $tot_atendimento/$num_resumo; 
			//~ $Espera[$k] = $tot_espera/$num_resumo; 
			//~ $Chamada[$k] = $tot_senhas_chamadas;
			//~ $tot_senhas += $tot_senhas_chamadas;
			
			//~ $k++;
		
		//~ }		
		
		
			
		$ordem = array();//array utilizado para estabelecer o criterio de ordenaçao dos dados do grafico;
		$i = 0;	
		
		switch($_GET['campo'])
		{	
			case "loja":
				$array1 = ordenacao($Loja , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $valore . "</td>
							<td>". $Servico[$chiave] . "</td>
							<td>".$Chamada[$chiave] . "</td>
							<td>".$Desistida[$chiave]  . "</td>
               		<td>".strftime("%X" , $Espera[$chiave]- $fuso)."</td>
							<td>".strftime("%X" ,$Atendimento[$chiave] -$fuso)."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
				case "servico":
				$array1 = ordenacao($Servico , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $Loja[$chiave] . "</td>
							<td>". $valore . "</td>
							<td>".$Chamada[$chiave]  . "</td>
							<td>".$Desistida[$chiave]  . "</td>
               		<td>".strftime("%X" , $Espera[$chiave]- $fuso)."</td>
							<td>".strftime("%X" ,$Atendimento[$chiave] -$fuso)."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
		
			case "chamada":
				$array1 = ordenacao($Chamada , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $Loja[$chiave] . "</td>
							<td>". $Servico[$chiave] . "</td>
							<td>".$valore  . "</td>
							<td>".$Desistida[$chiave]  . "</td>
               		<td>".strftime("%X" , $Espera[$chiave]- $fuso)."</td>
							<td>".strftime("%X" ,$Atendimento[$chiave] -$fuso)."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
				
			case "desistida":
				$array1 = ordenacao($Desistida , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $Loja[$chiave] . "</td>
							<td>". $Servico[$chiave] . "</td>
							<td>".$Chamada[$chiave]  . "</td>
							<td>".$valore  . "</td>
               		<td>".strftime("%X" , $Espera[$chiave]- $fuso)."</td>
							<td>".strftime("%X" ,$Atendimento[$chiave] -$fuso)."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
			
			case "mediaespera":
				$array1 = ordenacao($Espera , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $Loja[$chiave] . "</td>
							<td>". $Servico[$chiave] . "</td>
							<td>".$Chamada[$chiave]  . "</td>
							<td>".$Desistida[$chiave]  . "</td>
               		<td>".strftime("%X" , $valore - $fuso)."</td>
							<td>".strftime("%X" ,$Atendimento[$chiave] -$fuso)."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
			
			case "mediaatendimento":
				$array1 = ordenacao($Atendimento , $_GET['ordem']);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $Loja[$chiave] . "</td>
							<td>". $Servico[$chiave] . "</td>
							<td>".$Chamada[$chiave]. "</td>
							<td>".$Desistida[$chiave]  . "</td>
               		<td>".strftime("%X" , $Espera[$chiave]- $fuso)."</td>
							<td>".strftime("%X" ,$valore -$fuso)."</td>
						  </tr>";
						  $ordem[$i] = $chiave;
						  $i++;
				}
				break;
			default:
				for($i=0; $i<count($Servico); $i++){
					echo"<tr>
							<td>" . $Loja[$i] . "</td>
							<td>" . $Servico[$i] . "</td>
							<td>" . $Chamada[$i]. "</td>
							<td>".$Desistida[$i]  . "</td>
              			<td>".strftime("%X" , $Espera[$i]- $fuso)."</td>
							<td>".strftime("%X" ,$Atendimento[$i]- $fuso)."</td>
						  </tr>";
						  $ordem[$i] = $i;
						 
		
				}
				break;
		}		
		
		
		echo"		<tr>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>-----</td>
					</tr>	
					<tr>
	 					<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>".$tot_senhas."</td>
						<td>".$tot_desistidas."</td>
					</tr>	
	 			</table>
			  		</td> 	
					</tr>
		 		</table>";
			 									
		for($k = 0; $k<count($Espera); $k++){
			$res["espera"] +=  $Espera[$k];
			$res["atendimento"] +=  $Atendimento[$k];

		}
		
		$temp1 = array();
		$temp2 = array();
		for($k =0; $k<count($Espera); $k++){
			$chiave = $ordem[$k];
			$temp1[$k]["nomelocal"] = $Loja[$chiave];
			$temp1[$k]["nomeservico"] = $Servico[$chiave];
			$temp1[$k]["valor"] = (int)$Espera[$chiave];
			$temp2[$k]["nomelocal"] = $Loja[$chiave];
			$temp2[$k]["nomeservico"] = $Servico[$chiave];
			$temp2[$k]["valor"] = (int)$Atendimento[$chiave];

		}
		
		$res["espera"] = $res["espera"] /$numTuplos;
		$res["atendimento"] = $res["atendimento"] /$numTuplos;
    	$_SESSION["espera"] = $temp1;
    	$_SESSION["atendimento"] = $temp2;
  		$_SESSION["servico"] = $numTuplos;
  		unset($Loja,$Servico,$Chamada,$Espera,$Atendimento,$ordem,$temp1,$temp2);
  		
		return $res;
	}
		
		
		//funçao utilizada para visualizar os dados dos resumo diario com data igual a data actual de hoje 
		//os dados vem passado com os array $_SESSION 


	function visualizarResumoActual(){		
		$dados = $_SESSION["dados"];
	
		$dataActual = strtotime(date("Y-m-d"));
		// TODO: obter limites pela tabela horarios da bd
		$data_actual = date("Y-m-d");
		$limite_inf = $data_actual . " 00:00:00";
		$limite_sup = $data_actual . " 23:59:59";
		
		$sql_servicos = "SELECT sp.id_loja, sp.id_servico, l.nome as lojas , s.nome as servico FROM servicos_prestados sp,
								 servicos s, lojas l where sp.id_servico= s.id_servico and sp.id_loja= l.id_loja ";
		if($_GET["servico"] != "")
			$sql_servicos = $sql_servicos."AND s.id_servico = ".$_GET["servico"]." ";
      if($_GET["loja"] != "")
   		$sql_servicos = $sql_servicos."AND l.id_loja = ".$_GET["loja"]." ";
         		
      if(strcasecmp($_GET['campo'] , "loja") == 0)
      	$sql_servicos = $sql_servicos."ORDER BY l.nome";
      if(strcasecmp($_GET['campo'] , "servico") == 0)
      	$sql_servicos = $sql_servicos."ORDER BY s.nome";
      if($_GET['campo'] == '')	  		
      	$sql_servicos = $sql_servicos."ORDER BY l.id_loja, s.id_servico";
		if($_GET['ordem'] == 0)      
       	$sql_servicos = $sql_servicos." ASC;";
      if($_GET['ordem'] == 1)
      	$sql_servicos = $sql_servicos." DESC;";
       	
      if(!$rsserv = $this->bd->executarSQL($sql_servicos)) {
         // erro da bd
         echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
         return;
      }

	       
		global $ERROS, $N_REGISTOS;
		$n = 1;
      $numRegPag =20;
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rsserv); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_GET["pagina"]-1))
			$_GET["pagina"] -= 1;
		
		if($numTuplos == 0) {
			echo "<div class='empty_msg'>".translate('word_number_registers', true)."!</div>";
			return;
		}
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'>";
								
		$pagina = 1;
		if($_GET['pagina'] != '')
			$pagina = $_GET['pagina'];
						
		$url2spread = "?servico=" . $_GET['servico'] . "&tipo=" . $_GET['tipo'];
		echo drawPaginas($url2spread . "?campo=$_REQUEST[campo]&ordem=$_REQUEST[ordem]", $numPaginas, $pagina);
						
		$n = ($pagina - 1) * $numRegPag;
		$incremento = $n;
		if($pagina == $numPaginas && ($numTuplos % $numRegPag != 0))
			$numRegPag = $numTuplos % $numRegPag;
				
		echo "			
					</td>
				</tr>";				
		
		/* primeira linha da tabela com os titulos dos campos */
		
		echo "<tr class='column_row'>";
		
		//colanna per i locali	
		if (strcmp($_GET['campo'], "loja") == 0)
         if ($_GET['ordem'] == 1)
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
      else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "</div></a></td>";
		
		//colanna per i servizi	
		if (strcmp($_GET['campo'], "servico") == 0)
			if ($_GET['ordem'] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
 				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_service")  ."</div></a></td>";
 		
 		//colonna per le chiamate attendite
		if (strcmp($_GET['campo'], "chamada") == 0)
				if ($_GET['ordem'] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>". translate("word_met")  ."</div></a></td>";


	//Colonna per Tempo Medio di Espera
     if (strcmp($_GET['campo'], "mediaespera") == 0)
         if ($_GET['ordem'] == 1)
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaespera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_waiting', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaespera&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_waiting', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
     else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaespera&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_waiting', true)."</div></a></td>";

	//Colonna per Tempo Medio di Attendimento
     if (strcmp($_GET['campo'], "mediaatendimento") == 0)
         if ($_GET['ordem'] == 1)
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
     else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true)."</div></a></td>";
	
		echo "</tr>";	
			
		$k = 0;
		$i = 0;
		$this -> bd -> moverRegisto($rsserv  , 0);
				
		while($i < count($dados)){
				
			if(strcasecmp($dados[$i]["local"] , $this -> bd -> obterValor($rsserv , "lojas")) == 0 || strcasecmp($dados[$i]["servico"] , $this -> bd -> obterValor($rsserv , "servico")) == 0 || $numTuplos == count($dados)){
				echo"<tr>";			
				echo"	<td>" . $dados[$i]["local"] . "<br></td>"; 	
				echo"	<td>" . $dados[$i]["servico"]. "<br></td> 
						<td>" . $dados[$i]["chamada"]. "<br></td>
						<td>" . $dados[$i]["espera"]  . "<br></td> 
				      <td>" .$dados[$i]["atendimento"]. "<br></td>";
				echo"</tr>";
				if(strtotime($dados[$i]["espera"]) > 0)	
					$Espera[$k] = strtotime($dados[$i]["espera"]) - $dataActual;
				else
					$Espera[$k] = strtotime($dados[$i]["espera"]);
				if(strtotime($dados[$i]["atendimento"]) > 0)	
 					$Atendimento[$k] = strtotime($dados[$i]["atendimento"]) - $dataActual;
				else
					$Atendimento[$k] = strtotime($dados[$i]["atendimento"]);
				$nomeServico[$k] = $dados[$i]["servico"];
				$nomeLocal[$k] = $dados[$i]["local"];
				$tot_chamadas += $dados[$i]["chamada"];
				$k ++;	
							
			}	
				
			$i++;	
		}
		echo"<tr>
		 		 <td></td>
				 <td></td>
				 <td>--------<br></td>
			 </tr>";
		echo"<tr>
				 <td></td>
				 <td></td>
				 <td>".$tot_chamadas."<br></td>
				 </tr>";	
							
				
	 	echo"		</table>
			  		</td> 	
				</tr>
			</table>";
		 	
		for($i=0;$i< count($dados);$i++)
			$array_idservicos[$i] = $dados[$i]["idservico"]; 
	 	 	
	 	$sumEspera = CalculaValorMedia($Espera ,$array_idservicos, $nomeServico , $nomeLocal , null);	
	 	$sumAtendimento  = CalculaValorMedia($Atendimento , $array_idservicos, $nomeServico , $nomeLocal , null);		
	 	$_SESSION["espera"] = $sumEspera;
   	$_SESSION["atendimento"] = $sumAtendimento;
   	$_SESSION["servico"] = $nomeServico;
   	for($k = 0; $k<count($sumEspera); $k++){
			$res["espera"] +=  $sumEspera[$k]["valor"] ;
			$res["atendimento"] +=  $sumAtendimento[$k]["valor"];
		}
		
	 	$res["espera"] = $res["espera"] / $numTuplos;
		$res["atendimento"] = $res["atendimento"]/ $numTuplos;
	 		
		return $res;
	}
	
	function GetSenhasDoDia($local, $servico)
	{
		$sql = "SELECT distinct concat_ws('_', numero_senha, servico_emissao) as senha
			FROM log_atendimentos
			WHERE id_servico = '" . $servico . "'
			and id_loja= '" . $local . "'
			and tipo='Terminado'
			AND numero_senha != 0
			AND data_hora >= CURDATE()
			and concat_ws('_', numero_senha, servico_emissao) not in
				(select distinct concat_ws('_', numero_senha, servico_emissao)
				from log_atendimentos
				WHERE id_servico = '" . $servico . "'
				and id_loja= '" . $local . "'
				and tipo='Anulada'
				AND numero_senha != 0
				AND data_hora >= CURDATE())";
		
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " ."GetSenhasDoDia". $ERROS[0] . " </div>";
			return false;
		}
		$senhas = array();
		while ($row = $this->bd->obterRegisto($rs))
		{
			array_push($senhas, $row['senha']);
		}
		return $senhas;
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>
