<?php

/* Classe Utlizzata per l'inserimento dei dati statistici del giorno */
 

class GravacaoResumoDia
{
	var $bd;
	
	function GravacaoResumoDia()
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$this->bd = new AcessoBD();
		return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
	}
	
	function __destruct()
	{
		$this->bd->fecharBD();
	}
	
	function InserirResumo($data="", $hist=false)
	{
		$est = new EstatisticaAtendimentos;
		
		if (strlen($data))
		{
			echo $data . "\n";
			
			//Structura para gravar todos os dados do resumo diario da utilizar para escrever ficheiro xml	
			$struct = array();
			$lojas = array();
				
			$sql_lojas = "select * from lojas;";
			if (!$rsloja = $this->bd->executarSQL($sql_lojas))
			{
				return;
			}	
	       
			$num = $this->bd->obterNumRegistos($rsloja);
			for ($i = 0; $i < $num; $i++)
			{
				$this->bd->moverRegisto($rsloja , $i);
				$lojas[$i]["id_local"]= $this->bd->obterValor($rsloja, "id_loja");
				$lojas[$i]["nome"]= $this->bd->obterValor($rsloja, "nome");
				$lojas[$i]["endereco"]= $this->bd->obterValor($rsloja, "endereco");
				$lojas[$i]["email"]= $this->bd->obterValor($rsloja, "email");
			}
			
			//~ echo print_r($lojas, true) . "\n";
			
			$sql_servicos = "SELECT sp.id_loja as id_loja, sp.id_servico as id_servico, sb.id_balcao as id_balcao, l.endereco as endereco, l.nome as nome, b.nome as balcao , s.nome as servico
				FROM servicos_prestados sp, servicos s, servicos_balcao sb,lojas l, balcoes b  
				WHERE sb.id_balcao = b.id_balcao and sp.id_servico= s.id_servico and sp.id_loja= l.id_loja and s.id_servico = sb.id_servico order by id_loja,id_servico, id_balcao;";		
				
			if(!$rsserv = $this->bd->executarSQL($sql_servicos))
			{
				return;
			}
			
			$num = $this->bd->obterNumRegistos($rsserv);
			for ($i = 0; $i < $num; $i++)
			{
				$this->bd->moverRegisto($rsserv,$i);
				$struct[$i]["data"] = $data;
				$struct[$i]["endereco"] = $this->bd->obterValor($rsserv,"endereco"); 
				$struct[$i]["nomeServico"] = $this->bd->obterValor($rsserv,"servico"); 
				$struct[$i]["id_loja"]  = $this->bd->obterValor($rsserv, "id_loja");
				$struct[$i]["id_servico"] = $this->bd->obterValor($rsserv, "id_servico");
				$struct[$i]["id_balcao"] = $this->bd->obterValor($rsserv,"id_balcao");
				$struct[$i]["nome_balcao"] = $this->bd->obterValor($rsserv,"balcao");
				$struct[$i]["id_empregado"] = "null";
				$struct[$i]["senhas_emitidas"] =  $est->GetNumeroSenhasEmitidas($struct[$i]["id_loja"], $struct[$i]["id_servico"], $data, "", $hist);
				$struct[$i]["senhas_chamadas"] =  $est->GetNumeroSenhasAtendidas($struct[$i]["id_loja"], $struct[$i]["id_servico"], $data, $struct[$i]["id_balcao"], $hist);
				$struct[$i]["senhas_desistidas"] =  $est->GetNumeroSenhasDesistidas($struct[$i]["id_loja"], $struct[$i]["id_servico"], $data, $struct[$i]["id_balcao"], $hist);
				$struct[$i]["media_espera"] =  $est->GetTempoMedioEspera($struct[$i]["id_loja"], $struct[$i]["id_servico"], $data, $struct[$i]["id_balcao"], $hist);
				$struct[$i]["media_atendimento"] =  $est->GetTempoMedioAtendimento($struct[$i]["id_loja"], $struct[$i]["id_servico"], $data, $struct[$i]["id_balcao"], $hist);
				
				$sql_insert = "INSERT INTO resumodiario (data_resumo, id_servico, id_loja, id_balcao, id_empregado, senhas_emitidas, senhas_chamadas, senhas_desistidas, tempo_medio_espera, tempo_medio_atendimento) VALUES (
					'".$struct[$i]["data"]."',
					'".$struct[$i]["id_servico"]."',
					'".$struct[$i]["id_loja"]."',
					'".$struct[$i]["id_balcao"]."',
					'".$struct[$i]["id_empregado"]."',
					'".$struct[$i]["senhas_emitidas"]."',
					'".$struct[$i]["senhas_chamadas"]."',
					'".$struct[$i]["senhas_desistidas"]."',
					'".$struct[$i]["media_espera"]."',
					'".$struct[$i]["media_atendimento"]."')";
				if(!$rsinsert=$this->bd->executarSQL($sql_insert))
				{
					echo "Occorreo um erro a executar o sql de insert";
					return;
				}
			}
			
			//~ echo print_r($struct, true) . "\n";
			$this->EscreveXmlResumo($struct , $lojas);
		}
		else
		{
			$datas = $est->GetDatas("", "", "", $hist);
			
			for ($i=0; $i<count($datas); $i++)
			{
				$this->InserirResumo($datas[$i], $hist);
			}
		}
		unset($est);
	}
	
	
	//função que ecrive os dados dos resumo diario de un determinado dia en um ficheiro xml da enviar ao servidor central
	function EscreveXmlResumo($struct , $lojas){
		GLOBAL  $NOME_LOCAL;
		
		if(count($struct)>0){
			$documento = abreXMLSync();
			$raiz = $documento->firstChild;
			$resumo = $documento->createElement("resumo_diario");
			$raiz -> appendChild($resumo);	
			$resumo -> setAttribute("iteracao", count($struct));
		//	$resumo -> setAttribute("accao" , $operacao);
			
			$elemento = $documento->createElement("nome_client");
			$elemento -> nodeValue = $NOME_LOCAL;
			$resumo -> appendChild($elemento);
			
			for($i=0; $i < count($lojas); $i++){
				
				$elemento = $documento->createElement("id_local");
				$elemento -> nodeValue = $lojas[$i]["id_local"];
				$resumo -> appendChild($elemento);	
				
				$elemento = $documento->createElement("nome");
				$elemento -> nodeValue = $lojas[$i]["nome"];
				$resumo -> appendChild($elemento);	
				
				$elemento = $documento->createElement("endereco");
				$elemento -> nodeValue = $lojas[$i]["endereco"];
				$resumo -> appendChild($elemento);	
				
				$elemento = $documento->createElement("email");
				$elemento -> nodeValue = $lojas[$i]["email"];
				$resumo -> appendChild($elemento);	
								
			}
			
			
			for($i=0; $i < count($struct); $i++){
				
				$elemento = $documento->createElement("id");
				$elemento -> nodeValue = $i;
				$resumo -> appendChild($elemento);	
						
						
				$elemento = $documento->createElement("data");
				$elemento -> nodeValue = $struct[$i]["data"];
				$resumo -> appendChild($elemento);	
				
				$elemento = $documento->createElement("nomServico");
				$elemento -> nodeValue = $struct[$i]["nomeServico"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("id_servico");
				$elemento -> nodeValue = $struct[$i]["id_servico"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("id_loja");
				$elemento -> nodeValue = $struct[$i]["id_loja"];
				$resumo -> appendChild($elemento);				
				
				$elemento = $documento->createElement("id_balcao");
				$elemento -> nodeValue = $struct[$i]["id_balcao"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("nome_balcao");
				$elemento -> nodeValue = $struct[$i]["nome_balcao"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("id_empregado");
				$elemento -> nodeValue = $struct[$i]["id_empregado"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("senhas_emitidas");
				$elemento -> nodeValue = $struct[$i]["senhas_emitidas"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("senhas_chamadas");
				$elemento -> nodeValue = $struct[$i]["senhas_chamadas"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("media_espera");
				$elemento -> nodeValue = $struct[$i]["media_espera"];
				$resumo -> appendChild($elemento);
				
				$elemento = $documento->createElement("media_atendimento");
				$elemento -> nodeValue = $struct[$i]["media_atendimento"];
				$resumo -> appendChild($elemento);
				
				
			}			
		
			fechaXMLResumo($documento);
		}
	
	
	}
	
	function Fechar()
	{
		$this->bd->fecharBD();
	}


}	
?>
