<?php  

session_start();

require_once("../config.inc.php");
//require('../phpUtils/xlsxwriter.class.php');

$writer = new XLSXWriter();
$sheetName = 'Resumo Por Serviço';
$dataInicio = getRequestValue('data_inicio');
$dataFim = getRequestValue('data_fim');

$local = strlen(trim(getRequestValue('local')))?explode(",", getRequestValue('local')):'';
$servico = strlen(trim(getRequestValue('servico')))?explode(",", getRequestValue('servico')):'';

$oSenhas = new Senhas();
$senhas = $oSenhas->GetSenhasFormularios($dataInicio, $dataFim, $local, $servico);
unset($oSenhas);

$out = "";

if (is_array($senhas) && count($senhas)) {
    
    $keys_aux = array_keys($senhas[0]);
    $keys = array();
    $i = 0;
    foreach ($keys_aux AS $key) {
        if (!is_numeric($key)) {
            //$keys[] = $key;
            //$keys[$key] = 'integer';
            switch($key) {
                case 'data':
                    $keys['Data'] = 'date';

                break;
                case 'numero_senha':
                    $keys['Número Senha'] = 'integer';
                    break;
                case 'loja':
                    $keys['Loja'] = 'string';
                break;
                case 'servico_emissao':
                    $keys['Serviço Emissão'] = 'string';
                break;
                case 'servico_destino':
                    $keys['Serviço Destino'] = 'string';
                break;
                case 'data_emissao':
                    $keys['Data Emissão'] = 'date';
                break;
                case 'hora_emissao':
                    $keys['Hora Emissão'] = 'time';
                break;
                case 'previsao_atendimento':
                    $keys['Previsão Atendimento'] = 'string';
                break;
                
                case 'tempo_espera':
                    $keys['Tempo Espera'] = 'string';
                break;
                case 'tempo_atendimento':
                    $keys['Tempo Atendimento'] = 'string';
                break;
                case 'balcao':
                    $keys['Balcão'] = 'string';
                break;
                case 'empregado':
                    $keys['Empregado'] = 'string';
                break;
                case 'nome_utilizador':
                    $keys['Nome Utilizador'] = 'string';
                break;
                case 'status':
                    $keys['Estado'] = 'string';                    
                break;
                case 'satisfacao':
                    $keys['Satisfação'] = 'integer';
                case 'dataform':
                    $keys['Resposta Formulário'] = 'string';
                case 'tipo':
                    $keys['Tipo'] = 'string';
                case 'numero':
                    $keys['Número'] = 'integer';
                case 'nome':
                    $keys['Nome'] = 'string';
                case 'empresa':
                    $keys['Empresa'] = 'string';
                case 'area':
                    $keys['Área'] = 'string';
                case 'aduser':
                    $keys['AdUser'] = 'string';
                    
                break;
            }
            ++$i;
        }
    }
    //$out = implode(';', $keys) . "\r";
               
    $writer->writeSheetHeader($sheetName, $keys, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,15,15,20,20,15,15,15,15,15,20,20,15,15,15,50, 15,15,15,15,15,15]] );
    $format = array('font'=>'Calibri','font-size'=>12);
    $formNames = array();
    foreach ($senhas as $row) {
        //$writer->writeSheetRow($sheetName, $row, $format);
        $linha = array();
        foreach ($row AS $field => $value) {

            if($field == 'dataform' && !is_null($value)){
               $data = json_decode( $value, true);
              
               $form = '';
        
               foreach ($data as $name => $val) {                   
                    $form .= var_export($name, true) . ': ';
                    if(is_array($val))
                        $form .= implode(',', $val) . ' | ';
                    else  $form .= $nomis.  ' | ';
                }
                
                $value = $form;

            }
            //echo $value;
            array_push($linha,$value);
        }
       
        $writer->writeSheetRow($sheetName, $linha, $format);
    }
} else 
{

    echo '<script type="text/javascript">';
    echo 'function confirmExit() {check = window.alert("Sem dados para exportar"); location=history.back();}';
    echo ' confirmExit(); ';  //not showing an alert box.
    echo '</script>';
    exit(0);
}

/*if (ini_get('zlib.output_compression')) {
    ini_set('zlib.output_compression', 'Off');
}*/

$fileName = "ExportSenhas_Servico.xlsx";// . exec("hostname") . ".csv";
/*$fileSize = strlen($out);

header("Cache-Control: "); # leave blank to avoid IE errors
header("Pragma: "); # leave blank to avoid IE errors
header("Content-type: text/plain");
header("Content-Disposition: attachment; filename=\"$fileName\"");
header("Content-length: $fileSize");

echo "$out";*/

ini_set('display_errors', 0);
//ini_set('log_errors', 1);
//error_reporting(E_ALL & ~E_NOTICE);

//$filename = "example.xlsx";
header('Content-disposition: attachment; filename="'.XLSXWriter::sanitize_filename($fileName).'"');
header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
header('Content-Transfer-Encoding: binary');
header('Cache-Control: must-revalidate');
header('Pragma: public');
$writer->writeToStdOut();
exit(0);