<?php
	
/* Classe de Gestao de Atendimentos por balcao e user em Curso */
 
class AtendimentoBalcao extends AcessoBD {
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function AtendimentoBalcao() {
	 	global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	function GeraImagemTotSenhas($filepath){
		$Chart1 = array();
		$dados = $_SESSION["dadosempregado"];
	
		$chart = new VerticalBarChart(1450 , 600);
		$serie = new XYDataSet();
	
		for($y = 0; $y < count($dados); $y ++){
//			file_put_contents("/tmp/debug.txt", "\n".$dados[$y]["nome_empregado"]."    ".$dados[$y]["nome_balcao"]."   ".$dados[$y]["nome_loja"]."   atendida   ". $dados[$y]["atendida"] , FILE_APPEND);
		
			if($dados[$y]["atendida"] > 0)
				$serie->addPoint(new Point($dados[$y]["nome_empregado"]."\n".$dados[$y]["nome_balcao"]." \n".$dados[$y]["nome_loja"] , $dados[$y]["atendida"]));
			else
				$serie->addPoint(new Point($dados[$y]["nome_empregado"]."\n".$dados[$y]["nome_balcao"]."\n".$dados[$y]["nome_loja"] , 0));
					
		}		
		
		$dataSet = new XYSeriesDataSet();
	 	
		$dataSet->addSerie("Numero senhas atendidas" , $serie);
		
		$chart->setDataSet($dataSet);
		$chart->setTitle("Numero de senhas atendidas por Utilizador/Balcao/Local:");
	 	$chart->getPlot()->setGraphCaptionRatio(0.65);		
		
		$file_name = construirNome($filepath);			
		array_push($Chart1,$file_name);

			
		$chart->render($file_name);
		
		return $Chart1;

			
	}
	
	function GeraImagemTotSenhasUtilizador($filepath){
		$Chart2 = array();
		$dados = $_SESSION["atendimento_empreg"];	
		
		$chart = new VerticalBarChart(1450 , 600);
		$serie = new XYDataSet();
		
		
		for($y = 0; $y < count($dados); $y ++)					
			$serie->addPoint(new Point($dados[$y]["empregado"]." \n".$dados[$y]["loja"] , $dados[$y]["tot_atendidas"]));
					
		
		$dataSet = new XYSeriesDataSet();
	 	
		$dataSet->addSerie("Numero senhas atendidas" , $serie);
		
		$chart->setDataSet($dataSet);
		$chart->setTitle(translate('word_numero_senhas_por_utilizador', true).":");
	 	$chart->getPlot()->setGraphCaptionRatio(0.65);		
		$file_name = construirNome($filepath);			
		array_push($Chart2,$file_name);

			
		$chart->render($file_name);
		
		return $Chart2;

	
	}
	
	
	function GeraImagemSenhasHoraria($filepath , $dados){
		$Chart3 = array();
		$numhoras = $dados[0];
		$chart = new LineChart(1300 , 600);
		
		
		for($y = 0; $y < count($dados); $y ++){
			$serie[$y] = new XYDataSet();
			for($k = 0; $k< (count($numhoras)-1); $k++)
					$serie[$y]->addPoint(new Point($dados[$y][$k]["hora"].":00" , $dados[$y][$k]["atendida"]));
								
		}		
		$dataSet = new XYSeriesDataSet();
	 	for($j = 0; $j < count($dados); $j ++)
			$dataSet->addSerie($dados[$j]["etichetta"] , $serie[$j]);
 	
		
		$chart->setDataSet($dataSet);
		$chart->setTitle(translate('word_numero_senhas_atendidas_por_hora', true).":");
	 	$chart->getPlot()->setGraphCaptionRatio(0.65);		
		$file_name = construirNome($filepath);			
		array_push($Chart3,$file_name);

			
		$chart->render($file_name);
		
		return $Chart3;
	}
	
	
	function Listar()
	{
		unset($_SESSION["atendimento_empreg"], $_SESSION["dadosempregado"]); 
		$data_actual = strtotime(date("Y-m-d"));
		
		$sql_servicos = "SELECT l.id_loja, l.nome AS loja, b.id_balcao, b.nome AS balcao, e.id_entidade, e.nome AS entidade 
			FROM  lojas l, balcoes b, entidades e 
			WHERE b.id_loja = l.id_loja AND b.id_entidade = e.id_entidade AND b.estado = 1 ";
		
		$sql_servicos .= "AND (e.id_entidade = ".$_SESSION["entidade"][0];	
		for($i= 1; $i < count($_SESSION["entidade"]); $i++)
			$sql_servicos .= " OR e.id_entidade = ".$_SESSION["entidade"][$i];
		$sql_servicos .= ") ";
		
		$sql_servicos .= "AND (l.id_loja = ".$_SESSION["loja"][0];	
		for($i= 1; $i < count($_SESSION["loja"]); $i++)
			$sql_servicos .= " OR l.id_loja = ".$_SESSION["loja"][$i];
		$sql_servicos .= ") ";	
			
		if($_REQUEST["balcao"] != "")
			$sql_servicos = $sql_servicos."AND b.id_balcao = ".$_REQUEST["balcao"]." ";
		if($_REQUEST["loja"] != "")
			$sql_servicos = $sql_servicos."AND b.id_loja = ".$_REQUEST["loja"]." ";
		if($_REQUEST["entidade"] != "")
			$sql_servicos = $sql_servicos."AND b.id_entidade = ".$_REQUEST["entidade"]." ";
		if($_REQUEST["utente"] != "")
			$sql_servicos = $sql_servicos."AND e.id_empregado = ".$_REQUEST["utente"]." ";
      	
		if(strcasecmp($_GET["campo"] , "loja") == 0)
			$sql_servicos = $sql_servicos."ORDER BY l.nome";
		if(strcasecmp($_GET["campo"] , "balcao") == 0)
			$sql_servicos = $sql_servicos."ORDER BY b.nome";
		if(strcasecmp($_GET["campo"] , "loja") != 0 &&  strcasecmp($_GET["campo"] , "balcao") != 0)	  		
			$sql_servicos = $sql_servicos."ORDER BY b.id_loja, b.id_balcao";
		if($_GET["ordem"] == 0)      
			$sql_servicos = $sql_servicos." ASC;";
		if($_GET["ordem"] == 1)  
			$sql_servicos = $sql_servicos." DESC;";
      
		//~ echo $sql_servicos;	   	  
		if(!$rsserv = $this->bd->executarSQL($sql_servicos))
		{
			// erro da bd
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}
		
		global $ERROS, $N_REGISTOS;
		$n = 1;
		$numRegPag =20;
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rsserv); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>".translate('word_nao_existem_balcoes_activos',true)."!</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
		 			<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
		 						<td class='button_page' colspan='6'>";
		
		$pagina = 1;
		if($_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];
						
		$url2spread = "?servico=" . $_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'];
//		echo drawPaginas($url2spread . "?campo=$_REQUEST[campo]&ordem=$_REQUEST[ordem]", $numPaginas, $pagina);
								
		$n = ($pagina - 1) * $numRegPag;
		$incremento = $n;
		if($pagina == $numPaginas && ($numTuplos % $numRegPag != 0))
			$numRegPag = $numTuplos % $numRegPag;
							
		echo "				
								</td>
							</tr>";
		
		$empregado_balcao = array();
		$n=0;
		$i=0;//indice por o array dos empregados
			
		while($n < ($numRegPag + $incremento))
		{
			$this -> bd -> moverRegisto($rsserv , $n);
			$id_l = $this -> bd -> obterValor($rsserv , "id_loja");
			$id_b = $this -> bd -> obterValor($rsserv , "id_balcao");	
				
				
			$sql_entrada = " SELECT MAX(data_hora) as entrada FROM log_acessos_empregados WHERE data_hora >= curdate() AND acesso = 'Entrada' AND id_loja=".$id_l." AND id_balcao = ".$id_b.";";
	//		echo $sql_entrada."<br>";
							
			if(!$rsentrada = $this -> bd -> executarSQL($sql_entrada))
			{
				// erro da bd
				echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
				return;
			}
				
			$this -> bd -> moverRegisto($rsentrada , 0);
			$data_entrada = $this -> bd -> obterValor($rsentrada , "entrada");	
			if($data_entrada != '')
			{	
				$sql_empregado = "SELECT e.id_empregado, e.nome AS nome FROM empregados e, log_acessos_empregados le 
					WHERE estado = 1 AND e.id_empregado=le.id_empregado AND le.data_hora='".$data_entrada."' 
					AND le.id_loja =".$id_l." AND le.id_balcao = ".$id_b."
					ORDER BY id_empregado;";
											
				//~ echo $sql_empregado."<br>";
								
				if(!$rsempregado = $this -> bd -> executarSQL($sql_empregado))
				{
					// erro da bd
					echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
					return;
				}
		
				$this -> bd -> moverRegisto($rsempregado , 0);	
				$num_empregado  = $this -> bd -> obterNumRegistos($rsempregado);
			
				if($num_empregado > 0)
				{
					$empregado_balcao[$i]["id_empregado"] = $this -> bd -> obterValor($rsempregado , "id_empregado"); 
					$empregado_balcao[$i]["nome_empregado"] = $this -> bd -> obterValor($rsempregado , "nome");
					$empregado_balcao[$i]["id_loja"] = $this -> bd -> obterValor($rsserv , "id_loja"); 	 	
					$empregado_balcao[$i]["nome_loja"] = $this -> bd -> obterValor($rsserv , "loja"); 	
					$empregado_balcao[$i]["id_entidade"] = $this -> bd -> obterValor($rsserv , "id_entidade"); 	 	
					$empregado_balcao[$i]["nome_entidade"] = $this -> bd -> obterValor($rsserv , "entidade"); 	
					$empregado_balcao[$i]["id_balcao"] = $this -> bd -> obterValor($rsserv , "id_balcao"); 	
					$empregado_balcao[$i]["nome_balcao"] = $this -> bd -> obterValor($rsserv , "balcao"); 					
					$i++;	
				}
			}
			$n++;
		}
		
		$j=0;
		$temp = array();//utilizado para gravaçao do dados da ordenar
			
		while($j < count($empregado_balcao))
		{
			$sql_atendida = "SELECT COUNT(numero_senha) AS suma FROM log_atendimentos WHERE id_balcao = ".$empregado_balcao[$j]["id_balcao"]."
				AND id_loja=".$empregado_balcao[$j]["id_loja"]." 
				AND id_empregado = ".$empregado_balcao[$j]["id_empregado"]." AND tipo= 'Chamada';";
			
			if(!$rsatendida = $this -> bd -> executarSQL($sql_atendida))
			{
				// erro da bd
				echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
				return;
			}
			$this -> bd -> moverRegisto($rsatendida , 0);
			$empregado_balcao[$j]["atendida"] = $this -> bd -> obterValor($rsatendida , "suma"); 
			
			$sql_terminado = "SELECT * FROM log_atendimentos WHERE id_balcao = ".$empregado_balcao[$j]["id_balcao"]."
				AND id_loja=".$empregado_balcao[$j]["id_loja"]." 
				AND id_empregado = ".$empregado_balcao[$j]["id_empregado"]." AND tipo= 'Terminado' ORDER BY numero_senha, id_servico;";
		
		 	if(!$rsterminado = $this -> bd -> executarSQL($sql_terminado))
			{
				// erro da bd
				echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
				return;
			}
		
			$num_terminado = $this -> bd -> obterNumRegistos($rsterminado);     	
			
			$i=0;
			$tempo_medio_at = 0;
			while($i < $num_terminado)
			{
				$this -> bd -> moverRegisto($rsterminado , $i);
				$num_senha = $this -> bd -> obterValor($rsterminado , "numero_senha");			
				$id_servico = $this -> bd -> obterValor($rsterminado , "id_servico");
						
				$sql_chamada = "SELECT * FROM log_atendimentos WHERE id_balcao=".$empregado_balcao[$j]["id_balcao"]."
					AND id_loja = ".$empregado_balcao[$j]["id_loja"]." 
					AND id_empregado = ".$empregado_balcao[$j]["id_empregado"]."
					AND numero_senha = ".$num_senha." AND tipo = 'Chamada'
					AND id_servico = ".$id_servico.";";
				
				if(!$rschamada = $this -> bd -> executarSQL($sql_chamada))
				{
					// erro da bd
					echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
					return;
				}
				
				$tempo_terminado = strtotime($this -> bd -> obterValor($rsterminado , "data_hora")) - $data_actual;			
				$tempo_chamada = strtotime($this -> bd -> obterValor($rschamada , "data_hora")) - $data_actual;
				$tempo_medio_at += ($tempo_terminado - $tempo_chamada);
			
				$i++;
			}
		
			if($num_terminado != 0)
				$empregado_balcao[$j]["tempo"] = (int)($tempo_medio_at / $num_terminado);
			else
				$empregado_balcao[$j]["tempo"] = 0;
			
			if(strcasecmp($_GET["campo"] , "utente") == 0)
				$temp[$j] = $empregado_balcao[$j]["nome_empregado"];
			if(strcasecmp($_GET["campo"] , "chamada") == 0)
				$temp[$j] = $empregado_balcao[$j]["atendida"];
			if(strcasecmp($_GET["campo"] , "mediaatendimento") == 0)
				$temp[$j] = $empregado_balcao[$j]["tempo"];
			if(strcasecmp($_GET["campo"] , "entidade") == 0)
				$temp[$j] = $empregado_balcao[$j]["nome_entidade"];

			$j++;
		}
		
		if(count($empregado_balcao) != 0)
		{
			/* primeira linha da tabela com os titulos dos campos */
			
			echo "<tr class='column_row'>";
			if (strcmp($_GET["campo"], "loja") == 0)
				if ($_GET["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "</div></a></td>";
			
			if (strcmp($_GET["campo"], "entidade") == 0)
				if ($_GET["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=entidade&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=entidade&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=entidade&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_entity', true). "</div></a></td>";
			
			if (strcmp($_GET["campo"], "balcao") == 0)
				if ($_GET["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=balcao&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_agency', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=balcao&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_agency', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
			else 			
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=balcao&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_agency', true). "</div></a></td>";
	 
			if (strcmp($_GET["campo"], "utente") == 0)
				if ($_GET["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=utente&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_user', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=utente&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_user', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
			else 			
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=utente&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_user', true). "</div></a></td>";
				
			if (strcmp($_GET["campo"], "chamada") == 0)
					if ($_GET["ordem"] == 1)
						echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_met', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
					else
						echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_met', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
			else 			
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_met', true). "</div></a></td>";

			//Colonna per Tempo Medio di Attendimento
			if (strcmp($_GET["campo"], "mediaatendimento") == 0)
				if ($_GET["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true). "</div></a></td>";
		
			echo "</tr>";	
				 
			$i = 0;	
			$ordem = array();//array utilizado para estabelecer o criterio de ordenaçao dos dados do grafico;
			$fuso = 3600;
			
			switch($_GET["campo"])
			{	
				case "utente":
					$array1 = ordenacao($temp , $_GET["ordem"]);	
					while (list($chiave, $valore) = each($array1))
					{			
						echo"<tr>
							<td>". $empregado_balcao[$chiave]["nome_loja"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_entidade"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_balcao"] . "</td>
							<td>".$valore  . "</td>
							<td>".$empregado_balcao[$chiave]["atendida"] . "</td>
							<td>". strftime("%X" , $empregado_balcao[$chiave]["tempo"] - $fuso) . "</td>
							</tr>";
						$tot_senhas += $empregado_balcao[$chiave]["atendida"];
						$tot_atendimento += $empregado_balcao[$chiave]["tempo"];
						$ordem[$i] = $chiave;
						$i++;
					}
					break;	
		
				case "chamada":
					$array1 = ordenacao($temp , $_GET["ordem"]);	
					while (list($chiave, $valore) = each($array1))
					{
						echo"<tr>
							<td>". $empregado_balcao[$chiave]["nome_loja"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_entidade"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_balcao"] . "</td>
							<td>".$empregado_balcao[$chiave]["nome_empregado"]. "</td>
							<td>".$valore . "</td>
							<td>". strftime("%X" , $empregado_balcao[$chiave]["tempo"] - $fuso) . "</td>
							</tr>";
						$tot_senhas += $empregado_balcao[$chiave]["atendida"];
						$tot_atendimento += $empregado_balcao[$chiave]["tempo"];
						$ordem[$i] = $chiave;
						$i++;
					}
					break;	

				case "entidade":
					$array1 = ordenacao($temp , $_GET["ordem"]);	
					while (list($chiave, $valore) = each($array1))
					{
						echo"<tr>
							<td>". $empregado_balcao[$chiave]["nome_loja"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_balcao"] . "</td>
							<td>".$empregado_balcao[$chiave]["nome_empregado"]. "</td>
							<td>".$valore . "</td>
							<td>". strftime("%X" , $empregado_balcao[$chiave]["tempo"] - $fuso) . "</td>
							</tr>";
						$tot_senhas += $empregado_balcao[$chiave]["atendida"];
						$tot_atendimento += $empregado_balcao[$chiave]["tempo"];
						$ordem[$i] = $chiave;
						$i++;
					}
					break;	
				
				case "mediaatendimento":
					$array1 = ordenacao($temp , $_GET["ordem"]);	
					while (list($chiave, $valore) = each($array1))
					{
						echo"<tr>
							<td>". $empregado_balcao[$chiave]["nome_loja"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_entidade"] . "</td>
							<td>". $empregado_balcao[$chiave]["nome_balcao"] . "</td>
							<td>".$empregado_balcao[$chiave]["nome_empregado"]. "</td>
							<td>".$empregado_balcao[$chiave]["atendida"]. "</td>
							<td>". strftime("%X" , $valore - $fuso) . "</td>
							</tr>";
						$tot_senhas += $empregado_balcao[$chiave]["atendida"];
						$tot_atendimento += $empregado_balcao[$chiave]["tempo"];
						$ordem[$i] = $chiave;
						$i++;
					}
					break;
		
				default:
					for($j=0; $j < count($empregado_balcao); $j++)
					{
						echo "<tr>
							<td>".$empregado_balcao[$j]["nome_loja"]."</td>
							<td>". $empregado_balcao[$j]["nome_entidade"] . "</td>
							<td>".$empregado_balcao[$j]["nome_balcao"]."</td>
							<td>".$empregado_balcao[$j]["nome_empregado"]."</td>
							<td>".$empregado_balcao[$j]["atendida"]."</td>
							<td>".strftime("%X" , $empregado_balcao[$j]["tempo"] - $fuso) ."</td>
							</tr>";
						$tot_senhas += $empregado_balcao[$j]["atendida"];
						$tot_atendimento += $empregado_balcao[$j]["tempo"];
						$ordem[$j] = $j;
					}
			}
					
			$dados_ordenado = array();//array dos dados ordenados para os grafico		
			for($j=0; $j < count($ordem); $j++)
			{
				$chiave = $ordem[$j];
				$dados_ordenado[$j]["id_empregado"] = $empregado_balcao[$chiave]["id_empregado"];
				$dados_ordenado[$j]["nome_empregado"] = $empregado_balcao[$chiave]["nome_empregado"];
				$dados_ordenado[$j]["id_loja"] =  $empregado_balcao[$chiave]["id_loja"];
				$dados_ordenado[$j]["nome_loja"] =  $empregado_balcao[$chiave]["nome_loja"];
				$dados_ordenado[$j]["id_balcao"] = $empregado_balcao[$chiave]["id_balcao"];
				$dados_ordenado[$j]["nome_balcao"] = $empregado_balcao[$chiave]["nome_balcao"]; 
				$dados_ordenado[$j]["atendida"] = $empregado_balcao[$chiave]["atendida"];
				//		$tot_senhas += $empregado_balcao[$chiave]["atendida"];
				//		$tot_atendimento += $empregado_balcao[$chiave]["tempo"];
			}
			
			
			echo "		<tr>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>-----</td>
						</tr>	
						<tr>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>".$tot_senhas."</td>
						</tr>	
					</table>
						</td> 	
						</tr>
					</table>";	
				
			//~ $_SESSION["dadosempregado"] = $empregado_balcao;
			$_SESSION["dadosempregado"] = $dados_ordenado;
			//suma dos valares das senhas atendidas para o mismo utilizador no mismo local por diferentes balcao 
			$sql_lojas = "SELECT * FROM lojas;";
			if (!$rslojas = $this -> bd -> executarSQL($sql_lojas))
			{
				// erro da bd
				echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
				return;
			}
			$num_lojas = $this -> bd -> obterNumRegistos($rslojas);
			
			$j = 0;
			while($j < count($empregado_balcao))
			{
				$id[$j] = $empregado_balcao[$j]["id_empregado"];
				$nome_empr[$j] = $empregado_balcao[$j]["nome_empregado"];					
				$nome_loja[$j] = $empregado_balcao[$j]["nome_loja"];
				$j++;
			}     	
			
			$id_empregados = array_count_values($id);
			
			$i=0;   
					
			while(list($chiave , $valore) = each($id_empregados) )
			{
				$sql = "SELECT COUNT(numero_senha) AS totale FROM log_atendimentos WHERE data_hora >=  CURDATE()  AND id_empregado = ".$chiave." AND tipo = 'Chamada';";
				if(!$rs = $this -> bd -> executarSQL($sql))
				{
					// erro da bd
					echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
					return;
				}
				$tot_atendidas = $this -> bd -> obterValor($rs , "totale");
				$posicao = array_search($chiave , $id);
				
				$_SESSION["atendimento_empreg"][$i]["loja"] = $nome_loja[$posicao];
				$_SESSION["atendimento_empreg"][$i]["empregado"] = $nome_empr[$posicao];
				$_SESSION["atendimento_empreg"][$i]["tot_atendidas"] = $tot_atendidas;
				
				$i++;			
			}	
			$tot_atendimento = $tot_atendimento / count($empregado_balcao);  	
			unset($empregado_balcao , $dados_ordenado);	
			return strftime("%X" ,$tot_atendimento - $fuso);	 		
		}
		else
		{
			echo "
							</table>
						</td> 	
					</tr>
				</table>";	
			echo "<div id='msg_erro' class='error_space'> ".$ERROS[11]." </div>";
			return 0;
		}			
	}
	
	//gera o resumo diario por balcao para um determinado dia
	function GeraResumoBalcao($data){
   		// TODO: obter limites pela tabela horarios da bd
		$data_actual =(int) strtotime(date("Y-m-d"));
		$fuso = 3600;
		
		
		$sql = "SELECT * FROM resumodiario_empregado WHERE data_resumo ='".$data."'";
		
		if($_GET["campo"] == "loja")
			$sql .= "  ORDER BY id_loja";
		
		if($_GET["campo"] == "balcao")
			$sql .= "  ORDER BY id_balcao";
		
		if($_GET["campo"] == "chamada")
			$sql .= "  ORDER BY senhas_chamadas";
		
		if($_GET["campo"] == "mediaatendimento")
			$sql .= "  ORDER BY tempo_medio_atendimento";
		
		if(strcasecmp($_GET["campo"] , "loja") != 0 &&  strcasecmp($_GET["campo"] , "balcao") != 0 && strcasecmp($_GET["campo"] , "chamada") != 0 &&  strcasecmp($_GET["campo"] , "mediaatendimento") != 0)
			$sql .= " ORDER BY id_loja,id_balcao";
			
		if($_GET["ordem"] == 0)
			$sql .= " ASC;";
		else
			$sql .= " DESC;";
		
		
		if(!$rs = $this->bd->executarSQL($sql)) {
    	   echo "<div id='msg_erro' class='error_space'> "."Erro do sql resumo diario  " . $ERROS[0] . " </div>";
      	return;
   	}
   	$numResumo = $this -> obterNumRegistos($rs);
		// caso n�o existam registos
	 	if($numResumo == 0) {
			echo "<div class='empty_msg'>".translate('word_number_registers', true) . "!</div>";
			return;
		}      

	       
		global $ERROS, $N_REGISTOS;
		$n = 1;
      $numRegPag =20;
		$numPaginas = 1; // n�mero de p�ginas de registos
		
		echo "	
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
		 			<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
		 						<td class='button_page' colspan='6'>";
		
		/* primeira linha da tabela com os titulos dos campos */
	 	
		
		echo "<tr class='column_row'>";
			
		if (strcmp($_GET["campo"], "loja") == 0)
         if ($_GET["ordem"] == 1)
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=loja&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
      else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=loja&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_local', true). "</div></a></td>";
		
		if (strcmp($_GET["campo"], "entidade") == 0)
         if ($_GET["ordem"] == 1)
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=entidade&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
             echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=entidade&ordem=1&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
      else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=entidade&ordem=0&loja=". $_REQUEST['loja']."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>" .translate('word_entity', true). "</div></a></td>";
		
			
		if (strcmp($_GET["campo"], "balcao") == 0)
			if ($_GET["ordem"] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=balcao&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_agency', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
 				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=balcao&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_agency', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=balcao&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_agency', true). "</div></a></td>";
 
		if (strcmp($_GET["campo"], "utente") == 0)
			if ($_GET["ordem"] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=utente&ordem=0&loja=". $_REQUEST['loja'] ."&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_user', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
 				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=utente&ordem=1&loja=". $_REQUEST['loja']. "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_user', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=utente&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_user', true). "</div></a></td>";
 

			
		if (strcmp($_GET["campo"], "chamada") == 0)
				if ($_GET["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_met', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=chamada&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_met', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=chamada&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_met', true). "</div></a></td>";

	//Colonna per Tempo Medio di Attendimento
     if (strcmp($_GET["campo"], "mediaatendimento") == 0)
         if ($_GET["ordem"] == 1)
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
         else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=mediaatendimento&ordem=1&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
     else
         echo "<td class='column_cell'><a class='data_order' href='?pagina=1&data=".$data."&campo=mediaatendimento&ordem=0&loja=". $_REQUEST['loja'] . "&servico=" .$_REQUEST['servico'] . "&tipo=" . $_REQUEST['tipo'] ."'><div>".translate('word_time_middle_attendance', true). "</div></a></td>";
	
		echo "</tr>";	
	
	
	$empregado_balcao = array();
	$i=0;//indice por o array dos empregados
		
	while($i < $numResumo) {
  		$this -> bd -> moverRegisto($rs , $i);
  		$id_l = $this -> bd -> obterValor($rs , "id_loja");
		$id_b = $this -> bd -> obterValor($rs , "id_balcao");	
		$id_e = $this -> bd -> obterValor($rs , "id_empregado");		
		$id_s = $this -> bd -> obterValor($rs , "id_servico");		

		$empregado_balcao[$i]["id_empregado"] = $id_e; 
		$empregado_balcao[$i]["nome_empregado"] = devolveNome("empregados","empregado" , $id_e);
		$empregado_balcao[$i]["id_loja"] = $id_l; 	 	
		$empregado_balcao[$i]["nome_loja"] =  devolveNome("lojas","loja" , $id_l);	
		$empregado_balcao[$i]["id_balcao"] = $id_b; 	
		$empregado_balcao[$i]["nome_balcao"] = devolveNome("balcoes","balcao" , $id_b); 	
		$empregado_balcao[$i]["tempo"] = $this -> bd -> obterValor($rs , "tempo_medio_atendimento");
		$empregado_balcao[$i]["atendida"] = $this -> bd -> obterValor($rs , "senhas_chamadas");
		
		$sql_ent = "SELECT e.id_entidade AS id , e.nome AS nome 
							FROM servicos s , entidades e WHERE s.id_entidade = e.id_entidade AND s.id_servico = ".$id_s.";";		
		
			
		if(!$rsent = $this->bd->executarSQL($sql_ent)) {
			echo "<div class='empty_msg'>ERRO para executar a sql entidade!</div>";
			return;
		}      

		
		$empregado_balcao[$i]["id_entidade"] = $this -> bd -> obterValor($rsent , "id");
		$empregado_balcao[$i]["nome_entidade"] = $this -> bd -> obterValor($rsent , "nome");
	 	
		
		$i++;
	}
	

		
		$temp = array();//utilizado para gravaçao do dados da ordenar
	 	if($_GET["campo"] == "entidade"){
	 		for($j=0; $j < $numResumo; $j++)
	 			$temp[$j] = $empregado_balcao[$j]["nome_entidade"];
	 	}
	 		

	
		$i = 0;	
		$ordem = array();//array utilizado para estabelecer o criterio de ordenaçao dos dados do grafico;
		$fuso = 3600;
		switch($_GET["campo"])
		{	
			
			case "entidade":
				$array1 = ordenacao($temp , $_GET["ordem"]);	
				while (list($chiave, $valore) = each($array1)) {			
 			   	echo"<tr>
							<td>". $empregado_balcao[$chiave]["nome_loja"] . "</td>
							<td>".$valore . "</td>	
							<td>". $empregado_balcao[$chiave]["nome_balcao"] . "</td>
							<td>".$empregado_balcao[$chiave]["nome_empregado"]. "</td>
							<td>".$empregado_balcao[$chiave]["atendida"] . "</td>	
               		<td>". $empregado_balcao[$chiave]["tempo"] . "</td>
						  </tr>";
						  	 $tot_senhas += $empregado_balcao[$chiave]["atendida"];
							$tot_atendimento += strtotime($empregado_balcao[$chiave]["tempo"])- $data_actual;
						  $ordem[$i] = $chiave;
						  $i++;
				}
			break;	
			
			default:		
				for($j=0; $j < count($empregado_balcao); $j++){
				echo "<tr>
							<td>".$empregado_balcao[$j]["nome_loja"]."</td>
							<td>". $empregado_balcao[$j]["nome_entidade"] . "</td>
							<td>".$empregado_balcao[$j]["nome_balcao"]."</td>
							<td>".$empregado_balcao[$j]["nome_empregado"]."</td>
							<td>".$empregado_balcao[$j]["atendida"]."</td>
							<td>".$empregado_balcao[$j]["tempo"]."</td>
						</tr>";
					$tot_senhas += $empregado_balcao[$j]["atendida"];
					$tot_atendimento += strtotime($empregado_balcao[$j]["tempo"]) - $data_actual;
								
					$ordem[$j] = $j;
					
				}
	
		}
		$dados_ordenado = array();//array dos dados ordenados para os grafico		
		for($j=0; $j < count($ordem); $j++){
			$chiave = $ordem[$j];
			$dados_ordenado[$j]["id_empregado"] = $empregado_balcao[$chiave]["id_empregado"];
			$dados_ordenado[$j]["nome_empregado"] = $empregado_balcao[$chiave]["nome_empregado"];
			$dados_ordenado[$j]["id_loja"] =  $empregado_balcao[$chiave]["id_loja"];
			$dados_ordenado[$j]["nome_loja"] =  $empregado_balcao[$chiave]["nome_loja"];
			$dados_ordenado[$j]["id_balcao"] = $empregado_balcao[$chiave]["id_balcao"];
			$dados_ordenado[$j]["nome_balcao"] = $empregado_balcao[$chiave]["nome_balcao"]; 
			$dados_ordenado[$j]["atendida"] = $empregado_balcao[$chiave]["atendida"];
	//		$tot_senhas += $empregado_balcao[$chiave]["atendida"];
	//		$tot_atendimento += $empregado_balcao[$chiave]["tempo"];
		}
		
		
		echo"		<tr>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>-----</td>
					</tr>	
					<tr>
	 					<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>".$tot_senhas."</td>
					</tr>	
	 			</table>
			  		</td> 	
					</tr>
		 		</table>";	
		
	//	$_SESSION["dadosempregado"] = $empregado_balcao;
		$_SESSION["dadosempregado"] = $dados_ordenado;
		//suma dos valares das senhas atendidas para o mismo utilizador no mismo local por diferentes balcao 
		$sql_lojas = "SELECT * FROM lojas;";
		if(!$rslojas = $this -> bd -> executarSQL($sql_lojas)){
			 // erro da bd
     		  echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
     		  return;
     	}
     	$num_lojas = $this -> bd -> obterNumRegistos($rslojas);
     	
     	$j = 0;
		while($j < count($empregado_balcao)){
			$id[$j] = $dados_ordenado[$j]["id_empregado"];
			$nome_empr[$j] = $dados_ordenado[$j]["nome_empregado"];					
			$nome_loja[$j] = $dados_ordenado[$j]["nome_loja"];
			$j++;
		}     	
     	
     	$id_empregados = array_count_values($id);
    	
		
 
		$i=0;   
		 	
     	while(list($chiave , $valore) = each($id_empregados) ){
			$sql = "SELECT SUM(senhas_chamadas) AS totale FROM resumodiario_empregado 
						WHERE id_empregado = ".$chiave.";";
			if(!$rs = $this -> bd -> executarSQL($sql)){
			 // erro da bd
     		  echo "<div id='msg_erro' class='error_space'> ".$ERROS[0]." </div>";
     		  return;
     		}
			
			$tot_atendidas = $this -> bd -> obterValor($rs , "totale");
			
			
			$posicao = array_search($chiave , $id);
		
			$_SESSION["atendimento_empreg"][$i]["loja"] = $nome_loja[$posicao];
			$_SESSION["atendimento_empreg"][$i]["empregado"] = $nome_empr[$posicao];
			$_SESSION["atendimento_empreg"][$i]["tot_atendidas"] = $tot_atendidas;
			
			$i++;			
		}	
		
	
		unset($empregado_balcao , $dados_ordenado);	

		$tot_media = $tot_atendimento / $numResumo;

		return (strftime("%X" ,$tot_media - $fuso)) ;	 
	}
	
		/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
	
	
	
}
	
	
?>