<?php

/* Classe de Gestão de Balcões */
class Balcao extends AcessoBD
{
    var $bd;

    /*
		Construtor da classe

		0 = Erro da BD
    */
    function Balcao()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
		Fun��o de inser��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Inserir($dados)
    {

        if(!is_array($dados["servicos_prestados"]))
        {
            $temp = $dados["servicos_prestados"];
            $dados["servicos_prestados"][0] = $temp;
        }

        // insere o novo registo na tabela dos balcoes
        $sql = "INSERT INTO balcoes (nome, id_loja, piso, estado,id_entidade,nome_ecra,buttonid, on_display, on_print) VALUES ('"
                . $dados["nome"] . "',"
                . $dados["id_loja"] .","
                . $dados["piso"] .","
                . $dados["estado"] .","
                . $dados["id_entidade"] .",'"
                . $dados["nomeecra"]."', ".(strlen(trim($dados["buttonid"]))?"'".$dados["buttonid"]."'":"null") .",'"
				. $dados["on_display"]."','"
				. $dados["on_print"]."')";

        if($rs = $this->bd->executarSQL($sql))
        {
            // obtem o id do balcao criado
            $sql = "SELECT MAX(id_balcao) as id_balcao FROM balcoes;";

            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            } else
            {
                //$balcao_id  = $this->bd->obterValor($rs, 0);
                 $balcao_id = $this->bd->obterValor($rs,"id_balcao");
                $this->EscreveXMLSync($balcao_id, "inserir");

                $dados['pri'] = $dados['pri']  ? $dados['pri'] : array(); // if it's not defined, set it as an empty array

                // regista os servicos associados ao balcão
                for($i =0; $i< count($dados["servicos_prestados"]); $i++)
                {
					$sp = (is_array($dados["pri"])) ? (in_array($dados["servicos_prestados"][$i], $dados["pri"])?"true":"false") : "false";
                    $sql = "INSERT INTO servicos_balcao (id_balcao, id_servico, servico_prioritario)
							VALUES (".$balcao_id.",".$dados["servicos_prestados"][$i] .",".$sp.");";
                    //debug($sql);
                    if(!$rs = $this->bd->executarSQL($sql))
                    {
                        return 0;
                    }
                }

                /* id_hist */
                $sql = "insert into id_hist (id, name, type) values (
                    ".$balcao_id.",
                    '".$dados["nome"]."',
                    'balcao')";
                if(!$rs = $this->bd->executarSQL($sql))
                {
                    return 0;
                }

                // serviço prioritário...
                /*if ($dados["pri"])
				{
					$sql = "update balcoes set id_servico_prioritario='".$dados["pri"]."' where id_balcao='".$balcao_id."'";
					if(!$rs = $this->bd->executarSQL($sql)) {
						return 0;
					}
				}*/

                /*$sql = "delete from servicos_prioritarios_balcao where id_balcao='".$balcao_id."'";
				if (!$this->bd->executarSQL($sql)) return 0;

				if (count($dados["pri"]))
				{
					$sql = "insert into servicos_prioritarios_balcao (id_balcao, id_servico) values";
					for ($i=0; $i<count($dados["pri"]); $i++)
					{
						$sql .= " ('".$balcao_id."', '".$dados["pri"][$i]."')";
						if ($i+1 < count($dados["pri"])) $sql .= ", ";
					}
					if (!$this->bd->executarSQL($sql)) return 0;
				}*/

                // regista a criação do balcão
                $objecto = new LogAccao();
                $rs = $objecto->Inserir("Inserção", "Balcão", $dados["nome"]);
                $objecto->fechar();
                return "ok";
            }
        } else
        {
            return 0;
        }
    }

    /*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
    */
    function LerDados($id)
    {
        $aux = array();
        if (is_array($id))
        {
            $aux = $id;
        }
        else
        {
            array_push($aux, $id);
        }

        // obtem os campos do balcao especificado
        $sql = "SELECT * FROM balcoes WHERE id_balcao in (" . implode(",", $aux) . ");";
        $res = $this->bd->getRows($sql);
        if (!count($res)) return 0;

        if (is_array($id))
        {
            $_SESSION["sessao_campos"]["loja"] = $res[0]["id_loja"];
            $_SESSION["sessao_campos"]["piso"] = $res[0]["piso"];
            $_SESSION["sessao_campos"]["estado"] = $res[0]["estado"];
            $_SESSION["sessao_campos"]["entidade"] = $res[0]["id_entidade"];

            $sql = "SELECT id_servico, servico_prioritario FROM servicos_balcao WHERE id_balcao=".$aux[0];
            $_SESSION["sessao_campos"]["servicos_balcao"] = $this->bd->getRows($sql);

            $_SESSION["sessao_campos"]["nome_balcoes"] = array();

            foreach ($res as $r)
            {
                array_push($_SESSION["sessao_campos"]["nome_balcoes"], $r["nome"]);

                $_SESSION["sessao_campos"]["loja"] = $_SESSION["sessao_campos"]["loja"]==$r["id_loja"]?$r["id_loja"]:"";
                $_SESSION["sessao_campos"]["piso"] = $_SESSION["sessao_campos"]["piso"]==$r["piso"]?$r["piso"]:"";
                $_SESSION["sessao_campos"]["estado"] = $_SESSION["sessao_campos"]["estado"]==$r["estado"]?$r["estado"]:"";
                $_SESSION["sessao_campos"]["entidade"] = $_SESSION["sessao_campos"]["entidade"]==$r["id_entidade"]?$r["id_entidade"]:"";

                $sql = "SELECT id_servico, servico_prioritario FROM servicos_balcao WHERE id_balcao=".$r["id_balcao"];
                $res2 = $this->bd->getRows($sql);
                $_SESSION["sessao_campos"]["servicos_balcao"] = $_SESSION["sessao_campos"]["servicos_balcao"]==$res2?$res2:array();
            }
        }
        else
        {
            $_SESSION["sessao_campos"] = $res[0];
            $_SESSION["sessao_campos"]["loja"] = $res[0]["id_loja"];
            $_SESSION["sessao_campos"]["entidade"] = $res[0]["id_entidade"];

            $sql = "SELECT id_servico, servico_prioritario FROM servicos_balcao WHERE id_balcao=".$id;
            $_SESSION["sessao_campos"]["servicos_balcao"] = $this->bd->getRows($sql);
        }


//        if (!$rs = $this->bd->executarSQL($sql)) return 0;

//        $tuplo = $this->bd->obterRegisto($rs);
//        $_SESSION["sessao_campos"] = $tuplo;
//        $loja_balcao = $tuplo["id_loja"];
//        $_SESSION["sessao_campos"]["loja"] = $loja_balcao;
//        $entidade_balcao = $tuplo["id_entidade"];
//        $_SESSION["sessao_campos"]["entidade"] = $entidade_balcao;
//        $_SESSION["sessao_campos"]["id_servico_prioritario"] = $tuplo["id_servico_prioritario"];

        /*$sql = "select * from servicos_prioritarios_balcao where id_balcao='".$id."'";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$num_registos = $this->bd->obterNumRegistos($rs);
		$servicos_prioritarios = array();

		for ($i = 0; $i < $num_registos; $i++)
		{
			$this->bd->moverRegisto($rs, $i);
			array_push($servicos_prioritarios, $this->bd->obterValor($rs, "id_servico"));
		}
		$_SESSION["sessao_campos"]["servicos_prioritarios"] = $servicos_prioritarios;*/

        // obtem os servicos associados ao balcao
//        $sql = "SELECT id_servico, servico_prioritario FROM servicos_balcao WHERE id_balcao = " . $id . ";";
//        if(!$rs = $this->bd->executarSQL($sql))
//            return 0;
//
//        $num_registos = $this->bd->obterNumRegistos($rs);
//        $servicos_prestados = array();
//
//        for ($i = 0; $i < $num_registos ; $i++)
//        {
//            $this->bd->moverRegisto($rs, $i);
//
//            /*$servicos_prestados[$i] = $this->bd->obterValor($rs, "id_servico");*/
//            $servicos_prestados[$i] = $this->bd->obterRegisto($rs);
//        }
//
//        // obtem os servicos associados à loja onde o
//        // balcão se localiza
//        /*$servicos_loja = new ServicoPrestado();
//		$resultado = $servicos_loja->LerDados($loja_balcao);
//		$servicos_loja->Fechar();*/
//        $_SESSION["sessao_campos"]["servicos_balcao"] = $servicos_prestados;

        return "ok";
    }

    function getStatusTime($id_balcao){
        $sql="SELECT TIMEDIFF(NOW(), data_hora) AS data_hora FROM balcoes WHERE id_balcao=$id_balcao;";
        $res=$this->bd->executarSQL($sql);
        $estado_time=$this->bd->obterValor($res, 'data_hora');
        return $estado_time;
    }

    function changeStatus($status, $id){
        $sql="UPDATE balcoes SET estado=$status, data_hora=NOW() WHERE id_balcao=$id";
        $this->bd->executarSQL($sql);
    }

    function isSameStatus($id, $id_status){
        $sql="SELECT estado FROM balcoes WHERE id_balcao=$id";
        $res=$this->bd->executarSQL($sql);
        $estado=$this->bd->obterValor($res, 'estado');

        if($estado==$id_status){
           return true;
        }else{
            return false;
        }
    }

    /*
		Fun��o de edi��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Editar($dados, $id)
    {
        global $REGRA_PRIORIDADES;  
		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array("local"=>"Local","entidade" => "Entidade", "nome"=>"Nome", "nome_ecra"=>"Nome Ecrã");

        if (is_array($id))
        {
            $sql = "UPDATE balcoes SET ";

            $aux = array();

            if (isset($dados["change_local"]))
            {
                array_push($aux, "id_loja=".$dados["loja"]);
            }
            if (isset($dados["change_piso"]))
            {
                array_push($aux, "piso=".$dados["piso"]);
            }
            if (isset($dados["change_entity"]))
            {
                array_push($aux, "id_entidade=".$dados["id_entidade"]);
            }

            $sql .= implode(", ", $aux)." where id_balcao in (".implode(", ", $id).")";

            if (count($aux)) $this->bd->executarSQL($sql);

            if (isset($dados["change_servicos_prestados"]) || isset($dados["change_servicos_prioritarios"]))
            {
                $sql = "delete from servicos_balcao where id_balcao in (".implode(",", $id).")";
                if (!$rs = $this->bd->executarSQL($sql))
                {
                    return 0;
                }

                $sql = "INSERT INTO servicos_balcao (id_balcao, id_servico, servico_prioritario)
                        VALUES ";
                $aux2 = array();

                foreach($id as $i)
                {
                    foreach ($dados["servicos_prestados"] as $sp)
                    {
                        array_push($aux2, "(".$i.",".$sp .",".(in_array($sp, $dados["pri"])?"true":"false").")");
                    }
                }

                $sql .= implode(", ", $aux2);
                if (!$rs = $this->bd->executarSQL($sql))
                {
                    return 0;
                }
            }

            return "ok";
        }
        else
        {
            $sql = "SELECT id_loja FROM balcoes WHERE id_balcao  = ".$id.";";

    //        debug($sql, $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            $id_loja_antigo = $this->bd->obterValor($rs, "id_loja");
            $id_entidade_antigo = $this->bd->obterValor($rs, "id_entidade");

            $sql = "UPDATE balcoes SET
                                                                            nome = '" . $dados["nome"] . "',
                                                                            id_loja = ". $dados["id_loja"] .",
                                        piso = ". $dados["piso"] .",
                                                                            id_entidade = ".$dados["id_entidade"] .",
                                                                            nome_ecra = '".$dados["nomeecra"] ."',
                                                                            buttonid=".(strlen(trim($dados["buttonid"]))?"'".$dados["buttonid"]."'":"null") .",
																			on_display='".trim($dados["on_display"])."',
																			on_print='".trim($dados["on_print"])."'
                                                                    WHERE id_balcao = " . $id . " ;";

            if($id_loja_antigo != $dados["id_loja"])
                $this->EscreveXMLSync($id, "remover");

            if($id_entidade_antigo != $dados["id_entidade"])
                $this->EscreveXMLSync($id, "remover");

            if($rs = $this->bd->executarSQL($sql))
            {
                if($id_loja_antigo != $dados["id_loja"] || $id_entidade_antigo != $dados["id_entidade"])
                    $this->EscreveXMLSync($id, "inserir");
                else
                    $this->EscreveXMLSync($id, "editar");

                /*// actualiza os servicos associados ao balcao caso seja necessario
                            $sql = "SELECT id_servico FROM servicos_balcao WHERE id_balcao = " . $id . ";";
                            if(!$rs = $this->bd->executarSQL($sql))
                                    return 0;

                            $num_registos = $this->bd->obterNumRegistos($rs);
                            $servicos_obsoletos = array();
                            $servicos_existentes = array();

                            for ($i = 0; $i < $num_registos ; $i++) {
                                    $this->bd->moverRegisto($rs, $i);
                                    $servico = $this->bd->obterValor($rs, "id_servico");
                                    if (in_array($servico, $dados["servicos_prestados"])) {
                                            array_push($servicos_existentes, $servico);
                                    } else {
                                            // o servico foi desassociado
                                            array_push($servicos_obsoletos, $servico);
                                    }
                            }
                            // apaga os servicos que foram desassociados do balcão, caso existam
                            if (count($servicos_obsoletos)) {
                                    $sql = "DELETE FROM servicos_balcao
                                                                    WHERE id_balcao = $id AND id_servico IN ("
                                                                    . implode(",", $servicos_obsoletos) . ");";

                                    if(!$rs = $this->bd->executarSQL($sql))
                                            return 0;
                            }

                            // filtra os servicos novos que foram associados dos que já existiam ou foram removidos
                            $novos_servicos = array_diff($dados["servicos_prestados"], $servicos_obsoletos, $servicos_existentes);

                            // insere os novos servicos
                                    if (count($novos_servicos)) {
                                            $novos_servicos_values = implode("), ($id,", $novos_servicos);
                                            $sql = "INSERT INTO servicos_balcao VALUES ($id, " . $novos_servicos_values . ");";
                                            if(!$rs = $this->bd->executarSQL($sql))
                                                    return 0;
                                    }*/

                // caso a loja tenha mudado, os servicos existentes
                // necessitam de ser actualizados
                // TODO: falta o SET e verificar se os servicos existentes existem na nova loja
                /*if($id_loja_antigo != $dados["id_loja"]) {
                                    $sql = "UPDATE servicos_balcao SET id_WHERE id_balcao = $id
                                                                    AND id_servico IN (" . implode(",", $servicos_existentes) . ");";
                                    if(!$rs = $this->bd->executarSQL($sql))
                                            return 0;
                            }*/

                // se houver um seviço prioritário neste balcão...
                /*if ($dados["pri"])
                            {
                                    $sql = "update balcoes set id_servico_prioritario='".$dados["pri"]."' where id_balcao='".$id."'";
                                    if(!$rs = $this->bd->executarSQL($sql))
                                            return 0;
                            }
                            else // ...e se não houver...
                            {
                                    $sql = "update balcoes set id_servico_prioritario=null where id_balcao='".$id."'";
                                    if(!$rs = $this->bd->executarSQL($sql))
                                            return 0;
                            }*/



                /*$sql = "delete from servicos_prioritarios_balcao where id_balcao='".$id."'";
                            if (!$this->bd->executarSQL($sql)) return 0;

                            if (count($dados["pri"]))
                            {
                                    $sql = "insert into servicos_prioritarios_balcao (id_balcao, id_servico) values";
                                    for ($i=0; $i<count($dados["pri"]); $i++)
                                    {
                                            $sql .= " ('".$id."', '".$dados["pri"][$i]."')";
                                            if ($i+1 < count($dados["pri"])) $sql .= ", ";
                                    }
                                    if (!$this->bd->executarSQL($sql)) return 0;
                            }*/


                $sql = "delete from servicos_balcao where id_balcao=".$id;
                if (!$rs = $this->bd->executarSQL($sql))
                {
                    return 0;
                }

                for ($i=0; $i<count($dados["servicos_prestados"]); $i++)
                {
                    if(!$REGRA_PRIORIDADES)
                        $sql = "INSERT INTO servicos_balcao (id_balcao, id_servico, servico_prioritario)
                                                    VALUES (".$id.",".@$dados["servicos_prestados"][$i] .",".(@in_array(@$dados["servicos_prestados"][$i], @$dados["pri"])?"true":"false").");";
                    else
                        $sql = "INSERT INTO servicos_balcao (id_balcao, id_servico, servico_prioritario, priority, max_consecutive)
                                                    VALUES (".$id.",".@$dados["servicos_prestados"][$i] .",".(@in_array(@$dados["servicos_prestados"][$i], @$dados["pri"])?"true":"false").",".(@$dados["priority_".@$dados["servicos_prestados"][$i]] != ""?@$dados["priority_".@$dados["servicos_prestados"][$i]]:"NULL") 
                                                        .",".(@$dados["max_consecutive_".@$dados["servicos_prestados"][$i]] != ""?@$dados["max_consecutive_".@$dados["servicos_prestados"][$i]]:"NULL") 
                                                        .");";
                    //debug($sql);
                   
                    if (!$rs = $this->bd->executarSQL($sql))
                    {
                        return 0;
                    }
                }
            

                /* id_hist */
                $sql = "update id_hist
                    set name='".$dados["nome"]."'
                    where id=".$id."
                    and type='balcao'";
                if (!$rs = $this->bd->executarSQL($sql))
                {
                    return 0;
                }

                // finalmente, regista a modificação no log de accoes
                $objecto = new LogAccao();

				$newInfo["nome_ecra"] = $dados["nomeecra"];
				$diff = my_array_diff_values($oldInfo,$newInfo,$labels);

				// Faz o mesmo para a tabela de servicos
				$servicosOld = @$oldInfo['servicos_balcao'];
				$servicosNew = @$dados['servicos_prestados'];
				$servicosPri = @$dados['pri'];
				$diffServicos = @my_array_diff_values3($servicosOld,$servicosNew,$servicosPri);

				$msg = "<table><tr><td colspan=3 align=left><b>$newInfo[nome]</b></td></tr>";
				$msg .= action_msg_info($diff,false,'balcao');
				$msg .= action_msg_info($diffServicos,false,'balcao');
				$msg .= "</table>";

                $rs = $objecto->Inserir("Edição", "Balcão", $msg);
                $objecto->fechar();
                return "ok";
            }
            else
                return 0;
        }
    }

    /*
		Fun��o de remo��o

		0 = Erro da BD
		true = Sucesso
    */
    function Remover($id)
    {
        $this->EscreveXMLSync($id, "remover");

        $numEntradas = count($id);
        $nomes = array();
        $sql = "SELECT nome FROM balcoes WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_balcao = " . $id[$i] . " OR ";
        $sql .= "id_balcao = " . $id[0] . ";";


        if($rs = $this->bd->executarSQL($sql))
        {
            for($i = 0; $i < $numEntradas; $i++)
            {
                $this->bd->moverRegisto($rs,$i);
                array_push($nomes, $this->bd->obterValor($rs,"nome"));
            }
        }
        else
            return 0;

        $sql = "DELETE FROM balcoes WHERE ";
        // servicos associados a um balcao
        $sql_servicos_balcao = "DELETE FROM servicos_balcao WHERE ";
        for($i = count($id); $i > 1; $i--)
        {
            $sql .= "id_balcao = ". $id[$i-1] . " OR ";
            $sql_servicos_balcao .= "id_balcao = ". $id[$i-1] . " OR ";
        }
        $sql .= "id_balcao = ". $id[0] . ";";
        $sql_servicos_balcao .= "id_balcao = ". $id[0] . ";";

        $rs_servicos_balcao = $this->bd->executarSQL($sql_servicos_balcao);
        $rs = $this->bd->executarSQL($sql);

        // caso as duas remoções tenham sido efectuadas com sucesso,
        // regista a remoção na base de dados
        if($rs && $rs_servicos_balcao)
        {
            $objecto = new LogAccao();
            for($i = count($nomes)-1; $i >= 0; $i--)
            {
                $rs = $objecto->Inserir("Remoção", "Balcão", $nomes[$i]);
            }
            $objecto->fechar();
            return "ok";
        } else
        {
            return 0;
        }
    }

    /*
		Procede � cria��o e escrita de um
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao)
    {

        if(!is_array($id))
            $id = array($id);

        $numEntradas = count($id);

        $sql = "SELECT * FROM balcoes WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_balcao = " . $id[$i] . " OR ";
        $sql .= "id_balcao = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $documento = abreXMLSync();
        $raiz = $documento->firstChild;

        $loja = new Loja();
        $enderecos = array();

        $destinos = $documento->createElement("destinos");
        $raiz->appendChild($destinos);

        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0 ; $i < $numEntradas ; $i++)
        {
            $this->bd->moverRegisto($rs, $i);

            $enderecos = array_merge($enderecos, $loja->listaIpLojas($this->bd->obterValor($rs, "id_loja")));

            $no_balcao = $documento->createElement("balcao");
            $raiz->appendChild($no_balcao);

            $no_balcao->setAttribute("id", $this->bd->obterValor($rs, "id_balcao"));
            $no_balcao->setAttribute("accao", $accao);

            $elemento = $documento->createElement("nome");
            $elemento->nodeValue = $this->bd->obterValor($rs, "nome");
            $no_balcao->appendChild($elemento);

            $elemento = $documento->createElement("idLoja");
            $elemento->nodeValue = $this->bd->obterValor($rs, "id_loja");
            $no_balcao->appendChild($elemento);

            $elemento = $documento->createElement("idEstadoBalcao");
            $elemento->nodeValue = $this->bd->obterValor($rs, "estado");
            $no_balcao->appendChild($elemento);
        }

        $enderecos = array_unique($enderecos);

        for($i = 0 ; $i < count($enderecos) ; $i++)
        {

            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);

        }

        fechaXMLsync($documento);

    }

    /*
		Fun��o de listagem

		0 = Erro da BD
		true = Sucesso
    */

    function Listar()
    {
//        $sql = "SELECT DISTINCT b.id_balcao, b.nome, b.estado status_id, eb.nome estado, l.nome loja, e.nome entidade, b.nome_ecra, b.piso piso
//				FROM balcoes b inner join estados_balcao eb on eb.id_estados_balcao=b.estado, lojas l, lojas_entidades le, entidades e
//				WHERE id_balcao <> 0
//				AND b.id_loja = l.id_loja  AND le.id_loja=l.id_loja  AND le.id_entidade = e.id_entidade AND b.id_entidade=e.id_entidade ";

        $sql = "SELECT DISTINCT b.id_balcao, b.nome, b.estado status_id, eb.nome estado, l.nome loja, e.nome entidade, b.nome_ecra, b.piso piso
				FROM balcoes b inner join estados_balcao eb on eb.id_estados_balcao=b.estado, lojas l, lojas_entidades le, entidades e
				WHERE id_balcao <> 0
				AND b.id_loja = l.id_loja AND le.id_entidade = e.id_entidade AND b.id_entidade=e.id_entidade ";

        if(getRequestValue("loja") != "")    // estado
            $sql .= "and b.id_loja = " . $_REQUEST["loja"] . " ";

        if(getRequestValue("estados_balcao") != "")  // estado
            $sql .= "and b.estado = " . $_REQUEST["estados_balcao"] . " ";

        if($_SESSION["super_user"] != 1)
        {
            $sql .= " AND (l.id_loja =". $_SESSION["loja"][0]." ";

            for($i=1; $i<count($_SESSION["loja"]); $i++)
                $sql .= "OR l.id_loja = ".$_SESSION["loja"][$i]." ";

            $sql .= ") ";

            $sql .= "AND (le.id_entidade = ".$_SESSION["entidade"][0]." ";
            for($i=1; $i<count($_SESSION["entidade"]); $i++)
                $sql .= "OR le.id_entidade = ".$_SESSION["entidade"][$i]." ";

            $sql .= ") ";

        }
        if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= "ORDER BY " . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY b.nome ";

        if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";

        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $balcoes = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($balcoes, $row);

        $n = 1;
        $pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];

        $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
        $numPaginas = 1; // n�mero de p�ginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

        // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
        if(array_key_exists("pagina", $_REQUEST) && intVal($_REQUEST["pagina"]) > 0 && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
            $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', false) ." ". translate("word_agencies", false)." ". translate('word_registados_sistema', false) ."</div>";

            echo    "<tr><td class='button'>";
            echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
            echo    "</tr></td>";
            return;
        }

        // calculo do n�mero de p�ginas de registos
        if($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=balcoes&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "")  . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "")  . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>	";

            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
            <tr>
                <td class='button_page' colspan='6'>";

                if($pagina > 1)
                {
                    $pagAnterior = $pagina - 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                }
                else
                {
                    $pagina = 1; // na primeira vez n�o h� request
                    $TEMPLATE_navigation .= "<div> < </div>";
                }

                while($n <= $numPaginas)
                {
                    if($n == $pagina)
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='current_page'>$n</div></a>";
                    else
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='other_page'>$n</div></a>";
                    $n++;
                }

                $n = ($pagina - 1)*$numRegPag;
                $incremento = $n;

                if($pagina < $numPaginas)
                {
                    $pagPosterior = $pagina + 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
                }
                else
                {
                    if($numTuplos % $numRegPag != 0)
                        $numRegPag = $numTuplos % $numRegPag;
                    $TEMPLATE_navigation .= "<div> > </div>";
                }

        $TEMPLATE_navigation .= "		</td>
        </tr>";

        echo "<tr class='column_row'>";

        if ( $_SESSION["sessao_perms"]["perm_balcoes"] == 2 )
        {
            echo "<td width='18' style='padding-left:8px' >" .  translate('word_select') . "</td>";
        }

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."</div></a></td>";


        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"loja") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=1'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0'><div>" .translate('word_local', true). "</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"piso") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=piso&ordem=0'><div>". translate('word_floor', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=piso&ordem=1'><div>". translate('word_floor', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=piso&ordem=0'><div>". translate('word_floor', true)."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"entidade") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=entidade&ordem=0'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=entidade&ordem=1'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=entidade&ordem=0'><div>" .translate('word_entity', true). "</div></a></td>";


        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome_ecra") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra&ordem=0'><div>". translate('word_identificador_do_ecra', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra&ordem=1'><div>". translate('word_identificador_do_ecra', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra&ordem=0'><div>". translate('word_identificador_do_ecra', true)."</div></a></td>";

        echo "<td>". translate('word_state', true)."</td>";

        echo "<td width='155'>". translate('word_operations', true)."</td>
				</tr>";



        //while($n < ($numRegPag + $incremento))
        //{
            //$this->bd->moverRegisto($rs,$n);
        for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {
            echo"<tr class='form-data-tr'>";
            if ( $_SESSION["sessao_perms"]["perm_balcoes"] == 2 )
            {
              echo "<td class='form-data-td'>
                      <label class='custom-check-container'>
                          <input name='grupo' type='checkbox' value='" . $balcoes[$i]["id_balcao"]  . "' onClick='selectEntireRow(this)'>
                          <span class='custom-checkmark'></span>
                      </label>
                  </td>";//$this->bd->obterValor($rs,"id_balcao")

            }
            switch ($balcoes[$i]["status_id"]) //$this->bd->obterValor($rs, "status_id"))
            {
                case "1":
                    $color = "#008800";
                    break;
                case "2":
                    $color = "#888800";
                    break;
                case "3":
                    $color = "#880000";
                    break;
                case "4":
                    $color = "#00aa00";
                    break;
                default:
                    $color = "#ffffff";
                    break;
            }
            $aux_estado = $balcoes[$i]["estado"];
            if($aux_estado == "Disponivel")
                $aux_estado = translate('word_disponivel', true);
            else if($aux_estado == "Fechado")
                $aux_estado = translate('word_fechado', true);
            else if($aux_estado == "Em atendimento")
                $aux_estado = ucfirst(translate('word_in_attendance', true));

            echo	 "<td class='form-data-td'>" . $balcoes[$i]["nome"] /*$this->bd->obterValor($rs, "nome")*/ . "</td>
          					<td class='form-data-td'>" . $balcoes[$i]["loja"] /*$this->bd->obterValor($rs, "loja")*/ . "</td>
                    <td class='form-data-td'>" . $balcoes[$i]["piso"] /*$this->bd->obterValor($rs, "piso")*/ . "</td>
          					<td class='form-data-td'>" . $balcoes[$i]["entidade"] /*$this->bd->obterValor($rs, "entidade")*/ . "</td>
          					<td class='form-data-td'>" . $balcoes[$i]["nome_ecra"] /*$this->bd->obterValor($rs, "nome_ecra")*/ . "</td>
          					<td class='form-data-td' style=\"color: ".$color."; font-weight: bold\">" . $aux_estado /*$this->bd->obterValor($rs, "estado")*/ . "</div></td>
          					<td class='form-data-td'>";
                      if ( $_SESSION["sessao_perms"]["perm_balcoes"] == 2 )
                      {
                          echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=balcoes&id=" . $balcoes[$i]["id_balcao"] /*$this->bd->obterValor($rs,"id_balcao")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
          						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=balcoes&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" .  (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" .  (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "&id=" .  $balcoes[$i]["id_balcao"] /*$this->bd->obterValor($rs,"id_balcao")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
                      } else
                      {
                          echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=balcoes&id=" . $balcoes[$i]["id_balcao"] /*$this->bd->obterValor($rs,"id_balcao")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.png'><div>". translate('word_details', true)."</div></a>";
                      }
            echo	"</td>
				</tr>";

            //$n++;
        }

        //#3 - Re-design present NAVIGATION after table
        echo $TEMPLATE_navigation;

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";


        if ( $_SESSION["sessao_perms"]["perm_balcoes"] == 2 )
        {
          echo	"<tr>
  					<td class='button'>";
            if ($_SESSION["sessao_perms"]["perm_balcoes"] == 2) {
              echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
            }
              echo "
    						<div class='button-thin-green' onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
    						<div class='button-thin-green' onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
    						<div class='button-thin-green' onClick='removerMarcados(this);'>". translate('word_remove_selected', true)."</div>
    						<div class='button-thin-green' onClick='editarMarcados(\"balcoes\");'>". translate('word_edit_selected', true)."</div>
    					</td>
  				</tr>";
        }

        echo	"</table>
		</form>";
    }


    function GetTempos($data, $e, $local="")
    {
        $acessos = array();
        $tempos["atendimento"] = 0; // em segundos
        $tempos["suspenso"] = 0;
        $tempos["servico_interno"] = 0;

        $data_aux = $data;
        if (strlen($data)<10)
        {
            $data_aux = $data . "-01";
        }

        $sql = "select acesso from log_acessos_empregados where id_acessos=(
					select max(id_acessos)
					from log_acessos_empregados
					where date(data_hora)=date_add('".$data_aux."', interval -1 day)
					and id_empregado='".$e."'
					".($local?("and id_loja=".$local):"").")";
        if (!$rs = $this->bd->executarSQL($sql)) return;
        $ultimoAcessoDiaAterior = $this->bd->obterValor($rs, "acesso");

        $sql = "select acesso, time_to_sec(time(data_hora)) tempo from log_acessos_empregados where id_acessos=(
					select min(id_acessos)
					from log_acessos_empregados
					where date(data_hora)='".$data_aux."'
					and id_empregado='".$e."'
					".($local?("and id_loja=".$local):"").")";
        if (!$rs = $this->bd->executarSQL($sql)) return;
        $primeiroAcesso = $this->bd->obterValor($rs, "acesso");
        $primeiroTempo = $this->bd->obterValor($rs, "tempo");

        if (strlen($ultimoAcessoDiaAterior) && $ultimoAcessoDiaAterior != "Saida")
        {
            // Se o último acesso do dia anterior foi uma Entrada, o primeiro deve ser uma saida ou uma suspensão;
            // Se foi uma Suspensão, o primeiro deve ser uma entrada ou uma saida;
            // Se foi igual ao corrente, é estranho... por isso ignora
            if (strlen($primeiroAcesso) && $primeiroAcesso != $ultimoAcessoDiaAterior)
            {
                // como não saiu no dia anterior, vou contar o tempo desde a meia-noite do dia corrente.
                // Se no dia anterior o último acesso foi uma entrada, conto Tempo de Atendimento;
                // Se foi uma suspensão, conto como Tempo Suspenso.
                if ($ultimoAcessoDiaAterior == "Entrada" && $primeiroTempo>0)
                {
                    $tempos["atendimento"] += $primeiroTempo;
//		    echo "<br/>atendimento do dia anterior: ".gmdate("Y-m-d H:i:s", $primeiroTempo);
                }
                else if ($ultimoAcessoDiaAterior == "Suspenso" && $primeiroTempo>0)
                {
                    $tempos["suspenso"] += $primeiroTempo;
//		    echo "<br/>suspenso do dia anterior: ".gmdate("Y-m-d H:i:s", $primeiroTempo);
                }
            }
        }

        // A transição do dia anterior para o corrente está a ser contabilizada. Agora é apenas o corrente.
        // por acesso, ver qual o tipo de acesso e contar os tempos até ao acesso seguinte

//		$sql = "select time_to_sec(time(data_hora)) tempo, acesso from log_acessos_empregados where date(data_hora) like '".$data."%' and id_empregado='".$e."'
//					".($local?("and id_loja=".$local):"")." order by id_acessos";
        $sql = "select unix_timestamp(data_hora) tempo, acesso from log_acessos_empregados where date(data_hora) like '".$data."%' and id_empregado='".$e."'
					".($local?("and id_loja=".$local):"")." order by id_acessos";
        if (!$rs = $this->bd->executarSQL($sql)) return;
        while ($row = $this->bd->obterRegisto($rs)) array_push($acessos, $row);

        for ($i=0; $i<count($acessos); $i++)
        {
            switch($acessos[$i]["acesso"])
            {
                case "Entrada":
                // se for o último acesso, contar o tempo até agora
//					$tmp = (GetSecondsFromTimeString(date("H:i:s")) - $acessos[$i]["tempo"]);
//		    $tmp = (time() - $acessos[$i]["tempo"]);
//		    if ($i==count($acessos)-1 && $tmp>0)
//		    {
//			$tempos["atendimento"] += $tmp;
//			echo "<br/>atendimento: ".gmdate("Y-m-d H:i:s", $tmp);
//		    }
//		    // afinal nao conta nada. Ainda não terminou, pelo menos para este dia
//
                // se vem de uma suspensão, contar o tempo suspenso
                    $tmp = ($acessos[$i]["tempo"] - $acessos[$i-1]["tempo"]);
                    if ($i>0 && $acessos[$i-1]["acesso"]=="Suspenso" && $tmp>0)
                    {
                        $tempos["suspenso"] += $tmp;
//			echo "<br/>suspenso: ".gmdate("Y-m-d H:i:s", $tmp);
                    }
                    break;
                case "Saida":
                // se é o primeiro acesso, ignora. Já está tratado
                    if ($i==0) break;
                    else
                    {
                        // se o anterior é uma suspensão, conta como tempo suspenso;
                        // se é uma entrada, conta como atendimento.
                        // se for igual, estranho, ignora.
                        $tmp = ($acessos[$i]["tempo"] - $acessos[$i-1]["tempo"]);
                        if ($acessos[$i-1]["acesso"]=="Suspenso" && $tmp>0)
                        {
                            $tempos["suspenso"] += $tmp;
//			    echo "<br/>suspenso: ".gmdate("Y-m-d H:i:s", $tmp);
                        }
                        else if ($acessos[$i-1]["acesso"]=="Entrada" && $tmp>0)
                        {
                            $tempos["atendimento"] += $tmp;
//			    echo "<br/>atendimento: ".gmdate("Y-m-d H:i:s", $tmp);
                        }
                    }
                    break;
                case "Suspenso":
                // se for o último acesso, contar o tempo até agora
//		    $tmp = (time() - $acessos[$i]["tempo"]);
//		    if ($i==count($acessos)-1 && $tmp>0)
//		    {
//			$tempos["suspenso"] += $tmp;
//			echo "<br/>suspenso: ".gmdate("Y-m-d H:i:s", $tmp);
//		    }
//		    // tal como acima, ainda não terminou, por isso não conta
//
//
                // se é o primeiro acesso, ignora. Já está tratado
                    if ($i==0) break;
                    else
                    {
                        // se é uma entrada, conta como atendimento.
                        // se for igual, estranho, ignora.

                        $tmp = ($acessos[$i]["tempo"] - $acessos[$i-1]["tempo"]);
                        if ($acessos[$i-1]["acesso"]=="Entrada" && $tmp>0)
                        {
                            $tempos["atendimento"] += $tmp;
//			    echo "<br/>atendimento: ".gmdate("Y-m-d H:i:s", $tmp);
                        }
                    }
                    break;
                default:
                    break;
            }
        }

        $tempos["total"] = $tempos["atendimento"] + $tempos["suspenso"];
        $tempos["livre"]=0;
        return $tempos;
    }

    function GetBalcoes($where="")
    {
        /*
		select lae.id_balcao, lae.acesso, lae.data_hora
		from log_acessos_empregados lae
		right join (
					select max(id_acessos) id_acessos
					from log_acessos_empregados
					group by id_balcao) last
		on last.id_acessos=lae.id_acessos


		select id_balcao, max(data_hora)
		from log_acessos_empregados
		group by id_balcao;
        */

        $sql = "select l.id_loja, l.nome local, e.id_entidade, e.nome entidade, b.id_balcao, b.nome balcao, eb.nome estado, b.estado status_id, lae.data_hora desde, b.piso
				from balcoes b
				inner join lojas l on b.id_loja=l.id_loja
				inner join entidades e on b.id_entidade=e.id_entidade
				inner join estados_balcao eb on eb.id_estados_balcao=b.estado
				left join (
					select id_balcao, max(data_hora) data_hora
					from log_acessos_empregados
					group by id_balcao) lae
				on lae.id_balcao=b.id_balcao";
        if (strlen($where)) $sql .= " where ".$where;
        $res = $this->bd->executarSQL($sql);

        $balcoes = array();
        while ($row = $this->bd->obterRegisto($res))
        {
            $row["estado"] = obterEstadoGeral($row["estado"]);
            array_push($balcoes, $row);
        }
        return $balcoes;
    }

    function GetPriority($id_balcao, $id_servico)
    {
        $sql = "select priority from servicos_balcao where id_balcao='".$id_balcao."' and id_servico ='" . $id_servico . "'";

        if(!$rs = $this->bd->executarSQL($sql)){
            return "";
        }
        else {
            $ret = $this->bd->obterValor($rs, "priority");
            if(!$ret)
                return "";
            else 
                return $ret;
        } 
            
    }

    function GetMaxConsecutive($id_balcao, $id_servico)
    {
        $sql = "select max_consecutive from servicos_balcao where id_balcao='".$id_balcao."' and id_servico ='" . $id_servico . "'";

        if(!$rs = $this->bd->executarSQL($sql)){
            return;
        }
        else {
            $ret = $this->bd->obterValor($rs, "max_consecutive");
            if(!$ret)
                return "";
            else 
                return $ret;
        } 
    }




    /*
		Destrutor da classe

		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }
}
?>
