<?php
session_start();

require_once("../config.inc.php");

if($_SESSION["sessao_autenticado"] == 0)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);

if($_SESSION["sessao_perms"]["perm_balcoes"] < 2)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR ."/" );
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Zqueue - <?php   echo  translate('word_edition', true) ?> <?php   echo  translate('word_de', true) ?> <?php   echo  translate('word_agencies', true) ?></title>

        <link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">

        <!-- Re-design -->
        <link rel="stylesheet" type="text/css" media="screen" href="../css/components/custom-form.css">

        <script type="text/javascript" src="<?php   echo getPathScriptJS("menu.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("validacoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("sorttable.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("funcoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("custom-dropdown.js"); ?>"></script>

        <script type="text/javascript">

            var priChanged = false;

                function setPri(id)
                {
                    var pri = document.getElementById("pri_"+id);
                    if (pri.checked)
                    {
                        var srv = document.getElementById("srv_"+id);
                        srv.checked = true;
                    }

                    priChanged = true;
                }

                function setSrv(id)
                {
                    var srv = document.getElementById("srv_"+id);
                    if (!srv.checked)
                    {
                        var pri = document.getElementById("pri_"+id);
                        pri.checked = false;
                    }
                }

                function valueHasChanged(obj, val, chkId, obj2, val2)
                {
                    var oChk = document.getElementById(chkId);

                    if (obj2!=undefined && val2!=undefined)
                    {
                        var chck = false;

                        switch (obj.type)
                        {
                            case "checkbox":
                                if (obj.checked!=val) chck = true;
                                else chck = false;
                                break;
                            default:
                                if (obj.value!=val) chck = true;
                                else chck = false;
                                break;
                        }

                        if (!chck)
                        {
                            switch (obj2.type)
                            {
                                case "checkbox":
                                    if (obj2.checked!=val2) chck = true;
                                    else chck = false;
                                    break;
                                default:
                                    if (obj2.value!=val2) chck = true;
                                    else chck = false;
                                    break;
                            }
                        }

                        oChk.checked = chck;
                    }
                else
                {
                    switch (obj.type)
                    {
                        case "checkbox":
                            if (obj.checked!=val) oChk.checked = true;
                            else oChk.checked = false;
                            break;
                        default:
                            if (obj.value!=val) oChk.checked = true;
                            else oChk.checked = false;
                            break;
                    }
                }
              }

            function valuesHaveChanged(InputClassName, aVal, chkId)
            {
                var aInputs = document.getElementsByClassName(InputClassName);
                var oChk = document.getElementById(chkId);

                var aChgVal = new Array();
                for (var i=0; i<aInputs.length; i++)
                {
                    switch(aInputs[i].type)
                    {
                        case "checkbox":
                            if (aInputs[i].checked) aChgVal.push(aInputs[i].value);
                            break;
                        default:
                            aChgVal.push(aInputs[i].value);
                            break;
                    }
                }

            if (aVal.sort().compare(aChgVal.sort())) oChk.checked = false;
            else oChk.checked = true;
            }

        </script>

    </head>
    <body>
        <?php
        include("../cabecalho.php");

        $abalc = unserialize($_REQUEST["id"]);
        ?>

        <div class="full_area">
        	<!-- Title + Description -->
        	<div class="form-title">
        		<h2 class="text-bold text-green-light"><?php   echo   translate('word_edit', true)  ?> <?php   echo  translate('word_agency', true)?></h2>

            <?php 
            echo implode(",&nbsp;", $_SESSION["sessao_campos"]["nome_balcoes"]);
            ?>

        		<!-- Extra description -->
        		<div class="form-extra-desc text-bold text-gray-dark">
        			<?php   echo  translate('word_select_local') ?>
        		</div>
        	</div>

        	<!-- Main Table Content -->
        	<div class="form-table-container">

        		<div class="form-flex-container">
        			<!-- form fields -->
        			<table cellspacing="0" cellpadding="0">
        				<tr>
        					<td width="">

                    <!-- #A - Local And Entity -->
        						<form class="form_template" action="../accoes_intermedias/accaoEditar.php?modulo=balcoes&id[]=<?php  echo implode("&id[]=", $abalc); ?>" method="post">
        							<div class="form_template_flex_container">
        								<!-- Form main table -->
        								<table cellspacing="0" cellpadding="0">

                          <!-- Local (dropdown) -->
        									<tr>
        										<!-- field name -->
        										<td class="formname_space">
                              <input type="checkbox" name="change_local" id="change_local" value="1" title="change me"/>
        											<font class="text-green-light">* </font><?php   echo  translate('word_local', true) ?>:
        										</td>
        										<!-- field input -->
        										<td class="input_space" style="width: 320px;">
        											<div class="custom-select">
                                <?php
                                construirListaGeral("loja", "lojas", "id_loja", "nome", $_SESSION["sessao_campos"]["loja"],
                                        "-- ".translate("word_choose")." --", "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["loja"]."\", \"change_local\")");
                                ?>
        											</div>

        											<!-- Error message -->
        											<span id="" class="error_msg">&nbsp;</span>
        										</td>
        									</tr>

                          <!-- Entity (dropdown) -->
        									<tr>
        										<!-- field name -->
        										<td class="formname_space">
                              <input type="checkbox" name="change_entity" id="change_entity" value="1" title="change me"/>
        											<?php   echo  translate('word_entity', true) ?>:
        										</td>
        										<!-- field input -->
        										<td class="input_space" style="width: 320px;">
        											<div class="custom-select">
                                <?php
                                  if($_SESSION["super_user"] == 1)
                                      construirListaGeral("id_entidade", "entidades", "id_entidade", "nome", $_SESSION["sessao_campos"]["entidade"],
                                              "-- ".translate("word_choose")." --", "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["entidade"]."\", \"change_entity\")");
                                  else
                                      construirListaLojaEntidade("id_entidade", "entidades", "id_entidade", "nome", $_SESSION["sessao_campos"]["entidade"], $_SESSION["entidade"],
                                              "-- ".translate("word_choose")." --", "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["entidade"]."\", \"change_entity\")");
                                ?>
        											</div>

        											<!-- Error message -->
        											<span id="msg_entidade" class="error_msg">&nbsp;</span>
        										</td>
        									</tr>

                          <!-- Floor -->
        									<tr>
        										<td class="formname_space">
                              <input type="checkbox" name="change_piso" id="change_piso" value="1" title="change me"/>
        											<?php   echo  translate('word_floor', true) ?>:
        										</td>
        										<!-- field input -->
        										<td class="input_space">
                              <input type="text" name="piso" id="piso" size="5" maxlength="3" value="<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>"
                                     onkeypress="return NumbersOnly(event,this)"
                                     onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>', 'change_piso')"/>

        											<!-- Error message -->
        											<span class="error_msg">&nbsp;</span>
        										</td>
        									</tr>

                          <!-- Extra description -->
                          <tr>
                            <td colspan="3">
                							<div class="form-extra-desc text-bold text-gray-dark">
                								<?php   echo  translate('word_por_favor_preencha_seguintes_campos_obrigatorios', false) ?>
                								<font class="text-green-light">* </font>
                								<?php   echo  translate('word_sao_preencimento_obrigatorio', false) ?>
                							</div>
                							<br>
                            </td>
                          </tr>

                        </table>
        							</div>

                      <!-- Selection table and buttons -->
        							<table cellspacing="0" cellpadding="0">
        								<tr>
        									<td class="formname_space">
        										<font class='error_msg'>* </font><?php   echo  translate('word_servicos_associados', true) ?> <?php   echo  translate('word_agency', true) ?>:
        									<td>
        										<!-- Selectable list -->
        										<div class="form-selectable-table">

        											<table id="entidade_servico" class="data_table" cellspacing="0">
        												<tr class="column_row">
        													<td class="center">
                                    <input type="checkbox" name="change_servicos_prestados" id="change_servicos_prestados" value="1" title="change me"/>
                                    <br>
                                    <?php   echo  translate('word_add', true) ?>
                                  </td>
        													<td class="center">
                                    <input type="checkbox" name="change_servicos_prioritarios" id="change_servicos_prioritarios" value="1" title="change me"/>

                                    <?php   echo  translate("word_service", true) ?>
                                    <br>
                                    <?php   echo  translate('word_priority', true) ?>
                                  </td>
        													<td class="center"><?php   echo  translate('word_entity', true) ?></td>
        													<td class="left"><?php   echo  translate("word_service", true) ?></td>
        												</tr>

                                <tbody>
                                    <?php 

                                    $obj = new Servico();
                                    $servicos_entidade = $obj->obterDados(@$_POST["entidade"]);

                                    $num_servicos = count($servicos_entidade);

                                    function getSrvId($aItem)
                                    {
                                        return $aItem["id_servico"];
                                    }

                                    function getSrvPri($aItem)
                                    {
                                        return $aItem["servico_prioritario"]?$aItem["id_servico"]:0;
                                    }

                                    function notZero($aItem)
                                    {
                                        return $aItem!=0;
                                    }

                                    $srv_balcao = array_map("getSrvId", $_SESSION["sessao_campos"]["servicos_balcao"]);
                                    $srv_pri_balcao = array_map("getSrvPri", $_SESSION["sessao_campos"]["servicos_balcao"]);
                                    $srv_pri_balcao = array_filter($srv_pri_balcao, "notZero");

                                    for ($i=0; $i<count($servicos_entidade); $i++)
                                    {
                                        $id_servico = $servicos_entidade[$i]["id_servico"];
                                        if($_SESSION["super_user"] == 1)
                                        {
                                            ?>
                                    <tr class="form-data-tr <?php   if (in_array($id_servico, $srv_balcao)) echo "form-tr-selected"; ?>">
                                      <td class="form-data-td center">
                                        <label class='custom-check-container'>
                                          <input id="srv_<?php   echo $id_servico; ?>" class="servicos_prestados" name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>"
                                                                  onclick="selectEntireRow(this);setSrv('<?php   echo $id_servico; ?>');"
                                                                  onchange="valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados');
                                                  valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios')"
                                                                  type="checkbox" value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_balcao)) echo "checked"; ?>/>

                                              <span class='custom-checkmark'></span>
          																</label>
                                      </td>


                                      <td class="form-data-td center">
                                        <label class='custom-check-container'>
                                        <input id="pri_<?php   echo $id_servico; ?>" name="pri[]" class="pri" type="checkbox"
                                                                onclick="setPri('<?php   echo $id_servico; ?>');selectEntireRow(document.getElementById('srv_<?php   echo $id_servico; ?>'));
                                                valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios');
                                                valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados')"
                                                                value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_pri_balcao)) echo "checked"; ?>/>

                                              <span class='custom-checkmark' style="left:35px"></span>
          																</label>
                                      </td>
                                      <td class="form-data-td center"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
                                      <td class="form-data-td left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
                                    </tr>
                                            <?php 
                                        }
                                        else if (in_array($servicos_entidade[$i]["id_entidade"], $_SESSION["entidade"]))
                                        {
                                            ?>
                                    <tr class="form-data-tr <?php   if (in_array($id_servico, $srv_balcao)) echo "form-tr-selected"; ?>">
                                      <td class="form-data-td center">
                                        <label class='custom-check-container'>
                                        <input id="srv_<?php   echo $id_servico; ?>" class="servicos_prestados" name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>"
                                                                onclick="selectEntireRow(this);setSrv('<?php   echo $id_servico; ?>');"
                                                                onchange="valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados');
                                                valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios')"
                                                                type="checkbox" value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_balcao)) echo "checked"; ?>/>
                                              <span class='custom-checkmark'></span>
          																</label>
                                      </td>

                                      <td class="form-data-td center">
                                        <label class='custom-check-container'>
                                        <input id="pri_<?php   echo $id_servico; ?>" name="pri[]" class="pri" type="checkbox"
                                                                onclick="setPri('<?php   echo $id_servico; ?>');selectEntireRow(document.getElementById('srv_<?php   echo $id_servico; ?>'));
                                                valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios');
                                                valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados')"
                                                                value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_pri_balcao)) echo "checked"; ?>/>
                                              <span class='custom-checkmark' style="left:35px"></span>
          																</label>
                                      </td>
                                      <td class="form-data-td center"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
                                      <td class="form-data-td left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>

                                    </tr>
                                            <?php 
                                        }
                                    }
                                    ?>
                                </tbody>


                              </table>
                            </div>
                          </td>
                        </tr>

                        <!-- Table errors -->
                        <tr class="form-error-session">
                          <td></td>
                          <td>
                            <span id="msg_servicos_prestados[]" class="error_msg">&nbsp;</span>
                          </td>
                        </tr>

                        <!-- Buttons -->
                        <tr class="form-tr-buttons-container">
                            <td class="button">
                              <div class="button-full-green" onClick="validaFormBalcao(0 , <?php   echo $num_servicos; ?>, true);"><?php   echo  translate('word_modify', true) ?></div>
                            </td>
                          <td class="button">
                            <div class="button-thin-green" onClick="limpaFormulario(0);"><?php   echo  translate('word_clean', true) ?></div>
                            <a href="index.php"><div class="button-thin-green"><?php   echo  translate('word_cancel', true) ?></div></a>
                          </td>
                        </tr>

                      </table>

        						</form>


                  </td>
                </tr>
              </table>

            </div>

            <!-- Form Error -->
            <div class="form-error-session">
              <span id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></span>
            </div>

          </div>

        </div>

        <table class="full_area" cellpadding="0" cellspacing="0" style="display:none">
            <tr>
                <td>&nbsp;</td>
                <td class="content">
                    <table class="title_space" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="module_space" width="380">
                                <?php   echo  translate('word_edit', true) ?> <?php   echo  translate('word_agency', true) ?> </td>
                            <td class="function_space" width="110">
                            </td>
                            <td class="function_space" width="120">
                            </td>
                            <td class="function_space" width="160">
                                <a class="function" href="./"><div><?php   echo  translate('word_prev', true) ?></div><img alt="Recuar" src="../img/buttons/button_back.gif"></a>
                            </td>
                        </tr>
                    </table>
                    <table width="770" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td>
                                <?php 
                                echo implode(",&nbsp;", $_SESSION["sessao_campos"]["nome_balcoes"]);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td width="758">
                                <form class="form_template" action="../accoes_intermedias/accaoEditar.php?modulo=balcoes&id[]=<?php  echo implode("&id[]=", $abalc); ?>" method="post">
                                    <table class="form_table" cellspacing="0" cellpadding="0">
                                        <tr>
                                            <td class="question_space" colspan="5">
                                                <?php   echo  translate('word_select_local') ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="select_space">
                                                <input type="checkbox" name="change_local" id="change_local" value="1" title="change me"/>
                                                <?php   echo  translate('word_local', true) ?>
                                                <?php
                                                construirListaGeral("loja", "lojas", "id_loja", "nome", $_SESSION["sessao_campos"]["loja"],
                                                        "-- ".translate("word_choose")." --", "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["loja"]."\", \"change_local\")");
                                                ?>
                                            </td>
                                            <td class="select_space">
                                                <input type="checkbox" name="change_piso" id="change_piso" value="1" title="change me"/>
                                                <?php   echo  translate('word_floor', true) ?>
                                                <input type="text" name="piso" id="piso" size="5" maxlength="3" value="<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>"
                                                       onkeypress="return NumbersOnly(event,this)"
                                                       onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>', 'change_piso')"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="question_space" colspan="5">
                                                <?php   echo  translate('word_select_entity') ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="select_space">
                                                <input type="checkbox" name="change_entity" id="change_entity" value="1" title="change me"/>
                                                <?php   echo  translate('word_entity', true) ?>
                                                <?php
                                                if($_SESSION["super_user"] == 1)
                                                    construirListaGeral("id_entidade", "entidades", "id_entidade", "nome", $_SESSION["sessao_campos"]["entidade"],
                                                            "-- ".translate("word_choose")." --", "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["entidade"]."\", \"change_entity\")");
                                                else
                                                    construirListaLojaEntidade("id_entidade", "entidades", "id_entidade", "nome", $_SESSION["sessao_campos"]["entidade"], $_SESSION["entidade"],
                                                            "-- ".translate("word_choose")." --", "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["entidade"]."\", \"change_entity\")");
                                                ?>
                                            </td>
                                        </tr>
                                    </table>
                                    <br/>
                                    <table id="form_table" cellspacing="0" cellpadding="0">
                                        <tr>
                                            <td class="question_space" colspan="2">
                                                <?php   echo  translate('word_por_favor_preencha_seguintes_campos_obrigatorios') ?> <font class="error_msg">* </font> <?php   echo  translate('word_sao_preencimento_obrigatorio') ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="center">
                                                <br/>
                                                <table id="entidade_servico" class="select_list" cellspacing="0">
                                                    <caption>
                                                        <font class='error_msg'>* </font><?php   echo  translate('word_servicos_associados', true) ?> <?php   echo  translate('word_agency', true) ?>
                                                    </caption>
                                                    <thead>
                                                        <tr>
                                                            <th class="left"><?php   echo  translate('word_entity', true) ?></th>
                                                            <th class="left"><?php   echo  translate("word_service", true) ?></th>
                                                            <th class="center">
                                                                <input type="checkbox" name="change_servicos_prestados" id="change_servicos_prestados" value="1" title="change me"/>
                                                                <?php   echo  translate('word_add', true) ?>
                                                            </th>
                                                            <th class="center">
                                                                <input type="checkbox" name="change_servicos_prioritarios" id="change_servicos_prioritarios" value="1" title="change me"/>
                                                                <?php   echo  translate("word_service", true) ?><br/><?php   echo  translate('word_priority', true) ?>
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php 

                                                        $obj = new Servico();
                                                        $servicos_entidade = $obj->obterDados($_POST["entidade"]);

                                                        $num_servicos = count($servicos_entidade);

                                                        /*function getSrvId($aItem)
                                                        {
                                                            return $aItem["id_servico"];
                                                        }

                                                        function getSrvPri($aItem)
                                                        {
                                                            return $aItem["servico_prioritario"]?$aItem["id_servico"]:0;
                                                        }

                                                        function notZero($aItem)
                                                        {
                                                            return $aItem!=0;
                                                        }*/

                                                        $srv_balcao = array_map("getSrvId", $_SESSION["sessao_campos"]["servicos_balcao"]);
                                                        $srv_pri_balcao = array_map("getSrvPri", $_SESSION["sessao_campos"]["servicos_balcao"]);
                                                        $srv_pri_balcao = array_filter($srv_pri_balcao, "notZero");

                                                        for ($i=0; $i<count($servicos_entidade); $i++)
                                                        {
                                                            $id_servico = $servicos_entidade[$i]["id_servico"];
                                                            if($_SESSION["super_user"] == 1)
                                                            {
                                                                ?>
                                                        <tr>
                                                            <td class="left"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
                                                            <td class="left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
                                                            <td class="center"><input id="srv_<?php   echo $id_servico; ?>" class="servicos_prestados" name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>"
                                                                                      onclick="setSrv('<?php   echo $id_servico; ?>');"
                                                                                      onchange="valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados');
                                                                      valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios')"
                                                                                      type="checkbox" value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_balcao)) echo "checked"; ?>/></td>
                                                            <td class="center"><input id="pri_<?php   echo $id_servico; ?>" name="pri[]" class="pri" type="checkbox"
                                                                                      onclick="setPri('<?php   echo $id_servico; ?>');
                                                                      valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios');
                                                                      valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados')"
                                                                                      value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_pri_balcao)) echo "checked"; ?>/></td>
                                                        </tr>
                                                                <?php 
                                                            }
                                                            else if (in_array($servicos_entidade[$i]["id_entidade"], $_SESSION["entidade"]))
                                                            {
                                                                ?>
                                                        <tr>
                                                            <td class="left"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
                                                            <td class="left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
                                                            <td class="center"><input id="srv_<?php   echo $id_servico; ?>" class="servicos_prestados" name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>"
                                                                                      onclick="setSrv('<?php   echo $id_servico; ?>');"
                                                                                      onchange="valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados');
                                                                      valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios')"
                                                                                      type="checkbox" value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_balcao)) echo "checked"; ?>/></td>
                                                            <td class="center"><input id="pri_<?php   echo $id_servico; ?>" name="pri[]" class="pri" type="checkbox"
                                                                                      onclick="setPri('<?php   echo $id_servico; ?>');
                                                                      valuesHaveChanged('pri', [<?php   echo "'".implode("','", $srv_pri_balcao)."'"; ?>], 'change_servicos_prioritarios');
                                                                      valuesHaveChanged('servicos_prestados', [<?php   echo "'".implode("','", $srv_balcao)."'"; ?>], 'change_servicos_prestados')"
                                                                                      value="<?php   echo $id_servico; ?>" <?php   if (in_array($id_servico, $srv_pri_balcao)) echo "checked"; ?>/></td>
                                                        </tr>
                                                                <?php 
                                                            }
                                                        }
                                                        ?>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <span id="msg_servicos_prestados[]" class="error_msg">&nbsp;</span>
                                                <div id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="button" colspan="2">
                                                <div onClick="validaFormBalcao(0 , <?php   echo $num_servicos; ?>, true);"><?php   echo  translate('word_modify', true) ?></div>
                                                <div onClick="limpaFormulario(0);"><?php   echo  translate('word_clean', true) ?></div>
                                                <a href="index.php"><div><?php   echo  translate('word_cancel', true) ?></div></a>
                                            </td>
                                        </tr>
                                    </table>
                                </form>
                            </td>
                            <td class="bg_form_right">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="bg_form_bottom" colspan="3">&nbsp;</td>
                        </tr>
                    </table>
                </td>
                <td>&nbsp;</td>
            </tr>
        </table>

        <?php
        $_SESSION["sessao_msg"] = "&nbsp;"; // limpa a varíavel que guarda a última mensagem de erro
        ?>

        <?php
        include("../rodape.php");
        ?>

        <script>
        	// Initialize custom-dropdowns
        	(function() {
        		 initializeDropdowns();

        	})();
        </script>
    </body>
</html>
