<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<title>Gráfico</title>
		<link rel="stylesheet" href="../charts/amcharts/style.css" type="text/css">
		<script src="../charts/amcharts/amcharts.js" type="text/javascript"></script>
		<script src="../charts/amcharts/serial.js" type="text/javascript"></script>
		<script src="../charts/amcharts/amstock.js" type="text/javascript"></script>


                <script>
			AmCharts.ready(function () {
				generateChartData();
				createStockChart();
			});

			var chartData = [];

			function generateChartData() {
				var firstDate = new Date(2012, 0, 1);
				firstDate.setDate(firstDate.getDate() - 1000);
				firstDate.setHours(0, 0, 0, 0);

				for (var i = 0; i < 1000; i++) {
					var newDate = new Date(firstDate);
					newDate.setHours(0, i, 0, 0);

					var a = Math.round(Math.random() * (40 + i)) + 100 + i;
					var b = Math.round(Math.random() * 100000000);

					chartData.push({
						date: newDate,
						value: a,
						volume: b
					});
				}
			}

			var chart;

			function createStockChart() {
				chart = new AmCharts.AmStockChart();

				// As we have minutely data, we should set minPeriod to "mm"
				var categoryAxesSettings = new AmCharts.CategoryAxesSettings();
				categoryAxesSettings.minPeriod = "mm";
				chart.categoryAxesSettings = categoryAxesSettings;

				// DATASETS //////////////////////////////////////////
				var dataSet = new AmCharts.DataSet();
				dataSet.color = "#b0de09";
				dataSet.fieldMappings = [{
					fromField: "value",
					toField: "value"
				}, {
					fromField: "volume",
					toField: "volume"
				}];
				dataSet.dataProvider = chartData;
				dataSet.categoryField = "date";

				// set data sets to the chart
				chart.dataSets = [dataSet];

				// PANELS ///////////////////////////////////////////
				// first stock panel
				var stockPanel1 = new AmCharts.StockPanel();
				stockPanel1.showCategoryAxis = false;
				stockPanel1.title = "Value";
				stockPanel1.percentHeight = 70;

				// graph of first stock panel
				var graph1 = new AmCharts.StockGraph();
				graph1.valueField = "value";
				graph1.type = "smoothedLine";
				graph1.lineThickness = 2;
				graph1.bullet = "round";
				graph1.bulletBorderColor = "#FFFFFF";
				graph1.bulletBorderAlpha = 1;
				graph1.bulletBorderThickness = 3;
				stockPanel1.addStockGraph(graph1);

				// create stock legend
				var stockLegend1 = new AmCharts.StockLegend();
				stockLegend1.valueTextRegular = " ";
				stockLegend1.markerType = "none";
				stockPanel1.stockLegend = stockLegend1;


				// second stock panel
				var stockPanel2 = new AmCharts.StockPanel();
				stockPanel2.title = "Número de senhas atendidas:";
				stockPanel2.percentHeight = 30;
				var graph2 = new AmCharts.StockGraph();
				graph2.valueField = "volume";
				graph2.type = "column";
				graph2.cornerRadiusTop = 2;
				graph2.fillAlphas = 1;
				stockPanel2.addStockGraph(graph2);

				// create stock legend
				var stockLegend2 = new AmCharts.StockLegend();
				stockLegend2.valueTextRegular = " ";
				stockLegend2.markerType = "none";
				stockPanel2.stockLegend = stockLegend2;

				// set panels to the chart
				chart.panels = [stockPanel1, stockPanel2];


				// OTHER SETTINGS ////////////////////////////////////
				var scrollbarSettings = new AmCharts.ChartScrollbarSettings();
				scrollbarSettings.graph = graph1;
				scrollbarSettings.usePeriod = "10mm"; // this will improve performance
				scrollbarSettings.updateOnReleaseOnly = false;
				scrollbarSettings.position = "bottom";
				chart.chartScrollbarSettings = scrollbarSettings;

				var cursorSettings = new AmCharts.ChartCursorSettings();
				cursorSettings.valueBalloonsEnabled = true;
				chart.chartCursorSettings = cursorSettings;


				// PERIOD SELECTOR ///////////////////////////////////
				var periodSelector = new AmCharts.PeriodSelector();
				periodSelector.position = "bottom";
				periodSelector.dateFormat = "YYYY-MM-DD JJ:NN";
				periodSelector.inputFieldWidth = 150;
				periodSelector.periods = [{
					period: "D",
					count: 1,
                    label: "Dia"
				}, {
                    period: "W",
					label: "Semana"
				}, {
					period: "MAX",
					label: "MAX"
				}];
				chart.periodSelector = periodSelector;

				var panelsSettings = new AmCharts.PanelsSettings();
				panelsSettings.mouseWheelZoomEnabled = true;
                panelsSettings.usePrefixes = true;
				chart.panelsSettings = panelsSettings;


				chart.write('chartdiv');
			}


		</script>
	</head>
	<body style="background-color:#FFFFFF">
		<div id="chartdiv" style="width:100%; height:600px;"></div>
	</body>

</html>