<div class="chart-container">
    <canvas id="waitingTimeAvgMax"></canvas>
</div>

<?php 
    //Debug
    //print_r($_SESSION['waitingTimeAvgMaxConfig']);
?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@2.8.0"></script>
<script type="text/javascript">

    //#1 - Get canvas to draw Graph
    var ctx = document.getElementById('waitingTimeAvgMax').getContext('2d');

    //#2 - Prepare configs
    //#2.1 - Options
    let graphOptions = {
        elements: {
            line: {
                tension: 0
            }
        },
        legend: {
            display: true,
            position: 'bottom'
        },
        tooltips: {
            mode: 'index',
            intersect: false,
            callbacks: {
                label: function(tooltipItem, data) {
                    var label = data.datasets[tooltipItem.datasetIndex].label || '';

                    if (label) {
                        label += ': ';
                    }
                    label += tooltipItem.yLabel.toString().toHHMMSS();
                    return label;
                }
            }
        },
        hover: {
            mode: 'nearest',
            intersect: true
        },
        scales: {
            yAxes: [{
                ticks: {
                    callback: function(value, index, values) {
                        return Math.floor(value / 60) + 'min';
                    }
                }
            }]
        }
    }

    //#2.2 - Prepare data
    let labelsToUse = <?php  echo $_SESSION['waitingTimeAvgMaxConfig']['labelsToUse']; ?>;
    let fieldsToDraw = <?php  echo $_SESSION['waitingTimeAvgMaxConfig']['fieldsToDraw']; ?>;
    let rawData = <?php  echo $_SESSION['waitingTimeAvgMaxConfig']['rawData']; ?>;
    console.log(rawData);

    let treatedData = convertToDataSet(rawData, fieldsToDraw, labelsToUse);


    //#3 - Prepare chart object with config
    var chart = new Chart(ctx, {
        // The type of chart we want to create
        type: 'line',

        // The data for our dataset
        data: treatedData,

        // Configuration options go here
        options : graphOptions
    });

    //#UTIL - Convert seconds to HHmmss
    String.prototype.toHHMMSS = function () {
        var sec_num = parseInt(this, 10); // don't forget the second param
        var hours   = Math.floor(sec_num / 3600);
        var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
        var seconds = sec_num - (hours * 3600) - (minutes * 60);

        if (hours   < 10) {hours   = "0"+hours;}
        if (minutes < 10) {minutes = "0"+minutes;}
        if (seconds < 10) {seconds = "0"+seconds;}
        return hours+':'+minutes+':'+seconds;
    }


    //#UTIL - Convert raw data into chart dataset
    function convertToDataSet(rawData, fieldsToDraw, labelsToUse){
        //#0 - Available colors
        let availableColor = ['#304A56', '#4C7A87'];

        //#1 - Base dataset structure
        let dataResult = {
            labels : [],
            datasets : []
        };

        //#2 - Fulfill lables (xAxis)
        dataResult.labels = rawData.xAxis

        //#3 - Iterate rawData dataset
        rawData.dataSet.forEach(item => {

            //#3.1 - iterate fields to draw (1 or 2 lines per data)
            fieldsToDraw.forEach( (field, index) => {
                let newDataItem = {
                    label: item.name + ' ('+labelsToUse[index]+')',
                    fill: false,
                    borderColor: availableColor[index],
                    backgroundColor: availableColor[index],
                    data: item[field]
                }

                //#4 - push it to data dataResult
                dataResult.datasets.push(newDataItem);
            });


        });

        //#Finaly return treated data
        return dataResult;
    }

</script>
