<?php

session_start();
require_once("../config.inc.php");
global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
$bd = new AcessoBD();
$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0


$ssid = getRequestValue('ssid');
$stats = $_SESSION['statistics'][$ssid];
$source = $stats['type'];

$extra = getRequestValue('extra');
if($extra != ''){
	$extra .= "&$extra=" . getRequestValue($extra);
}

$extra = array();
$extra['ssid'] = $ssid;
foreach(explode(';', getRequestValue("extra")) AS $ex){
	$extra[$ex] = getRequestValue($ex);
}
$extraStr = "";
$extraStr2 = "";
$i = 0;
foreach($extra AS $ex => $str){
	if($i != 0){
		$extraStr .= ";";
	}
	$extraStr .= "$ex";
	$extraStr2 .= "&$ex=$str";
	
	$i++;
}


if(isset($extra['idLoja'])){
	$sql =	"SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN (" . $extra['idLoja'] . ") ";
	if($stats['services']['values'] != ''){
		$sql .= "AND s.id_servico IN (" . $stats['services']['values'] . ") ";
	}
}else{
	$sql =	"SELECT s.id_servico, s.nome FROM servicos AS s ";
	if($stats['services']['values'] != ''){
		$sql .= "WHERE s.id_servico IN (" . $stats['services']['values'] . ") ";
	}
}
//echo $sql;
$services = $bd->executarSQL($sql)->GetRows();

if(count($services) <= 0){
	echo " ";
	return;
}

$graphs = "";
$out = "<settings>\n";

// dump data_sets
$out .= "	<data_sets>\n".
	"		<data_set>\n".
	"			<title></title>\n".
	"			<file_name>../senhas/chartsData.php?dataSource=statistics_$source&extra=$extraStr$extraStr2</file_name>\n".
	"			<csv>\n".
	"				<separator>;</separator>\n".
	"				<date_format>YYYY-MM-DD</date_format>\n".
	"				<columns>\n".
	"					<column>date</column>\n";

$firstService = $services[0]['id_servico'];
foreach($services AS $service){
	$out .= "					<column>service_$service[id_servico]</column>\n";
	$graphs .= 	"				<graph>\n".
			"					<title>$service[nome]</title>\n".
			"					<color>#".dechex(mt_rand(16,100)) . dechex(mt_rand(16,255)) . dechex(mt_rand(16,255))."</color>\n".
			"					<data_sources>\n".
			"						<close>service_$service[id_servico]</close>\n".
			"					</data_sources>\n".
			"					<smoothed>true</smoothed>\n".
			"					<legend>\n".
			"						<date key='true' title='true'><![CDATA[: {close}]]></date>\n".
			"					</legend>\n".
			"				</graph>\n";
}
$out .= "				</columns>\n".
	"			</csv>\n".
	"		</data_set>\n".
	"	</data_sets>\n";

// dump graphs
$out .= "	<charts>\n".
	"		<chart>\n".
	"			<legend>\n".
	"				<show_date>true</show_date>\n".
	"			</legend>\n".
	"			<graphs>\n";
$out .= $graphs;
$out .= "			</graphs>\n".
	"		</chart>\n".
	"	</charts>\n";

if(count($services) > 0){
	$out .= "	<scroller>\n".
			"		<graph_data_source>service_$firstService</graph_data_source>\n".
			"	</scroller>\n";
}


$out .= "</settings>\n";

// output headers to avoid IE errors: http://support.microsoft.com/default.aspx?scid=kb;en-us;272359
header("Cache-Control: ");# leave blank to avoid IE errors
header("Pragma: ");# leave blank to avoid IE errors

echo $out;
?>
