<?php 

/* Classe de Gestão de Empregados */

class Empregado extends AcessoBD
{
    var $bd;

    /*
		Construtor da classe

		0 = Erro da BD
    */
    function Empregado()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
		Fun��o de inser��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Inserir($dados)
    {
        global $TRINCO;

        $auto = 0;
        $time_to_call = 0;

        switch ($dados["call_method"])
        {
            case "manual":
                break;
            case "semiauto":
                $auto = 1;
                $time_to_call = 0;
                break;
            case "auto":
                $auto = 1;
                $time_to_call = $dados["time_to_call"];
                break;
            default:
                break;
        }

//        if($dados["nome"] == "")
//            $dados["nome"] = "null";
//        else $dados["nome"] = "'".$dados["nome"]."'";

        if($dados["contacto"] == "")
            $dados["contacto"] = "null";
        else $dados["contacto"] = "'".$dados["contacto"]."'";

	if($dados["id_externo"] == "")
            $dados["id_externo"] = "NULL";
        else $dados["id_externo"] = "'".trim($dados["id_externo"])."'";

        if($dados["nome_utilizador"] == "")
            $dados["nome_utilizador"] = "null";
        else $dados["nome_utilizador"] = "'".$dados["nome_utilizador"]."'";
        //echo password_hash($dados["password"], PASSWORD_BCRYPT);
        if($dados["password"] == "")
            $dados["password"] = "null";
        else $dados["password"] = "'".password_hash($dados["password"], PASSWORD_BCRYPT)."'";
        //else $dados["password"] = "'".$dados["password"]."'";
        //else $dados["password"] = "'".password_hash($dados["password"], PASSWORD_BCRYPT)."'";

        /*if($dados["chamada"] == "")
			$dados["chamada"] = 0;
		else $dados["chamada"] = 1;*/

        if ($dados["desistir"] == "")
            $dados["time_to_disable"] = "null";
        else $dados["time_to_disable"] = "'".$dados["time_to_disable"]."'";

        $sql = "INSERT INTO empregados (nome, nome_utilizador, password, estado, ranking, contacto, id_externo, auto, refresh_time, disable_desistir_after, id_balcao)
									VALUES (
									".(strlen($dados["nome"])?("'".($dados["nome"])."'"):"null").",
									".$dados["nome_utilizador"].",
									".$dados["password"].",
									".$dados["estado"].",
									".$dados["ranking"].",
									".$dados["contacto"].",
									".$dados["id_externo"].",
									".$auto.",
									".$time_to_call.",
									".$dados["time_to_disable"].",
									".$dados["id_balcao"].")";

        if($rs = $this->bd->executarSQL($sql))
        {
            $sql = "SELECT MAX(id_empregado) as id_empregado FROM empregados;";
            
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            //$id = $this->bd->obterValor($rs,0);
            $id = $this->bd->obterValor($rs,"id_empregado");

            // insere os locais de trabalho do empregado
            $locais_trabalho = new LocalColaborador();

            $res = $locais_trabalho->Inserir($dados["locais_trabalho"], $id, NULL);
            if (!$res)
            {
                return 0;
            }

            // insere as entidades associadas ao empregado
            $entidades_trabalho = new EntidadeColaborador();

            $res = $entidades_trabalho->Inserir($dados["entidades_trabalho"], $id, NULL);
            if (!$res)
            {
                return 0;
            }

            /* id_hist */
            $sql = "insert into id_hist (id, name, type) values (
                    ".$id.",
                    ".(strlen($dados["nome"])?("'".($dados["nome"])."'"):"null").",
                    'empregado')";


            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }

            $objecto = new LogAccao();
            $rs = $objecto->Inserir("Inserção", "Empregado", (strlen($dados["nome"])?(($dados["nome"])):"null"));
            $objecto->fechar();

            // regista a inserção
//            $this->EscreveXMLSync($id, "inserir");

            return "ok";
        } else
        {
             
            return 0;
        }
    }

    /*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
    */
    function LerDados($id)
    {
        $aux = array();
        if (is_array($id))
        {
            $aux = $id;
        }
        else
        {
            array_push($aux, $id);
        }

        $sql = "SELECT c.*
            FROM empregados c
            left join local_colaborador lc on lc.id_colaborador=c.id_empregado
            left join entidade_colaborador ec on ec.id_colaborador=c.id_empregado
            WHERE id_empregado in (" . implode(",", $aux) . ")";

        /*$aux = array();
        if (is_array($_SESSION["loja"]))
        {
            array_push($aux, "lc.id_local in (".implode(",", $_SESSION["loja"]).")");
        }
        if (is_array($_SESSION["entidade"]))
        {
            array_push($aux, "ec.id_entidade in (".implode(",", $_SESSION["entidade"]).")");
        }
        $sql .= " and ".implode(" and ", $aux);*/

        $empData = $this->bd->getRows($sql);
        if(!count($empData)) return 0;

        $locais_trabalho = new LocalColaborador();
//        $resultado = $locais_trabalho->LerDados();

        $entidade_trabalho = new EntidadeColaborador();
//        $resultado = $entidade_trabalho->LerDados();

        $locais_trabalho->LerDados($empData[0]["id_empregado"]);
        $entidade_trabalho->LerDados($empData[0]["id_empregado"]);


        if (is_array($id))
        {
//            $_SESSION["sessao_campos"] deve conter os valores comuns e deixar os outros em branco.
            $_SESSION["sessao_campos"]["estado"] = $empData[0]["estado"];
            $_SESSION["sessao_campos"]["ranking"] = $empData[0]["ranking"];
            $_SESSION["sessao_campos"]["auto"] = $empData[0]["auto"];
            $_SESSION["sessao_campos"]["refresh_time"] = $empData[0]["refresh_time"];
            $_SESSION["sessao_campos"]["disable_desistir_after"] = $empData[0]["disable_desistir_after"];
			$_SESSION["sessao_campos"]["id_balcao"] = $empData[0]["id_balcao"];

//            $_SESSION["sessao_campos"]["locais_trabalho"] = "";
//            $_SESSION["sessao_campos"]["entidades_trabalho"] = "";
            $aLocTrab = $_SESSION["sessao_campos"]["locais_trabalho"];
            $aEntTrab = $_SESSION["sessao_campos"]["entidades_trabalho"];

            $_SESSION["sessao_campos"]["nome_empregados"] = array();

            foreach ($empData as $emp)
            {
                array_push($_SESSION["sessao_campos"]["nome_empregados"], $emp["nome"]);

                $_SESSION["sessao_campos"]["estado"] = ($emp["estado"]==$_SESSION["sessao_campos"]["estado"])?$emp["estado"]:"";
                $_SESSION["sessao_campos"]["ranking"] = ($emp["ranking"]==$_SESSION["sessao_campos"]["ranking"])?$emp["ranking"]:"";
		        $_SESSION["sessao_campos"]["id_externo_colaborador"] = ($emp["id_externo_colaborador"]==$_SESSION["sessao_campos"]["id_externo_colaborador"])?$emp["id_externo_colaborador"]:"";
                $_SESSION["sessao_campos"]["auto"] = ($emp["auto"]==$_SESSION["sessao_campos"]["auto"])?$emp["auto"]:"";
                $_SESSION["sessao_campos"]["refresh_time"] = ($emp["refresh_time"]==$_SESSION["sessao_campos"]["refresh_time"])?$emp["refresh_time"]:"";
                $_SESSION["sessao_campos"]["disable_desistir_after"] = ($emp["disable_desistir_after"]==$_SESSION["sessao_campos"]["disable_desistir_after"])?$emp["disable_desistir_after"]:"";

                $locais_trabalho->LerDados($emp["id_empregado"]);
                if ($_SESSION["sessao_campos"]["locais_trabalho"]!=$aLocTrab)
                {
                    $_SESSION["sessao_campos"]["locais_trabalho"] = array();
                    $aLocTrab = array();
                }

                $entidade_trabalho->LerDados($emp["id_empregado"]);
                if ($_SESSION["sessao_campos"]["entidades_trabalho"]!=$aEntTrab)
                {
                    $_SESSION["sessao_campos"]["entidades_trabalho"] = array();
                    $aEntTrab = array();
                }
            }
        }
        else
        {
            $_SESSION["sessao_campos"] += $empData[0];
        }

        $locais_trabalho->Fechar();
        $entidade_trabalho->Fechar();

//        $tuplo = $this->bd->moverRegisto($rs , 0);
//        $_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);



//        global $TRINCO;
        // desencriptar a palavra_chave para posterior edi��o
        /*		$sql = "SELECT AES_DECRYPT('" . $_SESSION["sessao_campos"]["password"] . "', '" . $TRINCO . "');"; //DES_ENCRYPT DES_DECRYPT para SSL
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$rs = $this->bd->obterRegisto($rs);
		$_SESSION["sessao_campos"]["password"] = $rs[0];
        */
//        $locais_trabalho = new LocalColaborador();
//        $resultado = $locais_trabalho->LerDados($id);
//        $locais_trabalho->Fechar();
//
//        $entidade_trabalho = new EntidadeColaborador();
//        $resultado = $entidade_trabalho->LerDados($id);
//        $entidade_trabalho->Fechar();

        return "ok";
    }

    /*
		Fun��o de edi��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Editar($dados, $id)
    {
		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array(
			"estado" => translate("word_state", true),
			"ranking" => translate("word_ranking", true),
			"nome"=> translate("word_name", true),
			"nome_utilizador" => translate("word_user_name", true),
			"password" => translate("word_pass", true));

        if (is_array($id))
        {
            $sql = "UPDATE empregados SET ";

            $aux = array();

            if (isset($dados["change_estado"]))
            {
                array_push($aux, "estado=".$dados["estado"]);

                if ($dados["estado"]==1) array_push($aux, "num_tentativas=0");
            }
            if (isset($dados["change_ranking"]))
            {
                array_push($aux, "ranking=".$dados["ranking"]);
            }
            if (isset($dados["change_call_method"]))
            {
                $auto = 0;
                $time_to_call = 0;

                switch ($dados["call_method"])
                {
                    case "manual":
                        break;
                    case "semiauto":
                        $auto = 1;
                        $time_to_call = 0;
                        break;
                    case "auto":
                        $auto = 1;
                        $time_to_call = $dados["time_to_call"];
                        break;
                    default:
                        break;
                }

                array_push($aux, "auto=".$auto);
                array_push($aux, "refresh_time=".$time_to_call);
            }
            if (isset($dados["change_desistir"]))
            {
                if (!isset($dados["desistir"])) array_push($aux, "disable_desistir_after=null");
                else if (isset($dados["desistir"]) && !strlen($dados["time_to_disable"])) array_push($aux, "disable_desistir_after=0");
                else array_push($aux, "disable_desistir_after=".$dados["time_to_disable"]);
            }

            $sql .= implode(", ", $aux)." where id_empregado in (".implode(", ", $id).")";

            if (count($aux)) $this->bd->executarSQL($sql);

            if (isset($dados["change_locais_trabalho"]))
            {
                $locais_trabalho = new LocalColaborador();
                $locais_trabalho->Editar($dados["locais_trabalho"],$id, NULL);
                $locais_trabalho->fechar();
            }
            if (isset($dados["change_entidades_trabalho"]))
            {
                $entidade_trabalho = new EntidadeColaborador();
                $entidade_trabalho->Editar($dados["entidades_trabalho"],$id, NULL);
                $entidade_trabalho->fechar();
            }

            return "ok";
        }
        else
        {
            global $TRINCO;

            $auto = 0;
            $time_to_call = 0;

            switch ($dados["call_method"])
            {
                case "manual":
                    break;
                case "semiauto":
                    $auto = 1;
                    $time_to_call = 0;
                    break;
                case "auto":
                    $auto = 1;
                    $time_to_call = $dados["time_to_call"];
                    break;
                default:
                    break;
            }

            if($dados["contacto"] == "")
                $dados["contacto"] = "null";

            if($dados["id_externo"] == "")
                $dados["id_externo"] = "NULL";
            else $dados["id_externo"] = "'".trim($dados["id_externo"])."'";

            if($dados["nome_utilizador"] == "")
                $dados["nome_utilizador"] = "null";
            else
                $dados["nome_utilizador"] = "'".$dados["nome_utilizador"]."'";

            if($dados["password"] == "")
                $dados["password"] = "null";
            else {
                $sql = "SELECT password FROM empregados WHERE  id_empregado=".$id;;
                $rs = $this->bd->executarSQL($sql);
                $tuplo = $this->bd->obterRegisto($rs);
                $old_password = $tuplo["password"];
                if($old_password != $dados["password"]) {
                    $dados["password"] = password_hash($dados["password"], PASSWORD_BCRYPT);
                }
            }


            /*if($dados["chamada"] == "")
                            $dados["chamada"] = 0;*/

            if (!isset($dados["desistir"]))
                $dados["time_to_disable"] = "null";
            else if (isset($dados["desistir"]) && !strlen($dados["time_to_disable"]))
                $dados["time_to_disable"] = 0;

            $sql = "UPDATE empregados SET nome = '" . $dados["nome"] . "',
                    nome_utilizador = " . $dados["nome_utilizador"] . ",
                    password = '" . $dados["password"] . "' ,
                    estado = '" . $dados["estado"] . "',
                    ranking = " . $dados["ranking"] . ",
                    id_externo = " . $dados["id_externo"] . ",
                    contacto=". $dados["contacto"] ." ";
            if($dados["estado"]	== 1)
                $sql .= ", num_tentativas = '0' ";
            $sql .=	", auto=".$auto.",
                    refresh_time=".$time_to_call.",
                    disable_desistir_after=".$dados["time_to_disable"].",
					id_balcao=".$dados['id_balcao']."
                    WHERE id_empregado=".$id;

            if($rs = $this->bd->executarSQL($sql))
            {
                /* id_hist */
                $sql = "update id_hist
                set name='".$dados["nome"]."'
                where id=".$id."
                and type='empregado'";
                if (!$rs = $this->bd->executarSQL($sql))
                {
                    return 0;
                }
                //$this->EscreveXMLSync($id, "editar");


                $locais_trabalho = new LocalColaborador();
                $resultado = $locais_trabalho->Editar($dados["locais_trabalho"],$id, NULL);
                $locais_trabalho->fechar();
                //		file_put_contents("/tmp/debug.txt" , "\naaaaaa   ".$dados["locais_trabalho"] , FILE_APPEND);
                //fechaXMLsync($documento);
                $entidade_trabalho = new EntidadeColaborador();
                $resultado2 = $entidade_trabalho->Editar($dados["entidades_trabalho"],$id, NULL);
                $entidade_trabalho->fechar();

                if($resultado || $resultado2)
                {
                    $objecto = new LogAccao();

                    if ($oldInfo['password'] != $newInfo['password']) {
                      $oldInfo['password'] = '****';
                      $newInfo['password'] = '*****';
                    }
                    $diff = my_array_diff_values($oldInfo, $newInfo, $labels);

                    // Faz o mesmo para as entidades
                    $locaisOld = $oldInfo['locais_trabalho'];
                    $EntidadesOld = $oldInfo['entidades_trabalho'];
                    $locaisNew = $dados['locais_trabalho'];
                    $EntidadesNew = $dados['entidades_trabalho'];
                    if (!is_array($locaisNew))
                        $locaisNew = array($locaisNew);
                    if (!is_array($EntidadesNew))
                        $EntidadesNew = array($EntidadesNew);
                    $diffServicos = my_array_diff_values4($locaisOld,$locaisNew,$EntidadesOld,$EntidadesNew);

                    $msg = "<table><tr><td colspan=3 align=left><b>$newInfo[nome]</b></td></tr>";
                    $msg .= action_msg_info($diff,false,'colaboradores');
                    $msg .= action_msg_info($diffServicos,false,'colaboradores');
                    $msg .= "</table>";

                    $rs = $objecto->Inserir("Edição", "Empregado", $msg);
                    $objecto->fechar();
                    return "ok";
                }
            }
            return 0;
        }
    }

    /*
		Fun��o de remo��o

		0 = Erro da BD
		true = Sucesso
    */
    function Remover($id)
    {
        $this->EscreveXMLSync($id, "remover");

        $numEntradas = count($id);
        $nomes = array();
        $sql = "SELECT nome FROM empregados WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_empregado = " . $id[$i] . " OR ";
        $sql .= "id_empregado = " . $id[0] . ";";

        if($rs = $this->bd->executarSQL($sql))
        {
            for($i = 0; $i < $numEntradas; $i++)
            {
                $this->bd->moverRegisto($rs,$i);
                array_push($nomes, $this->bd->obterValor($rs,"nome"));
            }
        }
        else
            return 0;

        $sql = "DELETE FROM empregados WHERE ";
        // locais de trabalho do empregado
        $sql_locais_colaborador = "DELETE FROM local_colaborador WHERE ";
        for ( $i = count($id); $i > 1; $i-- )
        {
            $ids .= "id_empregado = ". $id[$i-1] . " OR ";
        }
        $ids .= "id_empregado = ". $id[0] . ";";

        $sql .= $ids;
        $sql_locais_colaborador .= preg_replace("/empregado/", "colaborador", $ids);
        //debugSQL($sql_locais_colaborador);

        $rs = $this->bd->executarSQL($sql);
        $rs_locais_colaborador = $this->bd->executarSQL($sql_locais_colaborador);

        if($rs && $rs_locais_colaborador )
        {
            $entidade = new EntidadeColaborador();
            $entidade -> Remover($id);
            $entidade ->fechar();
            $objecto = new LogAccao();
            for($i = count($nomes)-1; $i >= 0; $i--)
            {
                $rs = $objecto->Inserir("Remoção", "Empregado", $nomes[$i]);
            }
            $objecto->fechar();
            return "ok";
        } else
        {
            return 0;
        }
    }

    /*
		Procede � cria��o e escrita de um
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao, $enderecos_lojas=null)
    {

        if(!is_array($id))
            $id = array($id);

        $numEntradas = count($id);//UtilizadorExistente($username);

        $sql = "SELECT * FROM empregados WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_empregado = " . $id[$i] . " OR ";
        $sql .= "id_empregado = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $documento = abreXMLSync();
        $raiz = $documento->firstChild;


        if(is_null($enderecos_lojas))
        {
            $loja = new Loja();
            $enderecos = $loja->listaIpLojas();

            //$loja->Fechar();
        } else
        {
            $enderecos = $enderecos_lojas;
        }

        if(count($enderecos) > 0)
        {
            $destinos = $documento->createElement("destinos");
            $raiz->appendChild($destinos);
            //		file_put_contents("/tmp/debug.txt" , "scrivi xml  ".$destinos , FILE_APPEND);
        }

        for($i = 0 ; $i < count($enderecos) ; $i++)
        {
            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);
        }

        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0 ; $i < $numEntradas ; $i++)
        {
            $this->bd->moverRegisto($rs, $i);

            $no_empregado = $documento->createElement("empregado");
            $raiz->appendChild($no_empregado);

            $no_empregado->setAttribute("id", $this->bd->obterValor($rs, "id_empregado"));
            $no_empregado->setAttribute("accao", $accao);

            $elemento = $documento->createElement("nomePessoa");
            $elemento->nodeValue = $this->bd->obterValor($rs, "nome");
            $no_empregado->appendChild($elemento);

            $valor = $this->bd->obterValor($rs, "nome_utilizador");
            if(isset($valor))
            {
                $elemento = $documento->createElement("nomeUtilizador");
                $elemento->nodeValue = $valor;
                $no_empregado->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "password");
            if(isset($valor))
            {
                $elemento = $documento->createElement("password");
                $elemento->nodeValue = base64_encode($valor);
                $no_empregado->appendChild($elemento);
            }

            $elemento = $documento->createElement("tentativas");
            $elemento->nodeValue = $this->bd->obterValor($rs, "num_tentativas");
            $no_empregado->appendChild($elemento);

            $elemento = $documento->createElement("estadoEmpregado");
            $elemento->nodeValue = $this->bd->obterValor($rs, "estado");
            $no_empregado->appendChild($elemento);

            $valor = $this->bd->obterValor($rs, "local_trabalho");
            if(isset($valor))
            {
                $elemento = $documento->createElement("idLoja");
                $elemento->nodeValue = $valor;
                $no_empregado->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "contacto");
            if(isset($valor))
            {
                $elemento = $documento->createElement("telefone");
                $elemento->nodeValue = $valor;
                $no_empregado->appendChild($elemento);
            }

	    $valor = $this->bd->obterValor($rs, "id_externo");
            if(isset($valor))
            {
                $elemento = $documento->createElement("idExterno");
                $elemento->nodeValue = $valor;
                $no_empregado->appendChild($elemento);
            }
        }

        fechaXMLsync($documento);

    }

    /*
		Fun��o de listagem

		0 = Erro da BD
		true = Sucesso
    */

    function Listar()
    {
        $sql = "SELECT distinct e.id_empregado, e.nome, e.estado, e.auto, e.ranking
				FROM entidades ent, entidade_colaborador ec, empregados e
                left join local_colaborador lc on lc.id_colaborador=e.id_empregado ";

        if(getSessionValue("super_user") == 0)
        {//nao é um administador

            $sql .= ", local_colaborador lc1 WHERE lc1.id_colaborador = e.id_empregado
							AND ec.id_colaborador = e.id_empregado AND (lc1.id_local =".$_SESSION["loja"][0];
            for($i=1; $i < count($_SESSION["loja"]); $i++)
                $sql .= " OR lc.id_local=".$_SESSION["loja"][$i];

            $sql .= ") AND (ec.id_entidade = ".$_SESSION["entidade"][0];

            for($i=1; $i < count($_SESSION["entidade"]); $i++)
                $sql .= " OR ec.id_entidade=".$_SESSION["entidade"][$i];
            $sql .= ") ";

            if(getRequestValue("estado") != "")	 // estado
                $sql .= "AND e.estado = " . $_REQUEST["estado"] . " and ent.id_entidade=ec.id_entidade ";

            if(getRequestValue("loja") != "")	 // estado
                $sql .= "AND lc1.id_local = " . $_REQUEST["loja"] . " and ent.id_entidade=ec.id_entidade ";
        }
        else
        {
            if(getRequestValue("estado") != "")	 // estado
                $sql .= "WHERE e.estado = " . $_REQUEST["estado"] . " and ent.id_entidade=ec.id_entidade ";
            else
                $sql .= "where ent.id_entidade=ec.id_entidade AND ec.id_colaborador = e.id_empregado ";

            if(getRequestValue("loja") != "")	 // estado
                $sql .= "and lc.id_local = " . $_REQUEST["loja"];
        }

        if(getRequestValue("nome") != "")	 // nome
        {
            $aNome = explode(" ", getRequestValue("nome"));
            foreach ($aNome as $nome)
            {
                $sql .= "and e.nome like '%".$nome."%' ";
            }
        }

/*  generating error J
        $sql .= " group by e.id_empregado ";
*/
        if(getRequestValue("campo") != "")
            $sql .= " ORDER BY e." . $_REQUEST["campo"] . " ";
        else
            $sql .= " ORDER BY e.nome ";

        if(getRequestValue("ordem") == 1)
            $sql .= " DESC";
        else
            $sql .= " ASC";


        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }
        
        $colaboradores = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($colaboradores, $row);

        $n = 1;
        $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
        $numPaginas = 1; // n�mero de p�ginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

        // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
        if(($numTuplos/$numRegPag) <= (intval(getRequestValue("pagina"))-1))
            $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>" . translate("word_number_costumers") . "</div>";
            //return;
        }

        // calculo do n�mero de p�ginas de registos
        if($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=colaboradores&pagina=" . getRequestValue("pagina") . "&campo=" . getRequestValue("campo")  . "&ordem=" . getRequestValue("ordem")  . "&estado=" . getRequestValue('estado') . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>";
        ?>
<br/>

<table id="tbl_colaboradores" class="sortable data_table" style="width:100%; text-align:center">
    <thead>
        <tr class="column_row" onClick="javascript:sortAll('tbl_colaboradores',10,'button_page')">
            <td width='18' style='padding-left:8px' ><?php   echo  translate("word_select", true) ?></td>
            <td class='column_cell'><?php   echo  translate('word_name', true)?></td>
            <td class='column_cell'><?php   echo  translate('word_entity', true) ?></td>
            <td class='column_cell'><?php   echo  translate('word_local', true)?></td>
            <td class='column_cell'><?php   echo  translate("word_state", true) ?></td>
            <td class='column_cell'><?php   echo  translate('word_ranking', true)?></td>
            <td class='column_cell' style="width:40px"><?php   echo  translate('word_auto', true)?></td>
            <td class='column_cell' style="width:140px"><?php   echo  translate('word_operations', true)?></td>
        </tr>
    </thead>
    <tbody>
                <?php 
                for ($i=0; $i<count($colaboradores); $i++)
                {
                    $estado = obterEstadoUtilizador($colaboradores[$i]["estado"]);
                    $entidades = $this->obterEntidadesColaborador($colaboradores[$i]["id_empregado"]);
                    $lojas = $this->obterLojasColaborador($colaboradores[$i]["id_empregado"]);

                    $auto = $colaboradores[$i]["auto"]?"X":"&nbsp;";
                    ?>
        <tr class='form-data-tr'>
            <td class='form-data-td'>
								<label class='custom-check-container'>
										<input name='grupo' type='checkbox' value='<?php   echo $colaboradores[$i]["id_empregado"]; ?>' onClick='selectEntireRow(this)'>
										<span class='custom-checkmark'></span>
								</label>
						</td>
            <td class='form-data-td'><?php   echo $colaboradores[$i]["nome"]; ?></td>
            <td class='form-data-td'><?php   echo $entidades; ?></td>
            <td class='form-data-td'><?php   echo $lojas; ?></td>
            <td class='form-data-td'><?php   echo $estado; ?></td>
            <td class='form-data-td'><?php   echo $colaboradores[$i]["ranking"]; ?></td>
            <td class='form-data-td'><?php   echo $auto; ?></td>
            <td class='form-data-td' style='width: 190px;'>
                <?php 
                if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_empregados"] == 2 )
                {
                    echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=colaboradores&id=" . $colaboradores[$i]["id_empregado"] . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
                          <a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=colaboradores&pagina=" . getRequestValue("pagina") . "&campo=" . getRequestValue("campo") . "&ordem=" . getRequestValue('ordem') . "&estado=" . getRequestValue('estado') . "&id=" . $colaboradores[$i]["id_empregado"] . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
                }
                else
                {
                    echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=colaboradores&id=" . $colaboradores[$i]["id_empregado"] . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
                }
                ?>
            </td>
        </tr>
                    <?php 
                }
                ?>
    </tbody>
</table>
<!-- Pager -->
<table style="width: 100%">
    <tr>
      <td class="button_page" id="button_page">
      </td>
    </tr>
</table>

        <?php 
        echo "
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
                
        if ( $_SESSION["sessao_perms"]["perm_empregados"] == 2 )
        {
            echo	'<tr>
                    <td class="button">
                      <div class="button-full-green" onClick="navigateToUrl(\'inserir.php\')">'.translate('word_insert_new', true).'</div>
          						<div class="button-thin-green" onClick="seleccionaCaixa(true)">'. translate('word_mark_all', true).'</div>
          						<div class="button-thin-green" onClick="seleccionaCaixa(false)">'. translate('word_unmark_all', true).'</div>
          						<div class="button-thin-green" onClick="removerMarcados(this)">'. translate('word_remove_selected', true).'</div>
          						<div class="button-thin-green" onClick="editarMarcados(\'colaboradores\')">'. translate('word_edit_selected', true).'</div>
        					</td>
        				</tr>';
        }

        echo	"</table>
		</form>";
    }


    function UtilizadorExistente($username)
    {
        $sql = "select count(*) as n from empregados where nome_utilizador='" . trim($username) . "'";
        if(!$rs = $this->bd->executarSQL($sql))
            return;
        return $this->bd->obterValor($rs, "n");
    }



    function obterLojasColaborador($idColaborador = 0)
    {

        $sql =	"SELECT DISTINCT l.id_loja, l.nome ".
                "FROM lojas AS l ".
                "INNER JOIN local_colaborador AS lc ON lc.id_local = l.id_loja ".
                "WHERE lc.id_colaborador = $idColaborador";
        $res = $this->bd->GetRows($sql);

        $results = array();
        $count = 0;
        $full = false;
        foreach($res AS $row)
        {
            if($count > 3)
            {
                $full = true;
                break;
            }
            $results[] = $row['nome'];

            $count++;
        }

        if($full)
        {
            $results[] = "... (" . (count($res) - 3) . ")";
        }
        $str = implode(', ', $results) . "&nbsp;";

        return $str;
    }

    function GetColaboradores($where="")
    {
        $sql = "select distinct c.id_empregado id_colaborador, c.nome nome
			from empregados c
			inner join local_colaborador lc on lc.id_colaborador=c.id_empregado";
        if (strlen($where)) $sql .= " where ".$where;
        $sql .= " order by nome";

        return $this->bd->getRows($sql);
    }

    /*
		Destrutor da classe

		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }

	function getBalcoes($thisBalcao=0)
	{
		if($thisBalcao=='')
			$thisBalcao=0;
        $sql = "SELECT id_balcao, nome FROM `balcoes` WHERE id_balcao=$thisBalcao OR id_balcao NOT IN (SELECT id_balcao FROM empregados WHERE id_balcao IS NOT NULL)";
        return $this->bd->getRows($sql);
	}



        function getEmpregadoStatus($id_colaborador){
            $sql = "SELECT id_loja, id_balcao, estado, TIMEDIFF(NOW(), ultima_actualizacao) as duracao from empregados_estados WHERE id_empregado=$id_colaborador";
            $rs = $this->bd->executarSQL($sql);
            $estado_empregado = array();
		$estado_empregado['id_loja']=$this->bd->obterValor($rs, "id_loja");
                $estado_empregado['id_balcao']=$this->bd->obterValor($rs, "id_balcao");
                $estado_empregado['estado']=$this->bd->obterValor($rs, "estado");
                $estado_empregado['duracao']=$this->bd->obterValor($rs, "duracao");
        return $estado_empregado;
        }

        function updateEstado($id_balcao, $estado){
            $sql = "UPDATE empregados_estados SET estado=$estado WHERE id_balcao=$id_balcao and 3 NOT in estado";
            $this->bd->executarSQL($sql);
        }

        function getSatisfacao($data, $empregado, $loja){

            $total_positivo=$this->getTotalPositivo($data, $empregado, $loja);
            $total_negativo=$this->getTotalNegativo($data, $empregado, $loja);
            $total_avaliado=$total_negativo+$total_positivo;
            $percentagem=($total_positivo/$total_avaliado)*100;

            return is_nan($percentagem) ? '-' : $percentagem;
            /*$percentage=0;



            $sql = "SELECT satisfacao from senhas WHERE id_colaborador=$empregado AND id_loja=$loja AND data LIKE '$data%' AND status='Terminado'";
            //$res = $this->bd->executarSQL($sql)->GetRows();
            $res = $this->bd->getRows($sql);
            $i=0;
             foreach($res AS $row){
                 $i++;
                 $percentage=$percentage+$row['satisfacao'];
             }
             $percentage=($percentage*100)/$i;
             return is_nan($percentage) ? '-' : $percentage;*/
     }

     function getTotalAval($data, $empregado, $loja){
            $sql = "SELECT count(satisfacao) as total from senhas WHERE id_colaborador=$empregado AND id_loja=$loja AND data LIKE '$data%' AND status='Terminado' ";//AND (satisfacao=0 OR satisfacao=1)
            //$res = $this->bd->executarSQL($sql)->GetRows();
            $res = $this->bd->getRows($sql);

             return $res[0]['total'];
     }

     function getTotalPositivo($data, $empregado, $loja){
        global $EVALUATION_POSITIVE_MIN;
            $sql = "SELECT count(satisfacao) as total from senhas WHERE id_colaborador=$empregado AND id_loja=$loja AND data LIKE '$data%' AND status='Terminado' AND satisfacao>=$EVALUATION_POSITIVE_MIN";
            //$res = $this->bd->executarSQL($sql)->GetRows();
             $res = $this->bd->getRows($sql);
             return $res[0]['total'];
     }

     function getTotalNegativo($data, $empregado, $loja){
        global $EVALUATION_POSITIVE_MIN;
            $sql = "SELECT count(satisfacao) as total from senhas WHERE id_colaborador=$empregado AND id_loja=$loja AND data LIKE '$data%' AND status='Terminado' AND satisfacao<$EVALUATION_POSITIVE_MIN";
            //$res = $this->bd->executarSQL($sql)->GetRows();
            $res = $this->bd->getRows($sql);
             return $res[0]['total'];
     }

     function obterEntidadesColaborador($idColaborador = 0)
    {

        $sql =  "SELECT DISTINCT e.id_entidade, e.nome ".
                "FROM entidades AS e ".
                "INNER JOIN entidade_colaborador AS ec ON ec.id_entidade = e.id_entidade ".
                "WHERE ec.id_colaborador = $idColaborador";
               
        $res = $this->bd->GetRows($sql);

        $results = array();
        $count = 0;
        $full = false;
        foreach($res AS $row)
        {
            if($count > 3)
            {
                $full = true;
                break;
            }
            $results[] = $row['nome'];

            $count++;
        }

        if($full)
        {
            $results[] = "... (" . (count($res) - 3) . ")";
        }
        $str = implode(', ', $results) . "&nbsp;";

        return $str;
    }

}

?>
