<?php

/* Classe de Gestão de Dispensadores */

class Dispensador extends AcessoBD
{
    var $bd;

    /*
		Construtor da classe

		0 = Erro da BD
    */
    function Dispensador()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
		Fun��o de inser��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Inserir($dados)
    {
        // cria o dispensador "geral"
        $sql = "INSERT INTO dispensador (tipo_dispensador, status_impressora, estado, nome, id_loja, piso)";
        $sql .= " VALUES (" . ($dados["nome_tabela"] == "dispensador_base" ? 1 : 2) .  ", " . $dados["status_impressora"].", ".$dados["estado"].", "
		. "'".$dados["nome"]."', " . $dados["id_loja"] . ", " . $dados["piso"] .")";

        if(!$rs = $this->bd->executarSQL($sql))
        {
            return 0;
        }
        // obtem o id do dispensador "geral" criado acima
        $id_super = $this->bd->obterUltimoInsertId();

        // dispensador manual (tipo bico de pato)
        if ($dados["nome_tabela"] == "dispensador_manual")
        {
            $sql = "INSERT INTO dispensador_manual (id_dispensador, id_servico) VALUES ($id_super, " . $dados["id_servico"] . ");";
            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }
        } else if ($dados["nome_tabela"] == "dispensador_base")
        {
			/* introduz o id e o ip nas tabelas leitor_cartoes e dcm */

			$ip = explode(':',$dados["identificador"]);
			$ip = $ip[0];

			if($dados["leitor_cartoes"]==1)
			{
				$stateAutoCheckin = $dados["stateAutoCheckinModule"];
				$sql = "insert into leitor_cartoes(ip, id_dispensador, enabled) values('$ip', $id_super, $stateAutoCheckin)";
				$this->bd->executarSQL($sql);
			}

			if($dados["dcm"]==1)
			{
				$statePayment = $dados["statePaymentModule"];
				$sql = "insert into dcm(ip, id_dispensador, enabled) values('$ip', $id_super, $statePayment)";
				$this->bd->executarSQL($sql);
			}

            // cria o dispensador base
            $sql = "INSERT INTO dispensador_base (id_dispensador, identificador, msg_boasvindas, msg_impressaosenha,
							tipo_processador, tipo_impressora, tipo_ecra)
							VALUES (" . $id_super . ", '" . $dados["identificador"] . "', '" . $dados["boasvindas"] . "', '"
                    . $dados["impressaosenha"] . "', '" . $dados["id_processador"] . "', '" . $dados["id_impressora"] . "', '"
                    . $dados["id_ecra"] . "');";

            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }

            // obtem o id do dispensador base criado
            $sql = "SELECT MAX(id_dispensador) FROM dispensador_base;";
            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }
            $id_dispensador_base = $this->bd->obterValor($rs, 0);

            $sql = "insert into servicos_dispensador (id_dispensador, id_servico, ordem, id_horario) values ";
            if (is_array($dados["servicos_prestados"]))
            {
                $aux = array();
                foreach ($dados["servicos_prestados"] as $sp)
                {
					$ordem = strlen($dados["ordem_servicos_".$sp]) ? $dados["ordem_servicos_".$sp]:"0";
					$id_horario = strlen($dados["horario_".$sp]) ? $dados["horario_".$sp] : "null";
					$aux[] = "($id_dispensador_base, $sp, $ordem, $id_horario)";
                }
                $sql .= implode($aux, ",");
            }
            else
            {
				$ordem = strlen($dados["ordem_servicos_" . $dados["servicos_prestados"]]) ? $dados["ordem_servicos_" . $dados["servicos_prestados"]] : "0";
				$id_horario = strlen($dados["horario_" . $dados["servicos_prestados"]]) ? $dados["horario_" . $dados["servicos_prestados"]] : "null";
				$sql .= "($id_dispensador_base, " . $dados["servicos_prestados"] . ", $ordem, $id_horario)";
            }
           
            if(!$rs = $this->bd->executarSQL($sql)) return 0;

            $path = "../XML/" . $dados["nome"] . ".xml";
            $this->escreveServicosXML($dados, $path);
        }

        // regista a criacao do dispensador
        $objecto = new LogAccao();
        $rs = $objecto->Inserir("Inserção", "Dispensador", $dados["nome"]);
        $objecto->fechar();
        return "ok";
    }


    /*
	 * Função que associa serviços a um determinado dispensador.
    */
    function associarServicos($servicos, $dispensador)
    {
        foreach($servicos as $servico)
        {
            $sql = "INSERT INTO servicos_dispensador VALUES ($dispensador, $servico);";
             
            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }
        }
        return 1;
    }

    /*
	 * Função que permite associar os tipos de ecrã, processador e impressora
	 * associados a um dispensador base.
    */
    function criarTipo($tipo, $dados)
    {
        $sql = "INSERT INTO " . $tipo . "_dispensador(modelo,fabricante,fornecedor)
						VALUES (" . implode(",", $dados) . ");";
        if(!$rs = $this->bd->executarSQL($sql))
        {
            return 0;
        }	else
        {
            return 1;
        }
    }

    /*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
    */
    function LerDados($id)
    {
        
        $aux = array();
        if (is_array($id))
        {
            $aux = $id;
        }
        else
        {
            array_push($aux, $id);
        }

        // dispensador do tipo de bico de pato

        if (array_key_exists("tipo", $_REQUEST) && $_REQUEST["tipo"] == 2)
        {
            $sql = "SELECT *
                    FROM dispensador d, dispensador_manual dm
                    WHERE d.id_dispensador = $id AND d.id_dispensador = dm.id_dispensador;";
            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }
            else
            {
                $_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);
                $_SESSION["sessao_campos"]["tipo_dispensador"] = "dispensador_manual";
                return "ok";
            }
        }

        $sql = "SELECT *
                    FROM dispensador d, dispensador_base db
                    WHERE d.id_dispensador in (" . implode(",", $aux) . ") AND d.id_dispensador = db.id_dispensador;";


        $res = $this->bd->getRows($sql);
        if (!count($res)) return 0;

        if (is_array($id))
        {
            $_SESSION["sessao_campos"]["tipo_dispensador"] = "dispensador_base";

            $_SESSION["sessao_campos"]["estado"] = $res[0]["estado"];
            $_SESSION["sessao_campos"]["status_impressora"] = $res[0]["status_impressora"];
            $_SESSION["sessao_campos"]["id_loja"] = $res[0]["id_loja"];
            $_SESSION["sessao_campos"]["piso"] = $res[0]["piso"];
            $_SESSION["sessao_campos"]["tipo_processador"] = $res[0]["tipo_processador"];
            $_SESSION["sessao_campos"]["tipo_impressora"] = $res[0]["tipo_impressora"];
            $_SESSION["sessao_campos"]["tipo_ecra"] = $res[0]["tipo_ecra"];
            $_SESSION["sessao_campos"]["msg_boasvindas"] = $res[0]["msg_boasvindas"];
            $_SESSION["sessao_campos"]["msg_impressaosenha"] = $res[0]["msg_impressaosenha"];

            // Query the dcm and leitor_cartoes tables to check if
            // the dispenser has dcm or leitor_cartoes and if it is active
            $this->setDcmAndLeitorCartoesInfo($res[0]["id_dispensador"]);

            $sql = "SELECT id_servico, id_horario, ordem FROM servicos_dispensador WHERE id_dispensador = " . $res[0]["id_dispensador"] . ";";
            $res2 = $this->bd->getRows($sql);
            
            $servicos_prestados = array();
            $ordem_servicos = array();
			$horarios = array();
            foreach ($res2 as $r)
            {
                
                array_push($servicos_prestados, $r["id_servico"]);
                array_push($ordem_servicos, $r["ordem"]);
				$horarios[] = $r["id_horario"];
            }
            $_SESSION["sessao_campos"]["servicos_dispensador"]["id"] = $servicos_prestados;
            $_SESSION["sessao_campos"]["servicos_dispensador"]["ordem"] = $ordem_servicos;
            $_SESSION["sessao_campos"]["servicos_dispensador"]["horario"] = $horarios;

            $_SESSION["sessao_campos"]["nome_dispensadores"] = array();

            foreach ($res as $r)
            {
                array_push($_SESSION["sessao_campos"]["nome_dispensadores"], $r["nome"]);

                $_SESSION["sessao_campos"]["estado"] = $_SESSION["sessao_campos"]["estado"]==$r["estado"]?$r["estado"]:"";
                $_SESSION["sessao_campos"]["status_impressora"] = $_SESSION["sessao_campos"]["status_impressora"]==$r["status_impressora"]?$r["status_impressora"]:"";
                $_SESSION["sessao_campos"]["id_loja"] = $_SESSION["sessao_campos"]["id_loja"]==$r["id_loja"]?$r["id_loja"]:"";
                $_SESSION["sessao_campos"]["piso"] = $_SESSION["sessao_campos"]["piso"]==$r["piso"]?$r["piso"]:"";
                $_SESSION["sessao_campos"]["tipo_processador"] = $_SESSION["sessao_campos"]["tipo_processador"]==$r["tipo_processador"]?$r["tipo_processador"]:"";
                $_SESSION["sessao_campos"]["tipo_impressora"] = $_SESSION["sessao_campos"]["tipo_impressora"]==$r["tipo_impressora"]?$r["tipo_impressora"]:"";
                $_SESSION["sessao_campos"]["tipo_ecra"] = $_SESSION["sessao_campos"]["tipo_ecra"]==$r["tipo_ecra"]?$r["tipo_ecra"]:"";
                $_SESSION["sessao_campos"]["msg_boasvindas"] = $_SESSION["sessao_campos"]["msg_boasvindas"]==$r["msg_boasvindas"]?$r["msg_boasvindas"]:"";
                $_SESSION["sessao_campos"]["msg_impressaosenha"] = $_SESSION["sessao_campos"]["msg_impressaosenha"]==$r["msg_impressaosenha"]?$r["msg_impressaosenha"]:"";

                $sql = "SELECT id_servico, ordem FROM servicos_dispensador WHERE id_dispensador = " . $r["id_dispensador"] . ";";
                $res2 = $this->bd->getRows($sql);
                $servicos_prestados = array();
                $ordem_servicos = array();
				$horarios = array();
                foreach ($res2 as $r)
                {                     
                    array_push($servicos_prestados, $r["id_servico"]);
                    array_push($ordem_servicos, $r["ordem"]);
					$horarios[] = @$r["id_horario"];
                }
                $_SESSION["sessao_campos"]["servicos_dispensador"]["id"] = $_SESSION["sessao_campos"]["servicos_dispensador"]["id"]==$servicos_prestados?$servicos_prestados:array();
                $_SESSION["sessao_campos"]["servicos_dispensador"]["ordem"] = $_SESSION["sessao_campos"]["servicos_dispensador"]["ordem"]==$ordem_servicos?$ordem_servicos:array();
                $_SESSION["sessao_campos"]["servicos_dispensador"]["horario"] = $_SESSION["sessao_campos"]["servicos_dispensador"]["horario"]==$horarios?$horarios:array();

                debug($_SESSION["sessao_campos"]);
            }
        }
        else
        {
            
            $_SESSION["sessao_campos"] = $res[0];
            $_SESSION["sessao_campos"]["tipo_dispensador"] = "dispensador_base";

            $id_dispensador_base = $_SESSION["sessao_campos"]["id_dispensador_base"];
            $id_loja = $_SESSION["sessao_campos"]["id_loja"];

            // Query the dcm and leitor_cartoes tables to check if
            // the dispenser has dcm or leitor_cartoes and if it is active
            $this->setDcmAndLeitorCartoesInfo($res[0]["id_dispensador"]);

            // obtem os servicos associados ao dispensador

            $sql = "SELECT id_servico, ordem, id_horario FROM servicos_dispensador WHERE id_dispensador = " . $id . ";";
            
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            $servicos_prestados = array();
            $ordem_servicos = array();
            $horarios = array();
           // $i = 0;
            $res2 = $this->bd->getRows($sql);
            foreach ($res2 as $r)
            { 
                array_push($servicos_prestados, $r["id_servico"]);
                array_push($ordem_servicos, $r["ordem"]);
                $horarios[] = @$r["id_horario"];
                //echo 'dis';
                //echo $r["id_servico"];
               // $servicos_prestados[$i] = $r["id_servico"];
               // $ordem_servicos[$i] = $r["ordem"];
               // $horarios[] = $r["id_horario"];

                //++$i;
            }

           // $num_registos = $this->bd->obterNumRegistos($rs);
           // var_dump($num_registos);
           // echo 'num_registos : '.$num_registos;
            
           // for ($i = 0; $i < $num_registos ; $i++)
           // {
                //$this->bd->moverRegisto($rs, $i);
                //echo 'id_servico ' . $this->bd->obterValor($rs, "id_servico");
               // $servicos_prestados[$i] = $this->bd->obterValors($rs, "id_servico");
               // $ordem_servicos[$i] = $this->bd->obterValor($rs, "ordem");
			 //	$horarios[] = $this->bd->obterValor($rs, "id_horario");
            //}
               // echo var_dumps($servicos_prestadodfs) . '$servicos_prestados';
            $_SESSION["sessao_campos"]["servicos_dispensador"]["id"] = $servicos_prestados;
            $_SESSION["sessao_campos"]["servicos_dispensador"]["ordem"] = $ordem_servicos;
            $_SESSION["sessao_campos"]["servicos_dispensador"]["horario"] = $horarios;

			if($_SESSION["sessao_campos"]["dcm"] == 1)
			{
				$sql = "SELECT nome FROM entidades WHERE id_entidade IN (SELECT id_entidade FROM lojas_entidades WHERE id_loja=".$_SESSION["sessao_campos"]["id_loja"].")";
				$res = $this->bd->getRows($sql);
				$_SESSION["sessao_campos"]["nome_entidade"] = $res[0]["nome"];
				$sql = "SELECT * FROM dcm WHERE id_dispensador=$id";
				$res = $this->bd->getRows($sql);
				$_SESSION["sessao_campos"]["dcm_status"] = $res[0];
			}
        }
        return "ok";
    }

    /*
		Fun��o de edi��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Editar($dados, $id)
    {
		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array("nome"=>"Nome","identificador" => "Identificador", "estado"=>"Estado");

        if (is_array($id))
        {
            $sql = "UPDATE dispensador SET ";

            $aux = array();

            if (isset($dados["change_estado"]))
            {
                array_push($aux, "estado=".$dados["estado"]);
            }
            if (isset($dados["change_status_impressora"]))
            {
                array_push($aux, "status_impressora=".$dados["status_impressora"]);
            }
            if (isset($dados["change_local"]))
            {
                array_push($aux, "id_loja=".$dados["id_loja"]);
            }
            if (isset($dados["change_piso"]))
            {
                array_push($aux, "piso=".$dados["piso"]);
            }

            $sql .= implode(", ", $aux)." where id_dispensador in (".implode(", ", $id).")";

            if (count($aux)) $this->bd->executarSQL($sql);

            if ($dados["tipo_dispensador"] == "dispensador_base")
            {
                $sql = "UPDATE dispensador_base SET ";

                $aux = array();

                if (isset($dados["change_tipo_processador"]))
                {
                    array_push($aux, "tipo_processador=".$dados["id_processador"]);
                }
                if (isset($dados["change_tipo_impressora"]))
                {
                    array_push($aux, "tipo_impressora=".$dados["id_impressora"]);
                }
                if (isset($dados["change_tipo_ecra"]))
                {
                    array_push($aux, "tipo_ecra=".$dados["id_ecra"]);
                }
                if (isset($dados["change_msg_boas_vindas"]))
                {
                    array_push($aux, "msg_boasvindas='".$dados["boasvindas"]."'");
                }
                if (isset($dados["change_msg_impressao_senha"]))
                {
                    array_push($aux, "msg_impressaosenha='".$dados["impressaosenha"]."'");
                }

                $sql .= implode(", ", $aux)." where id_dispensador in (".implode(", ", $id).")";

                if (count($aux)) $this->bd->executarSQL($sql);


                // Handle the DCM and Leitor de Cartões changes which are in other tables
                // For some dispensers we might need to update and for others
                // insert the leitor cartoes info, thus we must handle each dispenser independently
                foreach ($id as $idd) {

                    if ($dados["leitor_cartoes"]==1) {
                        $stateAutoCheckin = $dados["stateAutoCheckinModule"];
                        $sql = "SELECT COUNT(id) AS rows FROM leitor_cartoes WHERE id_dispensador = $idd;";
                        $rs = $this->bd->getRows($sql);
                        if ($rs && count($rs) > 0 && $rs[0]['rows'] > 0) {
                            // There was already a leitor_cartao, update it
                            $sql = "UPDATE leitor_cartoes SET enabled = $stateAutoCheckin, ip = '$ip' WHERE id_dispensador = $idd";
                        } else {
                            $ip = $this->getDispensadorIp($idd, true);
                            $sql = "INSERT INTO leitor_cartoes(ip, id_dispensador, enabled) VALUES('$ip', $idd, $stateAutoCheckin)";
                        }
                        $this->bd->executarSQL($sql);
                    } else {
                        $sql = "delete from leitor_cartoes where id_dispensador = $idd";
                        $this->bd->executarSQL($sql);
                    }

                    if ($dados["dcm"]==1) {
                        $statePayment = $dados["statePaymentModule"];
                        $sql = "SELECT COUNT(id) AS rows FROM dcm WHERE id_dispensador = $idd;";
                        $rs = $this->bd->getRows($sql);
                        if ($rs && count($rs) > 0 && $rs[0]['rows'] > 0) {
                            // There was already a dcm, update it
                            $sql = "UPDATE dcm SET enabled = $statePayment, ip = '$ip' WHERE id_dispensador = $idd";
                        } else {
                            if ($ip == null) {
                                $ip = $this->getDispensadorIp($idd, true);
                            }
                            $sql = "INSERT INTO dcm(ip, id_dispensador, enabled) VALUES('$ip', $idd, $statePayment)";
                        }
                        $this->bd->executarSQL($sql);
                    } else {
                        $sql = "delete from dcm where id_dispensador = $idd";
                        $this->bd->executarSQL($sql);
                    }

                    $ip = null;
                }
            }

            

            if (isset($dados["change_servicos"]))
            {
                if ($dados["tipo_dispensador"] == "dispensador_base")
                {
                    $sql = "DELETE FROM servicos_dispensador WHERE id_dispensador in (".implode(", ", $id).")";
                    if(!$rs = $this->bd->executarSQL($sql)) return 0;

                    $sql = "insert into servicos_dispensador (id_dispensador, id_servico, ordem, id_horario) values ";

                    $aux = array();
                    foreach ($id as $idAux)
                    {
                        if (is_array($dados["servicos_prestados"]))
                        {
                            foreach ($dados["servicos_prestados"] as $sp)
                            {
								$ordem = strlen($dados["ordem_servicos_".$sp]) ? $dados["ordem_servicos_".$sp]:"0";
								$id_horario = strlen($dados["horario_".$sp]) ? $dados["horario_".$sp] : "null";
                                $aux[] = "($idAux, $sp, $ordem, $id_horario)";
                            }
                        }
                        else
                        {
							$ordem = strlen($dados["ordem_servicos_".$dados["servicos_prestados"]]) ? $dados["ordem_servicos_".$dados["servicos_prestados"]] : "0";
							$id_horario = strlen($dados["horario_".$dados["servicos_prestados"]]) ? $dados["horario_".$dados["servicos_prestados"]] : "null";
                            $sql .= "($idAux, " . $dados["servicos_prestados"] . ", $ordem, $id_horario)";
                        }
                    }

                    $sql .= implode($aux, ",");
                    
                    if(!$rs = $this->bd->executarSQL($sql)) return 0;
                }

                return "ok";
            }
        }
        else
        {

            if ($id == null)
                return 0;

            // actualiza a tabela com os dados comuns a todos os tipos
            // de dispensadores
            $sql = "UPDATE dispensador SET ";
            $sql.= "nome = '" . $dados["nome"]."', ";
            $sql.= "estado = " . $dados["estado"] . ", ";
            $sql.= "status_impressora = " . $dados["status_impressora"] . ", ";
            $sql.= "id_loja = " . $dados["id_loja"] . ", ";
            $sql.= "piso = " . $dados["piso"] . " ";
            $sql.= "WHERE id_dispensador = " . $id . ";";

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            if ($dados["tipo_dispensador"] == "dispensador_manual")
            {
                $sql = "UPDATE dispensador_manual SET id_servico = " . $dados["id_servico"]
                        . " WHERE id_dispensador = $id;";
                if(!$rs = $this->bd->executarSQL($sql))
                    return 0;

            } else if ($dados["tipo_dispensador"] == "dispensador_base")
            {

                // actualiza os tipos e o identificador
                $sql = "UPDATE dispensador_base
                    SET identificador = '" . $dados["identificador"] . "',
                        msg_boasvindas = '" . $dados["boasvindas"] . "',
                        msg_impressaosenha = '" . $dados["impressaosenha"] . "',
                        tipo_processador =  " . $dados["id_processador"] . ",
                        tipo_ecra =  " . $dados["id_ecra"] . ",
                        tipo_impressora =  " . $dados["id_impressora"] . "
                    WHERE id_dispensador = $id;";

                if(!$rs = $this->bd->executarSQL($sql))
                    return 0;

                // Handle the update of the leitores de cartoes and DCM
                $ip = explode(':', $dados["identificador"]);
                $ip = $ip[0];

                if ($dados["leitor_cartoes"]==1) {
                    $stateAutoCheckin = $dados["stateAutoCheckinModule"];
                    $sql = "SELECT COUNT(id) AS rows FROM leitor_cartoes WHERE id_dispensador = $id;";
                    $rs = $this->bd->getRows($sql);
                    if ($rs && count($rs) > 0 && $rs[0]['rows'] > 0) {
                        // There was already a leitor_cartao, update it
                        $sql = "UPDATE leitor_cartoes SET enabled = $stateAutoCheckin, ip = '$ip' WHERE id_dispensador = $id";
                    }
                    else {
                        $sql = "INSERT INTO leitor_cartoes(ip, id_dispensador, enabled) VALUES('$ip', $id, $stateAutoCheckin)";
                    }
                    $this->bd->executarSQL($sql);
                }
                else {
                    $sql = "delete from leitor_cartoes where id_dispensador = $id";
                    $this->bd->executarSQL($sql);
                }

                if ($dados["dcm"]==1) {
                    $statePayment = $dados["statePaymentModule"];
                    $sql = "SELECT COUNT(id) AS rows FROM dcm WHERE id_dispensador = $id;";
                    $rs = $this->bd->getRows($sql);
                    if ($rs && count($rs) > 0 && $rs[0]['rows'] > 0) {
                        // There was already a dcm, update it
                        $sql = "UPDATE dcm SET enabled = $statePayment, ip = '$ip' WHERE id_dispensador = $id";
                    }
                    else {
                        $sql = "INSERT INTO dcm(ip, id_dispensador, enabled) VALUES('$ip', $id, $statePayment)";
                    }
                    $this->bd->executarSQL($sql);
                }
                else {
                    $sql = "delete from dcm where id_dispensador = $id";
                    $this->bd->executarSQL($sql);
                }

                $sql = "DELETE FROM servicos_dispensador WHERE id_dispensador = $id";
                if(!$rs = $this->bd->executarSQL($sql)) return 0;

				$sql = "insert into servicos_dispensador (id_dispensador, id_servico, ordem, id_horario) values ";
                if (is_array($dados["servicos_prestados"]))
                {
                    $aux = array();
                    foreach ($dados["servicos_prestados"] as $sp)
                    {
						$ordem = strlen($dados["ordem_servicos_".$sp]) ? $dados["ordem_servicos_".$sp] : "0";
						$id_horario = strlen($dados["horario_".$sp]) ? $dados["horario_".$sp] : "null";
						$aux[] = "($id, $sp, $ordem, $id_horario)";
                    }
                    $sql .= implode($aux, ",");
                }
                else
                {
					$ordem = strlen($dados["ordem_servicos_".$dados["servicos_prestados"]]) ? $dados["ordem_servicos_".$dados["servicos_prestados"]] : "0";
					$id_horario = strlen($dados["horario_".$dados["servicos_prestados"]]) ? $dados["horario_".$dados["servicos_prestados"]] : "null";
                    $sql .= "($id, ".$dados["servicos_prestados"].", $ordem, $id_horario)";
                }
                    
                if(!$rs = $this->bd->executarSQL($sql)) return 0;


                // actualiza o XML do dispensador
                //			if (count($servicos_obsoletos) || count($novos_servicos)) {
                $path = "../XML/" . $dados["nome"] . ".xml";
                $this->escreveServicosXML($dados, $path);
                //			}
            }
            // notifica o servidor central da modificação
            $this->notificarServidorCentral($dados["identificador"]);
            // finalmente, regista a modificação no log de accoes
            $objecto = new LogAccao();

			$newInfo['tipo_impressora'] = $dados['id_impressora'];
			$diff = my_array_diff_values($oldInfo,$newInfo,$labels);

			// Faz o mesmo para a tabela de servicos
			$servicosOld = $oldInfo['servicos_dispensador'];
			$servicosNew = $aux;
			$diffServicos = my_array_diff_values2($servicosOld,$servicosNew);

			$msg = "<table><tr><td colspan=3 align=left><b>$newInfo[nome]</b></td></tr>";
			$msg .= action_msg_info($diff,false,'dispensador');
			$msg .= action_msg_info($diffServicos,false,'dispensador');
			$msg .= "</table>";

            $rs = $objecto->Inserir("Edição", "Dispensador", $msg);
            $objecto->fechar();
            return "ok";
        }
    }

    function notificarServidorCentral($identificador)
    {
        global $NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL;
        list($ip_dispensador, $porto_dispensador) = explode(":", $identificador);
        // inicia a ligacao ao servidor central, com um timeout de 30 segundos
        $socketfp = @fsockopen($NOME_SERVIDOR_CENTRAL, $PORTO_SERVIDOR_CENTRAL, $errno, $errstr, 30);
        if (!$socketfp)
        {
            // TODO: retornar erro para o bof, e possivelmente colocar a info do servidor central
            // no campo identificador de um local.
            //echo  translate('word_erro_com_servidor_central', true)  .": $errno - $errstr<br />\n";
            return;
        }
        fputs($socketfp, "ACTZDISP $ip_dispensador $porto_dispensador\n");
        fclose($socketfp);
    }

    /*
		Fun��o de remo��o

		0 = Erro da BD
		true = Sucesso
    */
    function Remover($id)
    {

        $numEntradas = count($id);
        $nomes = array();
        $dispensadores_manuais = array();
        $dispensadores_base = array();

        $sql = "SELECT distinct d.id_dispensador, d.nome, nome_tabela
					  FROM dispensador d, tipos_dispensador td
						WHERE d.tipo_dispensador = td.id_tipos_dispensador AND (";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "d.id_dispensador = " . $id[$i] . " OR ";
        $sql .= "d.id_dispensador = " . $id[0] . ");";

        //debugSQL($sql);

        if($rs = $this->bd->executarSQL($sql))
        {
            for($i = 0; $i < $numEntradas; $i++)
            {
                $this->bd->moverRegisto($rs,$i);
                if ($this->bd->obterValor($rs, "nome_tabela") == "dispensador_manual")
                {
                    array_push($dispensadores_manuais, $this->bd->obterValor($rs,"id_dispensador"));
                } else
                {
                    array_push($dispensadores_base, $this->bd->obterValor($rs,"id_dispensador"));
                }
                array_push($nomes, $this->bd->obterValor($rs,"nome"));
            }
        } else
        {
            return 0;
        }

        // apaga da tabela geral de dispensadores
        $dispensadores = array_merge($dispensadores_manuais, $dispensadores_base);
        $sql = "DELETE FROM dispensador WHERE id_dispensador IN (" . implode(",", $dispensadores) . ");";
        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

		$sql = "delete from dcm WHERE id_dispensador IN (" . implode(",", $dispensadores) . ");";
		$this->bd->executarSQL($sql);
		$sql = "delete from leitor_cartoes WHERE id_dispensador IN (" . implode(",", $dispensadores) . ");";
		$this->bd->executarSQL($sql);

        if (count($dispensadores_manuais))
        {
            $sql =  "DELETE FROM dispensador_manual WHERE id_dispensador IN (" . implode(",", $dispensadores_manuais) . ");";
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
        }

        if (count($dispensadores_base))
        {
            // obtem os id's dos dispensadores base para apagar os servicos associados a estes
            $dispensadores_sql = implode(",", $dispensadores_base);
            $sql = "SELECT id_dispensador_base FROM dispensador_base WHERE id_dispensador IN (" . $dispensadores_sql . ");";
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
            $id_dispensadores_base = array();
            $id_dispensadores_base = $this->bd->obterRegisto($rs);

            // elimina os registos dos dispensadores base
            $sql =  "DELETE FROM dispensador_base WHERE id_dispensador IN (" . $dispensadores_sql . ");";
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            // apaga os servicos associados ao dispensador base
            $sql = "DELETE FROM servicos_dispensador WHERE id_dispensador IN (" . implode(",", $id) . ");";
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

        }

        // regista a remoção na base de dados

        $objecto = new LogAccao();
        for($i = count($nomes)-1; $i >= 0; $i--)
        {
            $rs = $objecto->Inserir("Remoção", "Balcão", $nomes[$i]);
        }
        $objecto->fechar();
        return "ok";
    }


    /*
	* Escreve num XML os servi�ços e mensagens associados
	* ao dispensador.
    */
    function escreveServicosXML($dados, $path)
    {

        $document = new DOMDocument("1.0", "UTF-8");
        $document->formatOutput = true;
        $root = $document->createElement("layout");
        $document->appendChild($root);

        $mensagens = $document->createElement("mensagens");
        $root->appendChild($mensagens);

        $mensagens->appendChild($document->createElement("boas_vindas", $dados["boasvindas"]));
        $mensagens->appendChild($document->createElement("impressao_senha", $dados["impressaosenha"]));

        $servicos = $document->createElement("servicos");
        $root->appendChild($servicos);

	if (is_array($dados["servicos_prestados"])) {
	    foreach($dados["servicos_prestados"] as $servico)
	    {
		$servicos->appendChild($document->createElement("servico", $servico));
	    }
	}
	else {
	    $servicos->appendChild($document->createElement("servico", $dados["servicos_prestados"]));
	}

        $document->save($path);
    }

    /*
		Procede � cria��o e escrita de um
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao, $documento, $tabela = null)
    {

        if(!is_array($id))
            $id = array($id);

        $numEntradas = count($id);

        $sql = "SELECT * FROM dispensador WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_dispensador = " . $id[$i] . " OR ";
        $sql .= "id_dispensador = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $raiz = $documento->firstChild;

        $loja = new Loja();
        $enderecos = array();

        $destinos = $documento->createElement("destinos");
        $raiz->appendChild($destinos);

        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0 ; $i < $numEntradas ; $i++)
        {
            $this->bd->moverRegisto($rs, $i);

            $enderecos = array_merge($enderecos, $loja->listaIpLojas($this->bd->obterValor($rs, "id_loja")));

            $no_dispensador = $documento->createElement("dispensador");
            $raiz->appendChild($no_dispensador);

            $no_dispensador->setAttribute("id", $this->bd->obterValor($rs, "id_dispensador"));
            $no_dispensador->setAttribute("accao", $accao);

            $elemento = $documento->createElement("idTipoDispensador");
            $elemento->nodeValue = $this->bd->obterValor($rs, "tipo_dispensador");
            $no_dispensador->appendChild($elemento);

            $elemento = $documento->createElement("idEstadoDispensador");
            $elemento->nodeValue = $this->bd->obterValor($rs, "estado");
            $no_dispensador->appendChild($elemento);

	    $elemento = $documento->createElement("statusImpressora");
            $elemento->nodeValue = $this->bd->obterValor($rs, "status_impressora");
            $no_dispensador->appendChild($elemento);

            $elemento = $documento->createElement("identificadorDispensador");
            $elemento->nodeValue = $this->bd->obterValor($rs, "identificador");
            $no_dispensador->appendChild($elemento);

            $elemento = $documento->createElement("idLoja");
            $elemento->nodeValue = $this->bd->obterValor($rs, "id_loja");
            $no_dispensador->appendChild($elemento);

            $valor = $this->bd->obterValor($rs, "impressora");
            if(isset($valor))
            {
                $elemento = $documento->createElement("idImpressora");
                $elemento->nodeValue = $valor;
                $no_dispensador->appendChild($elemento);
            }
        }

        $enderecos = array_unique($enderecos);

        for($i = 0 ; $i < count($enderecos) ; $i++)
        {

            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);

        }

        if(!is_null($tabela))
        {

            $sql = "SELECT * FROM ".$tabela." WHERE ";
            for($i = $numEntradas-1; $i > 0; $i--)
                $sql .= "id_dispensador = " . $id[$i] . " OR ";
            $sql .= "id_dispensador = " . $id[0] . ";";

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            $sql = "SHOW FULL COLUMNS FROM ". $tabela .";";

            if(!$rs_aux = $this->bd->executarSQL($sql))
                return 0;

            $numCampos = $this->bd->obterNumRegistos($rs_aux);

            for($i = 0 ; $i < $numEntradas ; $i++)
            {
                $this->bd->moverRegisto($rs, $i);

                $no_tipo = $documento->createElement("entradaTipo");
                $raiz->appendChild($no_tipo);

                $no_tipo->setAttribute("nomeTabela", $tabela);
                $no_tipo->setAttribute("accao", $accao);

                for($j = 0 ; $j < $numCampos ; $j++)
                {
                    $this->bd->moverRegisto($rs_aux, $j);
                    $campo = $this->bd->obterValor($rs_aux,"Field");
                    $valor = $this->bd->obterValor($rs, $campo);

                    if( $campo == "id_".$tabela)
                    {
                        $no_tipo->setAttribute("id", $valor);
                    }
                    else if (isset($valor))
                    {
                        $elemento = $documento->createElement("campoTipo");
                        $elemento->nodeValue = $valor;
                        $elemento->setAttribute("nomeCampo", $campo);
                        $no_tipo->appendChild($elemento);
                    }
                }

            }
        }

    }

    /*
		Fun��o de listagem

		0 = Erro da BD
		true = Sucesso
    */

    function Listar()
    {
         $sql = "SELECT d.id_dispensador, d.nome as nome_dispensador, d.estado, d.status_impressora, d.tipo_dispensador, td.nome tipo, l.nome loja, d.piso piso, dcm.id modulo_pagamentos ";
         $sql.= "FROM dispensador d ";
         $sql.= "JOIN tipos_dispensador td ON d.tipo_dispensador = td.id_tipos_dispensador ";
         $sql.= "JOIN lojas l ON l.id_loja = d.id_loja ";
         $sql.= "LEFT JOIN dcm ON dcm.id_dispensador = d.id_dispensador where true ";

        if(getRequestValue("loja") != "")    // estado
            $sql .= "and d.id_loja = " . $_REQUEST["loja"] . " ";
        if(getRequestValue("estados_dispensador") != "")  // estado
            $sql .= "and d.estado = " . $_REQUEST["estados_dispensador"] . " ";

        if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= "ORDER BY " . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY d.nome ";

        if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";

        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $dispensadores = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dispensadores, $row);

        $n = 1;
        $pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];
        $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
        $numPaginas = 1; // n�mero de p�ginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

        // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
        if(array_key_exists("pagina", $_REQUEST) && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
            $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', false) ." ".  translate('dispensadores', false)." " .translate('word_registados_sistema', false) ."</div>";
            return;
        }

        // calculo do n�mero de p�ginas de registos
        if($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=dispensadores&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "")  . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "") . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";
            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
            <tr>
                <td class='button_page' colspan='6'>";

                if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
                {
                    $pagAnterior = $_REQUEST["pagina"] - 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                }
                else
                {
                    $_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
                    $TEMPLATE_navigation .= "<div> < </div>";
                }

                while($n <= $numPaginas)
                {
                    if($n == $_REQUEST["pagina"])
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='current_page'>$n</div></a>";
                    else
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
                    $n++;
                }

                $n = ($pagina - 1)*$numRegPag;
                $incremento = $n;

                if($pagina < $numPaginas)
                {
                    $pagPosterior = $_REQUEST["pagina"] + 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
                }
                else
                {
                    if($numTuplos % $numRegPag != 0)
                        $numRegPag = $numTuplos % $numRegPag;
                    $TEMPLATE_navigation .= "<div> > </div>";
                }

        $TEMPLATE_navigation .= "		</td>
        </tr>";

        echo "<tr class='column_row'>";

        if ($_SESSION["sessao_perms"]["all_perm"] == 1)
        {
            echo "<td width='18' style='padding-left:8px' >" .  translate('word_select') . "</td>";
        }

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome_dispensador") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=nome_dispensador&ordem=0'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=nome_dispensador&ordem=1'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=nome_dispensador&ordem=0'><div>". translate('word_name', true)."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"estado") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=estado&ordem=0'><div>". translate('word_state', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=estado&ordem=1'><div>". translate('word_state', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=estado&ordem=0'><div>". translate('word_state', true)."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) &&  strcmp($_REQUEST["campo"],"status_impressora") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=status_printer&ordem=0'><div>". translate('word_state_printer', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=status_printer&ordem=1'><div>". translate('word_state_printer', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=status_printer&ordem=0'><div>". translate('word_state_printer', true)."</div></a></td>";


        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"tipo") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=tipo&ordem=0'><div>". translate('word_tipo_dispensador', true) ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=tipo&ordem=1'><div>". translate('word_tipo_dispensador', true) ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=tipo&ordem=0'><div>". translate('word_tipo_dispensador', true) ."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"loja") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=loja&ordem=0'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=loja&ordem=1'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=loja&ordem=0'><div>" .translate('word_local', true). "</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"piso") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=piso&ordem=0'><div>". translate('word_floor', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=piso&ordem=1'><div>". translate('word_floor', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?tipomod=dispensador&pagina=1&campo=piso&ordem=0'><div>". translate('word_floor', true)."</div></a></td>";

        echo "<td width='155'>". translate('word_operations', true)."</td>
				</tr>";



        //while($n < ($numRegPag + $incremento))
        //{
        //    $this->bd->moverRegisto($rs,$n);
        for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {

            echo"<tr class='form-data-tr'>";
            if ($_SESSION["sessao_perms"]["all_perm"] == 1)
            {
              echo "<td class='form-data-td'>
                      <label class='custom-check-container'>
                          <input name='grupo' type='checkbox' value='" . $dispensadores[$i]["id_dispensador"] /*$this->bd->obterValor($rs,"id_dispensador")*/ . "' onClick='selectEntireRow(this)'>
                          <span class='custom-checkmark'></span>
                      </label>
                  </td>";
            }
            echo   "<td class='form-data-td'>" . $dispensadores[$i]["nome_dispensador"] /*$this->bd->obterValor($rs,"nome_dispensador")*/ . "</td>
					<td class='form-data-td'>" . ($dispensadores[$i]["estado"] /*$this->bd->obterValor($rs, "estado")*/ ==1 ? translate('word_operational'):translate('word_notoperational')) . "</td>
                    <td class='form-data-td'>" . obterNomeGeral($dispensadores[$i]["status_impressora"] /*$this->bd->obterValor($rs,"status_impressora")*/,"id_estado_dispensador", "nome", "estados_dispensador") . "</td>
					<td class='form-data-td'>" . $dispensadores[$i]["tipo"] /*$this->bd->obterValor($rs,"tipo")*/ . "</td>
					<td class='form-data-td'>" . $dispensadores[$i]["loja"] /*$this->bd->obterValor($rs,"loja")*/ . "</td>
                    <td class='form-data-td'>" . $dispensadores[$i]["piso"] /*$this->bd->obterValor($rs,"piso")*/ . "</td>
					<td class='form-data-td'>";

            if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_dispensador"] == 2 )
            {

                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=dispensadores&id="
                        . $dispensadores[$i]["id_dispensador"] /*$this->bd->obterValor($rs,"id_dispensador")*/ .  "&tipo=" . $dispensadores[$i]["tipo_dispensador"] /*$this->bd->obterValor($rs, "tipo_dispensador") */
                        . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>";

                if ($_SESSION["sessao_perms"]["all_perm"] == 1)
                {
                    echo "<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=dispensadores&pagina=" . (array_key_exists("pagina",$_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo",$_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem",$_REQUEST) ? $_REQUEST["ordem"] : "") ."&id=" . $dispensadores[$i]["id_dispensador"] /*$this->bd->obterValor($rs,"id_dispensador")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";

					// Fecho de caixa
					if($dispensadores[$i]["modulo_pagamentos"] /*$this->bd->obterValor($rs,"modulo_pagamentos")*/ >0)
					{
						echo "<a class='function' href='../accoes_intermedias/accaoDiversa.php?accao=gestao_moedeiro&pagina=" . (array_key_exists("pagina",$_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo",$_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem",$_REQUEST) ? $_REQUEST["ordem"] : "") ."&id=" . $dispensadores[$i]["id_dispensador"] /*$this->bd->obterValor($rs,"id_dispensador")*/ . "'><img alt='Status' src='../img/buttons/button_programation.gif'><div>". translate('word_gestao_moedeiro', true)."</div></a>";
					}
                }
            }
            else
            {

                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=dispensadores&id=" . $dispensadores[$i]["id_dispensador"] /*$this->bd->obterValor($rs,"id_dispensador")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
            }
            echo	"</td>
				</tr>";

            //$n++;
        }

        //#3 - Re-design present NAVIGATION after table
        echo $TEMPLATE_navigation;

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        if ($_SESSION["sessao_perms"]["all_perm"] == 1)
        {
            echo	'<tr>
            					<td class="button">';
                      if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_entidade"] == 2) {
                        echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
                      }
      						echo '<div class="button-thin-green" onClick="seleccionaCaixa(true)">'. translate('word_mark_all', true).'</div>
            						<div class="button-thin-green" onClick="seleccionaCaixa(false)">'. translate('word_unmark_all', true).'</div>
            						<div class="button-thin-green" onClick="removerMarcados(this)">'. translate('word_remove_selected', true).'</div>
            						<div class="button-thin-green" onClick="editarMarcados(\'dispensadores\')">'. translate('word_edit_selected', true).'</div>
            					</td>
                  </tr>';
        }

        echo	"</table>
		</form>";
    }

    function GetDispensadores($where="")
    {
        $sql = "select d.id_loja, l.nome local, d.id_dispensador, d.tipo_dispensador tipo, d.nome dispensador, if(isnull(d.data_hora) || timestampdiff(minute, d.data_hora, now())>=1,2,1) as status_id, ed.nome estado, d.data_hora as desde, d.piso piso
				from dispensador d
				inner join lojas l on l.id_loja=d.id_loja
				inner join estados_dispensador ed on ed.id_estado_dispensador=d.estado";
        if (strlen($where)) $sql .= " where ".$where;
        $res = $this->bd->executarSQL($sql);

        $dispensadores = array();
        while ($row = $this->bd->obterRegisto($res))
        {
            $row["estado"] = obterEstadoGeral($row["estado"]);
            array_push($dispensadores, $row);
        }
        return $dispensadores;
    }

    function GetDispensadoresDcm($where="")
    {
        $sql = "select d.id_loja, l.nome local, d.id_dispensador, d.tipo_dispensador tipo, d.nome dispensador, if(isnull(d.data_hora) || timestampdiff(minute, d.data_hora, now())>=1,2,1) as status_id, ed.nome estado, d.data_hora as desde, d.piso piso
				from dispensador d
				inner join lojas l on l.id_loja=d.id_loja
				inner join estados_dispensador ed on ed.id_estado_dispensador=d.estado
				join dcm ON dcm.id_dispensador = d.id_dispensador";
        if (strlen($where)) $sql .= " where ".$where;
        $res = $this->bd->executarSQL($sql);

        $dispensadores = array();
        while ($row = $this->bd->obterRegisto($res))
        {
            array_push($dispensadores, $row);
        }
        return $dispensadores;
    }
/*
         $sql = "SELECT d.id_dispensador, d.nome as nome_dispensador, d.estado, d.status_impressora, d.tipo_dispensador, td.nome tipo, l.nome loja, d.piso piso, dcm.id modulo_pagamentos ";
         $sql.= "FROM dispensador d ";
         $sql.= "JOIN tipos_dispensador td ON d.tipo_dispensador = td.id_tipos_dispensador ";
         $sql.= "JOIN lojas l ON l.id_loja = d.id_loja ";
         $sql.= "LEFT JOIN dcm ON dcm.id_dispensador = d.id_dispensador ";
*/

    function GetDispensadoresBase()
    {
        $sql = "select * from dispensador_base";
        $res = $this->bd->executarSQL($sql);

        $dispensadores = array();
        while ($row = $this->bd->obterRegisto($res))
        {
            array_push($dispensadores, $row);
        }
        return $dispensadores;
    }

    private function setDcmAndLeitorCartoesInfo($idDispensador) {
        // Query the dcm and leitor_cartoes tables to check if
        // the dispenser has dcm or leitor_cartoes and if it is active
        $sqlDcm = "SELECT * FROM dcm WHERE id_dispensador = $idDispensador;";
        $sqlLeitorCartoes = "SELECT * FROM leitor_cartoes WHERE id_dispensador = $idDispensador;";
        $resDcm = $this->bd->getRows($sqlDcm);
        $resLeitorCartose = $this->bd->getRows($sqlLeitorCartoes);
        $_SESSION["sessao_campos"]["dcm"] = 0;
        $_SESSION["sessao_campos"]["dcm_operacional"] = 0;
        $_SESSION["sessao_campos"]["leitor_cartoes"] = 0;
        $_SESSION["sessao_campos"]["leitor_cartoes_operacional"] = 0;
        if (count($resDcm) > 0) {
            $_SESSION["sessao_campos"]["dcm"] = 1;
            $_SESSION["sessao_campos"]["dcm_operacional"] = $resDcm[0]["enabled"];
        }
        if (count($resLeitorCartose) > 0) {
            $_SESSION["sessao_campos"]["leitor_cartoes"] = 1;
            $_SESSION["sessao_campos"]["leitor_cartoes_operacional"] = $resLeitorCartose[0]["enabled"];
        }
    }

    private function getDispensadorIp($dispensadorId, $justIp = false) {
        $sql = "SELECT identificador FROM dispensador_base WHERE id_dispensador = $dispensadorId;";
        $res = $this->bd->getRows($sql);
        if (count($res) > 0) {
            if ($justIp == false) {
               return $res[0]["identificador"];
            }
            list($ip_dispensador, $porto_dispensador) = split(":", $res[0]["identificador"]);
            return $ip_dispensador;
        }
        return null;
    }

    /*
		Destrutor da classe

		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }

//	function AssociarFlash($data)
//	{
//	    if ($_FILES["ficheiro"]["name"] != "" )
//	    {
//		    $vector_nome = construcaoVector($_FILES["ficheiro"]["name"],".");
//		    $extensao = ".". $vector_nome[count($vector_nome)-1];
//
////		    $i = 0;
//
////		    do
////		    {
////			    $i++;
//			    $nome = "../flash/dispensador/"."dispensador".$extensao;
////		    } while (file_exists($nome));
//
//		    $sucesso_copia = move_uploaded_file($_FILES["ficheiro"]["tmp_name"], $nome);
//
//		    $conf_path = "../flash/dispensador/$idConteudo-dispensador.swf.xml";
//		    $template_path = "../flash/dispensador/dispensador.tpl";
//
//		    file_get_contents($filename)
//		    file_put_contents($filename, $data);
//
//		    $template = fopen($template_path, "r");
//		    $confFile = fopen($conf_path, "w");
//
//		    $conf = str_replace("%IP_SERVIDOR%", $_SERVER["SERVER_ADDR"], fread($template, filesize($template_path)));
//
//		    if (isset($confFile))
//		    {
//
//			fwrite($confFile, $conf);
//			fclose($confFile);
//		    }
//
//		    return "ok";
//	    }
//	    else
//		    return 0;
//	}

    function ListarTransaccoes()
    {
        $id_dispensador = @$_SESSION['sessao_campos']['id_dispensador'];
        if($id_dispensador == '')
            return ;
        $sql = "SELECT COUNT(*) FROM transaction_appointment ta WHERE ta.financial_transaction IN (SELECT tf.id FROM transaction_financial tf WHERE tf.transaction_id IN (SELECT t.transaction_id FROM transactions t WHERE t.id_dispensador IN (".$id_dispensador.")))";

        if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= " ORDER BY " . $_REQUEST["campo"] . " ";
        else
            $sql .= " ORDER BY appointment_date ";

        if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= " ASC";
        else
            $sql .= " DESC";

        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $n = 1;
        $numRegPag = $N_REGISTOS * 2; // número de registos por página
        $numPaginas = 1; // número de páginas de registos
        //$numTuplos = $this->bd->obterValor($rs, 0); // número total registos
        
        $res = $this->bd->getRows($sql);
        $numTuplos = @$res[0][0]; // número total registos

        // caso haja eliminação de registos que diminua o número de páginas
        if(array_key_exists("pagina", $_REQUEST) && intVal($_REQUEST["pagina"] > 0) && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
            $_REQUEST["pagina"] -= 1;

        // caso não existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', false) ." ".  translate('word_registo_transaccoes', false)." " .translate('word_registados_sistema', false) ."</div>";
            return;
        }

        // calculo do número de páginas de registos
        if($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=dispensadores&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"] . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>
							<tr>
								<td class='button_page' colspan='6'>";


        if($_REQUEST["pagina"] > 1)
        {
            $pagAnterior = $_REQUEST["pagina"] - 1;
            echo "<a href='?tipomod=dispensador&pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "#registo_transaccoes'><img alt='' src='../img/buttons/button_back.gif'></a> ";
        }
        else
        {
            $_REQUEST["pagina"] = 1; // na primeira vez não há request
            echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
        }

        while($n <= $numPaginas)
        {
            if($n == $_REQUEST["pagina"])
                echo "<a href='?tipomod=dispensador&pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "#registo_transaccoes'><div class='current_page'>$n</div></a>";
            else
                echo "<a href='?tipomod=dispensador&pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "#registo_transaccoes'><div class='other_page'>$n</div></a>";
            $n++;
        }

        $n = ($_REQUEST["pagina"] - 1)*$numRegPag;
        $incremento = $n;

        if($_REQUEST["pagina"] < $numPaginas)
        {
            $pagPosterior = $_REQUEST["pagina"] + 1;
            echo "<a href='?tipomod=dispensador&pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "#registo_transaccoes'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
        }
        else
        {
            if($numTuplos % $numRegPag != 0)
                $numRegPag = $numTuplos % $numRegPag;
            echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
        }

        echo "		</td>
				</tr>";


		/********************/
		/* FIM DA PAGINACAO */
		/********************/

        $sql = "SELECT ta.* FROM transaction_appointment ta WHERE ta.financial_transaction IN (SELECT tf.id FROM transaction_financial tf WHERE tf.transaction_id IN (SELECT t.transaction_id FROM transactions t WHERE t.id_dispensador IN (".$id_dispensador.")))";

        if($_REQUEST["campo"] != "")
            $sql .= "ORDER BY " . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY appointment_date ";

        if($_REQUEST["ordem"] == 1)
            $sql .= "ASC";
        else
            $sql .= "DESC";

		$sql.=" LIMIT ".(($_REQUEST["pagina"]-1)*$numRegPag).", ".$numRegPag;

        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }
        $dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);

        echo "<tr class='column_row'>";

        echo "<td class='column_cell'><div>Id</div></td>";
        echo "<td class='column_cell'><div>". translate('word_date', true)."</div></td>";
        echo "<td class='column_cell'><div>". translate('word_valor', true)."</div></td>";
        echo "<td class='column_cell'><div>". translate('word_state', true) ."</div></td>";

        echo "</tr>";

		$n = 0;

        while($n < $numRegPag)
        {
            //$this->bd->moverRegisto($rs,$n);

			$type = $dados[$n]["type"] /*$this->bd->obterValor($rs,"type")*/;
			if($type == 'PAYED' || $type == 'PAID')
				$type = translate('word_pago', true);
			else if($type == 'UNPAYED' || $type == 'UNPAID')
				$type = translate('word_naopago', true);
			else
				$type = translate('word_naoaplicavel', true);

            echo "<tr>";
            echo   "<td><a name=\"rt_$n\"><a href=\"#rt_$n\" onclick=\"javascript:popUp(800, 400, 'gestao_moedeiro_operacoes.php?id=". $dados[$n]["financial_transaction"] /*$this->bd->obterValor($rs,"financial_transaction")*/ ."');\">" . $dados[$n]["id"] /*$this->bd->obterValor($rs,"id") */ . "</a></td>
					<td><a href=\"#rt_$n\" onclick=\"javascript:popUp(800, 400, 'gestao_moedeiro_operacoes.php?id=". $dados[$n]["financial_transaction"] /*$this->bd->obterValor($rs,"financial_transaction")*/ ."')\">" . $dados[$n]["appointment_date"] /*$this->bd->obterValor($rs,"appointment_date")*/ . "</a></td>
					<td><a href=\"#rt_$n\" onclick=\"javascript:popUp(800, 400, 'gestao_moedeiro_operacoes.php?id=". $dados[$n]["financial_transaction"] /*$this->bd->obterValor($rs,"financial_transaction")*/ ."')\">" . $dados[$n]["total_value"] /*$this->bd->obterValor($rs,"total_value")*/ . "</a></td>
					<td><a href=\"#rt_$n\" onclick=\"javascript:popUp(800, 400, 'gestao_moedeiro_operacoes.php?id=". $dados[$n]["financial_transaction"] /*$this->bd->obterValor($rs,"financial_transaction")*/ ."')\">" . $type . "</a></td>";
            echo "</tr>";

            $n++;
        }
        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . @$_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        echo	"</table>
		</form>";
    }

    function ListarOperacoesTransaccao($id)
    {
         $sql = "SELECT * FROM transaction_financial WHERE id=$id";

        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $numTuplos = $this->bd->obterNumRegistos($rs); // número total registos

		// caso não existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', false) ." ".  translate('word_registo_transaccoes', false)." " .translate('word_registados_sistema', false) ."</div>";
            return;
        }

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=dispensadores&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"] . "' method='post'>
			<table width='500' class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table width='500' class='data_table' cellspacing='0' cellpadding='0'>
							<tr>
								<td class='button_page' colspan='6'>&nbsp;";
        echo "		</td>
				</tr>";

        echo "<tr class='column_row'>";

        echo "<td class='column_cell'><div></div></td>";

        echo "<td class='column_cell'><div>". translate('word_denominacao', true)."</div></td>";

        echo "</tr>";

		$row = $this->bd->obterRegisto($rs);

		$operacoes=array();
		if($row['coins']!=0)
			$operacoes = explode('|',$row['coins']);

        foreach($operacoes as $o)
        {
			echo"<tr class='column_row'>";
            echo   "<td class='column_cell'><div>" . (($o>=0)?"<img alt='' src='../img/buttons/order_asc.gif'>":"<img alt='' src='../img/buttons/order_desc.gif'>") . "</div></td>
					<td style='background-color: #fff; color: #777'>" . number_format(abs($o),2) . "&euro;</td>";
            echo "</tr>";

            $n++;
        }
        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        echo	"</table>
		</form>";

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=dispensadores&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"] . "' method='post'>
			<table width='500' class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>	";

        echo "<tr class='column_row'>";

        echo "<td class='column_cell' style='text-align: right'><div>". translate('word_valor_transaccao', true)."&nbsp;</div></td>";
		echo "<td class='column_cell' style='background-color: #fff; color: #777'><div>". number_format($row['total_value'],2) ."&euro;</div></td>";

        echo "</tr>";

        echo "<tr class='column_row'>";

        echo "<td class='column_cell' style='text-align: right'><div>". translate('word_total_inserido', true)."&nbsp;</div></td>";
		echo "<td class='column_cell' style='background-color: #fff; color: #777'><div>". number_format($row['inserted_value'],2) ."&euro;</div></td>";

        echo "</tr>";

        echo "<tr class='column_row'>";

        echo "<td class='column_cell' style='text-align: right'><div>". translate('word_total_troco', true)."&nbsp;</div></td>";
		echo "<td class='column_cell' style='background-color: #fff; color: #777'><div>". number_format($row['change_value'],2) ."&euro;</div></td>";

        echo "</tr>";

        echo "<tr class='column_row'>";

        echo "<td class='column_cell' style='text-align: right'><div>". translate('word_balanco', true)."&nbsp;</div></td>";
		echo "<td class='column_cell' style='background-color: #fff; color: #777'><div>". number_format($row['inserted_value']-$row['change_value'],2) ."&euro;</div></td>";

        echo "</tr>";

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        echo	"</table>
		</form>";
    }

}
?>
