<?php
session_start();

require_once("../config.inc.php");

if($_SESSION["sessao_autenticado"] == 0)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);

if($_SESSION["sessao_perms"]["perm_dispensador"] < 2)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR ."/" );

$num_servicos=0;
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Zqueue - <?php   echo  translate('word_edition', true) ?> <?php   echo  translate('word_de', true) ?> <?php   echo  translate('word_dispensador', true) ?></title>

        <link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">

        <!-- Re-design -->
        <link rel="stylesheet" type="text/css" media="screen" href="../css/components/custom-form.css">

        <script type="text/javascript" src="<?php   echo getPathScriptJS("menu.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("validacoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("funcoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("custom-dropdown.js"); ?>"></script>
        <script type="text/javascript">
            //variavel tipo dispensador
            var tipo = "<?php  echo $_SESSION['sessao_campos']['tipo_dispensador'];?>";

            function valueHasChanged(obj, val, chkId, obj2, val2)
            {
                var oChk = document.getElementById(chkId);

                if (obj2!=undefined && val2!=undefined)
                {
                    var chck = false;

                    switch (obj.type)
                    {
                        case "checkbox":
                            if (obj.checked!=val) chck = true;
                            else chck = false;
                            break;
                        default:
                            if (obj.value!=val) chck = true;
                            else chck = false;
                            break;
                    }

                    if (!chck)
                    {
                        switch (obj2.type)
                        {
                            case "checkbox":
                                if (obj2.checked!=val2) chck = true;
                                else chck = false;
                                break;
                            default:
                                if (obj2.value!=val2) chck = true;
                                else chck = false;
                                break;
                        }
                    }

                    oChk.checked = chck;
                }
                else
                {
                    switch (obj.type)
                    {
                        case "checkbox":
                            if (obj.checked!=val) oChk.checked = true;
                            else oChk.checked = false;
                            break;
                        default:
                            if (obj.value!=val) oChk.checked = true;
                            else oChk.checked = false;
                            break;
                    }
                }
            }

            function valuesHaveChanged(InputClassName, aVal, chkId, yetanotherInputClassName, yetanotheraVal)
            {
                var aInputs = document.getElementsByClassName(InputClassName);
                var oChk = document.getElementById(chkId);

                var aChgVal = new Array();
                for (var i=0; i<aInputs.length; i++)
                {
                    switch(aInputs[i].type)
                    {
                        case "checkbox":
                            if (aInputs[i].checked) aChgVal.push(aInputs[i].value);
                            break;
                        default:
                            aChgVal.push(aInputs[i].value);
                            break;
                    }
                }

                if (yetanotherInputClassName != undefined)
                {
                    var ayetanotherInputs = document.getElementsByClassName(yetanotherInputClassName);

                    var ayetanotherChgVal = new Array();
                    for (var i=0; i<ayetanotherInputs.length; i++)
                    {
                        switch(ayetanotherInputs[i].type)
                        {
                            case "checkbox":
                                if (ayetanotherInputs[i].checked) ayetanotherChgVal.push(ayetanotherInputs[i].value);
                                break;
                            default:
                                ayetanotherChgVal.push(ayetanotherInputs[i].value);
                                break;
                        }
                    }

                    if (aVal.sort().compare(aChgVal.sort()) && yetanotheraVal.sort().compare(ayetanotherChgVal.sort())) oChk.checked = false;
                    else oChk.checked = true;
                }
                else
                {
                    if (aVal.sort().compare(aChgVal.sort())) oChk.checked = false;
                    else oChk.checked = true;
                }
        }

        </script>
    </head>
    <body>
        <?php
        include("../cabecalho.php");

        $adisp = unserialize($_REQUEST["id"]);

        $oDisp = new Dispensador();
        $aDispBase = $oDisp->GetDispensadoresBase();
        unset($oDisp);
        $aux = array();
        foreach ($aDispBase as $adb)
        {
            array_push($aux, $adb["id_dispensador"]);
        }

        function soBase($i)
        {
            global $aux;
            return in_array($i, $aux);
        }

        $adisp = array_filter($adisp, "soBase");

        if(count($_POST) != 0 )
        {
            $_SESSION["sessao_campos"] = $_POST;
        }
        $num = 0;
        ?>

        <div class="full_area">
          <!-- Title + Description -->
          <div class="form-title">
            <h2 class="text-bold text-green-light"><?php   echo   translate('word_edit', true)  ?> <?php   echo  translate('word_dispensador', true)?></h2>

            <!-- Extra description -->
            <div class="form-extra-desc text-bold text-gray-dark">
              <!-- Selected ones -->
              <div class="text-bold text-green-light">Dispensadores em edição:</div>
              <?php  echo implode(",&nbsp;", $_SESSION["sessao_campos"]["nome_dispensadores"]); ?>
            </div>
          </div>

          <!-- Main Table Content -->
          <div class="form-table-container">

            <div class="form-flex-container">
              <!-- form fields -->
              <table cellspacing="0" cellpadding="0">
                <tr>
                  <td width="">
                    <!-- #B - Type Selected -->
                    <form class="form_template" action="../accoes_intermedias/accaoEditar.php?modulo=dispensadores&tipo=<?php   echo ""; ?>&id[]=<?php  echo implode("&id[]=", $adisp); ?>" method="post">
                      <!-- hidden input with type chosen -->
                      <input type="hidden" id="tipo_dispensador" name="tipo_dispensador" value="<?php  echo $_SESSION["sessao_campos"]["tipo_dispensador"]; ?>">


                      <?php  if ($_SESSION["sessao_perms"]["all_perm"] == 1 || $_SESSION["sessao_perms"]["perm_servicos_dispensador"]) { ?>
                        <!-- Main Form + Checks -->
                        <div class="form_template_flex_container">
                          <!-- Form main table -->
                          <table cellspacing="0" cellpadding="0">

                              <!-- Floor -->
                              <tr>
                                <!-- field name -->
                                <td class="formname_space">
                                  <font class="text-green-light">* </font><?php   echo  translate('word_floor', true) ?>:
                                </td>
                                <!-- field input -->
                                <td class="input_space">
                                  <input type="text" name="piso" size="5" maxlength="3" value="<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>" onkeypress="return NumbersOnly(event,this)"
                                         onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>', 'change_piso')"/>

                                  <!-- Error message -->
                                  <span id="msg_piso" class="error_msg">&nbsp;</span>
                                </td>
                              </tr>

                              <!-- State (dropdown) -->
                              <tr>
                                <!-- field name -->
                                <td class="formname_space">
                                  <font class="text-green-light">* </font><?php   echo  translate("word_state", true) ?>:
                                </td>
                                <!-- field input -->
                                <td class="input_space">
                                  <div class="custom-select">
                                    <select id="estado" name="estado" onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["estado"]; ?>', 'change_estado');">
                                        <option value="">-- <?php   echo  translate('word_choose'); ?> --</option>
                                        <option value="1" <?php  if($_SESSION["sessao_campos"]["estado"]==1) echo 'selected="yes"' ?>><?php   echo  translate('word_operational'); ?></option>
                                        <option value="0" <?php  if($_SESSION["sessao_campos"]["estado"]==0) echo 'selected="yes"' ?>><?php   echo  translate('word_notoperational'); ?></option>
                                    </select>
                                  </div>
                                  <!-- Error message -->
                                  <span id="msg_estado" class="error_msg">&nbsp;</span>
                                </td>
                              </tr>

                              <!-- Printer State (dropdown) -->
                              <tr>
                                <!-- field name -->
                                <td class="formname_space">
                                  <font class="text-green-light">* </font><?php   echo  translate("word_state_printer", true) ?>:
                                </td>
                                <!-- field input -->
                                <td class="input_space">
                                  <div class="custom-select">
                                    <?php  construirListaGeral("status_impressora", "estados_dispensador", "id_estado_dispensador", "nome", $_SESSION["sessao_campos"]["status_impressora"], "",
                                            "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["status_impressora"]."\", \"change_status_impressora\")"); ?>
                                  </div>

                                  <!-- Error message -->
                                  <span id="msg_estado" class="error_msg">&nbsp;</span>
                                </td>
                              </tr>

                              <!-- Local (dropdown) -->
                              <tr>
                                <!-- field name -->
                                <td class="formname_space">
                                  <font class="text-green-light">* </font><?php   echo  translate("word_local", true) ?>:
                                </td>
                                <!-- field input -->
                                <td class="input_space">
                                  <div class="custom-select">
                                    <?php  construirListaGeral("id_loja", "lojas", "id_loja", "nome", $_SESSION["sessao_campos"]["id_loja"], "",
                                            "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["id_loja"]."\", \"change_local\")"); ?>
                                  </div>

                                  <!-- Error message -->
                                  <span id="msg_id_loja" class="error_msg">&nbsp;</span>
                                </td>
                              </tr>

                              <!-- #A - dispensador_base (base) -->
                              <?php  if( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base") { ?>
                                <!-- Type Processor (dropdown) -->
                                <tr>
                                  <!-- field name -->
                                  <td class="formname_space">
                                    <font class="text-green-light">* </font>Tipo de Processador:
                                  </td>
                                  <!-- field input -->
                                  <td class="input_space">
                                    <!-- dropdown with button inline -->
                                    <div class="form-dropdown-with-btn">
                                      <div class="custom-select">
                                        <?php  construirListaGeral("id_processador", "processador_dispensador", "id_processador", "modelo", $_SESSION["sessao_campos"]["tipo_processador"], "",
                                                "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["tipo_processador"]."\", \"change_tipo_processador\")"); ?>
                                      </div>

                                      <?php  if ($_SESSION["sessao_perms"]["perm_tipos_processador"]==2) { ?>
                                        <div class="button-inline-dropdown">
                                          <a href="visualizar_popup.php?tipo=processador" onClick="javascript:popUp(540, 220, 'visualizar_popup.php?tipo=processador&nome=Processador', onclose); return false;">
                                            <div class="button-full-gray">
                                              <span>Criar</span>
                                              <div class="btn-checkmark"></div>
                                            </div>
                                          </a>
                                        </div>
                                      <?php  } ?>
                                    </div>
                                    <!-- Error message -->
                                    <span id="msg_id_processador" class="error_msg">&nbsp;</span>
                                  </td>
                                </tr>

                                <!-- Type Printer (dropdown) -->
                                <tr>
                                  <!-- field name -->
                                  <td class="formname_space">
                                    <font class="text-green-light">* </font><?php   echo  translate('word_tipo_impressora', true) ?>:
                                  </td>
                                  <!-- field input -->
                                  <td class="input_space">
                                    <!-- dropdown with button inline -->
                                    <div class="form-dropdown-with-btn">
                                      <div class="custom-select">
                                        <?php  construirListaGeral("id_impressora", "impressora_dispensador", "id_impressora", "modelo", $_SESSION["sessao_campos"]["tipo_impressora"], "",
                                                "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["tipo_impressora"]."\", \"change_tipo_impressora\")"); ?>
                                      </div>

                                      <?php  if ($_SESSION["sessao_perms"]["perm_tipos_impressora"]==2) { ?>
                                        <div class="button-inline-dropdown">
                                          <a href="visualizar_popup.php?tipo=impressora" onClick="javascript:popUp(540, 220, 'visualizar_popup.php?tipo=impressora&nome=Impressora', onclose); return false;">
                                            <div class="button-full-gray">
                                              <span>Criar</span>
                                              <div class="btn-checkmark"></div>
                                            </div>
                                          </a>
                                        </div>
                                      <?php  } ?>
                                    </div>
                                    <!-- Error message -->
                                    <span id="msg_id_impressora" class="error_msg">&nbsp;</span>
                                  </td>
                                </tr>

                                <!-- Type Screen (dropdown) -->
                                <tr>
                                  <!-- field name -->
                                  <td class="formname_space">
                                    <font class="text-green-light">* </font><?php   echo  translate('word_tipo_ecra', true) ?>:
                                  </td>
                                  <!-- field input -->
                                  <td class="input_space">
                                    <!-- dropdown with button inline -->
                                    <div class="form-dropdown-with-btn">
                                      <div class="custom-select">
                                        <?php  construirListaGeral("id_ecra", "ecra_dispensador", "id_ecra", "modelo", $_SESSION["sessao_campos"]["tipo_ecra"], "",
                                                "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["tipo_ecra"]."\", \"change_tipo_ecra\")"); ?>
                                      </div>

                                      <?php  if ($_SESSION["sessao_perms"]["perm_tipos_ecra"]==2) { ?>
                                        <div class="button-inline-dropdown">
                                          <a href="visualizar_popup.php?tipo=ecra" onClick="javascript:popUp(540, 220, 'visualizar_popup.php?tipo=ecra&nome=Ecr\u00E3', null); return false;">
                                            <div class="button-full-gray">
                                              <span>Criar</span>
                                              <div class="btn-checkmark"></div>
                                            </div>
                                          </a>
                                        </div>
                                      <?php  } ?>
                                    </div>
                                    <!-- Error message -->
                                    <span id="msg_id_ecra" class="error_msg">&nbsp;</span>
                                  </td>
                                </tr>

                              <?php  } ?>

                              <!-- #B - dispensador_manual (bico) -->
                              <?php  if( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_manual") { ?>
                                <!-- Associated Service (dropdown) -->
                                <tr>
                                  <!-- field name -->
                                  <td class="formname_space">
                                    <font class="text-green-light">* </font><?php   echo  translate("word_service", true) ?>:
                                  </td>
                                  <!-- field input -->
                                  <td class="input_space">
                                    <div class="custom-select">
                                      <?php  construirListaGeralServicos("id_servico", "servicos", "id_servico", "nome", $_SESSION["sessao_campos"]["id_servico"]); ?>
                                    </div>

                                    <!-- Error message -->
                                    <span id="msg_id_servico" class="error_msg">&nbsp;</span>
                                  </td>
                                </tr>
                              <?php  } ?>

                              <!-- #A - dispensador_base (base) -->
                              <?php  if( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base") { ?>
                                <!-- Message Welcome -->
                                <tr>
                                  <!-- field name -->
                                  <td class="formname_space">
                                    <font class="text-green-light">* </font><?php   echo  translate('word_msg_boas_vindas', true) ?>:
                                  </td>
                                  <!-- field input -->
                                  <td class="input_space">
                                    <textarea id="boasvindas" name="boasvindas" rows="4" cols="51"
                                              onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["msg_boasvindas"]; ?>', 'change_msg_boas_vindas')"><?php  echo $_SESSION["sessao_campos"]["msg_boasvindas"]; ?></textarea>

                                    <!-- Error message -->
                                    <span id="msg_boasvindas" class="error_msg">&nbsp;</span>
                                  </td>
                                </tr>

                                <!-- Message Print ticket -->
                                <tr>
                                  <!-- field name -->
                                  <td class="formname_space">
                                    <font class="text-green-light">* </font><?php   echo  translate('word_msg_impressao_senha', true) ?>:
                                  </td>
                                  <!-- field input -->
                                  <td class="input_space">
                                    <textarea id="impressaosenha" name="impressaosenha" rows="4" cols="51"
                                              onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["msg_impressaosenha"]; ?>', 'change_msg_impressao_senha')"><?php  echo $_SESSION["sessao_campos"]["msg_impressaosenha"]; ?></textarea>

                                    <!-- Error message -->
                                    <span id="msg_impressaosenha" class="error_msg">&nbsp;</span>
                                  </td>
                                </tr>

                              <?php  } ?>

                          </table>

                          <!-- Check forms -->
                          <?php  if( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base") { ?>
                            <table class="form-options-container" cellspacing="0" cellpadding="0">
                              <!-- Separator: Card reader -->
                              <tr>
                                <td class="text-bold"><?php   echo  translate('word_leitor_cartoes', true) ?>:</td>
                              </tr>

                              <!-- #1 Card reader yes/no -->
                              <tr>
                                <td>
                                  <label class="custom-radio-container <?php  if($_SESSION["sessao_campos"]["leitor_cartoes"]==0) echo 'custom-radio-selected' ?>">
                                    <div><?php   echo  translate('word_no') ?></div>
                                    <input  type="radio" name="leitor_cartoes"
                                            <?php  if($_SESSION["sessao_campos"]["leitor_cartoes"]==0) echo 'checked' ?>
                                            value="0" onchange="activateRadio(this);valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_leitor_cartoes');">
                                    <span class="radio-checkmark"></span>
                                  </label>
                                </td>
                                <td>
                                  <label class="custom-radio-container <?php  if($_SESSION["sessao_campos"]["leitor_cartoes"]==1) echo 'custom-radio-selected' ?>">
                                    <div><?php   echo  translate('word_yes') ?></div>
                                    <input  type="radio" name="leitor_cartoes"
                                            <?php  if($_SESSION["sessao_campos"]["leitor_cartoes"]==1) echo 'checked' ?>
                                            value="1" onchange="activateRadio(this);valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_leitor_cartoes');">
                                    <span class="radio-checkmark"></span>
                                  </label>
                                </td>
                              </tr>
                              <tr>
                                <td colspan="2">
                                  <div class="custom-select">
                                    <select id="stateAutoCheckinModule" name="stateAutoCheckinModule" onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_leitor_cartoes');">
                                        <option value="">--vazio--</option>
                                        <option value="1" <?php  if($_SESSION["sessao_campos"]["leitor_cartoes_operacional"]==1) echo 'selected="yes"' ?>><?php   echo  translate('word_operational'); ?></option>
                                        <option value="0" <?php  if($_SESSION["sessao_campos"]["leitor_cartoes_operacional"]==0) echo 'selected="yes"' ?>><?php   echo  translate('word_notoperational'); ?></option>
                                    </select>
                                  </div>
                                </td>

                              </tr>

                              <!-- Separator: Payment -->
                              <tr>
                                <td class="text-bold" style="padding-top: 30px;"><?php   echo  translate('word_modulo_pagamentos', true) ?>:</td>
                              </tr>
                              <!-- #2 Payment method yes/no -->
                              <tr>
                                <td>
                                  <label class="custom-radio-container <?php  if($_SESSION["sessao_campos"]["dcm"]==0) echo 'custom-radio-selected' ?>">
                                    <div><?php   echo  translate('word_no') ?></div>
                                    <input  type="radio" name="dcm"
                                            <?php  if($_SESSION["sessao_campos"]["dcm"]==0) echo 'checked' ?>
                                            value="0" onchange="activateRadio(this);valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_dcm')">
                                    <span class="radio-checkmark"></span>
                                  </label>
                                </td>
                                <td>
                                  <label class="custom-radio-container <?php  if($_SESSION["sessao_campos"]["dcm"]==1) echo 'custom-radio-selected' ?>">
                                    <div><?php   echo  translate('word_yes') ?></div>
                                    <input  type="radio" name="dcm"
                                            <?php  if($_SESSION["sessao_campos"]["dcm"]==1) echo 'checked' ?>
                                            value="1" onchange="activateRadio(this);valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_dcm')">
                                    <span class="radio-checkmark"></span>
                                  </label>
                                </td>
                              </tr>
                              <tr>
                                <td colspan="2">
                                  <div class="custom-select">
                                    <select id="statePaymentModule" name="statePaymentModule" onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_dcm');">
                                        <option value="">--vazio--</option>
                                        <option value="1" <?php  if($_SESSION["sessao_campos"]["dcm_operacional"]==1) echo 'selected="yes"' ?>><?php   echo  translate('word_operational'); ?></option>
                                        <option value="0" <?php  if($_SESSION["sessao_campos"]["dcm_operacional"]==0) echo 'selected="yes"' ?>><?php   echo  translate('word_notoperational'); ?></option>
                                    </select>
                                  </div>
                                </td>

                              </tr>
                            </table>
                          <?php  } ?>
                        </div>

                        <!-- Selection table and buttons -->
                        <table cellspacing="0" cellpadding="0">
                          <!-- #A - dispensador_base (base) -->
                          <?php  if( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base") { ?>
                            <tr>
                              <td class="formname_space">
                                <?php   echo  translate('word_servicos_associados', true) ?> <?php   echo  translate('word_dispensador', true)?> por entidade:
                              <td>
                                <!-- Selectable list -->
                                <div class="form-selectable-table">
                                  <table id="entidade_servico" class="data_table" cellspacing="0">
                                      <thead>
                                          <tr class="column_row">
                                              <td class="center">&nbsp;</td>
                                              <td class="left"><?php   echo  translate('word_entity', true) ?></td>
                                              <td class="left"><?php   echo  translate("word_service", true) ?></td>
                                              <td class="center"><?php   echo  translate("word_order", true) ?></td>
                                          </tr>
                                      </thead>
                                      <tbody>

                                        <?php 

                                        $servicos_prestados = new Servico();
                                        $servicos_entidade = $servicos_prestados->obterDados();

                                        $num_servicos = count($servicos_entidade);
                                        $prestados_count = array_count_values($_SESSION["sessao_campos"]["servicos_dispensador"]["id"]);

                                        $ordem = array();
                                        for ($i=0; $i<count($_SESSION["sessao_campos"]["servicos_dispensador"]["id"]); $i++)
                                        {
                                            $ordem[$_SESSION["sessao_campos"]["servicos_dispensador"]["id"][$i]] = $_SESSION["sessao_campos"]["servicos_dispensador"]["ordem"][$i];
                                        }

                                        $ordemAux = array();

                                        for ($i=0; $i<$num_servicos; $i++)
                                        {
                                            $id_servico = $servicos_entidade[$i]["id_servico"];
                                            array_push($ordemAux, @$ordem[$id_servico]);
                                        }

                                        $num = @$_SESSION["sessao_campos"]["num_servicos"];

                                        //debug($_SESSION["sessao_campos"]);

                                        for ($i=0; $i<$num_servicos; $i++)
                                        {
                                            $id_servico = $servicos_entidade[$i]["id_servico"];
                                            ?>
                                          <tr class="form-data-tr <?php   if (array_key_exists($id_servico, $prestados_count) && $prestados_count[$id_servico] > 0) echo "form-tr-selected"; ?>">
                                            <td class="form-data-td center">
                                              <label class='custom-check-container'>
                                                <input  class="servicos_prestados"
                                                        name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>"
                                                        type="checkbox"
                                                        <?php   if (array_key_exists($id_servico, $prestados_count) && $prestados_count[$id_servico] > 0) echo "checked"; ?>
                                                        value="<?php   echo $id_servico; ?>"
                                                        onchange="valuesHaveChanged('servicos_prestados', [<?php   if (count($_SESSION["sessao_campos"]["servicos_dispensador"]["id"])) echo "'".implode("','", $_SESSION["sessao_campos"]["servicos_dispensador"]["id"])."'"; ?>], 'change_servicos',
                                                        'ordem_servicos', [<?php   echo "'".implode("','", $ordemAux)."'"; ?>])"
                                                        onClick='selectEntireRow(this)'>
                                                <span class='custom-checkmark'></span>
                                              </label>
                                            </td>
                                            <td class="form-data-td left"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
                                            <td class="form-data-td left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
                                            <td class="form-data-td center">
                                              <input  class="ordem_servicos table-input"
                                                      name="ordem_servicos_<?php   echo $id_servico; ?>"
                                                      type="input"
                                                      value="<?php   echo (array_key_exists($id_servico, $ordem) ? $ordem[$id_servico] : ''); ?>"
                                                      size="5" maxlength="2" value=""
                                                      onkeypress="return NumbersOnly(event,this)"
                                                      onchange="valuesHaveChanged('ordem_servicos', [<?php   echo "'".implode("','", $ordemAux)."'"; ?>], 'change_servicos',
                                                            'servicos_prestados', [<?php   if (count($_SESSION["sessao_campos"]["servicos_dispensador"]["id"])) echo "'".implode("','", $_SESSION["sessao_campos"]["servicos_dispensador"]["id"])."'"; ?>])"/>
                                            </td>
                                        </tr>
                                        <?php  } ?>

                                      </tbody>
                                  </table>

                                </div>
                              </td>
                            </tr>
                          <?php  } ?>

                          <!-- Table Errors -->
                          <?php  if ( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base" ) { ?>
                            <tr class="form-error-session">
                              <td></td>
                              <td><span id="msg_servicos_prestados[]" class="error_space">&nbsp;</span></td>
                            </tr>
                          <?php  } ?>

                          <!-- Buttons -->
                          <tr class="form-tr-buttons-container">
                            <td class="button">
                              <div class="button-full-green" onClick="validaFormDispensador(0 , <?php echo $num_servicos;?>);"><?php   echo  translate('word_modify', true); ?></div>
                            </td>
                            <td class="button">
                              <div class="button-thin-green" onClick="limpaFormulario();"><?php   echo  translate('word_clean', true) ?></div>
                              <a href="index.php"><div class="button-thin-green"><?php   echo  translate('word_cancel', true) ?></div></a>
                            </td>
                          </tr>

                        </table>

                      <?php  } else {//end of permissions?>
                        <!-- Main Form Readonly almost -->
                        <div class="form_template_flex_container">
                          <!-- Form main table -->
                          <table cellspacing="0" cellpadding="0">
                              <!-- Name -->
                              <tr>
                                <!-- field name -->
                                <td class="formname_space">
                                  <?php   echo  translate('word_name', true) ?>
                                </td>
                                <!-- field input -->
                                <td class="input_space">
                                  <input id="nome" name="nome" type="text" maxlength="128" size="52" value="<?php  echo $_SESSION["sessao_campos"]["nome"]; ?>" disabled>

                                  <!-- Error message -->
                                  <span id="msg_nome" class="error_msg">&nbsp;</span>
                                </td>
                              </tr>

                              <!-- Printer State (dropdown) -->
                              <tr>
                                <!-- field name -->
                                <td class="formname_space">
                                  <font class="text-green-light">* </font><?php   echo  translate("word_state_printer", true) ?>
                                </td>
                                <!-- field input -->
                                <td class="input_space">
                                  <div class="custom-select">
                                    <?php  construirListaGeral("status_impressora", "estados_dispensador", "id_estado_dispensador", "nome", $_SESSION["sessao_campos"]["status_impressora"]); ?>
                                  </div>

                                  <!-- Error message -->
                                  <span id="msg_estado" class="error_msg">&nbsp;</span>
                                </td>
                              </tr>

                              <!-- Hidden inputs Start here -->
                              <div>
                                <?php  if ( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base") { ?>
                                  <input type="hidden" name="identificador" value="<?php  echo $_SESSION["sessao_campos"]["identificador"]; ?>"/>
                                <?php  } ?>

                                <?php  if ( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_manual") { ?>
                                  <input type="hidden" name="id_servico" value="<?php   echo $_SESSION["sessao_campos"]["id_servico"]; ?>"/>
                                <?php  } else if ( $_SESSION["sessao_campos"]["tipo_dispensador"] == "dispensador_base") { ?>
                                  <input type="hidden" name="id_processador" value="<?php   echo $_SESSION["sessao_campos"]["tipo_processador"]; ?>"/>
                                  <input type="hidden" name="id_impressora" value="<?php   echo $_SESSION["sessao_campos"]["tipo_impressora"]; ?>"/>
                                  <input type="hidden" name="id_ecra" value="<?php   echo $_SESSION["sessao_campos"]["tipo_ecra"]; ?>"/>
                                  <input type="hidden" name="boasvindas" value="<?php   echo $_SESSION["sessao_campos"]["msg_boasvindas"]; ?>"/>
                                  <input type="hidden" name="impressaosenha" value="<?php  echo $_SESSION["sessao_campos"]["msg_impressaosenha"]; ?>"/>
                                <?php 
                                    $servicos_prestados = new Servico();
                                    $servicos_entidade = $servicos_prestados->obterDados();

                                    $num_servicos = count($servicos_entidade);
                                    $prestados_count = array_count_values($_SESSION["sessao_campos"]["servicos_dispensador"]["id"]);

                                    $num = $_SESSION["sessao_campos"]["num_servicos"];

                                    for ($i=0; $i<$num_servicos; $i++)
                                    {
                                        $id_servico = $servicos_entidade[$i]["id_servico"];

                                        if ($prestados_count[$id_servico] > 0) { ?>
                                            <input name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>" type="hidden" value="<?php   echo $id_servico; ?>"/>
                                      <?php 
                                        }
                                    }
                                }
                                ?>
                                <input type="hidden" name="nome" value="<?php  echo $_SESSION["sessao_campos"]["nome"]; ?>"/>
                                <input type="hidden" name="id_loja" value="<?php   echo $_SESSION["sessao_campos"]["id_loja"]; ?>"/>
                                <input type="hidden" name="piso" value="<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>"/>
                                <input type="hidden" name="estado" value="<?php   echo $_SESSION["sessao_campos"]["estado"]; ?>"/>
                              </div>
                              <!-- Hidden inputs End here -->


                              <!-- Buttons -->
                              <tr class="form-tr-buttons-container">
                                <td class="button">
                                  <div class="button-full-green" onClick="document.forms[0].submit()"><?php   echo  translate('word_modify', true) ?></div>
                                </td>
                                <td class="button">
                                  <a href="index.php"><div class="button-thin-green"><?php   echo  translate('word_cancel', true) ?></div></a>
                                </td>
                              </tr>


                            </table>
                          </div>
                      <?php  } //end of permissions?>

                    </form>


                  </td>
                </tr>
              </table>

            </div>

            <!-- Form Error -->
            <div class="form-error-session">
              <span id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></span>
            </div>

          </div>

        </div>

        <table class="full_area" cellpadding="0" cellspacing="0" style="display:none">
            <tr>
                <td>&nbsp;</td>
                <td class="content">
                    <table class="title_space" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="module_space" width="380">
                                <?php   echo  translate('word_edit', true) ?> <?php   echo  translate('word_dispensador', true)?> </td>
                            <td class="function_space" width="110">
                            </td>
                            <td class="function_space" width="120">
                            </td>
                            <td class="function_space" width="160">
                                <a class="function" href="./"><div><?php   echo  translate('word_prev', true) ?></div><img alt="Recuar" src="../img/buttons/button_back.gif"></a>
                            </td>
                        </tr>
                    </table>
                    <table width="770" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td>
                                <?php 
                                echo implode(",&nbsp;", $_SESSION["sessao_campos"]["nome_dispensadores"]);
                                ?>
                            </td>
                            <td class="bg_form_right">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td>&nbsp;</td>
                            <td class="bg_form_right">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td width="758">
                                <form class="form_template" action="../accoes_intermedias/accaoEditar.php?modulo=dispensadores&tipo=<?php   echo ""; ?>&id[]=<?php  echo implode("&id[]=", $adisp); ?>"  method="post">
                                    <input type="hidden" name="tipo_dispensador" value="<?php  echo $_SESSION['sessao_campos']['tipo_dispensador'];?>"/>
                                    <table id="form_table" cellspacing="0" cellpadding="0">
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_estado" id="change_estado" value="1"/>
                                                <font class="error_msg">* </font><?php   echo  translate('word_state', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <select id="estado" name="estado" onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["estado"]; ?>', 'change_estado');">
                                                    <option value="">-- <?php   echo  translate('word_choose'); ?> --</option>
                                                    <option value="1" <?php  if($_SESSION["sessao_campos"]["estado"]==1) echo 'selected="yes"' ?>><?php   echo  translate('word_operational'); ?></option>
                                                    <option value="0" <?php  if($_SESSION["sessao_campos"]["estado"]==0) echo 'selected="yes"' ?>><?php   echo  translate('word_notoperational'); ?></option>
                                                </select>
                                                <span id="msg_estado" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_status_impressora" id="change_status_impressora" value="1" />
                                                <font class="error_msg">* </font><?php   echo  translate('word_state_printer', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <?php  construirListaGeral("status_impressora", "estados_dispensador", "id_estado_dispensador", "nome", $_SESSION["sessao_campos"]["status_impressora"], "",
                                                        "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["status_impressora"]."\", \"change_status_impressora\")"); ?>
                                                <span id="msg_estado" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_local" id="change_local" value="1"/>
                                                <font class="error_msg">* </font><?php   echo  translate('word_local', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <?php  construirListaGeral("id_loja", "lojas", "id_loja", "nome", $_SESSION["sessao_campos"]["id_loja"], "",
                                                        "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["id_loja"]."\", \"change_local\")"); ?>
                                                <span id="msg_id_loja" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_piso" id="change_piso" value="1"/>
                                                <font class="error_msg">* </font><?php   echo  translate('word_floor', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <input type="text" name="piso" size="5" maxlength="3" value="<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>" onkeypress="return NumbersOnly(event,this)"
                                                       onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["piso"]; ?>', 'change_piso')"/>
                                                <span id="msg_piso" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_tipo_processador" id="change_tipo_processador" value="1"/>
                                                <font class="error_msg">* </font><?php   echo  translate('word_tipo_processador', true)?>
                                            </td>
                                            <td class="input_space">
                                                <?php  construirListaGeral("id_processador", "processador_dispensador", "id_processador", "modelo", $_SESSION["sessao_campos"]["tipo_processador"], "",
                                                        "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["tipo_processador"]."\", \"change_tipo_processador\")"); ?>
                                                <a href="visualizar_popup.php?tipo=processador"
                                                   onClick="javascript:popUp(540, 220, 'visualizar_popup.php?tipo=processador&nome=Processador', null); return false;">
                                                    <img  alt="Inserir Novo" src="../img/buttons/button_add.gif">
                                                </a>
                                                <span id="msg_id_processador" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_tipo_impressora" id="change_tipo_impressora" value="1"/>
                                                <font class="error_msg">* </font> <?php   echo  translate('word_tipo_impressora', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <?php  construirListaGeral("id_impressora", "impressora_dispensador", "id_impressora", "modelo", $_SESSION["sessao_campos"]["tipo_impressora"], "",
                                                        "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["tipo_impressora"]."\", \"change_tipo_impressora\")"); ?>
                                                <a href="visualizar_popup.php?tipo=impressora" onClick="javascript:popUp(540, 220, 'visualizar_popup.php?tipo=impressora&nome=Impressora', null); return false;">
                                                    <img  alt="Inserir Novo" src="../img/buttons/button_add.gif">
                                                </a>
                                                <span id="msg_id_impressora" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_tipo_ecra" id="change_tipo_ecra" value="1"/>
                                                <font class="error_msg">* </font> <?php   echo  translate('word_tipo_ecra', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <?php  construirListaGeral("id_ecra", "ecra_dispensador", "id_ecra", "modelo", $_SESSION["sessao_campos"]["tipo_ecra"], "",
                                                        "valueHasChanged(this, \"".$_SESSION["sessao_campos"]["tipo_ecra"]."\", \"change_tipo_ecra\")"); ?>
                                                <a href="visualizar_popup.php?tipo=ecra" onClick="javascript:popUp(540, 220, 'visualizar_popup.php?tipo=ecra&nome=Ecr\u00E3', null); return false;">
                                                    <img  alt="Inserir Novo" src="../img/buttons/button_add.gif">
                                                </a>
                                                <span id="msg_id_ecra" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_leitor_cartoes" id="change_leitor_cartoes" value="1"/>
                                                <font class="error_msg">* </font> <?php   echo  translate('word_leitor_cartoes', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <input type="radio" name="leitor_cartoes" value="0" <?php  if($_SESSION["sessao_campos"]["leitor_cartoes"]==0) echo 'checked' ?> onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_leitor_cartoes');" />
                                                    <?php   echo  translate('word_no') ?>
                                                <input type="radio" name="leitor_cartoes" value="1" <?php  if($_SESSION["sessao_campos"]["leitor_cartoes"]==1) echo 'checked' ?> onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_leitor_cartoes');" />
                                                    <?php   echo  translate('word_yes') ?>
                                                <select id="stateAutoCheckinModule" name="stateAutoCheckinModule" onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_leitor_cartoes');">
                                                    <option value="1" <?php  if($_SESSION["sessao_campos"]["leitor_cartoes_operacional"]==1) echo 'selected="yes"' ?>><?php   echo  translate('word_operational'); ?></option>
                                                    <option value="0" <?php  if($_SESSION["sessao_campos"]["leitor_cartoes_operacional"]==0) echo 'selected="yes"' ?>><?php   echo  translate('word_notoperational'); ?></option>
                                                </select>
                                                <span id="msg_id_ecra" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_dcm" id="change_dcm" value="1"/>
                                                <font class="error_msg">* </font> <?php   echo  translate('word_modulo_pagamentos', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <input type="radio" name="dcm" value="0" <?php  if($_SESSION["sessao_campos"]["dcm"]==0) echo 'checked' ?> onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_dcm');" />
                                                    <?php   echo  translate('word_no') ?>
                                                <input type="radio" name="dcm" value="1" <?php  if($_SESSION["sessao_campos"]["dcm"]==1) echo 'checked' ?> onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_dcm');" />
                                                    <?php   echo  translate('word_yes') ?>
                                                <select id="statePaymentModule" name="statePaymentModule" onchange="valueHasChanged(this, '<?php  /* leave blank! */?>', 'change_dcm');">
                                                    <option value="1" <?php  if($_SESSION["sessao_campos"]["dcm_operacional"]==1) echo 'selected="yes"' ?>><?php   echo  translate('word_operational'); ?></option>
                                                    <option value="0" <?php  if($_SESSION["sessao_campos"]["dcm_operacional"]==0) echo 'selected="yes"' ?>><?php   echo  translate('word_notoperational'); ?></option>
                                                </select>
                                                <span id="msg_id_ecra" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>


                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_msg_boas_vindas" id="change_msg_boas_vindas" value="1"/>
                                                <?php   echo  translate('word_msg_boas_vindas', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <textarea id="boasvindas" name="boasvindas" rows="2" cols="51"
                                                          onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["msg_boasvindas"]; ?>', 'change_msg_boas_vindas')"><?php  echo $_SESSION["sessao_campos"]["msg_boasvindas"]; ?></textarea>
                                                <span id="msg_boasvindas" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <input type="checkbox" name="change_msg_impressao_senha" id="change_msg_impressao_senha" value="1"/>
                                                <?php   echo  translate('word_msg_impressao_senha', true) ?>
                                            </td>
                                            <td class="input_space">
                                                <textarea id="impressaosenha" name="impressaosenha" rows="2" cols="51"
                                                          onchange="valueHasChanged(this, '<?php   echo $_SESSION["sessao_campos"]["msg_impressaosenha"]; ?>', 'change_msg_impressao_senha')"><?php  echo $_SESSION["sessao_campos"]["msg_impressaosenha"]; ?></textarea>
                                                <span id="msg_impressaosenha" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td>
                                                <br/>
                                                <table id="entidade_servico" class="select_list" cellspacing="0">
                                                    <caption>
                                                        <input type="checkbox" name="change_servicos" id="change_servicos" value="1"/>
                                                        <font class='error_msg'>* </font><?php   echo  translate('word_servicos_associados', true) ?> <?php   echo  translate('word_dispensador', true)?> por entidade
                                                    </caption>
                                                    <thead>
                                                        <tr>
                                                            <th class="left"><?php   echo  translate('word_entity', true) ?></th>
                                                            <th class="left"><?php   echo  translate("word_service", true) ?></th>
                                                            <th class="center"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php 

                                                        $servicos_prestados = new Servico();
                                                        $servicos_entidade = $servicos_prestados->obterDados();

                                                        $num_servicos = count($servicos_entidade);
                                                        $prestados_count = array_count_values(@$_SESSION["sessao_campos"]["servicos_dispensador"]["id"]);

                                                        $ordem = array();
                                                        for ($i=0; $i<count(@$_SESSION["sessao_campos"]["servicos_dispensador"]["id"]); $i++)
                                                        {
                                                            $ordem[@$_SESSION["sessao_campos"]["servicos_dispensador"]["id"][$i]] = @$_SESSION["sessao_campos"]["servicos_dispensador"]["ordem"][$i];
                                                        }

                                                        $ordemAux = array();

                                                        for ($i=0; $i<$num_servicos; $i++)
                                                        {
                                                            $id_servico = $servicos_entidade[$i]["id_servico"];
                                                            array_push($ordemAux, @$ordem[$id_servico]);
                                                        }

                                                        $num = @$_SESSION["sessao_campos"]["num_servicos"];

                                                        //debug($_SESSION["sessao_campos"]);

                                                        for ($i=0; $i<$num_servicos; $i++)
                                                        {
                                                            $id_servico = $servicos_entidade[$i]["id_servico"];
                                                            ?>
                                                        <tr>
                                                            <td class="left"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
                                                            <td class="left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
                                                            <td class="center"><input class="ordem_servicos" name="ordem_servicos_<?php   echo $id_servico; ?>" type="input" value="<?php   echo (array_key_exists($id_servico, $ordem) ? $ordem[$id_servico] : ''); ?>" size="5" maxlength="2" value=""
                                                                                      onkeypress="return NumbersOnly(event,this)"
                                                                                      onchange="valuesHaveChanged('ordem_servicos', [<?php   echo "'".implode("','", $ordemAux)."'"; ?>], 'change_servicos',
                                                                                      'servicos_prestados', [<?php   if (count($_SESSION["sessao_campos"]["servicos_dispensador"]["id"])) echo "'".implode("','", $_SESSION["sessao_campos"]["servicos_dispensador"]["id"])."'"; ?>])"/></td>
                                                            <td class="center"><input class="servicos_prestados" name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>" type="checkbox" value="<?php   echo $id_servico; ?>"
                                                                                      onchange="valuesHaveChanged('servicos_prestados', [<?php   if (count($_SESSION["sessao_campos"]["servicos_dispensador"]["id"])) echo "'".implode("','", $_SESSION["sessao_campos"]["servicos_dispensador"]["id"])."'"; ?>], 'change_servicos',
                                                                                      'ordem_servicos', [<?php   echo "'".implode("','", $ordemAux)."'"; ?>])"
                                                                                          <?php   if (array_key_exists($id_servico, $prestados_count) && $prestados_count[$id_servico] > 0) echo "checked"; ?>/></td>
                                                        </tr>
                                                            <?php  } ?>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <span id="msg_servicos_prestados[]" class="error_msg">&nbsp;</span>
                                                <div id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="button" colspan="2">
                                                <div onClick="validaFormDispensador(0 , <?php echo $num_servicos;?>, true);"><?php   echo  translate('word_modify', true) ?></div>
                                                <div onClick="limpaFormulario();"><?php   echo  translate('word_clean', true) ?></div>
                                                <a href="index.php"><div><?php   echo  translate('word_cancel', true) ?></div></a>
                                            </td>
                                        </tr>
                                    </table>
                                </form>
                            </td>
                            <td class="bg_form_right">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="bg_form_bottom" colspan="3">&nbsp;</td>
                        </tr>
                    </table>
                </td>
                <td>&nbsp;</td>
            </tr>
        </table>

        <?php 
        $_SESSION["sessao_msg"] = "&nbsp;"; // limpa a var�avel que guarda a �ltima mensagem de erro
        ?>

        <?php 
        include("../rodape.php");
        ?>

        <script>
          // Initialize custom-dropdowns
          (function() {
             initializeDropdowns();

          })();
        </script>

    </body>
</html>
