<?php

/* Classe de Gest�o de Ecr�s */

class Ecra extends AcessoBD
{
    var $bd;

    /*
		Construtor da classe

		0 = Erro da BD
    */
    function Ecra()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
		Fun��o de inser��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Inserir($dados)
    {
        if($dados["nome"] == "")
            $dados["nome"] = "null";
        else
            $dados["nome"] = "'".$dados["nome"]."'";

        $sql = "INSERT INTO ecra (nome, identificador, id_loja, estado) VALUES ("
                . $dados["nome"] . ",'"
                . $dados["identificador"] . "',"
                . $dados["id_loja"] .","
                . $dados["estado"] .");";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $sql = "SELECT MAX(id_ecra) FROM ecra;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $id = $this->bd->obterValor($rs,0);

//		if(!is_array($dados["servicos_prestados"])){
//				$temp = $dados["servicos_prestados"];
//				$dados["servicos_prestados"] = array();
//				$dados["servicos_prestados"][0] = $temp;
//
//			}
//
//
//		foreach($dados["servicos_prestados"] as $servico) {
//			$sql = "INSERT INTO servicos_ecra VALUES ($id, $servico);";
//			if(!$rs = $this->bd->executarSQL($sql)) {
//				return 0;
//			}
//		}


        $sql = "insert into servicos_ecra (id_ecra, id_servico, ordem) values ";
        if (is_array($dados["servicos_prestados"]))
        {
            $aux = array();
            foreach ($dados["servicos_prestados"] as $sp)
            {
                array_push($aux, "(".$id.", ".$sp.", ".(strlen($dados["ordem_servicos_".$sp])?$dados["ordem_servicos_".$sp]:"0").")");
            }
            $sql .= implode($aux, ",");
        }
        else
        {
            $sql .= "(".$id.", ".$dados["servicos_prestados"].", ".(strlen($dados["ordem_servicos_".$dados["servicos_prestados"]])?$dados["ordem_servicos_".$dados["servicos_prestados"]]:"0").")";
        }
        if(!$rs = $this->bd->executarSQL($sql)) return 0;

        $this->EscreveXMLSync($id, "inserir");

        $objecto = new LogAccao();
        $rs = $objecto->Inserir("Inserção", "Ecrã", $dados["identificador"]);
        $objecto->fechar();
        return "ok";
    }

    /*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
    */
    function LerDados($id)
    {
        $aux = array();
        if (is_array($id))
        {
            $aux = $id;
        }
        else
        {
            array_push($aux, $id);
        }

        $sql = "SELECT * FROM ecra WHERE id_ecra in (" . implode(",", $aux) . ");";
        $res = $this->bd->getRows($sql);
        if (!count($res)) return 0;

        if (is_array($id))
        {
            $_SESSION["sessao_campos"]["estado"] = $res[0]["estado"];
            $_SESSION["sessao_campos"]["id_loja"] = $res[0]["id_loja"];

            $sql = "SELECT id_servico, ordem FROM servicos_ecra WHERE id_ecra = " . $res[0]["id_ecra"] . ";";
            $res2 = $this->bd->getRows($sql);
            $servicos_prestados = array();
            $ordem_servicos = array();
            foreach ($res2 as $r)
            {
                array_push($servicos_prestados, $r["id_servico"]);
                array_push($ordem_servicos, $r["ordem"]);
            }
            $_SESSION["sessao_campos"]["servicos_ecra"]["id"] = $servicos_prestados;
            $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"] = $ordem_servicos;

            $_SESSION["sessao_campos"]["nome_ecras"] = array();

            foreach ($res as $r)
            {
                array_push($_SESSION["sessao_campos"]["nome_ecras"], $r["nome"]);

                $_SESSION["sessao_campos"]["estado"] = $_SESSION["sessao_campos"]["estado"]==$r["estado"]?$r["estado"]:"";
                $_SESSION["sessao_campos"]["id_loja"] = $_SESSION["sessao_campos"]["id_loja"]==$r["id_loja"]?$r["id_loja"]:"";

                $sql = "SELECT id_servico, ordem FROM servicos_ecra WHERE id_ecra = " . $r["id_ecra"] . ";";
                $res2 = $this->bd->getRows($sql);
                $servicos_prestados = array();
                $ordem_servicos = array();
                foreach ($res2 as $r2)
                {
                    array_push($servicos_prestados, $r2["id_servico"]);
                    array_push($ordem_servicos, $r2["ordem"]);
                }
                $_SESSION["sessao_campos"]["servicos_ecra"]["id"] = $_SESSION["sessao_campos"]["servicos_ecra"]["id"]==$servicos_prestados?$servicos_prestados:array();
                $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"] = $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"]==$ordem_servicos?$ordem_servicos:array();
            }
        }
        else
        {
            $_SESSION["sessao_campos"] = $res[0];
            //$id_ecra = $_SESSION["sessao_campos"]["id_ecra"];
            $id_loja = $_SESSION["sessao_campos"]["id_loja"];

            // Otteniamo i servizi associati all'ecra
            $sql = "SELECT id_servico, ordem FROM servicos_ecra WHERE id_ecra = " . $id . ";";
            $res2 = $this->bd->getRows($sql);
            //if(!$rs = $this->bd->executarSQL($sql))
            //    return 0;

            //$num_registos = $this->bd->obterNumRegistos($rs);
            $servicos_prestados = array();
            $ordem_servicos = array();

            foreach ($res2 as $r2)
                {
                    array_push($servicos_prestados, $r2["id_servico"]);
                    array_push($ordem_servicos, $r2["ordem"]);
                }

            /*for ($i = 0; $i < $num_registos ; $i++)
            {
                $this->bd->moverRegisto($rs, $i);

                $servicos_prestados[$i] = $this->bd->obterValor($rs, "id_servico");
                $ordem_servicos[$i] = $this->bd->obterValor($rs, "ordem");
            }*/

            // Otteniamo i servizi della logia dove � localizzato l'ecra
    //		$servicos_loja = new ServicoPrestado();
    //		$resultado = $servicos_loja->LerDados($id_loja);
    //		$servicos_loja->Fechar();

            $_SESSION["sessao_campos"]["servicos_ecra"]["id"] = $servicos_prestados;
            $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"] = $ordem_servicos;
        }

        return "ok";
    }


    function obterServicos()
    {
        $sql = "SELECT * FROM servicos WHERE id_servico >0;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        for($i=0; $i< ($this->bd->obterNumRegistos($rs)); $i++)
        {
            $this->bd->moverRegisto($rs,$i);
            $_SESSION["sessao_campos"]["servicos"]["nome"][$i]=$this->bd ->obterValor($rs,"nome");
            $_SESSION["sessao_campos"]["servicos"]["id"][$i]=$this->bd ->obterValor($rs,"id_servico");
        }
        return "ok";
    }

    /*
		Fun��o de edi��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Editar($dados, $id)
    {
		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array("nome"=>"Nome","identificador" => "Identificador", "estado"=>"Estado", "local"=>"Local");

        if (is_array($id))
        {
            $sql = "UPDATE ecra SET ";

            $aux = array();

            if (isset($dados["change_estado"]))
            {
                array_push($aux, "estado=".$dados["estado"]);
            }
            if (isset($dados["change_local"]))
            {
                array_push($aux, "id_loja=".$dados["id_loja"]);
            }

            $sql .= implode(", ", $aux)." where id_ecra in (".implode(", ", $id).")";

            if (count($aux)) $this->bd->executarSQL($sql);

            if (isset($dados["change_servicos"]))
            {
                $sql = "DELETE FROM servicos_ecra WHERE id_ecra in (".implode(", ", $id).")";
                if(!$rs = $this->bd->executarSQL($sql)) return 0;

                $sql = "insert into servicos_ecra (id_ecra, id_servico, ordem) values ";

                $aux = array();
                foreach ($id as $idAux)
                {
                    if (is_array($dados["servicos_prestados"]))
                    {
                        foreach ($dados["servicos_prestados"] as $sp)
                        {
                            array_push($aux, "(".$idAux.", ".$sp.", ".(strlen($dados["ordem_servicos_".$sp])?$dados["ordem_servicos_".$sp]:"0").")");
                        }
                    }
                    else
                    {
                        array_push($aux, "(".$idAux.", ".$dados["servicos_prestados"].", ".(strlen($dados["ordem_servicos_".$dados["servicos_prestados"]])?$dados["ordem_servicos_".$dados["servicos_prestados"]]:"0").")");
                    }
                }

                $sql .= implode($aux, ",");
                if(!$rs = $this->bd->executarSQL($sql)) return 0;

                return "ok";
            }
        }
        else
        {
            if($dados["nome"] == "")
                $dados["nome"] = "null";
            else
                $dados["nome"] = "'".$dados["nome"]."'";

            if (!is_array($dados["servicos_prestados"])) $dados["servicos_prestados"] = array($dados["servicos_prestados"]);

            $sql = "SELECT id_loja FROM ecra WHERE id_ecra=".$id.";";

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
            //file_put_contents("/tmp/debug.txt","dati servizio ".$dados["nome"] ."\n",FILE_APPEND);
            $id_loja_antiga = $this->bd->obterValor($rs, "id_loja");

            if($id_loja_antiga != $dados["id_loja"])
            {
                $dados["modifica_loja"] = 1;
                $this->EscreveXMLSync($id, "remover");
            }


            $sql = "UPDATE ecra SET
                                                                    nome = " . $dados["nome"] . ",
                                                                    identificador = '" . $dados["identificador"] . "',
                                                                    id_loja = ". $dados["id_loja"] .",
                                                                    estado = ". $dados["estado"] ."
                                                            WHERE id_ecra = " . $id . " ;";

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
            // actualiza os servicos associados ao ecra caso seja necessario
            $sql = "SELECT id_servico FROM servicos_ecra WHERE id_ecra = " . $id . ";";
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            $sql = "DELETE FROM servicos_ecra WHERE id_ecra = $id";
            if(!$rs = $this->bd->executarSQL($sql)) return 0;

            $sql = "insert into servicos_ecra (id_ecra, id_servico, ordem) values ";
            if (is_array($dados["servicos_prestados"]))
            {
                $aux = array();
                foreach ($dados["servicos_prestados"] as $sp)
                {
                    array_push($aux, "(".$id.", ".$sp.", ".(strlen($dados["ordem_servicos_".$sp])?$dados["ordem_servicos_".$sp]:"0").")");
                }
                $sql .= implode($aux, ",");
            }
            else
            {
                $sql .= "(".$id.", ".$dados["servicos_prestados"].", ".(strlen($dados["ordem_servicos_".$dados["servicos_prestados"]])?$dados["ordem_servicos_".$dados["servicos_prestados"]]:"0").")";
            }
            if(!$rs = $this->bd->executarSQL($sql)) return 0;

            if($id_loja_antiga != $dados["id_loja"])
                $this->EscreveXMLSync($id, "inserir");
            else
                $this->EscreveXMLSync($id, "editar");

            $objecto = new LogAccao();

			$diff = my_array_diff_values($oldInfo,$newInfo,$labels);

			// Faz o mesmo para a tabela de servicos
			$servicosOld = $oldInfo['servicos_ecra'];
			$servicosNew = $aux;
			$diffServicos = my_array_diff_values2($servicosOld,$servicosNew);

			$msg = "<table><tr><td colspan=3 align=left><b>$newInfo[nome]</b></td></tr>";
			$msg .= action_msg_info($diff,false,'ecra');
			$msg .= action_msg_info($diffServicos,false,'ecra');
			$msg .= "</table>";

            $rs = $objecto->Inserir("Edição", "Ecrã", $msg);
            $objecto->fechar();
            return "ok";
        }
    }

    /*
		Fun��o de remo��o

		0 = Erro da BD
		true = Sucesso
    */
    function Remover($id)
    {
        /*
        ecra
        servicos_ecra
        */

        $this->EscreveXMLSync($id, "remover");

        $numEntradas = count($id);
        $nomes = array();
        $sql = "SELECT identificador FROM ecra WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_ecra = " . $id[$i] . " OR ";
        $sql .= "id_ecra = " . $id[0] . ";";


        if($rs = $this->bd->executarSQL($sql))
        {
            for($i = 0; $i < $numEntradas; $i++)
            {
                $this->bd->moverRegisto($rs,$i);
                array_push($nomes, $this->bd->obterValor($rs,"identificador"));
            }
        }
        else
            return 0;

        $sql = "delete from servicos_ecra where id_ecra='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_ecra='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from ecra where id_ecra='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_ecra='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $objecto = new LogAccao();
        for($i = count($nomes)-1; $i >= 0; $i--)
        {
            $rs = $objecto->Inserir("Remoção", "Ecrã", $nomes[$i]);
        }
        $objecto->fechar();
        return "ok";

        //~ $sql = "DELETE FROM ecra WHERE ";
        //~ for($i = count($id); $i > 1; $i--)
        //~ $sql .= "id_ecra = ". $id[$i-1] . " OR ";
        //~ $sql .= "id_ecra = ". $id[0] . ";";

        //~ if($rs = $this->bd->executarSQL($sql))
        //~ {
        //~ $objecto = new LogAccao();
        //~ for($i = count($nomes)-1; $i >= 0; $i--){
        //~ $rs = $objecto->Inserir("Remo��o", "Ecr�", $nomes[$i]);
        //~ }
        //~ $objecto->fechar();
        //~ return "ok";
        //~ }
        //~ else
        //~ return 0;
    }


    /*
		Procede � cria��o e escrita de um
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao)
    {

        if(!is_array($id))
            $id = array($id);

        $numEntradas = count($id);

        $sql = "SELECT * FROM ecra WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_ecra = " . $id[$i] . " OR ";
        $sql .= "id_ecra = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $documento = abreXMLSync();
        $raiz = $documento->firstChild;

        $loja = new Loja();
        $enderecos = array();

        $destinos = $documento->createElement("destinos");
        $raiz->appendChild($destinos);

        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0 ; $i < $numEntradas ; $i++)
        {
            $this->bd->moverRegisto($rs, $i);

            $enderecos = array_merge($enderecos, $loja->listaIpLojas($this->bd->obterValor($rs, "id_loja")));

            $no_ecra = $documento->createElement("ecra");
            $raiz->appendChild($no_ecra);

            $no_ecra->setAttribute("id", $this->bd->obterValor($rs, "id_ecra"));
            $no_ecra->setAttribute("accao", $accao);

            $valor = $this->bd->obterValor($rs, "nome");
            if(isset($valor))
            {
                $elemento = $documento->createElement("nome");
                $elemento->nodeValue = $valor;
                $no_ecra->appendChild($elemento);
            }

            $elemento = $documento->createElement("identificadorIpPorto");
            $elemento->nodeValue = $this->bd->obterValor($rs, "identificador");
            $no_ecra->appendChild($elemento);

            $elemento = $documento->createElement("idEstadoBalcao");
            $elemento->nodeValue = $this->bd->obterValor($rs, "estado");
            $no_ecra->appendChild($elemento);

            $elemento = $documento->createElement("idLoja");
            $elemento->nodeValue = $this->bd->obterValor($rs, "id_loja");
            $no_ecra->appendChild($elemento);
        }

        $enderecos = array_unique($enderecos);

        for($i = 0 ; $i < count($enderecos) ; $i++)
        {

            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);

        }

        fechaXMLsync($documento);

    }

    /*
		Fun��o de listagem

		0 = Erro da BD
		true = Sucesso
    */

    function Listar()
    {
        //$this->StatusRefresh();

        $sql = "SELECT e.id_ecra, e.nome, e.estado, l.nome loja
				FROM ecra e,  lojas l
				WHERE l.id_loja = e.id_loja ";

        if(getRequestValue("loja") != "")    // estado
            $sql .= "and e.id_loja = " . $_REQUEST["loja"] . " ";

        if(getRequestValue("estados_ecra") != "")  // estado
            $sql .= "and e.estado = " . $_REQUEST["estados_ecra"] . " ";

        if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= "ORDER BY " . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY e.nome ";

        if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";


        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $ecras = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($ecras, $row);

        $n = 1;
        $pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];

        $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
        $numPaginas = 1; // n�mero de p�ginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

        // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
        if(array_key_exists("pagina", $_REQUEST) && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
            $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', false) ." ". translate('word_ecras', false). " ".translate('word_registados_sistema', false) ."</div>";
            return;
        }

        // calculo do n�mero de p�ginas de registos
        if($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=ecras&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "") . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";
            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
            <tr>
                <td class='button_page' colspan='6'>";

                if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
                {
                    $pagAnterior = $_REQUEST["pagina"] - 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                }
                else
                {
                    $_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
                    $TEMPLATE_navigation .= "<div> < </div>";
                }

                while($n <= $numPaginas)
                {
                    if($n == $_REQUEST["pagina"])
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='current_page'>$n</div></a>";
                    else
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='other_page'>$n</div></a>";
                    $n++;
                }

                $n = ($_REQUEST["pagina"] - 1)*$numRegPag;
                $incremento = $n;

                if($_REQUEST["pagina"] < $numPaginas)
                {
                    $pagPosterior = $_REQUEST["pagina"] + 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
                }
                else
                {
                    if($numTuplos % $numRegPag != 0)
                        $numRegPag = $numTuplos % $numRegPag;
                    $TEMPLATE_navigation .= "<div> > </div>";
                }

        $TEMPLATE_navigation .= "		</td>
        </tr>";

        echo "<tr class='column_row'>";

        if ($_SESSION["sessao_perms"]["all_perm"] == 1)
        {
            echo "<td width='18' style='padding-left:8px' >" .  translate('word_select') . "</td>";
        }

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"estado") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=estado&ordem=0'><div>". translate('word_state', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=estado&ordem=1'><div>". translate('word_state', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=estado&ordem=0'><div>". translate('word_state', true)."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"loja") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=1'><div>" .translate('word_local', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0'><div>" .translate('word_local', true). "</div></a></td>";

        echo "<td width='155'>". translate('word_operations', true)."</td>
				</tr>";



        //while($n < ($numRegPag + $incremento))
        //{
        //    $this->bd->moverRegisto($rs,$n);
        for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {

            echo"<tr class='form-data-tr'>";
            if ($_SESSION["sessao_perms"]["all_perm"] == 1)
            {
              echo "<td class='form-data-td'>
                      <label class='custom-check-container'>
                          <input name='grupo' type='checkbox' value='" . $ecras[$i]["id_ecra"] /*$this->bd->obterValor($rs,"id_ecra")*/ . "' onClick='selectEntireRow(this)'>
                          <span class='custom-checkmark'></span>
                      </label>
                  </td>";
            }
            echo   "<td class='form-data-td'>" . $ecras[$i]["nome"] /*$this->bd->obterValor($rs,"nome")*/ . "</td>
					<td class='form-data-td'>" . obterNomeGeral($ecras[$i]["estado"] /*$this->bd->obterValor($rs,"estado")*/,"id_estados_ecra", "nome", "estados_ecra") . "</td>
					<td class='form-data-td'>" . $ecras[$i]["loja"] /*$this->bd->obterValor($rs,"loja")*/ . "</td>
					<td class='form-data-td'>";

            if( $_SESSION["sessao_perms"]["perm_ecra"] == 2 )
            {

                echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=ecras&id=" . $ecras[$i]["id_ecra"] /*$this->bd->obterValor($rs,"id_ecra")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>";

                if ($_SESSION["sessao_perms"]["all_perm"] == 1)
                    echo "<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=ecras&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ?$_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") ."&id=" . $ecras[$i]["id_ecra"] /*$this->bd->obterValor($rs,"id_ecra")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";

            } else
            {

                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=ecras&id=" . $ecras[$i]["id_ecra"] /*$this->bd->obterValor($rs,"id_ecra")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
            }
            echo	"</td>
				</tr>";

            //$n++;
        }

        //#3 - Re-design present NAVIGATION after table
        echo $TEMPLATE_navigation;

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        if ($_SESSION["sessao_perms"]["all_perm"] == 1)
        {
            echo	"<tr>
					<td class='button'>";
            if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_entidade"] == 2) {
              echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
            }
						echo "<div class='button-thin-green' onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
      						<div class='button-thin-green' onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
      						<div class='button-thin-green' onClick='removerMarcados(this);'>". translate('word_remove_selected', true)."</div>
      						<div class='button-thin-green' onClick='editarMarcados(\"ecras\");'>". translate('word_edit_selected', true)."</div>
					</td>
				</tr>";
        }

        echo	"</table>
		</form>";
    }

    function GetEcras($where="")
    {
        //$this->StatusRefresh();

        $sql = "select e.id_loja, l.nome local, e.id_ecra, e.nome ecra, e.identificador, e.data_hora desde,
				if(isnull(data_hora) || timestampdiff(minute, data_hora, now())>=1,2,1) as status_id, e.estado as estado_ecra
				from ecra e
				inner join lojas l on l.id_loja=e.id_loja";
        if (strlen($where)) $sql .= " where ".$where;
        $res = $this->bd->executarSQL($sql);

        $ecras = array();
        while ($row = $this->bd->obterRegisto($res))
        {
            array_push($ecras, $row);
        }
        return $ecras;
    }

    function StatusRefresh()
    {
        $sql = "update ecra set estado=if(isnull(data_hora) || timestampdiff(minute, data_hora, now())>1,2,1)";
        $this->bd->executarSQL($sql);
    }

    /*
		Destrutor da classe

		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }
}
?>
