<?php
	session_start();

	require_once("../config.inc.php");

	if($_SESSION["sessao_autenticado"] == 0)
		header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);

	if($_SESSION["sessao_perms"]["perm_ecra"] < 2)
		header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR ."/" );
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Zqueue - <?php   echo  translate("word_insertion", true) ?> <?php   echo  translate("word_de", true) ?>  <?php   echo  translate("word_ecra", true) ?></title>

<link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">

<!-- Re-design -->
<link rel="stylesheet" type="text/css" media="screen" href="../css/components/custom-form.css">

<script type="text/javascript" src="<?php   echo getPathScriptJS("menu.js"); ?>"></script>
<script type="text/javascript" src="<?php   echo getPathScriptJS("validacoes.js"); ?>"></script>
<script type="text/javascript" src="<?php   echo getPathScriptJS("funcoes.js"); ?>"></script>
<script type="text/javascript" src="<?php   echo getPathScriptJS("custom-dropdown.js"); ?>"></script>

</head>
<body>
<?php
	include("../cabecalho.php");
?>

<div class="full_area">
	<!-- Title + Description -->
	<div class="form-title">
		<h2 class="text-bold text-green-light"><?php   echo   translate('word_insert', true)  ?> <?php   echo  translate('word_ecra', true)?></h2>

		<!-- Extra description -->
		<div class="form-extra-desc text-bold text-gray-dark">
			<?php   echo  translate('word_por_favor_preencha_seguintes_campos_obrigatorios', false) ?>
			<font class="text-green-light">* </font>
			<?php   echo  translate('word_sao_preencimento_obrigatorio', false) ?>
		</div>
	</div>

	<!-- Main Table Content -->
	<div class="form-table-container">

		<div class="form-flex-container">
			<!-- form fields -->
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td width="">
						<form class="form_template" action="../accoes_intermedias/accaoInserir.php?modulo=ecras" method="post">
							<!-- Main Form + Checks(there are no checks) -->
							<div class="form_template_flex_container">
								<!-- Form main table -->
								<table cellspacing="0" cellpadding="0">
									<!-- Name -->
									<tr>
										<!-- field name -->
										<td class="formname_space">
											<font class="text-green-light">* </font><?php   echo  translate('word_name', true) ?>:
										</td>
										<!-- field input -->
										<td class="input_space">
											<input id="nome" name="nome" type="text" maxlength="128" size="52" value="<?php  echo @$_SESSION["sessao_campos"]["nome"]; ?>">

											<!-- Error message -->
											<span id="msg_nome" class="error_msg">&nbsp;</span>
										</td>
									</tr>

									<!-- Identifier -->
									<tr>
										<!-- field name -->
										<td class="formname_space">
											<font class="text-green-light">* </font><?php   echo  translate('word_identifier', true) ?>:
										</td>
										<!-- field input -->
										<td class="input_space">
											<input id="identificador" name="identificador" placeholder="(<?php   echo  translate('word_addressIP') ?>)" type="text" maxlength="30" size="52" value="<?php  echo @$_SESSION["sessao_campos"]["identificador"]; ?>">

											<!-- Error message -->
											<span id="msg_identificador" class="error_msg">&nbsp;</span>
										</td>
									</tr>

									<!-- State (dropdown) -->
									<tr>
										<!-- field name -->
										<td class="formname_space">
											<font class="text-green-light">* </font><?php   echo  translate("word_state", true) ?>:
										</td>
										<!-- field input -->
										<td class="input_space">
											<div class="custom-select">
												<?php  construirListaGeral("estado", "estados_ecra", "id_estados_ecra", "nome", @$_SESSION["sessao_campos"]["estado"]); ?>
											</div>
											<!-- Error message -->
											<span id="msg_estado" class="error_msg">&nbsp;</span>
										</td>
									</tr>

									<!-- Local (dropdown) -->
									<tr>
										<!-- field name -->
										<td class="formname_space">
											<font class="text-green-light">* </font><?php   echo  translate("word_local", true) ?>:
										</td>
										<!-- field input -->
										<td class="input_space">
											<div class="custom-select">
												<?php  construirListaGeral("id_loja", "lojas", "id_loja", "nome", @$_SESSION["sessao_campos"]["id_loja"],"-- ".translate("word_choose")." --", "href=inserir."); ?>
											</div>
											<!-- Error message -->
											<span id="msg_id_loja" class="error_msg">&nbsp;</span>
										</td>
									</tr>

								</table>

							</div>

							<!-- Selection table and buttons -->
							<table cellspacing="0" cellpadding="0">
								<!-- Selectable list -->
								<tr>
									<td class="formname_space form_align_top" style="padding-top:35px">
										<?php   echo  translate('word_servicos_associados', true) ?> <?php   echo  translate('word_dispensador', true)?> por entidade:
									<td>
										<!-- Selectable list -->
										<div class="form-selectable-table">
											<table id="entidade_servico" class="data_table" cellspacing="0">
													<thead>
															<tr class="column_row">
																<td class="center"></td>
																<td class="left"><?php   echo  translate('word_entity', true) ?></td>
																<td class="left"><?php   echo  translate("word_service", true) ?></td>
																<td class="center"><?php   echo  translate("word_order", true) ?></td>
															</tr>
													</thead>
													<tbody>
																<?php 

																$obj = new Servico();
																$servicos_entidade = $obj->obterDados();
																$num_servicos = count($servicos_entidade);

																for ($i=0; $i<$num_servicos; $i++)
																{
																	$id_servico = $servicos_entidade[$i]["id_servico"];
																	?>
																	<tr class="form-data-tr">
																		<td class="form-data-td center">
																			<label class='custom-check-container'>
																					<input 	name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>"
																									type="checkbox"
																									value="<?php   echo $id_servico; ?>"
																									onClick='selectEntireRow(this)'>
																					<span class='custom-checkmark'></span>
																			</label>
																		</td>
																		<td class="form-data-td left"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
																		<td class="form-data-td left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
																		<td class="form-data-td center"><input class="table-input" name="ordem_servicos_<?php   echo $id_servico; ?>" type="input" value="" size="5" maxlength="2" value="" onkeypress="return NumbersOnly(event,this)"/></td>

																	</tr>
																<?php  } ?>

													</tbody>
											</table>

										</div>

									</td>
								</tr>

								<!-- Table errors -->
								<tr class="form-error-session">
									<td></td>
									<td><span id="msg_servicos_prestados[]" class="error_space">&nbsp;</span></td>
								</tr>

								<!-- Buttons -->
								<tr class="form-tr-buttons-container">
									<td class="button">
										<div class="button-full-green" onClick="validaFormEcra(1 , <?php  echo $num_servicos;?>);"> <?php   echo  translate('word_insert', true) ?></div>
									</td>
									<td class="button">
										<div class="button-thin-green" onClick="limpaFormulario();"><?php   echo  translate('word_clean', true) ?></div>
										<a href="index.php"><div class="button-thin-green"><?php   echo  translate('word_cancel', true) ?></div></a>
									</td>
								</tr>

							</table>

						</form>

					</td>
				</tr>
			</table>

		</div>

		<!-- Form Error -->
		<div class="form-error-session">
			<span id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></span>
		</div>


	</div>

</div>


<table class="full_area" cellpadding="0" cellspacing="0" style="display:none">
  	<tr>
    	<td>&nbsp;</td>
    	<td class="content">
			<table class="title_space" cellspacing="0" cellpadding="0">
			<tr>
				<td class="module_space" width="380">
					<?php   echo   translate('word_insert', true)  ?>  <?php   echo  translate("word_ecra", true) ?> </td>
				<td class="function_space" width="110">
				</td>
				<td class="function_space" width="120">
				</td>
				<td class="function_space" width="160">
					<a class="function" href="./"><div><?php   echo  translate('word_prev', true) ?></div><img alt="Recuar" src="../img/buttons/button_back.gif"></a>
					<div class="function" onClick="validaFormEcra(0 , 0);"><img alt="Avan&ccedil;ar" src="../img/buttons/button_forward.gif"><div><?php   echo  translate('word_next', true) ?></div></div>
				</td>
			</tr>
			</table>
			<table width="770" cellspacing="0" cellpadding="0">
				<tr>
					<td class="bg_form_left">&nbsp;</td>
					<td width="758">
						<form class="form_template" action="../accoes_intermedias/accaoInserir.php?modulo=ecras" method="post">
							<table id="form_table" cellspacing="0" cellpadding="0">
								<tr>
									<td class="question_space" colspan="2">
										<?php   echo  translate('word_por_favor_preencha_seguintes_campos_obrigatorios', false) ?> <font class="error_msg">* </font> <?php   echo  translate('word_sao_preencimento_obrigatorio', false) ?>
									</td>
								</tr>
								<tr>
									<td class="formname_space">
										<?php   echo  translate('word_name', true) ?>
									</td>
									<td class="input_space">
										<input id="nome" name="nome" type="text" maxlength="128" size="52" value="<?php  echo $_SESSION["sessao_campos"]["nome"]; ?>">
										<span id="msg_nome" class="error_msg">&nbsp;</span>
									</td>
								</tr>
								<tr>
									<td class="formname_space">
										<font class="error_msg">* </font> <?php   echo  translate('word_identifier', true) ?>
									</td>
									<td class="input_space">
										<input id="identificador" name="identificador" type="text" maxlength="30" size="52" value="<?php  echo $_SESSION["sessao_campos"]["identificador"]; ?>">
										<font class="info_msg">(<?php   echo  translate('word_addressIP') ?>)</font>
										<span id="msg_identificador" class="error_msg">&nbsp;</span>
									</td>
								</tr>
								<tr>
									<td class="formname_space">
										<font class="error_msg">* </font><?php   echo  translate('word_state', true) ?>
									</td>
									<td class="input_space">
										<?php  construirListaGeral("estado", "estados_ecra", "id_estados_ecra", "nome", $_SESSION["sessao_campos"]["estado"]); ?>
										<span id="msg_estado" class="error_msg">&nbsp;</span>
									</td>
								</tr>
								<tr>
									<td class="formname_space">
										<font class="error_msg">* </font><?php   echo  translate('word_local', true) ?>
									</td>
									<td class="input_space">
										<?php  construirListaGeral("id_loja", "lojas", "id_loja", "nome", $_SESSION["sessao_campos"]["id_loja"],"-- ".translate("word_choose")." --", "href=inserir."); ?>
										<span id="msg_id_loja" class="error_msg">&nbsp;</span>
									</td>
								</tr>
								<tr>
									<td></td>
									<td>
										<br/>
										<table id="entidade_servico" class="select_list" cellspacing="0">
											<caption>
												<font class='error_msg'>* </font>Servi&ccedil;os associados ao ecra
											</caption>
											<thead>
												<tr>
													<th class="left"><?php   echo  translate('word_entity', true) ?></th>
													<th class="left"><?php   echo  translate("word_service", true) ?></th>
													<th class="center"><?php   echo  translate("word_order", true) ?></th>
													<th class="center"></th>
												</tr>
											</thead>
											<tbody>
												<?php 

												$obj = new Servico();
												$servicos_entidade = $obj->obterDados();
												$num_servicos = count($servicos_entidade);

												for ($i=0; $i<$num_servicos; $i++)
												{
													$id_servico = $servicos_entidade[$i]["id_servico"];
													?>
													<tr>
														<td class="left"><?php   echo $servicos_entidade[$i]["entidade"]; ?></td>
														<td class="left"><?php   echo $servicos_entidade[$i]["nome"]; ?></td>
														<td class="center"><input name="ordem_servicos_<?php   echo $id_servico; ?>" type="input" value="" size="5" maxlength="2" value="" onkeypress="return NumbersOnly(event,this)"/></td>
														<td class="center"><input name="servicos_prestados<?php   if ($num_servicos > 1) echo "[]"; ?>" type="checkbox" value="<?php   echo $id_servico; ?>"/></td>
													</tr>
													<?php 
												}
												?>
											</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<span id="msg_servicos_prestados[]" class="error_msg">&nbsp;</span>
										<div id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></div>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<div id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></div>
									</td>
								</tr>
								<tr>
									<td class="button" colspan="2">
										<div onClick="validaFormEcra(1 , <?php  echo $num_servicos;?>);"> <?php   echo  translate('word_insert', true) ?></div>
										<div onClick="limpaFormulario();"><?php   echo  translate('word_clean', true) ?></div>
										<a href="index.php"><div><?php   echo  translate('word_cancel', true) ?></div></a>
									</td>
								</tr>
							</table>
						</form>
					</td>
					<td class="bg_form_right">&nbsp;</td>
				</tr>
				<tr>
					<td class="bg_form_bottom" colspan="3">&nbsp;</td>
				</tr>
			</table>
		</td>
		<td>&nbsp;</td>
	</tr>
</table>

<?php 
	$_SESSION["sessao_msg"] = "&nbsp;"; // limpa a var�avel que guarda a �ltima mensagem de erro
?>

<?php
	include("../rodape.php");
?>

<script>
	// Initialize custom-dropdowns
	(function() {
		 initializeDropdowns();

	})();
</script>

</body>
</html>
