<?php
	
/* Classe de Gestão de Serviços Prestados numa entidade */

class EntidadeAssociada extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function EntidadeAssociada() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Função de inserção
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados, $id, $documento = null)
	{
        //~ debug(print_r($dados, true));
        if (!is_array($dados))
        {
            $aux = array();
            array_push($aux, $dados);
            unset($dados);
            $dados = $aux;
        }

        
		$ids = array();
		
		for($i=0 ; $i < count($dados) ; $i++){
			$sql = "INSERT INTO lojas_entidades(id_loja, id_entidade)
					VALUES (".$id.",".$dados[$i].");";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "SELECT MAX(id_lojas_entidades) FROM lojas_entidades;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids, $this->bd->obterValor($rs, 0));
			
		}
		
//		$this->EscreveXMLSync($ids, "inserir", $documento);
		
		return "ok";
	}

	/*
		Função de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$sql = "SELECT id_entidade, nome
				FROM entidades 
				WHERE id_entidade > 0;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		
		$entidades = array();
		$entidades["nome"] = array();
		$entidades["id"] = array();
			
		for ($i = 0; $i < $num_registos ; $i++){
			//$this->bd->moverRegisto($rs, $i);
			
			$entidades["nome"][$i] = $dados[$i]["nome"]; /*$this->bd->obterValor($rs, "nome");*/
			$entidades["id"][$i] = $dados[$i]["id_entidade"]; /*$this->bd->obterValor($rs, "id_entidade");*/
		}
		
		$_SESSION["sessao_campos"]["entidades"] = $entidades;
		
		$sql = "SELECT id_entidade
				FROM lojas_entidades
				WHERE id_loja = ".$id.";";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		
		$lojas_entidades = array();
		$dados2 = array();
		while ($row = $this->bd->obterRegisto($rs)) array_push($dados2, $row);

		$num_registos = $this->bd->obterNumRegistos($rs);
		$entidades_rel = array();		
		for ($i = 0; $i < $num_registos ; $i++){
			//$this->bd->moverRegisto($rs, $i);
			
			//$lojas_entidades[$i] = $this->bd->obterValor($rs, "id_entidade");
			$lojas_entidades[$i] = $dados2[$i]["id_entidade"];
		}
		
		$_SESSION["sessao_campos"]["lojas_entidades"]= $lojas_entidades;
		
		return "ok";
	}

	/*
		Função de edição
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id, $documento)
	{

	    if (!is_array($dados))
        {
            $aux = array();
            if ($dados) array_push($aux, $dados);
            unset($dados);
            $dados = $aux;
        }
        
        $sql = "delete from lojas_entidades where id_loja='" . $id . "'";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
            
        for($i=0 ; $i < count($dados) ; $i++){
			$sql = "INSERT INTO lojas_entidades(id_loja, id_entidade)
					VALUES (".$id.",".$dados[$i].");";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
        }
        
        return "ok";
            
		//~ $sql = "SELECT id_entidade FROM lojas_entidades WHERE id_loja=".$id.";";
		//file_put_contents("/tmp/debug.txt" , "\nsql   ".$sql , FILE_APPEND);
		//file_put_contents("/tmp/debug.txt" , "\nentidades   ".$dados , FILE_APPEND);
		//~ if(!$rs = $this->bd->executarSQL($sql))
			//~ return 0;
		
		//~ $existentes = array();
		//~ for ($i = $this->bd->obterNumRegistos($rs)-1 ; $i >= 0 ; $i--){
			//~ $this->bd->moverRegisto($rs, $i);
			//~ array_push($existentes, $this->bd->obterValor($rs,"id_entidade"));
		//~ }
		
		
		
        //~ for($i=0 ; $i < count($dados) ; $i++){
			//~ $sql = "INSERT INTO lojas_entidades(id_loja, id_entidade)
					//~ VALUES (".$id.",".$dados[$i].");";

			//~ if(!$rs = $this->bd->executarSQL($sql))
				//~ return 0;
        
		//~ $criar = array_merge(array_diff($dados, $existentes));
		//~ $ids_lojas_entidades = array();
		
		//~ for($i=0 ; $i < count($criar) ; $i++){
			//~ $sql = "INSERT INTO lojas_entidades(id_loja, id_entidade)
					//~ VALUES (".$id.",".$criar[$i].");";

			//~ if(!$rs = $this->bd->executarSQL($sql))
				//~ return 0;
				
			//~ $sql = "SELECT MAX(id_lojas_entidades) FROM lojas_entidades;";
			
			//~ if(!$rs = $this->bd->executarSQL($sql))
				//~ return 0;
				
			//~ array_push($ids_lojas_entidades, $this->bd->obterValor($rs, 0));
			
		//~ }
		
//~ //		$this->EscreveXMLSync($ids_lojas_entidades, "inserir", $documento);
		
		//~ $apagar = array_merge(array_diff($existentes, $dados));
		
		//~ $ids_lojas_entidades = array();
		
		//~ for($i=0 ; $i < count($apagar) ; $i++){
			//~ $sql = "SELECT id_lojas_entidades FROM lojas_entidades
					//~ WHERE id_loja =".$id."
					//~ AND id_entidade=".$apagar[$i].";";
			
			//~ if(!$rs = $this->bd->executarSQL($sql))
				//~ return 0;
				
			//~ array_push($ids_lojas_entidades, $this->bd->obterValor($rs, "id_lojas_entidades"));			
		//~ }
		
	//~ //	$this->EscreveXMLSync($ids_lojas_entidades, "remover", $documento);
		
		//~ for($i=0 ; $i < count($ids_lojas_entidades) ; $i++){
			//~ echo $sql = "DELETE FROM lojas_entidades
					//~ WHERE id_lojas_entidades =".$ids_lojas_entidades[$i].";";
			
			//~ if(!$rs = $this->bd->executarSQL($sql))
				//~ return 0;		
		//~ }
		
		//~ return "ok";
	}
	
	/*
		Procede à criação e escrita de um 
		ficheiro XML para as alterações feitas
		serem replicadas pelas base de dados necessárias
	*/
	
	function EscreveXMLSync($id, $accao, $documento){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM lojas_entidades WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_lojas_entidades = " . $id[$i] . " OR ";
		$sql .= "id_lojas_entidades = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$raiz = $documento->firstChild;
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$no_servico_prestado = $documento->createElement("EntidadeAssociada");
			$raiz->appendChild($no_servico_prestado);
			
			$no_servico_prestado->setAttribute("id", $this->bd->obterValor($rs, "id_lojas_entidades"));
			$no_servico_prestado->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("idServico");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_entidade");
			$no_servico_prestado->appendChild($elemento);
			
			$elemento = $documento->createElement("idEntidade");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_entidade");
			$no_servico_prestado->appendChild($elemento);
			
			$valor = $this->bd->obterValor($rs, "promocao_0");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao0");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_1");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao1");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_2");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao2");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_3");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao3");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_4");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao4");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_5");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao5");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_6");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao6");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
		}
		
	}
		
	function obterEntidadeBalcao($id){
		$sql = "SELECT le.id_entidade FROM lojas_entidades le, balcoes b WHERE le.id_loja = b.id_loja AND b.id_balcao = ".$id.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		 
		$this->bd->moverRegisto($rs , 0);
		$_SESSION["sessao_campos"]["entidade"] = $this->bd->obterValor($rs , "id_entidade");		
	
	}	
		
			
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>
