<?php

class Estatisticas extends AcessoBD {
	var $bd;
	var $language;

	/**
		* Construtor da classe
		* 0 = Erro da BD
		*/
	function Estatisticas()	{
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD(NOME_SERVIDOR, USERNAME, PASSWORD, NOME_BD); // Se falhar retorna 0
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD, $LANG;
		$this->language =  $LANG;
		//$this->bd = new AcessoBD();
		//return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		return $this->bd = new AcessoBD($conn);

	}

	function getNewSessionStatisticId($statsType){

		if(session_id() == ''){
			session_start();
		}

		// ultra mega unique ssid with 32 characters :D
		$ssid = md5(uniqid(rand(), true));

		$stats = array(
			"type" => $statsType,
			"title" => $statsType,
			"stores" => array(
					"filter" => "all", // can be: all, filter or hide (and filter)
					"values" => ""
				),
			"entities" => array(
					"filter" => "all", // can be: all, filter, hide (and filter)
					"values" => ""
				),
			"services" => array(
					"filter" => "all", // can be: all, filter, hide (and filter)
					"values" => ""
				),
			"employes" => array(
					"filter" => "all", // can be: all, filter, hide (and filter)
					"values" => ""
				),
			"dates" => array(
					"period" => "lastMonth", // can be: lastMonth, lastYear, lastWeek, lastDay or custom
					"from" => "",
					"to" => date('Y-m-d'),
					"frequency" => "day" // can be: hour, day, month or year
				)
			);

		switch($statsType){
			case 'servicesAvgMaxWaitTime':
				$stats["title"] = translate("word_tempos_medios_maximos_espera_min_por")." ". translate("word_service", true);
				//$stats["entities"]["filter"] = "hide";
				break;
			case 'servicesAvgMaxAttendanceTime':
				$stats["title"] = translate("word_tempos_medios_maximos_atendimento_por")." ". translate("word_service", true);
				//$stats["entities"]["filter"] = "hide";
				break;
			case 'servicesTicketsNumber':
				$stats["title"] = translate("word_numero_senhas_atendidas_desistidas_por")." ". translate("word_service", true);
				//$stats["entities"]["filter"] = "hide";
				break;
			case 'employesAvgMaxAttendanceTime':
				$stats["title"] = translate("word_tempos_medios_maximos_atendimento_por")." ". translate("word_costumer", false);
				//$stats["entities"]["filter"] = "hide";
				break;
			case 'employesTicketsNumber':
				$stats["title"] = translate("word_numero_senhas_atendidas_desistidas_por")." ". translate("word_costumer", false);
				//$stats["entities"]["filter"] = "hide";
				break;
		}

		$_SESSION['statistics'][$ssid] = $stats;

		return $ssid;
	}

	function drawSelectionData($ssid){
		$stats = $_SESSION['statistics'][$ssid];

		$html = "";

		// data selection
		$toShow = array(
			"stores" => translate("word_menu_locations", true),//"Stores",
			//"entities" => "Entidades",
			"services" => translate("word_menu_services", true), //"Services",
			"employes" => translate("word_menu_employees", true), //"Employees"
			);
		$tables = array(
			"stores" => "lojas",
			"entities" => "entidades",
			"services" => "servicos",
			"employes" => "empregados"
			);

		$filters = array(
			"stores" => "",
			"entities" => "",
			"services" => "",
			"employes" => ""
		);

		// get filtered services
		/*if($stats['entities']['values'] != '' OR $stats['stores']['values'] != ''){
			$employesArray = array();
			if($stats['stores']['values'] != ''){
				$sql = "SELECT * FROM local_colaborador WHERE id_local IN (" . $stats['stores']['values'] . ")";
				$res = $this->bd->executarSQL($sql)->GetRows();
				foreach($res AS $row){
					$employesArray[] = $row['id_colaborador'];
				}
			}

			if($stats['entities']['values'] != ''){
				$sql = "SELECT * FROM entidade_colaborador WHERE id_entidade IN (" . $stats['entities']['values'] . ")";
				$res = $this->bd->executarSQL($sql)->GetRows();
				foreach($res AS $row){
					if(!in_array($row['id_colaborador'], $employesArray)){
						$employesArray[] = $row['id_colaborador'];
					}
				}
			}

			$filters['stores'] = implode(',', $employesArray);
		}*/

		// get filtered employes
		if($stats['entities']['values'] != '' OR $stats['stores']['values'] != ''){
			$employesArray = array();
			if($stats['stores']['values'] != ''){
				$sql = "SELECT * FROM local_colaborador WHERE id_local IN (" . $stats['stores']['values'] . ")";
				//$res = $this->bd->executarSQL($sql)->GetRows();
				$res = $this->bd->getRows($sql);
				foreach($res AS $row){
					$employesArray[] = $row['id_colaborador'];
				}
			}

			if($stats['entities']['values'] != ''){
				$sql = "SELECT * FROM entidade_colaborador WHERE id_entidade IN (" . $stats['entities']['values'] . ")";
				//$res = $this->bd->executarSQL($sql)->GetRows();
				$res = $this->bd->getRows($sql);
				foreach($res AS $row){
					if(!in_array($row['id_colaborador'], $employesArray)){
						$employesArray[] = $row['id_colaborador'];
					}
				}
			}

			$filters['employes'] = implode(',', $employesArray);
			//var_dump($employesArray); 
		}

		// filter stores to a non-superuser
		if(getSessionValue('super_user') != 1){

			$storesArray = array();

			$sql = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql)->GetRows();
			$res = $this->bd->getRows($sql);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$filters['stores'] = implode(',', $storesArray);
		}


		$cols = 1;

		$script = "";
		$html .= '<td class="formname_space">'. translate('word_select', true) . ':</td>';

		foreach($toShow AS $node => $label){

			$toAdd = "";
			$extra = "";
			/*var_dump($stats[$node]['values']);
			$number = devolveNumeroTotal($tables[$node], $filters[$node]);
			$selected = $number;
			if($stats[$node]['values'] != ''){
				$selected = count(explode(',', $stats[$node]['values']));
			}*/
//			$hide = "";
//			switch($stats[$node]['filter']){
//				case 'hide':
//				$text = "N&atilde;o se encontra vis&iacute;vel!";
//				$extra = "&nbsp;<img width='15' height='15' src='../img/warning.png' alt='$text' title='$text'/>";
//				$hide = "checked";
//				break;
//			}
			/*$toAdd = "<td><div class='select__trigger'><a id='dataSelection" . $cols . "_v_toggle' style='padding-right: 15px;' href='#' width='80px'>$label <font class='info_msg'>($selected/$number)$extra</font></a><div class='arrow'></div></div></td>";
			$html .= "&nbsp;&nbsp;&nbsp;&nbsp;$toAdd";
			*/
			// html to change selection data
			$functionName = "dataSelection" . $cols ."_v_toggleDump";
			//$functionHtml = "<table width=\"100%\"><tr>";
			//$functionHtml .= "<td class=\"form-extra-desc text-bold text-gray-dark\">" . str_replace('$label', $label, translate('word_estatisticas_escolher_filtro', true)) . ": </td>";
			//$functionHtml .= "</tr><tr>";

			//$functionHtml .= "<td>" . construirMultipleSelect($node, $label, "", $filters[$node]) . "</td>";
			//echo $node;
			//var_dump($stats);
			$functionHtml = "<td>" . construirMultipleSelectNewDropDown(true, $functionName, $node, $label, "", $filters[$node], $cols, $stats[$node]['values'] ) . "</td>";

			//$functionHtml .= "</tr><tr><td>&nbsp;</td>";
			//$functionHtml .= "</tr><tr>";
			//$functionHtml .= "<input id=\"hide_$node\" type=\"checkbox\" name=\"hide_$node\" value=\"$node\" $hide /> N&atilde;o mostrar nas tabelas";
			//$functionHtml .= "</tr></table>";

			$functionHtml .= "<input id=\"values_$node\" name=\"values_$node\" type=\"hidden\" value=\"\" />";

			$after = "";
			/*if($stats[$node]['values'] == ''){
				$after = "estatisticasAddListElement('$node', 'TODOS', 'TODOS');";
			}else{
				foreach(explode(',', $stats[$node]['values']) AS $elemFilter){
					$name = devolveNome($tables[$node], substr($tables[$node], 0, -1), $elemFilter);
					$after .= "estatisticasAddListElement('$node', '$elemFilter', '$name'); ";
				}
			}*/

			//$onSubmit = "fillValuesFromMultipleSelect('$node')";
			$onSubmit = " var selecao = []; jQuery(\"#$functionName a[selected='selected']\").map(function() { selecao.push( jQuery( this ).attr('value'));  }); ";
			$onSubmit .= "var selecao = selecao.filter(function(v){return v!==''});";
			$onSubmit .= "fillValuesFromMultipleSelectNew('$node', selecao)";
			$html .= $this->dumpJavascriptFormFunctionNew($functionName, $functionHtml, $node, $ssid, '', '', $after, $onSubmit);

			$cols++;
		}
		
		$title = "";
		switch($stats['dates']['frequency']){
			case 'year':
				$title = translate("word_estatisticas_frquencia_ano", true); //"Yearly";
				$selectInput = "year";
				break;
			case 'month':
				$title = translate("word_estatisticas_frquencia_mes", true); //"Monthly";
				$selectInput = "month";
				break;
			case 'day':
				$title = translate("word_estatisticas_frquencia_dia", true); //"daily";
				$selectInput = "day";
				break;
			case 'hour':
				$title = translate("word_estatisticas_frquencia_hora", true); //"Hourly";
				$selectInput = "hour";
				break;
		}
		$valores = ["year", "month", "day", "hour"];
		$labels = [translate("word_estatisticas_frquencia_ano", true), translate("word_estatisticas_frquencia_mes", true), translate("word_estatisticas_frquencia_dia", true), translate("word_estatisticas_frquencia_hora", true)];
		$functionName = "periodSelection2_v_toggleDump";
		$functionHtml = "<td>" . construirMultipleSelectNewDropDown(false, $functionName, "periodSelection2", $title, $valores, $labels, $cols, $title, $selectInput ) . "</td>";
		$functionHtml .= "<input id=\"frequency\" name=\"frequency\" type=\"hidden\" value=\"\" />";
		$onSubmit = " var selecao = []; jQuery(\"#$functionName a[selected='selected']\").map(function() { selecao.push( jQuery( this ).attr('value'));  }); ";
		$onSubmit .= "var selecao = selecao.filter(function(v){return v!==''});";
		$onSubmit .= "fillValuesFromMultipleSelectNewFrequency('frequency', selecao[0])";
		$html .= $this->dumpJavascriptFormFunctionNew($functionName, $functionHtml, 'frequencySelection', $ssid, '', '', $after, $onSubmit);

		//$html .= $script;

		/*$html .= '<td>';
		$html .= "<input class=\"dark-light\" type=\"checkbox\" id=\"dark-light\" name=\"dark-light\"/>";
  		$html .= "<label for=\"dark-light\"></label>";
  		$html .= "<div class=\"light-back\"></div>";
  		$html .= "<a href=\"https://front.codes/\" class=\"logo\" target=\"_blank\">";
		$html .= "<img src=\"https://assets.codepen.io/1462889/fcy.png\" alt=\"\">";
		$html .= "</a>";
		$html .= "<div class=\"sec-center\">";
	  	$html .= "<input class=\"dropdown\" type=\"checkbox\" id=\"dropdown\" name=\"dropdown\"/>";
	  	$html .= "<label class=\"for-dropdown\" for=\"dropdown\">Dropdown Menu <i class=\"uil uil-arrow-down\"></i></label>";
  		$html .= "<div class=\"section-dropdown\">";
  		$html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
		$html .= "<input class=\"dropdown-sub\" type=\"checkbox\" id=\"dropdown-sub\" name=\"dropdown-sub\"/>";
		$html .= "<label class=\"for-dropdown-sub\" for=\"dropdown-sub\">Dropdown Sub <i class=\"uil uil-plus\"></i></label>";
	  	$html .= "<div class=\"section-dropdown-sub\">";
	  	$html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
	  	$html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
	  	$html .= "</div>";
  		$html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
  		$html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
  		$html .= "</div>";
  		$html .= "</div>";
  		$html .= '</td>';*/
		return $html;
	}

	function drawPeriodDates($ssid){
		$stats = $_SESSION['statistics'][$ssid];

		$html = "";
		$script = "";
		$toAdd = "";

		//$html .= "<td class=\"formname_space\" style=\"width:75px !important;\">" . translate('word_estatisticas_periodo_tempo', true) . ":</td>";
		

		//$html  .= "<td><div class='select__trigger'>";

		switch($stats['dates']['period']){
			case 'lastYear':
				$toAdd .= "Last Year <font class='info_msg'>(" . $stats["dates"]["from"] . " <-> " . $stats["dates"]["to"] . ")</font>";
				break;
			case 'lastMonth':
				$toAdd .= "Last month <font class='info_msg'>(" . $stats["dates"]["from"] . " <-> " . $stats["dates"]["to"] . ")</font>";
				break;
			case 'lastWeek':
				$toAdd .= "Last week <font class='info_msg'>(" . $stats["dates"]["from"] . " <-> " . $stats["dates"]["to"] . ")</font>";
				break;
			case 'lastDay':
				$toAdd .= "Last day  <font class='info_msg'>(" . $stats["dates"]["from"] . " <-> " . $stats["dates"]["to"] . ")</font>";
				break;
			default:
				$toAdd .= "from " . $stats["dates"]["from"] . " to " . $stats["dates"]["to"];
		}
        /*$toAdd = "<a id='periodSelection1_v_toggle' style='padding-right: 15px;' href='#'>$toAdd</a>";        
        $html .= $toAdd;
        $html .= "<div class='arrow'></div></div></td>";
		*/
		// html to change dates
		$functionName = "periodSelection1_v_toggleDump";
		//$functionHtml = "<table width=\"100%\"><tr>";
		//$functionHtml .= "</tr><tr>";
		$functionHtml .= "<td class=\"formname_space\" >".translate('word_estatisticas_periodo_tempo', true).":</td>";
		//$functionHtml .= "<td class=\"input_space\" >Start date: ";
		$functionHtml .= "<td>".translate('word_data_start', true).": ";
		$functionHtml .= "<input id=\"dateInicio\" type=\"text\" name=\"dateInicio\" maxlength=\"10\" size=\"11\" lang=\"" . $this->language . "\" value=\"" . $stats["dates"]["from"] . "\" />";
		$functionHtml .= "&nbsp;<a style=\"vertical-align: sub;\" href=\"javascript:var calInicio = new calendar1(document.forms['form_$functionName'].elements['dateInicio']); calInicio.year_scroll = true; calInicio.time_comp = false; calInicio.popup();\">";
		$functionHtml .= "<img src=\"../img/icons_zqueue/definir_datas_20x15.png\" width=\"16\" height=\"16\" border=\"0\" alt=\"" . translate('word_estatisticas_aceder_calendario', true) . "\"></a>";
		//$functionHtml .= "&nbsp;<font class=\"info_msg\">(aaaa-mm-dd)</font></td>";
		$functionHtml .= "</td>";

		//$functionHtml .= "<td class=\"input_space\" >End Date: ";
		$functionHtml .= "<td style=\"padding-left: 15px;\" >".translate('word_data_end', true).": ";		
		$functionHtml .= "<input id=\"dateFim\" type=\"text\" name=\"dateFim\" maxlength=\"10\" size=\"11\" lang=\"" . $this->language  . "\" value=\"" . $stats["dates"]["to"] . "\" />";
		$functionHtml .= "&nbsp;<a style=\"vertical-align: sub;\" href=\"javascript:var calFim = new calendar1(document.forms['form_$functionName'].elements['dateFim']); calFim.year_scroll = true; calFim.time_comp = false; calFim.popup();\">";
		$functionHtml .= "<img src=\"../img/icons_zqueue/definir_datas_20x15.png\" width=\"16\" height=\"16\" border=\"0\" alt=\"" . translate('word_estatisticas_aceder_calendario', true) . "\"></a>";
		//$functionHtml .= "&nbsp;<font class=\"info_msg\">(aaaa-mm-dd)</font></td>";
		$functionHtml .= "</td>";

		//$functionHtml .= "</tr></table>"; 
		$script .= $this->dumpJavascriptFormFunction($functionName, $functionHtml, "periodSelection", $ssid, "validaFormPeriodSelectionDatas()");

		//$html .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
		/*$html .= "<td class=\"formname_space\" style=\"width:116px !important;\">" . translate('word_estatisticas_frequencia_tempo', true) . ": </td>";
		$toAdd = "";
		$selectInputYear = "";
		$selectInputMonth = "";
		$selectInputDay = "";
		$selectInputHour = "";

		$html  .= "<td><div class='select__trigger'>";
		switch($stats['dates']['frequency']){
			case 'year':
				$toAdd .= "Yearly";
				$selectInputYear = "checked";
				break;
			case 'month':
				$toAdd .= "Monthly";
				$selectInputMonth = "checked";
				break;
			case 'day':
				$toAdd .= "daily";
				$selectInputDay = "checked";
				break;
			case 'hour':
				$toAdd .= "Hourly";
				$selectInputHour = "checked";
				break;
		}
		$toAdd = "<a id='periodSelection2_v_toggle' style='padding-right: 42px;' href='#'>$toAdd</a>";

		// html to change frequency
		$functionName = "periodSelection2_v_toggleDump";
		$functionHtml = "<table width=\"100%\"><tr>";
		$functionHtml .= "</tr><tr>";

		$functionHtml .= "<td class=\"input_space\">";
		$functionHtml .= "<input type=\"radio\" name=\"frequency\" value=\"hour\" $selectInputHour> " . translate('word_estatisticas_frquencia_hora', true) . "&nbsp;&nbsp;&nbsp;&nbsp;";
		$functionHtml .= "<input type=\"radio\" name=\"frequency\" value=\"day\" $selectInputDay> " . translate('word_estatisticas_frquencia_dia', true) . "&nbsp;&nbsp;&nbsp;&nbsp;";
		$functionHtml .= "<input type=\"radio\" name=\"frequency\" value=\"month\" $selectInputMonth> " . translate('word_estatisticas_frquencia_mes', true) . "&nbsp;&nbsp;&nbsp;&nbsp;";
		$functionHtml .= "<input type=\"radio\" name=\"frequency\" value=\"year\" $selectInputYear> " . translate('word_estatisticas_frquencia_ano', true) . "&nbsp;&nbsp;&nbsp;&nbsp;";
		$functionHtml .= "</td>";

		$functionHtml .= "</tr></table>";
		$script .= $this->dumpJavascriptFormFunction($functionName, $functionHtml, "frequencySelection", $ssid);


		$html .= $toAdd;
		*/$html .= "<div class='arrow'></div></div></td>";
		
		$html .= $script;

		return $html;
	}

	function drawTable($ssid){
		$stats = $_SESSION['statistics'][$ssid];
		
		$html = "";

		switch($stats['type']){
			case 'servicesAvgMaxWaitTime':
			$html .= $this->dummyFunction1($ssid, $stats);
			break;
			case 'servicesAvgMaxAttendanceTime':
			$html .= $this->dummyFunction2($ssid, $stats);
			break;
			case 'servicesTicketsNumber':
			$html .= $this->dummyFunction3($ssid, $stats);
			break;
			case 'employesAvgMaxAttendanceTime':
			$html .= $this->dummyFunction4($ssid, $stats);
			break;
			case 'employesTicketsNumber':
			$html .= $this->dummyFunction5($ssid, $stats);
			break;
		}

		return $html;
	}

	/* DUMMY FUNCTIONS */
	function dummyFunction1($ssid, $stats){
		// servicesAvgMaxWaitTime
		$html = "";

		// apresentar primeiro uma tabela com as medias globais dos servicos
		// depois apresentar uma tabela por servico com as medias de cada servico em cada loja
		$groupBy = $stats['dates']['frequency'];		
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction1($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT id_servico, nome ".
			"FROM servicos ";
		if($stats['services']['values'] != ''){
			$sql .= "WHERE id_servico IN (" . $stats['services']['values'] . ") ";
		}

		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);
		$html .= "<div class=\"graph-button-container\">";
		
		$html .= "<div class=\"select__trigger graph-button-left graph-button-selected \">". translate('word_estatisticas_tabela', true) . "</div>";
		$html .= "<div class=\"select__trigger graph-button-right\">". translate('word_estatisticas_grafico', true) . "</div>";
		$html .= "</div>";
		$html .= "<div class=\"graph-button-container\">";
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left\">". translate('word_resume', true)." ". translate('word_global', true).":</div>";
		$html .= "</div>";
		$html .= "<div id=\"resume-table\" style=\"overflow:auto;\"><table style=\"width:50%; text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader(translate("word_service", true) , $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($servicos AS $row){
			$idServico = $row['id_servico'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}

			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idServico][$source]['espera'])){
					$avg = $dados[$idServico][$source]['espera'];
					$max = $dados[$idServico][$source]['esperaMax'];
					$cols++;
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

				if ($zero && ($avg || $max)) $zero = false;

				
			}

			//if (!$zero)
			//{
				
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}
		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
		$html .= "</table>";

		// button to download data
		//$html .= dumpExportButton($downloadURL);

		// chart goes here!
		$downloadURL = "../senhas/chartsData_old.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		//$html .= dumpExportButton($downloadURL);
		/*if($stats['dates']['frequency'] == 'hour'){
			$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		}else{
			$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		}*/
		$chartType = "serial";
		
		$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats_old.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		$html .= "</div>";
		$html .= "<div id=\"resume-graph\" style=\"display:none\">";
		$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&chartType=$chartType'></iframe>", $downloadURL);
		$html .= "</div>";
		// bring tables to each store!
		$dados = $this->getDataDummyFunction2($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT id_loja, nome ".
			"FROM lojas ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$whereArray[] = "id_loja IN (" . $stats['stores']['values'] . ")";
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$whereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}
		if(count($whereArray) > 0){
			$sql .= "WHERE (" . implode(') AND (', $whereArray) . ")";
		}
		//$lojas = $this->bd->executarSQL($sql)->GetRows();
		$lojas = $this->bd->getRows($sql);


		if(count($lojas) <= 1){
			return $html;
		}
		foreach($lojas AS $loja){
			$idLoja = $loja['id_loja'];

			$html .= "<br/><br/>";
			
			$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left; width:300px;\">". translate('word_resume', true)." ". translate('word_local', true)." '$loja[nome]':</div>";

			$html .= "<div class=\"graph-button-container\">";
			$html .= "<div id=\"resume-loja-" . $loja[nome]. "\" style=\"overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader( translate("word_service", true) , $headerData['toHTML']);


			$sql = 	"SELECT s.id_servico, s.nome ".
					"FROM servicos AS s ".
					"INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade ".
					"WHERE le.id_loja = $idLoja ";
			if($stats['services']['values'] != ''){
				$sql .= "AND id_servico IN (" . $stats['services']['values'] . ") ";
			}
			//echo $sql;
			//$servicos2 = $this->bd->executarSQL($sql)->GetRows();
			$servicos2 = $this->bd->getRows($sql);

			// dump table contents
			$i = 0;
			foreach($servicos2 AS $servico){
				$idServico = $servico['id_servico'];

				$aux = "";
				$zero = true;
				$background = '';
				$background_service = '';
				$background_data = '';
				if($i++ % 2){
					//$background = 'style="background-color:#eeeeee"';
					$background_service = 'class="graph-service-box-pair"';
					$background_data =  'class="graph-data-box-pair"';
				} else {
					$background_service = 'class="graph-service-box-odd"';
					$background_data =  'class="graph-data-box-odd"';
				}

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idLoja][$idServico][$source]['espera'])){
						$avg = $dados[$idLoja][$idServico][$source]['espera'];
						$max = $dados[$idLoja][$idServico][$source]['esperaMax'];
					}

					/*
					$avg = $avg?$avg:"";
					$max = $max?$max:"";
					*/

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td $background_data>$avg<br/><font class='graph-data-colored'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					/*$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}*/
					$html .= "<tr $background>";

					$html .= "<td $background_service>".$servico["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}
			$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . htmlentities(translate('word_estatisticas_tempo_medio', true)) . " |</div><div class=\"graph-caption-second\"> " . htmlentities(translate('word_estatisticas_tempo_maximo', true)) . "</div></div></td></tr>";
			$html .= "</table></div>";

			// chart goes here!
			$extra = "idLoja=$idLoja";//ssid;
			$extraurl = "idLoja&idLoja=$idLoja";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extraurl&ssid=$ssid&outputFormat=downloadCSV";
            $chartType = "serial";
            $html .= dumpGrafico("resumoLoja$idLoja", $chartType, "../charts/settingsStats.xml,../charts/settingsStats_old.php?ssid=$ssid&extra=ssid", "", $downloadURL);
            $html .= "<div id=\"resume-graph-loja-$loja[nome]\" style=\"display:none\">";
			$html .= dumpGraficoJs("resumoLoja$idLoja", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);
			$html .= "</div>";
		}

		return $html;
	}
	function getDataDummyFunction1($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}
		
		if(getSessionValue('super_user') != 1){
			$storesArray = array();
			$sql12 = "";
			if(getSessionValue('sessao_id_utilizador'))
				$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			else 
				$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas ";
			
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$tempos = array();

		$sql = 	"SELECT	servico_destino, ".
			"	ROUND(AVG(TIME_TO_SEC(tempo_espera) / 60)) as med_tempo_espera, ".
			"	ROUND(MAX(TIME_TO_SEC(tempo_espera) / 60)) AS max_tempo_espera $extraSelect ".
//                $sql = 	"SELECT	servico_destino, ".
//			"	sec_to_time(ROUND(AVG(TIME_TO_SEC(tempo_espera)))) as med_tempo_espera, ".
//			"	sec_to_time(ROUND(MAX(TIME_TO_SEC(tempo_espera)))) AS max_tempo_espera $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_CHAMADA . "' OR ".
			"		status = '" . SENHA_RECHAMADA . "' OR ".
			"		status = '" . SENHA_SUSPENSA . "' OR ".
			"		status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy servico_destino";


		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($tempos[$row['servico_destino']][$row[$groupBy]])){
				$tempos[$row['servico_destino']][$row[$groupBy]] = array();
				$tempos[$row['servico_destino']][$row[$groupBy]]['espera'] = "0";
				$tempos[$row['servico_destino']][$row[$groupBy]]['esperaMax'] = "0";
			}
			$arrayPos = &$tempos[$row['servico_destino']][$row[$groupBy]];

			$arrayPos['espera'] = $row['med_tempo_espera'];
			$arrayPos['esperaMax'] = $row['max_tempo_espera'];
		}

		return $tempos;
	}
	function getDataDummyFunction2($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();
			$sql2 = "";
			if(getSessionValue('sessao_id_utilizador'))
				$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			else 
				$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas ";
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}
		$tempos = array();

		$sql = 	"SELECT	id_loja, ".
			"	servico_destino, ".
			"	ROUND(AVG(TIME_TO_SEC(tempo_espera) / 60)) as med_tempo_espera, ".
			"	ROUND(MAX(TIME_TO_SEC(tempo_espera) / 60)) AS max_tempo_espera $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_CHAMADA . "' OR ".
			"		status = '" . SENHA_RECHAMADA . "' OR ".
			"		status = '" . SENHA_SUSPENSA . "' OR ".
			"		status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy servico_destino, id_loja";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]])){
				$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]] = array();
				$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]]['espera'] = "0";
				$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]]['esperaMax'] = "0";
			}
			$arrayPos = &$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]];

			$arrayPos['espera'] = $row['med_tempo_espera'];
			$arrayPos['esperaMax'] = $row['max_tempo_espera'];
		}

		return $tempos;
	}

	function dummyFunction2($ssid, $stats){
		// servicesAvgMaxAttendanceTime
		$html = "";
		// apresentar primeiro uma tabela com as medias globais dos servicos
		// depois apresentar uma tabela por servico com as medias de cada servico em cada loja
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction3($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT id_servico, nome ".
			"FROM servicos ";
		if($stats['services']['values'] != ''){
			$sql .= "WHERE id_servico IN (" . $stats['services']['values'] . ") ";
		}
		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);
		$html .= "<div class=\"graph-button-container\">";
		
		$html .= "<div class=\"select__trigger graph-button-left graph-button-selected \">". translate('word_estatisticas_tabela', true) . "</div>";
		$html .= "<div class=\"select__trigger graph-button-right\">". translate('word_estatisticas_grafico', true) . "</div>";
		$html .= "</div>";
		$html .= "<div class=\"graph-button-container\">";
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left\">". translate('word_resume', true)." ". translate('word_global', true).":</div>";
			$html .= "</div>";
		$html .= "<div id=\"resume-table\" style=\"overflow:auto;\"><table style=\"width:100%; text-align:center\">";

		$data = date('Y-m', strtotime($endDate));

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader(translate("word_service", true), $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($servicos AS $row){

			$idServico = $row['id_servico'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}

			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idServico][$source]['atendimento'])){
					$avg = $dados[$idServico][$source]['atendimento'];
					$max = $dados[$idServico][$source]['atendimentoMax'];
					$cols++;
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";


				if ($zero && ($avg || $max)) $zero = false;
			}

			//if (!$zero)
			//{
				
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}

		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
		$html .= "</table>";

        // chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		$chartType = "serial";
		$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		$html .= "</div>";
		$html .= "<div id=\"resume-graph\" style=\"display:none\">";
		$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&chartType=$chartType'></iframe>", $downloadURL);
		$html .= "</div>";
		// bring tables to each store!
		$dados = $this->getDataDummyFunction4($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT id_loja, nome ".
			"FROM lojas ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$whereArray[] = "id_loja IN (" . $stats['stores']['values'] . ")";
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$whereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}
		if(count($whereArray) > 0){
			$sql .= "WHERE (" . implode(') AND (', $whereArray) . ")";
		}

		//$lojas = $this->bd->executarSQL($sql)->GetRows();
		$lojas = $this->bd->getRows($sql);
		if(count($lojas) <= 1){
			return $html;
		}
		foreach($lojas AS $loja){
			$idLoja = $loja['id_loja'];

			$html .= "<br/><br/>";

			
			$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left; width:300px;\">". translate('word_resume', true)." ". translate('word_local', true)." '$loja[nome]':</div>";
			$html .= "<div class=\"graph-button-container\">";
			$html .= "<div id=\"resume-loja-" . $loja[nome] . "\" style=\"overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader(translate("word_service", true), $headerData['toHTML']);


			$sql = 	"SELECT s.id_servico, s.nome ".
					"FROM servicos AS s ".
					"INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade ".
					"WHERE le.id_loja = $idLoja ";
			if($stats['services']['values'] != ''){
				$sql .= "AND id_servico IN (" . $stats['services']['values'] . ") ";
			}
			//echo $sql;
			//$servicos2 = $this->bd->executarSQL($sql)->GetRows();
			$servicos2 = $this->bd->getRows($sql);

			// dump table contents
			$i = 0;
			foreach($servicos2 AS $servico){

				$idServico = $servico['id_servico'];

				$aux = "";
				$zero = true;
				$background = '';
				$background_service = '';
				$background_data = '';
				if($i++ % 2){
					//$background = 'style="background-color:#eeeeee"';
					$background_service = 'class="graph-service-box-pair"';
					$background_data =  'class="graph-data-box-pair"';
				} else {
					$background_service = 'class="graph-service-box-odd"';
					$background_data =  'class="graph-data-box-odd"';
				}

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idLoja][$idServico][$source]['atendimento'])){
						$avg = $dados[$idLoja][$idServico][$source]['atendimento'];
						$max = $dados[$idLoja][$idServico][$source]['atendimentoMax'];
					}

					/*
					$avg = $avg?$avg:"";
					$max = $max?$max:"";
					*/

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					/*$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}*/
					$html .= "<tr $background>";

					$html .= "<td $background_service>".$servico["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}
			$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";

			$html .= "</table>";




			// chart goes here!
			$extra = "idLoja=$idLoja";//ssid;
			$extraurl = "idLoja&idLoja=$idLoja";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extraurl&ssid=$ssid&outputFormat=downloadCSV";
			$chartType = "serial";
			$html .= dumpGrafico("resumoLoja$idLoja", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
			$html .= "</div>";
			$html .= "<div id=\"resume-graph-loja-$loja[nome]\" style=\"display:none\">";
			$html .= dumpGraficoJs("resumoLoja$idLoja", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);
			$html .= "</div>";
		}

		return $html;
	}
	function getDataDummyFunction3($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$tempos = array();

		$sql = 	"SELECT	servico_destino, ".
			"	ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) as med_tempo_atendimento, ".
			"	ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS max_tempo_atendimento $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy servico_destino";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($tempos[$row['servico_destino']][$row[$groupBy]])){
				$tempos[$row['servico_destino']][$row[$groupBy]] = array();
				$tempos[$row['servico_destino']][$row[$groupBy]]['atendimento'] = "0";
				$tempos[$row['servico_destino']][$row[$groupBy]]['atendimentoMax'] = "0";
			}
			$arrayPos = &$tempos[$row['servico_destino']][$row[$groupBy]];

			$arrayPos['atendimento'] = $row['med_tempo_atendimento'];
			$arrayPos['atendimentoMax'] = $row['max_tempo_atendimento'];
		}

		return $tempos;
	}
	function getDataDummyFunction4($groupBy, $startDate, $endDate, $stats=array(), $storeId = null){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}
		if(isset($storeId)){
			$extraWhere .= " AND id_loja=" . $storeId;
		}

		$tempos = array();

		$sql = 	"SELECT	id_loja, ".
			"	servico_destino, ".
			"	ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) as med_tempo_atendimento, ".
			"	ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS max_tempo_atendimento $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy servico_destino, id_loja";

		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]])){
				$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]] = array();
				$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]]['atendimento'] = "0";
				$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]]['atendimentoMax'] = "0";
			}
			$arrayPos = &$tempos[$row['id_loja']][$row['servico_destino']][$row[$groupBy]];

			$arrayPos['atendimento'] = $row['med_tempo_atendimento'];
			$arrayPos['atendimentoMax'] = $row['max_tempo_atendimento'];
		}

		return $tempos;
	}


	function dummyFunction3($ssid, $stats){
		// servicesTicketsNumber
		$html = "";
		// apresentar primeiro uma tabela com as medias globais dos servicos
		// depois apresentar uma tabela por servico totais de cada servico em cada loja
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction5($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT id_servico, nome ".
			"FROM servicos ";
		if($stats['services']['values'] != ''){
			$sql .= "WHERE id_servico IN (" . $stats['services']['values'] . ") ";
		}
		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);


		$html .= "<div class=\"graph-button-container\">";
		$html .= "<div class=\"select__trigger graph-button-left graph-button-selected \">". translate('word_estatisticas_tabela', true) . "</div>";
		$html .= "<div class=\"select__trigger graph-button-right\">". translate('word_estatisticas_grafico', true) . "</div>";
		$html .= "</div>";

		$html .= "<div class=\"graph-button-container\">";
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left\">". translate('word_resume', true)." ". translate('word_global', true).":</div>";
		$html .= "</div>";
		$html .= "<div id=\"resume-table\" style=\"overflow:auto;\"><table style=\"width:100%; text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader(translate("word_service", true), $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($servicos AS $row){

			$idServico = $row['id_servico'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}

			// each column
			foreach($headerData['source'] AS $source){
				$atendidas = 0;
				$desistidas = 0;
				if(isset($dados[$idServico][$source]['atendidas'])){
					$atendidas = $dados[$idServico][$source]['atendidas'];
					$desistidas = $dados[$idServico][$source]['desistidas'];
					$cols++;
				}

				/*
				$atendidas = $atendidas?$atendidas:"";
				$desistidas = $desistidas?$desistidas:"";
				*/
				if($atendidas == 0 && $desistidas == 0){
					$atendidas = '';
					$desistidas = '';
				}

				$aux .= "<td $background_data>$atendidas<font class='graph-data-colored'>$desistidas</font></td>";

				if ($zero && ($desistidas || $atendidas)){
					$zero = false;
				}
			}

			//if (!$zero)
			//{
				
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}
		$cols .=2;
		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_export_senhas_atendidas', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_tickets', true) . " " . translate('word_desistidas', true) . "</div></div></td></tr>";
		$html .= "</table>";

		// chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		
		$chartType = "serial";
		$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		$html .= "</div>";
		$html .= "<div id=\"resume-graph\" style=\"display:none\">";
		$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&chartType=$chartType'></iframe>", $downloadURL);
		$html .= "</div>";
		// bring tables to each store!
		$dados = $this->getDataDummyFunction6($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT id_loja, nome ".
			"FROM lojas ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$whereArray[] = "id_loja IN (" . $stats['stores']['values'] . ")";
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$whereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}
		if(count($whereArray) > 0){
			$sql .= "WHERE (" . implode(') AND (', $whereArray) . ")";
		}

		//$lojas = $this->bd->executarSQL($sql)->GetRows();
		$lojas = $this->bd->getRows($sql);
		if(count($lojas) <= 1){
			return $html;
		}
		foreach($lojas AS $loja){
			$idLoja = $loja['id_loja'];

			$html .= "<br/><br/>";
			
			
			$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left; width:300px;\">". translate('word_resume', true)." ". translate('word_local', true)." '$loja[nome]':</div>";
			$html .= "<div class=\"graph-button-container\">";
			$html .= "<div id=\"resume-loja-" . $loja[nome] . "\" style=\"overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader(translate("word_service", true), $headerData['toHTML']);


			$sql = 	"SELECT s.id_servico, s.nome ".
					"FROM servicos AS s ".
					"INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade ".
					"WHERE le.id_loja = $idLoja ";
			if($stats['services']['values'] != ''){
				$sql .= "AND id_servico IN (" . $stats['services']['values'] . ") ";
			}
			//echo $sql;
			//$servicos2 = $this->bd->executarSQL($sql)->GetRows();
			$servicos2 = $this->bd->getRows($sql);

			// dump table contents
			$i = 0;
			foreach($servicos2 AS $servico){

				$idServico = $servico['id_servico'];

				$aux = "";
				$zero = true;
				$background = '';
				$background_service = '';
				$background_data = '';
				if($i++ % 2){
					//$background = 'style="background-color:#eeeeee"';
					$background_service = 'class="graph-service-box-pair"';
					$background_data =  'class="graph-data-box-pair"';
				} else {
					$background_service = 'class="graph-service-box-odd"';
					$background_data =  'class="graph-data-box-odd"';
				}


				// each column
				foreach($headerData['source'] AS $source){
					$atendidas = 0;
					$desistidas = 0;
					if(isset($dados[$idLoja][$idServico][$source]['atendidas'])){
						$atendidas = $dados[$idLoja][$idServico][$source]['atendidas'];
						$desistidas = $dados[$idLoja][$idServico][$source]['desistidas'];
					}

					/*
					$atendidas = $atendidas?$atendidas:"";
					$desistidas = $desistidas?$desistidas:"";
					*/

					if($atendidas == 0 && $desistidas == 0){
						$atendidas = '';
						$desistidas = '';
					}

					$aux .= "<td $background_data>$atendidas<font class='graph-data-colored'>$desistidas</font></td>";

					if ($zero && ($atendidas || $desistidas)) $zero = false;
				}

				//if (!$zero)
				//{
					/*$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}*/
					$html .= "<tr $background>";

					$html .= "<td $background_service>".$servico["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}
			$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_export_senhas_atendidas', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_desistidas', true) . "</div></div></td></tr>";
			$html .= "</table>";

			// chart goes here!
			$extra = "idLoja&idLoja=$idLoja";//
			$extraurl = "idLoja&idLoja=$idLoja";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extraurl&ssid=$ssid&outputFormat=downloadCSV";
			$chartType = "serial";
			$html .= dumpGrafico("resumoLoja$idLoja", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
			$html .= "</div>";
			$html .= "<div id=\"resume-graph-loja-$loja[nome]\" style=\"display:none\">";
			$html .= dumpGraficoJs("resumoLoja$idLoja", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);
			$html .= "</div>";
		}

		return $html;
	}
	function getDataDummyFunction5($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$senhas = array();

		$sql = 	"SELECT	servico_destino, ".
			"	status, ".
			"	COUNT(*) AS n $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy servico_destino, status";
		//$res = $this->bd->executarSQL($sql)->GetRows();


		$res = $this->bd->getRows($sql);

		foreach($res AS $row){
			if(!isset($senhas[$row['servico_destino']][$row[$groupBy]])){
				$senhas[$row['servico_destino']][$row[$groupBy]] = array();
				$senhas[$row['servico_destino']][$row[$groupBy]]['atendidas'] = 0;
				$senhas[$row['servico_destino']][$row[$groupBy]]['desistidas'] = 0;
			}
			$arrayPos = &$senhas[$row['servico_destino']][$row[$groupBy]];

			switch($row['status']){
				case SENHA_TERMINADA:
				case SENHA_REDIRECCAO:
					$arrayPos['atendidas'] = intval($row['n']) + intval($arrayPos['atendidas']) ;
					break;
				case SENHA_DESISTIDA:
					$arrayPos['desistidas'] = intval($row['n']) + intval($arrayPos['desistidas']) ;
					break;
			}
		}

		return $senhas;
	}
	function getDataDummyFunction6($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$senhas = array();

		$sql = 	"SELECT	id_loja, ".
			"	servico_destino, ".
			"	status, ".
			"	COUNT(*) AS n $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy servico_destino, status, id_loja";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);

		foreach($res AS $row){
			if(!isset($senhas[$row['id_loja']][$row['servico_destino']][$row[$groupBy]])){
				$senhas[$row['id_loja']][$row['servico_destino']][$row[$groupBy]] = array();
				$senhas[$row['id_loja']][$row['servico_destino']][$row[$groupBy]]['atendidas'] = "0";
				$senhas[$row['id_loja']][$row['servico_destino']][$row[$groupBy]]['desistidas'] = "0";
			}
			$arrayPos = &$senhas[$row['id_loja']][$row['servico_destino']][$row[$groupBy]];
			
			switch($row['status']){
				case SENHA_TERMINADA:
				case SENHA_REDIRECCAO:
					$arrayPos['atendidas'] = intval($row['n']) + intval($arrayPos['atendidas']) ;
					break;
				case SENHA_DESISTIDA:
					$arrayPos['desistidas'] = intval($row['n']) + intval($arrayPos['desistidas']) ;
					break;
			}
		}

		
		return $senhas;
	}


	function dummyFunction4($ssid, $stats){
		// employesAvgMaxAttendanceTime
		$html = "";
		// apresentar primeiro uma tabela com as medias globais dos colaboradores
		// depois apresentar uma tabela por servico com as medias de cada colaborador em cada servico
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction7($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT DISTINCT emp.id_empregado, emp.nome ".
			"FROM empregados AS emp ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$sql .= " INNER JOIN local_colaborador AS lc ON lc.id_colaborador = emp.id_empregado ";
			$whereArray[] = " lc.id_local IN (" . $stats['stores']['values'] . ") ";
		}
		if($stats['entities']['values'] != ''){
			$sql .= " INNER JOIN entidade_colaborador AS ec ON ec.id_colaborador = emp.id_empregado ";
			$whereArray[] = " ec.id_entidade IN (" . $stats['entities']['values'] . ") ";
		}

		if($stats['employes']['values'] != ''){
			$whereArray[] = " emp.id_empregado IN (" . $stats['employes']['values'] . ") ";
		}

		if(count($whereArray) > 0){
			$sql .= " WHERE (" . implode(') AND (', $whereArray) . ")";
		}
		$sql;
		//$colaboradores = $this->bd->executarSQL($sql)->GetRows();
		$colaboradores = $this->bd->getRows($sql);
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left;width: 100px;\">". translate('word_resume', true)." ". translate('word_global', true).":</div>";

		$html .= "<div style=\"width:50%; text-align:center;\"><table width=\"100%\" style=\"text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($colaboradores AS $row){

			$idColaborador = $row['id_empregado'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}
			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;

				if(isset($dados[$idColaborador][$source]['atendimento'])){
					$avg = $dados[$idColaborador][$source]['atendimento'];
					$max = $dados[$idColaborador][$source]['atendimentoMax'];
					$cols++;
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

				if ($zero && ($avg || $max)) $zero = false;
			}

			//if (!$zero)
			//{
				/*$background = '';
				if($i++ % 2){
					$background = 'style="background-color:#eeeeee"';
				}*/
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}

		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
		$html .= "</table></div>";

		// chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		$chartType = "serial";
		$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStatsEmployes.php?ssid=$ssid&extra=ssid", "", $downloadURL);

		//$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]'></iframe>", $downloadURL);

		// bring tables to each store!
		/*$dados = $this->getDataDummyFunction8($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT distinct s.id_servico, s.nome ".
			"FROM servicos s
			inner join (
				select sb.id_servico servico, b.id_loja loja
				from servicos_balcao sb
				inner join balcoes b on b.id_balcao=sb.id_balcao) sl on sl.servico=s.id_servico ";

		$where = array();

		if ($stats['services']['values'] != '')
		{
			array_push($where, "s.id_servico IN (" . $stats['services']['values'] . ") ");
		}

		if ($stats['stores']['values'] != '')
		{
			array_push($where, "sl.loja IN (" . $stats['stores']['values'] . ") ");
		}

		if (count($where))
		{
			$sql .= "where ".implode(" and ", $where);
		}

		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);






		if(count($servicos) <= 1){
			return $html;
		}
		foreach($servicos AS $servico){
			$idServico = $servico['id_servico'];

			$html .= "<br/><br/>";
			$html .= "<h3>". translate('word_resume', true)."". translate("word_service", true)." '".$servico[nome]."'</h3>";

			$html .= "<div style=\"width:758px; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

			// dump table contents
			$i = 0;
			foreach($colaboradores AS $colaborador){

				$idColaborador = $colaborador['id_empregado'];

				$aux = "";
				$zero = true;

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idServico][$idColaborador][$source]['atendimento'])){
						$avg = $dados[$idServico][$idColaborador][$source]['atendimento'];
						$max = $dados[$idServico][$idColaborador][$source]['atendimentoMax'];
					}


					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td>$avg<br/><font color='red'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}
					$html .= "<tr $background>";

					$html .= "<td>".$colaborador["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}

			$html .= "</table></div>";

			// chart goes here!
			$extra = "idServico&idServico=$idServico";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extra&ssid=$ssid&outputFormat=downloadCSV";
			$chartType = "serial";
            $html .= dumpGraficoJs("resumoLoja$idServico", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);

		}*/

		return $html;
	}
	function getDataDummyFunction7($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$tempos = array();

		$sql = 	"SELECT	id_colaborador, ".
			"	ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) as med_tempo_atendimento, ".
			"	ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS max_tempo_atendimento $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	id_colaborador IS NOT NULL AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy id_colaborador ";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($tempos[$row['id_colaborador']][$row[$groupBy]])){
				$tempos[$row['id_colaborador']][$row[$groupBy]] = array();
				$tempos[$row['id_colaborador']][$row[$groupBy]]['atendimento'] = "0";
				$tempos[$row['id_colaborador']][$row[$groupBy]]['atendimentoMax'] = "0";
			}
			$arrayPos = &$tempos[$row['id_colaborador']][$row[$groupBy]];

			$arrayPos['atendimento'] = $row['med_tempo_atendimento'];
			$arrayPos['atendimentoMax'] = $row['max_tempo_atendimento'];
		}

		return $tempos;
	}
	function getDataDummyFunction8($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$tempos = array();

		$sql = 	"SELECT	id_colaborador, ".
			"	servico_destino, ".
			"	ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) as med_tempo_atendimento, ".
			"	ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS max_tempo_atendimento $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	id_colaborador IS NOT NULL AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy id_colaborador, servico_destino ";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($tempos[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]])){
				$tempos[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]] = array();
				$tempos[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]]['atendimento'] = "0";
				$tempos[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]]['atendimentoMax'] = "0";
			}
			$arrayPos = &$tempos[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]];

			$arrayPos['atendimento'] = $row['med_tempo_atendimento'];
			$arrayPos['atendimentoMax'] = $row['max_tempo_atendimento'];
		}

		return $tempos;
	}

	function dummyFunction5($ssid, $stats){
		// employesTicketsNumber
		$html = "";

		// apresentar primeiro uma tabela com as medias globais dos colaboradores
		// depois apresentar uma tabela por servico com as medias de cada colaborador em cada servico
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction9($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT DISTINCT emp.id_empregado, emp.nome ".
			"FROM empregados AS emp ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$sql .= " INNER JOIN local_colaborador AS lc ON lc.id_colaborador = emp.id_empregado ";
			$whereArray[] = " lc.id_local IN (" . $stats['stores']['values'] . ") ";
		}
		if($stats['entities']['values'] != ''){
			$sql .= " INNER JOIN entidade_colaborador AS ec ON ec.id_colaborador = emp.id_empregado ";
			$whereArray[] = " ec.id_entidade IN (" . $stats['entities']['values'] . ") ";
		}

		if($stats['employes']['values'] != ''){
			$whereArray[] = " emp.id_empregado IN (" . $stats['employes']['values'] . ") ";
		}

		if(count($whereArray) > 0){
			$sql .= " WHERE (" . implode(') AND (', $whereArray) . ")";
		}

		//$colaboradores = $this->bd->executarSQL($sql)->GetRows();
		$colaboradores = $this->bd->getRows($sql);
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left;width: 100px;\">". translate('word_global', true)." ". translate('word_resume', true).":</div>";

		$html .= "<div style=\"width:100%; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader(translate('word_costumer', true), $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($colaboradores AS $row){

			$idColaborador = $row['id_empregado'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}
			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idColaborador][$source]['atendidas'])){
					$avg = $dados[$idColaborador][$source]['atendidas'];
					$max = $dados[$idColaborador][$source]['desistidas'];
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

				if ($zero && ($avg || $max)) $zero = false;
			}

			//if (!$zero)
			//{
				/*$background = '';
				if($i++ % 2){
					$background = 'style="background-color:#eeeeee"';
				}*/
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}
		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_export_senhas_atendidas', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_tickets', true) . " " . translate('word_desistidas', true) . "</div></div></td></tr>";
		$html .= "</table></div>";

		// chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		$chartType = "serial";
		$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStatsEmployes.php?ssid=$ssid&extra=ssid", "", $downloadURL);
	/*	$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]'></iframe>", $downloadURL);


		// get tables to each service!
		$dados = $this->getDataDummyFunction10($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT distinct s.id_servico, s.nome ".
			"FROM servicos s
			inner join (
				select sb.id_servico servico, b.id_loja loja
				from servicos_balcao sb
				inner join balcoes b on b.id_balcao=sb.id_balcao) sl on sl.servico=s.id_servico ";

		$where = array();

		if ($stats['services']['values'] != '')
		{
			array_push($where, "s.id_servico IN (" . $stats['services']['values'] . ") ");
		}

		if ($stats['stores']['values'] != '')
		{
			array_push($where, "sl.loja IN (" . $stats['stores']['values'] . ") ");
		}

		if (count($where))
		{
			$sql .= "where ".implode(" and ", $where);
		}

		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);

		if(count($servicos) <= 1){
			return $html;
		}
		foreach($servicos AS $servico){
			$idServico = $servico['id_servico'];

			$html .= "<br/><br/>";
			$html .= "<h3>". translate('word_resume', true)."". translate("word_service", true) ."'".$servico[nome]."'</h3>";

			$html .= "<div style=\"width:758px; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

			// dump table contents
			$i = 0;
			foreach($colaboradores AS $colaborador){

				$idColaborador = $colaborador['id_empregado'];

				$aux = "";
				$zero = true;

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idServico][$idColaborador][$source]['atendidas'])){
						$avg = $dados[$idServico][$idColaborador][$source]['atendidas'];
						$max = $dados[$idServico][$idColaborador][$source]['desistidas'];
					}

					

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td>$avg<br/><font color='red'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}
					$html .= "<tr $background>";

					$html .= "<td>".$colaborador["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}

			$html .= "</table></div>";

			// chart goes here!
			$extra = "idServico&idServico=$idServico";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extra&ssid=$ssid&outputFormat=downloadCSV";
		    $chartType = "serial";
			$html .= dumpGraficoJs("resumoLoja$idServico", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);

		}
*/
		return $html;
	}
	function getDataDummyFunction9($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$senhas = array();

		$sql = 	"SELECT	id_colaborador, ".
			"	status, ".
			"	COUNT(*) AS n $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy id_colaborador, status";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($senhas[$row['id_colaborador']][$row[$groupBy]])){
				$senhas[$row['id_colaborador']][$row[$groupBy]] = array();
				$senhas[$row['id_colaborador']][$row[$groupBy]]['atendidas'] = 0;
				$senhas[$row['id_colaborador']][$row[$groupBy]]['desistidas'] = 0;
			}
			$arrayPos = &$senhas[$row['id_colaborador']][$row[$groupBy]];

			switch($row['status']){
				case SENHA_TERMINADA:
				case SENHA_REDIRECCAO:
					$arrayPos['atendidas'] = intval($row['n']) + intval($arrayPos['atendidas']) ;
					break;
				case SENHA_DESISTIDA:
					$arrayPos['desistidas'] = intval($row['n']) + intval($arrayPos['desistidas']) ;
					break;
			}
		}

		return $senhas;
	}
	function getDataDummyFunction10($groupBy, $startDate, $endDate, $stats=array()){
		// groupBy can be: hour or day or month or year

		$extraSelect = "";
		$extraGroupBy = "";
		switch($groupBy){
			case 'hour':
				$extraSelect = ", DATE_FORMAT(emissao, '%H:00') AS hour ";
				$extraGroupBy = "hour,";
				break;
			case 'day':
				$extraSelect = ", DATE(emissao) AS day ";
				$extraGroupBy = "day,";
				break;
			case 'month':
				$extraSelect = ", DATE_FORMAT(emissao, '%Y-%m') AS month ";
				$extraGroupBy = "month,";
				break;
			case 'year':
				$extraSelect = ", YEAR(emissao) AS year ";
				$extraGroupBy = "year,";
				break;
		}

		$extraWhereArray = array();
		foreach($stats AS $node => $values){
			if(!isset($values['values']) || $values['values'] == ''){
				continue;
			}

			switch($node){
				case 'stores':
					$extraWhereArray[] = "id_loja IN ($values[values])";
					break;
				case 'services':
					$extraWhereArray[] = "servico_destino IN ($values[values])";
					break;
				case 'entities':
					//$extraWhereArray[] = "id_entidade IN ($values[values])";
					break;
				case 'employes':
					$extraWhereArray[] = "id_colaborador IN ($values[values])";
					break;
			}
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$extraWhereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}

		$extraWhere = "";
		if(count($extraWhereArray) > 0){
			$extraWhere = "AND (" . implode(') AND (', $extraWhereArray) . ")";
		}

		$senhas = array();

		$sql = 	"SELECT	id_colaborador, ".
			"	servico_destino, ".
			"	status, ".
			"	COUNT(*) AS n $extraSelect ".
			"FROM senhas ".
			"WHERE	data BETWEEN '$startDate' AND '$endDate' AND ".
			"	(	status = '" . SENHA_TERMINADA . "' OR ".
			"		status = '" . SENHA_DESISTIDA . "' OR ".
			"		status = '" . SENHA_REDIRECCAO . "' ".
			"	) ".
			"	$extraWhere ".
			"GROUP BY $extraGroupBy id_colaborador, status, servico_destino";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);
		foreach($res AS $row){
			if(!isset($senhas[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]])){
				$senhas[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]] = array();
				$senhas[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]]['atendidas'] = "0";
				$senhas[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]]['desistidas'] = "0";
			}
			$arrayPos = &$senhas[$row['servico_destino']][$row['id_colaborador']][$row[$groupBy]];

			switch($row['status']){
				case SENHA_TERMINADA:
				case SENHA_REDIRECCAO:
					$arrayPos['atendidas'] = intval($row['n']) + intval($arrayPos['atendidas']) ;
					break;
				case SENHA_DESISTIDA:
					$arrayPos['desistidas'] = intval($row['n']) + intval($arrayPos['desistidas']) ;
					break;
			}
		}

		return $senhas;
	}



	/* USEFUL FUNCTIONS */
	function dumpJavascriptFormFunction($functionName, $html, $module, $ssid, $verification='', $extraInstructions='', $onSelect='', $onSubmitValidation=''){
		$script = "";
		$formHtml = "";

		// escape all ''s
		//$html = str_replace("'", "\\'", $html);
		$menu = $_GET["menu"];
		//$formHtml .= "<form id=\"form_$functionName\" class=\"form_templateSmall\" action=\"../estatisticas/statsChange.php?module=$module&ssid=$ssid\" method=\"post\">";
		$formHtml .= "<form id=\"form_$functionName\" action=\"../estatisticas/statsChange.php?module=$module&menu=$menu&ssid=$ssid\" method=\"post\">";
		//$formHtml .= "<table class=\"form_tableSmall\" cellspacing=\"0\" cellpadding=\"0\">";
		$formHtml .= "<table cellspacing=\"0\" cellpadding=\"0\">";
		//$formHtml .= "<tr><td colspan=\\'2\\'>$html</td></tr>";
		$formHtml .= "<tr>$html";
		$formHtml .= "</tr><tr>";
		$formHtml .= "<td></td><td class=\"button\" style=\"padding-top: 15px;\"><div class=\"button-full-green button-filter\" style=\"margin-left: 0px !important;\" onClick=\"onSubmit_$functionName();\">" . translate('word_filtrar', true) . "</div></td></tr>";
		$formHtml .= "<tr><td colspan=\\'2\\'><span id=\"msg_$functionName\" class=\"error_msg\">&nbsp;</span></td></tr>";
//		$formHtml .= "<tr><td class=\"button\"><div class=\"button-gray\" onClick=\"onSubmit_$functionName();\">" . translate('word_alterar', true) . "</div></td></tr>";
		$formHtml .= "</table>";
		$formHtml .= "</form>";

		$script = "<script type='text/javascript'>";

		/*$script .= "function $functionName(){ ";
		$script .= "	var html = '$formHtml'; ";
		if($extraInstructions != ''){
			$script .= "	$extraInstructions; ";
		}
		

		$script .= "	return html; ";
		$script .= "} ";

		$script .= "function after_$functionName(){ ";
		if($onSelect != ''){
			$script .= "	$onSelect;";
		}

		$script .= "} ";
*/
		$script .= "function onSubmit_$functionName(){ ";
		if($verification != ''){
			$script .= "	$verification();";
		}else{
			if($onSubmitValidation != ''){
				$script .= "	$onSubmitValidation;";
			}
			$script .= "	justSubmit('form_$functionName');";
		}
		$script .= "} ";

		$script .= "</script>";

		return $formHtml . $script;
	}

	function dumpJavascriptFormFunctionNew($functionName, $html, $module, $ssid, $verification='', $extraInstructions='', $onSelect='', $onSubmitValidation=''){
		$script = "";
		$formHtml = "";

		// escape all ''s
		//$html = str_replace("'", "\\'", $html);
		$menu = $_GET["menu"];

		$formHtml .= "<form id=\"form_$functionName\" class=\"form_templateSmall\" action=\"../estatisticas/statsChange.php?module=$module&menu=$menu&ssid=$ssid\" method=\"post\">";
		$formHtml .= $html;
		//$formHtml .= "<table class=\"form_tableSmall\" cellspacing=\"0\" cellpadding=\"0\">";
		//$formHtml .= "<tr><td colspan=\\'2\\'>$html</td></tr>";
		//$formHtml .= "<tr><td colspan=\\'2\\'><span id=\"msg_$functionName\" class=\"error_msg\">&nbsp;</span></td></tr>";
		//$formHtml .= "<tr><td class=\"button\"><div class=\"button-gray\" onClick=\"onSubmit_$functionName();\">" . translate('word_alterar', true) . "</div></td></tr>";
		//$formHtml .= "</table>";
		$formHtml .= "</form>";

		$script = "<script type='text/javascript'>";

		/*$script .= "function $functionName(){ ";
		$script .= "	var html = '$formHtml'; ";
		if($extraInstructions != ''){
			$script .= "	$extraInstructions; ";
		}
		

		$script .= "	return html; ";
		$script .= "} ";

		$script .= "function after_$functionName(){ ";
		if($onSelect != ''){
			$script .= "	$onSelect;";
		}

		$script .= "} ";
*/
		$script .= "function onSubmit_$functionName(){ ";
		if($verification != ''){
			$script .= "	$verification();";
		}else{
			if($onSubmitValidation != ''){
				$script .= "	$onSubmitValidation;";
			}
			$script .= "	justSubmit('form_$functionName');";
		}
		$script .= "} ";

		$script .= "</script>";

		return $formHtml . $script;
	}

	function getDateColumns($startDate, $endDate, $frequency){
		$meses = array(translate('word_january', true), translate('word_february', true), translate('word_march', true), translate('word_april', true), translate('word_may', true), translate('word_june', true), translate('word_july', true), translate('word_august', true), translate('word_september', true), translate('word_october', true), translate('word_november', true), translate('word_december', true));

		$rows = array();
		$rows['source'] = array();
		$rows['toHTML'] = array();

		$startDateTimeStamp = strtotime($startDate);
		$endDateTimeStamp = strtotime($endDate);
		$actualTimeStamp = $startDateTimeStamp;

		switch($frequency){
			case 'hour':
			for($i = 0; $i < 24; $i++){
				if($i < 10){
					$i = "0$i";
				}
				$rows['toHTML']['horas'][] = $i;
				$rows['source'][] = "$i:00";
			}
			break;

			case 'day':
			while($actualTimeStamp <= $endDateTimeStamp){
				$month = date('m', $actualTimeStamp);
				$day = date('d', $actualTimeStamp);

				$labelMonth = $meses[intval($month)-1];

				if(!isset($rows['toHTML'][$labelMonth])){
					$rows['toHTML'][$labelMonth] = array();
				}
				$rows['toHTML'][$labelMonth][] = $day;

				$rows['source'][] = date('Y-m-d', $actualTimeStamp);

				$actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp)+1, date("Y", $actualTimeStamp));
			}
			break;

			case 'month':
			while($actualTimeStamp <= $endDateTimeStamp){
				$year = date('Y', $actualTimeStamp);
				$month = date('m', $actualTimeStamp);

				$labelMonth = $meses[intval($month)-1];

				if(!isset($rows['toHTML'][$year])){
					$rows['toHTML'][$year] = array();
				}
				$rows['toHTML'][$year][] = $labelMonth;

				$rows['source'][] = date('Y-m', $actualTimeStamp);

				$actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp)+1, date("d", $actualTimeStamp), date("Y", $actualTimeStamp));
			}
			break;

			case 'year':
			while($actualTimeStamp <= $endDateTimeStamp){
				$year = date('Y', $actualTimeStamp);

				if(!isset($rows['toHTML']['Ano'])){
					$rows['toHTML']['Ano'] = array();
				}
				$rows['toHTML']['Ano'][] = $year;

				$rows['source'][] = date('Y', $actualTimeStamp);

				$actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp), date("Y", $actualTimeStamp)+1);
			}
			break;
		}

		return $rows;
	}

	function dumpHTMLHeader($firstColumn, $rows){
		$html = "";

		$html .= "<thead>";

		$firstRowColumns = "";
		$secondRowColumns = "";

		// allways have at least one row!
		$numberRows = 1;

		foreach($rows AS $column => $deeperCol){
			$numberCols = 1;
			if(is_array($deeperCol)){
				$numberCols = count($deeperCol);
				foreach($deeperCol AS $col){
					$secondRowColumns .= "<th class=\"graph-header-row-box\">$col</th>";
				}
				$numberRows = 2;
			}

			$firstRowColumns .= "<th class=\"graph-header-row-box\" colspan='$numberCols'>$column</th>";
		}

		$html .= "<tr class=\"column_row\">";
		$html .= "<th class=\"graph-header-service-box\" rowspan='$numberRows'>$firstColumn</th>";
		$html .= $firstRowColumns;
		$html .= "</tr>";

		// second row and so on
		$html .= "<tr class=\"column_row\">";
		$html .= $secondRowColumns;
		$html .= "</tr>";

		$html .= "</thead>";

		return $html;
	}

	/**
	* translate dates from lastMonth to real dates
	*/
	function fixDates($ssid){

		$stats = &$_SESSION['statistics'][$ssid];

		$endDateTimeStamp = strtotime($stats['dates']['to']);
		if($stats['dates']['from'] == ''){
			switch($stats['dates']['period']){
				case 'lastDay':
					$stats['dates']['from'] = date('Y-m-d', mktime(0, 0, 0, date("m", $endDateTimeStamp), date("d", $endDateTimeStamp)-1, date("Y", $endDateTimeStamp)));
					break;
				case 'lastWeek':
					$stats['dates']['from'] = date('Y-m-d', mktime(0, 0, 0, date("m", $endDateTimeStamp), date("d", $endDateTimeStamp)-7, date("Y", $endDateTimeStamp)));
					break;
				case 'lastMonth':
					$stats['dates']['from'] = date('Y-m-d', mktime(0, 0, 0, date("m", $endDateTimeStamp)-1, date("d", $endDateTimeStamp), date("Y", $endDateTimeStamp)));
					break;
				case 'lastYear':
					$stats['dates']['from'] = date('Y-m-d', mktime(0, 0, 0, date("m", $endDateTimeStamp), date("d", $endDateTimeStamp), date("Y", $endDateTimeStamp)-1));
					break;
			}
		}

	}

	function drawTable4Service($stats){
		$ssid = "";
		$html = "";

		switch($stats['type']){
			case 'servicesAvgMaxWaitTime':
			$html .= $this->dummyFunction1Service($ssid, $stats);
			break;
			case 'servicesAvgMaxAttendanceTime':
			$html .= $this->dummyFunction2Service($ssid, $stats);
			break;
			case 'servicesTicketsNumber':
			$html .= $this->dummyFunction3($ssid, $stats);
			break;
			case 'employesAvgMaxAttendanceTime':
			$html .= $this->dummyFunction4Service($ssid, $stats);
			break;
			case 'employesTicketsNumber':
			$html .= $this->dummyFunction5Service($ssid, $stats);
			break;
		}

		return $html;
	}

	function dummyFunction1Service($ssid, $stats){
		// servicesAvgMaxWaitTime
		$html = "";

		// apresentar primeiro uma tabela com as medias globais dos servicos
		// depois apresentar uma tabela por servico com as medias de cada servico em cada loja
		$groupBy = $stats['dates']['frequency'];		
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction1($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT id_servico, nome ".
			"FROM servicos ";
		if($stats['services']['values'] != ''){
			$sql .= "WHERE id_servico IN (" . $stats['services']['values'] . ") ";
		}

		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);
		/*$html .= "<div class=\"graph-button-container\">";
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left\">". translate('word_resume', true)." ". translate('word_global', true).":</div>";
		$html .= "<div class=\"select__trigger graph-button-left graph-button-selected \">". translate('word_estatisticas_tabela', true) . "</div>";
		$html .= "<div class=\"select__trigger graph-button-right\">". translate('word_estatisticas_grafico', true) . "</div>";
		$html .= "</div>";
		*/

		$html .= "<div id=\"resume-table\" style=\"overflow:auto;\"><table style=\"width:50%; text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);

		$html .= $this->dumpHTMLHeader(translate("word_service", true) , $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($servicos AS $row){
			$idServico = $row['id_servico'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}

			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idServico][$source]['espera'])){
					$avg = $dados[$idServico][$source]['espera'];
					$max = $dados[$idServico][$source]['esperaMax'];
					$cols++;
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

				if ($zero && ($avg || $max)) $zero = false;

				
			}

			//if (!$zero)
			//{
				
				$html .= "<tr $background>";

				$html .= "<td $background_service>".htmlentities($row["nome"])."</td>".$aux;

				$html .= "</tr>";
			//}
		}
		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . htmlentities(translate('word_estatisticas_tempo_medio', true)) . " |</div><div class=\"graph-caption-second\"> " . htmlentities(translate('word_estatisticas_tempo_maximo', true)) . "</div></div></td></tr>";
		$html .= "</table>";

		// button to download data
		//$html .= dumpExportButton($downloadURL);

		// chart goes here!
		$downloadURL = "../senhas/chartsData_old.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";

		$chartType = "serial";
		
		//$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats_old.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		$html .= "</div>";
		/*$html .= "<div id=\"resume-graph\" style=\"display:none\">";
		$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&chartType=$chartType'></iframe>", $downloadURL);
		$html .= "</div>";
		*/
		// bring tables to each store!
		$dados = $this->getDataDummyFunction2($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT id_loja, nome ".
			"FROM lojas ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$whereArray[] = "id_loja IN (" . $stats['stores']['values'] . ")";
		}



		if(getSessionValue('super_user') != 1){
			$storesArray = array();
			$sql2 = "";
			if(getSessionValue('sessao_id_utilizador'))
				$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			else
				$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas ";


			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$whereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}
		if(count($whereArray) > 0){
			$sql .= "WHERE (" . implode(') AND (', $whereArray) . ")";
		}
		//$lojas = $this->bd->executarSQL($sql)->GetRows();
		$lojas = $this->bd->getRows($sql);


		if(count($lojas) <= 1){
			return $html;
		}
		foreach($lojas AS $loja){
			$idLoja = $loja['id_loja'];

			$html .= "<br/><br/>";
			
			
			$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left; width:300px;\">". translate('word_resume', true)." ". translate('word_local', true)." '$loja[nome]':</div>";
			$html .= "<div class=\"graph-button-container\">";
			$html .= "<div id=\"resume-loja-" . $loja[nome] . "\" style=\"overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader( translate("word_service", true) , $headerData['toHTML']);


			$sql = 	"SELECT s.id_servico, s.nome ".
					"FROM servicos AS s ".
					"INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade ".
					"WHERE le.id_loja = $idLoja ";
			if($stats['services']['values'] != ''){
				$sql .= "AND id_servico IN (" . $stats['services']['values'] . ") ";
			}

			//$servicos2 = $this->bd->executarSQL($sql)->GetRows();
			$servicos2 = $this->bd->getRows($sql);

			// dump table contents
			$i = 0;
			foreach($servicos2 AS $servico){
				$idServico = $servico['id_servico'];

				$aux = "";
				$zero = true;
				$background = '';
				$background_service = '';
				$background_data = '';
				if($i++ % 2){
					//$background = 'style="background-color:#eeeeee"';
					$background_service = 'class="graph-service-box-pair"';
					$background_data =  'class="graph-data-box-pair"';
				} else {
					$background_service = 'class="graph-service-box-odd"';
					$background_data =  'class="graph-data-box-odd"';
				}

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idLoja][$idServico][$source]['espera'])){
						$avg = $dados[$idLoja][$idServico][$source]['espera'];
						$max = $dados[$idLoja][$idServico][$source]['esperaMax'];
					}

					/*
					$avg = $avg?$avg:"";
					$max = $max?$max:"";
					*/

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{ 
					/*$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}*/
					$html .= "<tr $background>";

					$html .= "<td $background_service>".$servico["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}
			$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
			$html .= "</table></div>";

			// chart goes here! 
			$extra = "idLoja=$idLoja";//ssid;
			$extraurl = "idLoja&idLoja=$idLoja";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extraurl&ssid=$ssid&outputFormat=downloadCSV";
            $chartType = "serial";
            $html .= dumpGrafico("resumoLoja$idLoja", $chartType, "../charts/settingsStats.xml,../charts/settingsStats_old.php?ssid=$ssid&extra=ssid", "", $downloadURL);
			/*$html .= dumpGraficoJs("resumoLoja$idLoja", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);
			*/
		}

		return $html;
	}

	function dummyFunction2Service($ssid, $stats){
		// servicesAvgMaxAttendanceTime
		$html = "";
		// apresentar primeiro uma tabela com as medias globais dos servicos
		// depois apresentar uma tabela por servico com as medias de cada servico em cada loja
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction3($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT id_servico, nome ".
			"FROM servicos ";
		if($stats['services']['values'] != ''){
			$sql .= "WHERE id_servico IN (" . $stats['services']['values'] . ") ";
		}
		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);
		$html .= "<div id=\"resume-table\" style=\"overflow:auto;\"><table style=\"width:100%; text-align:center\">";

		$data = date('Y-m', strtotime($endDate));

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader(translate("word_service", true), $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($servicos AS $row){

			$idServico = $row['id_servico'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}

			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idServico][$source]['atendimento'])){
					$avg = $dados[$idServico][$source]['atendimento'];
					$max = $dados[$idServico][$source]['atendimentoMax'];
					$cols++;
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";


				if ($zero && ($avg || $max)) $zero = false;
			}

			//if (!$zero)
			//{
				
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}

		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
		$html .= "</table>";

        // chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		$chartType = "serial";
		//$html .= dumpGrafico("resumoGlobal", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
		$html .= "</div>";
		//$html .= "<div id=\"resume-graph\" style=\"display:none\">";
		//$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&chartType=$chartType'></iframe>", $downloadURL);
		//$html .= "</div>";
		// bring tables to each store!
		$dados = $this->getDataDummyFunction4($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT id_loja, nome ".
			"FROM lojas ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$whereArray[] = "id_loja IN (" . $stats['stores']['values'] . ")";
		}

		if(getSessionValue('super_user') != 1){
			$storesArray = array();

			$sql2 = "SELECT DISTINCT id_loja FROM utilizadores_lojas WHERE id_utilizadores = " . getSessionValue('sessao_id_utilizador');
			//$res = $this->bd->executarSQL($sql2)->GetRows();
			$res = $this->bd->getRows($sql2);
			foreach($res AS $row){
				$storesArray[] = $row['id_loja'];
			}

			$whereArray[] = "id_loja IN (" . implode(',', $storesArray) . ")";
		}
		if(count($whereArray) > 0){
			$sql .= "WHERE (" . implode(') AND (', $whereArray) . ")";
		}

		//$lojas = $this->bd->executarSQL($sql)->GetRows();
		$lojas = $this->bd->getRows($sql);
		if(count($lojas) <= 1){
			return $html;
		}
		foreach($lojas AS $loja){
			$idLoja = $loja['id_loja'];

			$html .= "<br/><br/>";
			
			
			$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left; width:300px;\">". translate('word_resume', true)." ". translate('word_local', true)." '$loja[nome]':</div>";

			$html .= "<div class=\"graph-button-container\">";
			$html .= "<div id=\"resume-loja-" . $loja[nome] . "\" style=\"overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader(translate("word_service", true), $headerData['toHTML']);


			$sql = 	"SELECT s.id_servico, s.nome ".
					"FROM servicos AS s ".
					"INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade ".
					"WHERE le.id_loja = $idLoja ";
			if($stats['services']['values'] != ''){
				$sql .= "AND id_servico IN (" . $stats['services']['values'] . ") ";
			}
			//echo $sql;
			//$servicos2 = $this->bd->executarSQL($sql)->GetRows();
			$servicos2 = $this->bd->getRows($sql);

			// dump table contents
			$i = 0;
			foreach($servicos2 AS $servico){

				$idServico = $servico['id_servico'];

				$aux = "";
				$zero = true;
				$background = '';
				$background_service = '';
				$background_data = '';
				if($i++ % 2){
					//$background = 'style="background-color:#eeeeee"';
					$background_service = 'class="graph-service-box-pair"';
					$background_data =  'class="graph-data-box-pair"';
				} else {
					$background_service = 'class="graph-service-box-odd"';
					$background_data =  'class="graph-data-box-odd"';
				}

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idLoja][$idServico][$source]['atendimento'])){
						$avg = $dados[$idLoja][$idServico][$source]['atendimento'];
						$max = $dados[$idLoja][$idServico][$source]['atendimentoMax'];
						$cols++;
					}

					/*
					$avg = $avg?$avg:"";
					$max = $max?$max:"";
					*/

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td $background_data>$avg<br/><font class='graph-data-colored'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					/*$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}*/
					$html .= "<tr $background>";

					$html .= "<td $background_service>".$servico["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}
			$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
			$html .= "</table></div>";

			// chart goes here!
			$extra = "idLoja=$idLoja";//ssid;
			$extraurl = "idLoja&idLoja=$idLoja";

			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extraurl&ssid=$ssid&outputFormat=downloadCSV";
			$chartType = "serial";
			$html .= dumpGrafico("resumoLoja$idLoja", $chartType, "../charts/settingsStats.xml,../charts/settingsStats.php?ssid=$ssid&extra=ssid", "", $downloadURL);
			//$html .= dumpGraficoJs("resumoLoja$idLoja", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStats.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);

		}

		return $html;
	}

	function dummyFunction4Service($ssid, $stats){
		// employesAvgMaxAttendanceTime
		$html = "";
		// apresentar primeiro uma tabela com as medias globais dos colaboradores
		// depois apresentar uma tabela por servico com as medias de cada colaborador em cada servico
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction7($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT DISTINCT emp.id_empregado, emp.nome ".
			"FROM empregados AS emp ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$sql .= " INNER JOIN local_colaborador AS lc ON lc.id_colaborador = emp.id_empregado ";
			$whereArray[] = " lc.id_local IN (" . $stats['stores']['values'] . ") ";
		}
		if($stats['entities']['values'] != ''){
			$sql .= " INNER JOIN entidade_colaborador AS ec ON ec.id_colaborador = emp.id_empregado ";
			$whereArray[] = " ec.id_entidade IN (" . $stats['entities']['values'] . ") ";
		}

		if($stats['employes']['values'] != ''){
			$whereArray[] = " emp.id_empregado IN (" . $stats['employes']['values'] . ") ";
		}

		if(count($whereArray) > 0){
			$sql .= " WHERE (" . implode(') AND (', $whereArray) . ")";
		}
		$sql;
		//$colaboradores = $this->bd->executarSQL($sql)->GetRows();
		$colaboradores = $this->bd->getRows($sql);
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left;width: 100px;\">". translate('word_resume', true)." ". translate('word_global', true).":</div>";

		$html .= "<div style=\"width:100%; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

		// dump table contents
		$i = 0;
		$cols = 0;
		foreach($colaboradores AS $row){

			$idColaborador = $row['id_empregado'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}
			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idColaborador][$source]['atendimento'])){
					$avg = $dados[$idColaborador][$source]['atendimento'];
					$max = $dados[$idColaborador][$source]['atendimentoMax'];
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

				if ($zero && ($avg || $max)) $zero = false;
			}

			//if (!$zero)
			//{
				/*$background = '';
				if($i++ % 2){
					$background = 'style="background-color:#eeeeee"';
				}*/
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}
		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
		$html .= "</table></div>";

		// chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		$chartType = "serial";
		//$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]'></iframe>", $downloadURL);

		// bring tables to each store!
		$dados = $this->getDataDummyFunction8($groupBy, $startDate, $endDate, $stats);

		$sql = 	"SELECT distinct s.id_servico, s.nome ".
			"FROM servicos s
			inner join (
				select sb.id_servico servico, b.id_loja loja
				from servicos_balcao sb
				inner join balcoes b on b.id_balcao=sb.id_balcao) sl on sl.servico=s.id_servico ";

		$where = array();

		if ($stats['services']['values'] != '')
		{
			array_push($where, "s.id_servico IN (" . $stats['services']['values'] . ") ");
		}

		if ($stats['stores']['values'] != '')
		{
			array_push($where, "sl.loja IN (" . $stats['stores']['values'] . ") ");
		}

		if (count($where))
		{
			$sql .= "where ".implode(" and ", $where);
		}

		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);






		if(count($servicos) <= 1){
			return $html;
		}
		foreach($servicos AS $servico){
			$idServico = $servico['id_servico'];

			$html .= "<br/><br/>";
			$html .= "<h3>". translate('word_resume', true)."". translate("word_service", true)." '".$servico[nome]."'</h3>";

			$html .= "<div style=\"width:758px; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

			// dump table contents
			$i = 0;
			foreach($colaboradores AS $colaborador){

				$idColaborador = $colaborador['id_empregado'];

				$aux = "";
				$zero = true;

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idServico][$idColaborador][$source]['atendimento'])){
						$avg = $dados[$idServico][$idColaborador][$source]['atendimento'];
						$max = $dados[$idServico][$idColaborador][$source]['atendimentoMax'];
					}

					/*
					$avg = $avg?$avg:"";
					$max = $max?$max:"";
					*/

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td>$avg<br/><font color='red'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}
					$html .= "<tr $background>";

					$html .= "<td>".$colaborador["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}

			$html .= "</table></div>";

			// chart goes here!
			$extra = "idServico&idServico=$idServico";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extra&ssid=$ssid&outputFormat=downloadCSV";
			$chartType = "serial";
           //$html .= dumpGraficoJs("resumoLoja$idServico", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);

		}

		return $html;
	}

	function dummyFunction5Service($ssid, $stats){
		// employesTicketsNumber
		$html = "";

		// apresentar primeiro uma tabela com as medias globais dos colaboradores
		// depois apresentar uma tabela por servico com as medias de cada colaborador em cada servico
		$groupBy = $stats['dates']['frequency'];
		$startDate = $stats['dates']['from'];
		$endDate = $stats['dates']['to'];

		$dados = $this->getDataDummyFunction9($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT DISTINCT emp.id_empregado, emp.nome ".
			"FROM empregados AS emp ";

		$whereArray = array();
		if($stats['stores']['values'] != ''){
			$sql .= " INNER JOIN local_colaborador AS lc ON lc.id_colaborador = emp.id_empregado ";
			$whereArray[] = " lc.id_local IN (" . $stats['stores']['values'] . ") ";
		}
		if($stats['entities']['values'] != ''){
			$sql .= " INNER JOIN entidade_colaborador AS ec ON ec.id_colaborador = emp.id_empregado ";
			$whereArray[] = " ec.id_entidade IN (" . $stats['entities']['values'] . ") ";
		}

		if($stats['employes']['values'] != ''){
			$whereArray[] = " emp.id_empregado IN (" . $stats['employes']['values'] . ") ";
		}

		if(count($whereArray) > 0){
			$sql .= " WHERE (" . implode(') AND (', $whereArray) . ")";
		}

		//$colaboradores = $this->bd->executarSQL($sql)->GetRows();
		$colaboradores = $this->bd->getRows($sql);
		$html .= "<div class=\"formname_space graph-button-label\" style=\"text-align:left;width: 100px;\">". translate('word_global', true)." ". translate('word_resume', true).":</div>";

		$html .= "<div style=\"width:758px; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

		// dump header
		$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
		$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

		// dump table contents
		$i = 0;		
		$cols = 0;
		foreach($colaboradores AS $row){

			$idColaborador = $row['id_empregado'];

			$aux = "";
			$zero = true;
			$background = '';
			$background_service = '';
			$background_data = '';
			if($i++ % 2){
				//$background = 'style="background-color:#eeeeee"';
				$background_service = 'class="graph-service-box-pair"';
				$background_data =  'class="graph-data-box-pair"';
			} else {
				$background_service = 'class="graph-service-box-odd"';
				$background_data =  'class="graph-data-box-odd"';
			}
			// each column
			foreach($headerData['source'] AS $source){
				$avg = 0;
				$max = 0;
				if(isset($dados[$idColaborador][$source]['atendidas'])){
					$avg = $dados[$idColaborador][$source]['atendidas'];
					$max = $dados[$idColaborador][$source]['desistidas'];
				}

				/*
				$avg = $avg?$avg:"";
				$max = $max?$max:"";
				*/

				if($avg == 0 && $max == 0){
					$avg = '';
					$max = '';
				}

				$aux .= "<td $background_data>$avg<font class='graph-data-colored'>$max</font></td>";

				if ($zero && ($avg || $max)) $zero = false;
			}

			//if (!$zero)
			//{
				/*$background = '';
				if($i++ % 2){
					$background = 'style="background-color:#eeeeee"';
				}*/
				$html .= "<tr $background>";

				$html .= "<td $background_service>".$row["nome"]."</td>".$aux;

				$html .= "</tr>";
			//}
		}
		$html .= "<tr><td></td><td colspan=\"100\"><div class=\"graph-caption-container\"><div class=\"graph-caption-first\">" . translate('word_estatisticas_tempo_medio', true) . " |</div><div class=\"graph-caption-second\"> " . translate('word_estatisticas_tempo_maximo', true) . "</div></div></td></tr>";
		$html .= "</table></div>";

		// chart goes here!
		$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid&ssid=$ssid&outputFormat=downloadCSV";
		$chartType = "serial";
		//$html .= dumpGraficoJs("resumoGlobal", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]'></iframe>", $downloadURL);


		// get tables to each service!
		$dados = $this->getDataDummyFunction10($groupBy, $startDate, $endDate, $stats);


		$sql = 	"SELECT distinct s.id_servico, s.nome ".
			"FROM servicos s
			inner join (
				select sb.id_servico servico, b.id_loja loja
				from servicos_balcao sb
				inner join balcoes b on b.id_balcao=sb.id_balcao) sl on sl.servico=s.id_servico ";

		$where = array();

		if ($stats['services']['values'] != '')
		{
			array_push($where, "s.id_servico IN (" . $stats['services']['values'] . ") ");
		}

		if ($stats['stores']['values'] != '')
		{
			array_push($where, "sl.loja IN (" . $stats['stores']['values'] . ") ");
		}

		if (count($where))
		{
			$sql .= "where ".implode(" and ", $where);
		}

		//$servicos = $this->bd->executarSQL($sql)->GetRows();
		$servicos = $this->bd->getRows($sql);

		if(count($servicos) <= 1){
			return $html;
		}
		foreach($servicos AS $servico){
			$idServico = $servico['id_servico'];

			$html .= "<br/><br/>";
			$html .= "<h3>". translate('word_resume', true)."". translate("word_service", true) ."'".$servico[nome]."'</h3>";

			$html .= "<div style=\"width:758px; overflow:auto;\"><table width=\"100%\" style=\"text-align:center\">";

			// dump header
			$headerData = $this->getDateColumns($startDate, $endDate, $groupBy);
			$html .= $this->dumpHTMLHeader("Employee", $headerData['toHTML']);

			// dump table contents
			$i = 0;
			foreach($colaboradores AS $colaborador){

				$idColaborador = $colaborador['id_empregado'];

				$aux = "";
				$zero = true;

				// each column
				foreach($headerData['source'] AS $source){
					$avg = 0;
					$max = 0;
					if(isset($dados[$idServico][$idColaborador][$source]['atendidas'])){
						$avg = $dados[$idServico][$idColaborador][$source]['atendidas'];
						$max = $dados[$idServico][$idColaborador][$source]['desistidas'];
					}

					/*
					$avg = $avg?$avg:"";
					$max = $max?$max:"";
					*/

					if($avg == 0 && $max == 0){
						$avg = '';
						$max = '';
					}

					$aux .= "<td>$avg<br/><font color='red'>$max</font></td>";

					if ($zero && ($avg || $max)) $zero = false;
				}

				//if (!$zero)
				//{
					$background = '';
					if($i++ % 2){
						$background = 'style="background-color:#eeeeee"';
					}
					$html .= "<tr $background>";

					$html .= "<td>".$colaborador["nome"]."</td>".$aux;

					$html .= "</tr>";
				//}
			}

			$html .= "</table></div>";

			// chart goes here!
			$extra = "idServico&idServico=$idServico";
			$downloadURL = "../senhas/chartsDataDownload.php?dataSource=statistics_$stats[type]&extra=ssid;$extra&ssid=$ssid&outputFormat=downloadCSV";
		    $chartType = "serial";
			//$html .= dumpGraficoJs("resumoLoja$idServico", "<iframe frameborder='yes' scrolling='no' width='100%' height='800px' src='../charts/settingsStatsEmployes.php?chartType=$chartType&ssid=$ssid&extra=ssid&dataSource=statistics_$stats[type]&$extra'></iframe>", $downloadURL);

		}

		return $html;
	}

	/**
	* Destrutor da classe
	* 0 = Erro da BD
	*/
	function Fechar() {
		$this->bd->fecharBD();
	}
}
?>
